#!/usr/bin/perl -w
#######################################################
#                                                     #
# Copyright IBM Corporation 2018, 2025 All rights reserved. #
#                                                     #
#######################################################
use CGI qw(:standard);
use strict;
#
#   Define variables needed for token
#
our ($up_time, $hash);
require "./webadmin_bld_token.pl";

###########################################
#
# Begin of main section
#
###########################################
my ($arg, $arg_pu_name, $arg_description, $arg_bkup_dlus_name, $arg_dlus_name, 
    $arg_initially_active, $arg_conventional_lu_compression, 
    $arg_dlus_retry_limit, $arg_pu_id, $description, $dlus_name, 
    $bkup_dlus_name, $pu_id,$dlus_retry_limit, $time, $remote_addr, 
    $remote_port, $line, @data, @contents, @retval);

$arg_pu_name="";
$arg_description="";
$arg_bkup_dlus_name="";
$arg_dlus_name="";
$arg_initially_active="NO";
$arg_dlus_retry_limit="0";
$arg_conventional_lu_compression="NO";
$arg_pu_id="00000000";
#
#  Get IP and port of client's socket connection
#
$remote_addr=$ENV{REMOTE_ADDR};
#$remote_port=$ENV{REMOTE_PORT}; Change to use HTTP_USER_AGENT env. var
$remote_port=$ENV{HTTP_USER_AGENT};
#
#
#  Build token for secure invocation of addaccess.cgi
#    
@retval = build_token($remote_addr, $remote_port);
$up_time = $retval[0];
$hash = $retval[1];
if ($up_time eq "0000") {
    print "<b>Failed to access the node. \n</b>";
    exit -1;
}    
print "<font face=\"Times New Roman, Helvetica\">";
print "<form action= \"/cscbin/addpu.cgi\" method=\"post\">\n";    

print "<table border=\"0\" cellpadding=\"0\" cellspacing=\"10\" width=\"100%\" style=\"border-collapse:separate; border-spacing:0px 10px;\"> ";
print "<tbody> ";
    #  PU name
print "<tr><td>* PU name :</td> <td> <input type=\"text\" class=\"rightAligned\" name=\"pu_name_unique\" maxlength=\"8\" value=\"$arg_pu_name\" required=\"required\" oninput=\"value=value.replace(/[^A-Z0-9#@\$]/g,'')\" /></td></tr>";
    
    #  Description
print "<tr><td>Description :</td> <td><input type=\"text\" class=\"rightAligned\" name=\"description\"  maxlength=\"31\" value=\"$arg_description\" /oninput=\"value=value.replace(/[^a-zA-Z0-9_-#!. @\(\)\$]/g,'')\" /></td></tr>";

    #   DLUS server name
print "<tr><td>DLUS server name :</td> <td><input type=\"text\" class=\"rightAligned\" name=\"dlus_name\" maxlength=\"17\" value=\"$arg_dlus_name\" oninput=\"value=value.replace(/[^A-Z0-9.]/g,'')\"  /></td></tr>";
    
    #  Backup DLUS server name
print "<tr><td>Backup DLUS server name : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"bkup_dlus_name\" maxlength=\"17\" value=\"$arg_bkup_dlus_name\" oninput=\"value=value.replace(/[^A-Z0-9.]/g,'')\"  /></td></tr>";
    
    #  PU id
print "<tr><td>* PU id : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"pu_id\" maxlength=\"8\" value=\"$arg_pu_id\" required=\"required\" oninput=\"value=value.replace(/[^0-9a-fA-F]/g,'')\" /></td></tr>";

    #  Initially active?
print "<tr><td>Initially active ? </td> <td> <select name=\"initially_active\" class=\"rightAligned\" value=\"$arg_initially_active\" >  ";
print "<option value=\"YES\" >YES</option> ";
print "<option value=\"NO\" selected=\"selected\">NO</option> </select></td></tr>";
    
    #   Retry contacting DLUS indefinitely?
print "<tr><td>Retry contacting DLUS indefinitely? (0-65535) : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"dlus_retry_limit\" maxlength=\"5\" value=\"$arg_dlus_retry_limit\" oninput=\"value=value.replace(/[^\\d]/g,'')\" /></td></tr>";
    
    #   Compression Supported
print "<tr><td>Compression Supported ? </td> <td><select name=\"conventional_lu_compression\" class=\"rightAligned\" value=\"$arg_conventional_lu_compression\" > ";
print "<option value=\"YES\">YES</option> ";
print "<option value=\"NO\" selected=\"selected\">NO</option> </select></td></tr>";

print "<input type=\"hidden\" name=\"up_time\" value=\"$up_time\"/>";

print "<input type=\"hidden\" name=\"hash\" value=\"$hash\"/>";

print "<tr> <td><input type=\"submit\" value=\"Submit\"></td> <td><input type=\"reset\"/></td></tr>";
print "</tbody> ";
print "</table> ";
print "</form>";
print "<p>";

exit 0;

