#!/usr/bin/perl -w
#######################################################
#                                                     #
# Copyright IBM Corporation 2018, 2025 All rights reserved. #
#                                                     #
#######################################################
use CGI qw(:standard);
use strict;
#
#   Define variables needed for token
#
our ($up_time, $hash);
require "./webadmin_bld_token.pl";

###########################################
#
# Begin of main section
#
###########################################
my ($arg_fqplu_name, $arg_description, $arg_plu_alias, $arg_plu_un_name, 
    $arg_parallel_sess_supp, $arg_max_mc_ll_send_size, $arg_conv_security_ver, 
    $max_mc_ll_send_size, $plu_un_name, $description, $time, $remote_addr,
    $remote_port, $line, @data, @contents, @retval);

$arg_fqplu_name="";
$arg_description="";
$arg_plu_alias="";
$arg_parallel_sess_supp="YES";
$arg_plu_un_name="";
$arg_conv_security_ver="NO";
$arg_max_mc_ll_send_size="0";
#
#  Get IP and port of client's socket connection
#
$remote_addr=$ENV{REMOTE_ADDR};
#$remote_port=$ENV{REMOTE_PORT}; Change to use HTTP_USER_AGENT env. var
$remote_port=$ENV{HTTP_USER_AGENT};
#
#
#  Build token for secure invocation of addaccess.cgi
#    
@retval = build_token($remote_addr, $remote_port);
$up_time = $retval[0];
$hash = $retval[1];
if ($up_time eq "0000") {
    print "<b>Failed to access the node. \n</b>";
    exit -1;
}    
print "<font face=\"Times New Roman, Helvetica\">";
print "<form action= \"/cscbin/add_part_lu.cgi\" method=\"post\">\n";   
    
print "<table border=\"0\" cellpadding=\"0\" cellspacing=\"10\" width=\"100%\" style=\"border-collapse:separate; border-spacing:0px 10px;\"> ";
print "<tbody> ";
    #  Alias
print "<tr><td>* Partner Alias :</td> <td> <input type=\"text\" class=\"rightAligned\" name=\"plu_alias\" maxlength=\"8\" value=\"$arg_plu_alias\" required=\"required\" oninput=\"value=value.replace(/[^a-zA-Z0-9#@\$]/g,'')\" /></td></tr>";
    
    #  Description
print "<tr><td>Description :</td> <td><input type=\"text\" class=\"rightAligned\" name=\"description\"  maxlength=\"31\" value=\"$arg_description\" /oninput=\"value=value.replace(/[^a-zA-Z0-9_-#!. :@\(\)\$]/g,'')\" /></td></tr>";
    
    #  Fully-qualified LU name
print "<tr><td>* Fully-qualified Partner LU name :</td> <td> <input type=\"text\" class=\"rightAligned\" name=\"fqplu_name_unique\" maxlength=\"17\" value=\"$arg_fqplu_name\" required=\"required\" /oninput=\"value=value.replace(/[^A-Z0-9.]/g,'')\"  /></td></tr>";
    
    #  Uninterpreted LU name
print "<tr><td>Uninterpreted LU name : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"plu_un_name\" maxlength=\"8\" value=\"$arg_plu_un_name\" oninput=\"value=value.replace(/[^a-zA-Z0-9#@\$]/g,'')\" /></td></tr>";
    
    #  Parallel sessions supported?
print "<tr><td> Parallel sessions supported ?</td> <td> <select name=\"parallel_sess_supp\" class=\"rightAligned\" value=\"$arg_parallel_sess_supp\" >  ";
print "<option value=\"YES\" selected=\"selected\">YES</option> ";
print "<option value=\"NO\">NO</option></select></td></tr>";
    
    #   Maximum size of logical records
print "<tr><td>Maximum size of logical records(0-32767) : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"max_mc_ll_send_size\" maxlength=\"5\" value=\"$arg_max_mc_ll_send_size\" oninput=\"value=value.replace(/[^\\d]/g,'')\" /></td></tr>";
    
    #   conv. security already verified supported?
print "<tr><td>conv. security already verified supported ? </td> <td><select name=\"conv_security_ver\" class=\"rightAligned\" value=\"$arg_conv_security_ver\" >  ";
print "<option value=\"YES\">YES</option> ";
print "<option value=\"NO\" selected=\"selected\">NO</option></select></td></tr>";

print "<input type=\"hidden\" name=\"up_time\" value=\"$up_time\"/>";

print "<input type=\"hidden\" name=\"hash\" value=\"$hash\"/>";

print "<tr> <td><input type=\"submit\" value=\"Submit\"></td> <td><input type=\"reset\"/></td></tr>";
print "</tbody> ";
print "</table> ";
print "</form>";
print "<p>";

exit 0;

