#!/usr/bin/perl -w
#######################################################
#                                                     #
# Copyright IBM Corporation 2018, 2025 All rights reserved. #
#                                                     #
#######################################################
use CGI qw(:standard);
use strict;
#
#   Define variables needed for token
#
our ($up_time, $hash);
require "./webadmin_bld_token.pl";

###########################################
#
# Begin of main section
#
###########################################
my ($arg, $arg_eth_port_name, $arg_description, $arg_port_number,$arg_dlc_name, 
    $arg_initially_active, $arg_lsap_address, $arg_implicit_hpr_support, 
    $arg_implicit_link_lvl_error, $arg_implicit_uplink_to_en, $arg_max_rcv_btu_size, 
    $arg_tot_link_act_lim,$arg_implicit_dspu_template, $arg_max_ifrm_rcvd, 
    $arg_xid_timer_retry, $description, $dlc_name, $len,$port_number, $lsap_address,
    $max_rcv_btu_size, $tot_link_act_lim,$implicit_dspu_template, $max_ifrm_rcvd, 
    $xid_timer_retry, $time, $remote_addr, $remote_port, $line, @data, @contents, 
    @dlclist, @dspulist, @retval);

$arg_eth_port_name="";
$arg_description="";
$arg_port_number="";
$arg_dlc_name="";
$arg_initially_active="YES";
$arg_lsap_address="04";
$arg_implicit_hpr_support="YES";
$arg_implicit_link_lvl_error="NO";
$arg_implicit_uplink_to_en="NO";
$arg_max_rcv_btu_size="1033";
$arg_tot_link_act_lim="64";
$arg_implicit_dspu_template="";
$arg_max_ifrm_rcvd="7";
$arg_xid_timer_retry="5";
    
@contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin query_dlc`;
foreach $line (@contents) {
     next if ($line=~m/-----/);   # Do not display seperaters
       
     if ($line=~m/dlc_name/) {
         @data = split(/=/,$line);
         $data[1]=~s/^\s+|\s+$//g;   # This removes all blank characters
         $dlc_name= $data[1];
         next;
     }elsif ($line=~m/dlc_type/) {
         @data = split(/=/,$line);
         $data[1]=~s/^\s+|\s+$//g;   # This removes all blank characters
         if ($data[1]=~m/ETHERNET/) {
              push @dlclist, $dlc_name;
         }
         next;
     }
}
    
$len=@dlclist;
if($len eq 0){
    print "<br> Ethernet DLC should be defined before define Ethernet Port. ";
    exit 1;
}
    #   Build DSPU Template options list
push @dspulist, "NONE";
push @dspulist, "DLUR";
push @dspulist, "PU_CONCENTRATION";
#
#  Get IP and port of client's socket connection
#
$remote_addr=$ENV{REMOTE_ADDR};
#$remote_port=$ENV{REMOTE_PORT}; Change to use HTTP_USER_AGENT env. var
$remote_port=$ENV{HTTP_USER_AGENT};
#
#
#  Build token for secure invocation of addaccess.cgi
#    
@retval = build_token($remote_addr, $remote_port);
$up_time = $retval[0];
$hash = $retval[1];
if ($up_time eq "0000") {
    print "<b>Failed to access the node. \n</b>";
    exit -1;
}
print "<font face=\"Times New Roman, Helvetica\">";
print "<form action= \"/cscbin/addetherport.cgi\" method=\"post\">\n";

print "<table border=\"0\" cellpadding=\"0\" cellspacing=\"10\" width=\"100%\" style=\"border-collapse:separate; border-spacing:0px 10px;\"> ";
print "<tbody> ";
    #  Port name
print "<tr> <td>* Port name : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"ethportname_unique\"  maxlength=\"8\" value=\"$arg_eth_port_name\" required=\"required\" oninput=\"value=value.replace(/[^a-zA-Z0-9_.#@\$]/g,'')\" /></td></tr>";
    
    #  Description
print "<tr> <td>Description : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"description\" maxlength=\"31\" value=\"$arg_description\" /oninput=\"value=value.replace(/[^a-zA-Z0-9_-#!. @\(\)\$]/g,'')\" /></td></tr>";
    
    #  Port number
print "<tr> <td>Port number : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"port_number\"  maxlength=\"8\" value=\"$arg_port_number\" oninput=\"value=value.replace(/[^\\d]/g,'')\"/></td></tr>";
    
    #   DLC Name
print "<tr> <td>DLC Name : </td> <td><select name=\"dlc_name\"  class=\"rightAligned\" value=\"$arg_dlc_name\" /> ";

foreach $line (@dlclist) {
    print "<option value=\"$line\">$line</option> ";
}
print "</select></td></tr>";
    
    #  Local SAP address
print "<tr> <td>Local SAP address(0x04-0xEC) : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"lsap_address\"  maxlength=\"2\" value=\"$arg_lsap_address\"  oninput=\"value=value.replace(/[^0-9a-fA-F]/g,'')\" /></td></tr>";

    #  Initially active?
print "<tr> <td>Initially active ? </td> <td><select name=\"initially_active\"  class=\"rightAligned\" value=\"$arg_initially_active\" > ";
print "<option value=\"YES\" selected=\"selected\">YES</option> ";
print "<option value=\"NO\">NO</option> </select> </td></tr>";
    
    #   Use HPR on implicit links?
print "<tr> <td>Use HPR on implicit links ? </td> <td><select name=\"implicit_hpr_support\"  class=\"rightAligned\" value=\"$arg_implicit_hpr_support\" >  ";
print "<option value=\"YES\" selected=\"selected\">YES</option> ";
print "<option value=\"NO\">NO</option> </select></td></tr>";
    
    #   Use HPR link level error recovery?
print "<tr> <td>Use HPR link level error recovery ? </td> <td><select name=\"implicit_link_lvl_error\"  class=\"rightAligned\" value=\"$arg_implicit_link_lvl_error\" >  ";
print "<option value=\"YES\">YES</option> ";
print "<option value=\"NO\" selected=\"selected\">NO</option> </select></td></tr>";
    
    #   Implicit links to end nodes are uplinks?
print "<tr> <td>Implicit links to end nodes are uplinks ? </td> <td><select name=\"implicit_uplink_to_en\"  class=\"rightAligned\" value=\"$arg_implicit_uplink_to_en\" >  ";
print "<option value=\"YES\">YES</option> ";
print "<option value=\"NO\" selected=\"selected\">NO</option> </select></td></tr>";
    
    #   Maximum BTU size allowed
print "<tr> <td>Maximum BTU size allowed(265-7689) :</td> <td><input type=\"text\" class=\"rightAligned\" name=\"max_rcv_btu_size\"  maxlength=\"5\" value=\"$arg_max_rcv_btu_size\"  oninput=\"value=value.replace(/[^\\d]/g,'')\"/></td></tr>";
    
    #   Maximum number of active links allowed
print "<tr> <td>Maximum number of active links allowed(0-65535) :</td> <td><input type=\"text\" class=\"rightAligned\" name=\"tot_link_act_lim\"  maxlength=\"5\" value=\"$arg_tot_link_act_lim\" oninput=\"value=value.replace(/[^\\d]/g,'')\" /></td></tr>";
    
    #  Implicit DSPU template
print "<tr> <td>Implicit DSPU template : </td> <td><select name=\"implicit_dspu_template\"  class=\"rightAligned\"  value=\"$arg_implicit_dspu_template\"  />";

foreach $line (@dspulist) {
    print "<option value=\"$line\">$line</option> ";
}
print "</select></td></tr>";

    #   Maximum number of I-frames outstanding
print "<tr> <td>Maximum number of I-frames outstanding(1-127) :</td> <td><input type=\"text\" class=\"rightAligned\" name=\"max_ifrm_rcvd\"  maxlength=\"3\"  value=\"$arg_max_ifrm_rcvd\"  oninput=\"value=value.replace(/[^\\d]/g,'')\"/></td></tr>";
    #  XID retry count
print "<tr> <td>XID timer retry count(0-65535) : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"xid_timer_retry\"  maxlength=\"5\" value=\"$arg_xid_timer_retry\"  oninput=\"value=value.replace(/[^\\d]/g,'')\"/></td></tr>";
    
print "<input type=\"hidden\" name=\"up_time\" value=\"$up_time\"/>";

print "<input type=\"hidden\" name=\"hash\" value=\"$hash\"/>";

print "<tr> <td><input type=\"submit\" value=\"Submit\"></td> <td><input type=\"reset\"/></td></tr>";
print "</tbody> ";
print "</table> ";
print "</form>";
print "<p>";

exit 0; 

