#!/usr/bin/perl -w
#######################################################
#                                                     #
# Copyright IBM Corporation 2020, 2025 All rights reserved. #
#                                                     #
#######################################################
use CGI qw(:standard);
use strict;
#
#   Define variables needed for token
#
our ($up_time, $hash);
require "./webadmin_bld_token.pl";

###########################################
#
# Begin of main section
#
###########################################
my ($arg, $arg_ee_port_name, $arg_description, $arg_ip_version,$arg_dlc_name, 
    $arg_initially_active, $arg_implicit_uplink_to_en, $arg_max_rcv_btu_size, 
    $arg_tot_link_act_lim,$arg_local_ip_interface, $description, $dlc_name, 
    $local_ip_interface,$max_rcv_btu_size, $tot_link_act_lim,$ip_version, 
    $len, $time, $remote_addr, $remote_port, $line, @data, @contents, 
    @dlclist, @retval);

$arg_ee_port_name="";
$arg_description="";
$arg_dlc_name="";
$arg_initially_active="YES";
$arg_ip_version="IPV4";
$arg_max_rcv_btu_size="1500";
$arg_tot_link_act_lim="4096";
$arg_implicit_uplink_to_en="NO";
$arg_local_ip_interface="";
#
#  Get IP and port of client's socket connection
#
$remote_addr=$ENV{REMOTE_ADDR};
#$remote_port=$ENV{REMOTE_PORT}; Change to use HTTP_USER_AGENT env. var
$remote_port=$ENV{HTTP_USER_AGENT};
#
#
#  Build token for secure invocation of addaccess.cgi
#    
@retval = build_token($remote_addr, $remote_port);
$up_time = $retval[0];
$hash = $retval[1];
if ($up_time eq "0000") {
    print "<b>Failed to access the node. \n</b>";
    exit -1;
}
    
@contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin query_dlc`;
foreach $line (@contents) {
     next if ($line=~m/-----/);   # Do not display seperaters
     
     if ($line=~m/dlc_name/) {
         @data = split(/=/,$line);
         $data[1]=~s/^\s+|\s+$//g;   # This removes all blank characters
         $dlc_name= $data[1];
         next;
     }elsif ($line=~m/dlc_type/) {
         @data = split(/=/,$line);
         $data[1]=~s/^\s+|\s+$//g;   # This removes all blank characters
         if ($data[1]=~m/HPRIP/) {
              push @dlclist, $dlc_name;
         }
         next;
     }
}
    
$len=@dlclist;
if($len eq 0){
    print "<br> Enterprise Extender DLC should be defined before define Enterprise Extender Port. ";
    exit 1;
}

print "<font face=\"Times New Roman, Helvetica\">";
print "<form action= \"/cscbin/addeeport.cgi\" method=\"post\">\n";
    
print "<table border=\"0\" cellpadding=\"0\" cellspacing=\"10\" width=\"100%\" style=\"border-collapse:separate; border-spacing:0px 10px;\"> ";
print "<tbody> ";
    #  Port name
print "<tr><td>* Port name :</td> <td> <input type=\"text\" class=\"rightAligned\" name=\"eeportname_unique\" maxlength=\"8\" value=\"$arg_ee_port_name\" required=\"required\" oninput=\"value=value.replace(/[^a-zA-Z0-9_.\$]/g,'')\" /></td></tr>";
    
    #  Protocol
print "<tr><td>Protocol : </td> <td><select name=\"ip_version\" class=\"rightAligned\" value=\"$arg_ip_version\" >  ";
print "<option value=\"IPV4\" selected=\"selected\">IPV4</option> ";
print "<option value=\"IPV6\">IPV6</option> ";
print "</select></td></tr>";
    
    #  Description
print "<tr><td>Description :</td> <td><input type=\"text\" class=\"rightAligned\" name=\"description\"  maxlength=\"31\" value=\"$arg_description\" /oninput=\"value=value.replace(/[^a-zA-Z0-9_-#!. @\(\)\$]/g,'')\" /></td></tr>";
    
    #   DLC Name
print "<tr><td>DLC Name :</td> <td><select name=\"dlc_name\" class=\"rightAligned\" value=\"$arg_dlc_name\" >  ";
   foreach $line (@dlclist) {
print "<option value=\"$line\">$line</option> ";
    }
print "</select></td></tr>";
    
    #  Initially active?
print "<tr><td>Initially active ? </td> <td> <select name=\"initially_active\" class=\"rightAligned\" value=\"$arg_initially_active\" >  ";
print "<option value=\"YES\" selected=\"selected\">YES</option> ";
print "<option value=\"NO\">NO</option> </select></td></tr>";
    
    #   Maximum BTU size allowed
print "<tr><td>Maximum BTU size allowed(265-65535) : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"max_rcv_btu_size\" maxlength=\"5\" value=\"$arg_max_rcv_btu_size\" oninput=\"value=value.replace(/[^\\d]/g,'')\" /></td></tr>";
    
    #   Maximum number of active links allowed
print "<tr><td>Maximum number of active links allowed(0-4096) : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"tot_link_act_lim\" maxlength=\"4\" value=\"$arg_tot_link_act_lim\" oninput=\"value=value.replace(/[^\\d]/g,'')\" /></td></tr>";
    
    #   Implicit links to end nodes are uplinks?
print "<tr><td>Implicit links to end nodes are uplinks ? </td> <td><select name=\"implicit_uplink_to_en\" class=\"rightAligned\" value=\"$arg_implicit_uplink_to_en\" >  ";
print "<option value=\"YES\">YES</option> ";
print "<option value=\"NO\" selected=\"selected\">NO</option> </select></td></tr>";

    #  Local IP interface
print "<tr><td>Local IP interface : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"local_ip_interface\" maxlength=\"45\" value=\"$arg_local_ip_interface\" oninput=\"value=value.replace(/[^a-zA-Z0-9_-.\$]/g,'')\" /></td></tr>";

print "<input type=\"hidden\" name=\"up_time\" value=\"$up_time\"/>";

print "<input type=\"hidden\" name=\"hash\" value=\"$hash\"/>";

print "<tr> <td><input type=\"submit\" value=\"Submit\"></td> <td><input type=\"reset\"/></td></tr>";
print "</tbody> ";
print "</table> ";
print "</form>";
print "<p>";
 
exit 0; 

