#!/usr/bin/perl -w
#######################################################
#                                                     #
# Copyright IBM Corporation 2018, 2025 All rights reserved. #
#                                                     #
#######################################################
use CGI qw(:standard);
use strict;
#
#   Define variables needed for token
#
our ($up_time, $hash);
require "./webadmin_bld_token.pl";

###########################################
#
# Begin of main section
#
###########################################
my ($arg, $arg_ee_ls_name, $arg_description, $arg_initially_active,
    $arg_port_name, $arg_adj_cp_name, $arg_adj_cp_type, $arg_remote_ip_host,
    $arg_max_retry,$arg_liveness_timeout, $arg_cp_cp_sess_support,$arg_ip_version, 
    $arg_tg_number, $arg_max_send_btu_size, $arg_default_nn_server,
    $arg_branch_link_type, $arg_ack_timeout,$arg_restart_on_normal_deact, 
    $description, $port_name, $len,$tg_number, $liveness_timeout,
    $max_send_btu_size, $adj_cp_name,$max_retry, $ack_timeout, $time, 
    $remote_addr, $remote_port, $line, @data, @contents, @portlist, @retval);

$arg_ee_ls_name="";
$arg_port_name="";
$arg_description="";
$arg_initially_active="YES";
$arg_remote_ip_host="";
$arg_adj_cp_name="";
$arg_adj_cp_type="LEARN_NODE";
$arg_max_send_btu_size="1461";
$arg_cp_cp_sess_support="YES";
$arg_default_nn_server="NO";
$arg_ip_version="IPV4";
$arg_tg_number="0";
$arg_branch_link_type="NONE";
$arg_restart_on_normal_deact="NO";
$arg_ack_timeout="10000";
$arg_max_retry="10";
$arg_liveness_timeout="10000";

#
#  Get IP and port of client's socket connection
#
$remote_addr=$ENV{REMOTE_ADDR};
#$remote_port=$ENV{REMOTE_PORT}; Change to use HTTP_USER_AGENT env. var
$remote_port=$ENV{HTTP_USER_AGENT};
#
#
#  Build token for secure invocation of addaccess.cgi
#    
@retval = build_token($remote_addr, $remote_port);
$up_time = $retval[0];
$hash = $retval[1];
if ($up_time eq "0000") {
    print "<b>Failed to access the node. \n</b>";
    exit -1;
}

    
@contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin query_port -d`;
foreach $line (@contents) {
     next if ($line=~m/-----/);   # Do not display seperaters
        
     if ($line=~m/port_name/) {
         @data = split(/=/,$line);
         $data[1]=~s/^\s+|\s+$//g;   # This removes all blank characters
         $port_name= $data[1];
         next;
     }elsif ($line=~m/dlc_type/) {
         @data = split(/=/,$line);
         $data[1]=~s/^\s+|\s+$//g;   # This removes all blank characters
         if ($data[1]=~m/HPRIP/) {
              push @portlist, $port_name;
         }
         next;
     }
}
    
$len=@portlist;
if($len eq 0){
     print "<br> Enterprise Extender Port should be defined before define Enterprise Extender Link Station. ";
     exit 1;
}
print "<font face=\"Times New Roman, Helvetica\">";
print "<form action= \"/cscbin/addeels.cgi\" method=\"post\">\n";

print "<table border=\"0\" cellpadding=\"0\" cellspacing=\"10\" width=\"100%\" style=\"border-collapse:separate; border-spacing:0px 10px;\"> ";
print "<tbody> ";
    
    #  Link station name
print "<tr><td>* Link station name : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"eelsname_unique\"  maxlength=\"8\" value=\"$arg_ee_ls_name\" required=\"required\" oninput=\"value=value.replace(/[^a-zA-Z0-9_.#@\$]/g,'')\" /></td></tr>";
    
    #  Description
print "<tr><td>Description : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"description\"  maxlength=\"31\" value=\"$arg_description\" /oninput=\"value=value.replace(/[^a-zA-Z0-9_-#!. :@\(\)\$]/g,'')\" /></td></tr>";
    
    #   Port name
print "<tr><td>* Port Name :</td> <td><select name=\"port_name\"  class=\"rightAligned\" value=\"$arg_port_name\" >  ";
foreach $line (@portlist) {
   print "<option value=\"$line\">$line</option> ";
}
print "</select></td></tr>";

    #  Initially active?
print "<tr><td>Initially active ?</td> <td> <select name=\"initially_active\"  class=\"rightAligned\" value=\"$arg_initially_active\" >";
print "<option value=\"YES\">YES</option> ";
print "<option value=\"NO\" selected=\"selected\">NO</option> </select></td></tr>";
    
print "<tr><td>Contact Information :  </td></tr>";
    
    # Remote IP host
print "<tr><td>* Remote IP host :</td> <td> <input type=\"text\" class=\"rightAligned\" name=\"remote_ip_host\"  maxlength=\"255\" value=\"$arg_remote_ip_host\" required=\"required\" oninput=\"value=value.replace(/[^0-9a-zA-Z._-:]/g,'')\" /></td></tr>";
   
print "<tr><td>Independent LU Traffic :</td></tr> ";
    
    # Remote node Control Point name
print "<tr><td>Remote node Control Point name :</td> <td> <input type=\"text\" class=\"rightAligned\" name=\"adj_cp_name\"  maxlength=\"17\" value=\"$arg_adj_cp_name\" oninput=\"value=value.replace(/[^A-Z0-9.]/g,'')\" /></td></tr>";
    
    #  Remote node type
print "<tr><td>Remote node type : </td> <td><select name=\"adj_cp_type\"  class=\"rightAligned\" value=\"$arg_adj_cp_type\">  ";
print "<option value=\"LEARN_NODE\" selected=\"selected\">LEARN_NODE</option> ";
print "<option value=\"END_NODE\">END_NODE</option>";
print "<option value=\"NETWORK_NODE\">NETWORK_NODE</option></select></td></tr>";
    
print "<tr><td>Advanced : </td></tr> ";
    #   Maximum BTU size to be sent
print "<tr><td>Maximum BTU size to be sent(265-65535) : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"max_send_btu_size\"  maxlength=\"5\" value=\"$arg_max_send_btu_size\" oninput=\"value=value.replace(/[^\\d]/g,'')\"/></td></tr>";
    
    #  Request CP-CP sessions?
print "<tr><td>Request CP-CP sessions ? </td> <td><select name=\"cp_cp_sess_support\"  class=\"rightAligned\" value=\"$arg_cp_cp_sess_support\" >  ";
print "<option value=\"YES\" selected=\"selected\">YES</option> ";
print "<option value=\"NO\">NO</option> </select></td></tr>";
    
    #   Remote node is a network node server?
print "<tr><td>Remote node is a network node server ?</td> <td><select name=\"default_nn_server\"  class=\"rightAligned\" value=\"$arg_default_nn_server\" >  ";
print "<option value=\"YES\">YES</option> ";
print "<option value=\"NO\" selected=\"selected\">NO</option> </select></td></tr>";
    
    #   Protocol
print "<tr><td>Protocol : </td> <td><select name=\"ip_version\"  class=\"rightAligned\" value=\"$arg_ip_version\" >  ";
print "<option value=\"IPV4\" selected=\"selected\">IPV4</option> ";
print "<option value=\"IPV6\">IPV6</option> </select></td></tr>";
    
    #  TG number
print "<tr><td>TG number(0-20) : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"tg_number\"  maxlength=\"2\" value=\"$arg_tg_number\" oninput=\"value=value.replace(/[^\\d]/g,'')\"/></td></tr>";
    
    #   Branch link type
print "<tr><td>Branch link type : </td> <td><select name=\"branch_link_type\"  class=\"rightAligned\" value=\"$arg_branch_link_type\" >  ";
print "<option value=\"NONE\" selected=\"selected\">NONE</option> ";
print "<option value=\"DOWNLINK\">DOWNLINK</option> ";
print "<option value=\"UPLINK\">UPLINK</option> </select></td></tr>";
    
    #   Restart on normal deactivation
print "<tr><td>Restart on normal deactivation : </td> <td> <select name=\"restart_on_normal_deact\"  class=\"rightAligned\" value=\"$arg_restart_on_normal_deact\" >  ";
print "<option value=\"YES\">YES</option> ";
print "<option value=\"NO\" selected=\"selected\">NO</option> </select></td></tr>";

    #  Acknowledgement timeout
print "<tr><td>Acknowledgement timeout(0-65535) : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"ack_timeout\"  maxlength=\"5\" value=\"$arg_ack_timeout\" oninput=\"value=value.replace(/[^\\d]/g,'')\"/></td></tr>";
    
    #  Maximum retry count
print "<tr><td>Maximum retry count(0-255) :</td> <td> <input type=\"text\" class=\"rightAligned\" name=\"max_retry\"  maxlength=\"3\" value=\"$arg_max_retry\" oninput=\"value=value.replace(/[^\\d]/g,'')\"/></td></tr>";
    
    #   Liveness timeout
print "<tr><td>Liveness timeout (1-65535) : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"liveness_timeout\"  maxlength=\"5\" value=\"$arg_liveness_timeout\" oninput=\"value=value.replace(/[^\\d]/g,'')\"/></td></tr>";
  
print "<input type=\"hidden\" name=\"up_time\" value=\"$up_time\"/>";

print "<input type=\"hidden\" name=\"hash\" value=\"$hash\"/>";
      
print "<tr> <td><input type=\"submit\" value=\"Submit\"></td> <td><input type=\"reset\"/></td></tr>";
print "</tbody> ";
print "</table> ";
print "</form>";
print "<p>";

exit 0;

