#!/usr/bin/perl -w
#######################################################
#                                                     #
# Copyright IBM Corporation 2018, 2025 All rights reserved. #
#                                                     #
#######################################################
use CGI qw(:standard);
use strict;
#
#   Define variables needed for token
#
our ($up_time, $hash);
require "./webadmin_bld_token.pl";

###########################################
#
# Begin of main section
#
###########################################
my ($arg, $arg_ee_dlc_name, $arg_description,  $arg_initially_active, 
    $arg_udp_port_llc, $arg_udp_port_network, $arg_udp_port_high, 
    $arg_udp_port_medium, $arg_udp_port_low, $description, 
    $udp_port_network, $udp_port_llc, $udp_port_high, $udp_port_medium, 
    $udp_port_low, $time, $remote_addr, $remote_port, $line, @data, 
    @contents, @listing, @retval);

$arg_ee_dlc_name="";
$arg_udp_port_llc="12000";
$arg_udp_port_network="12001";
$arg_udp_port_high="12002";
$arg_udp_port_medium="12003";
$arg_udp_port_low="12004";
$arg_description="";
$arg_initially_active="YES";
#
#  Get IP and port of client's socket connection
#
$remote_addr=$ENV{REMOTE_ADDR};
#$remote_port=$ENV{REMOTE_PORT}; Change to use HTTP_USER_AGENT env. var
$remote_port=$ENV{HTTP_USER_AGENT};
#
#
#  Build token for secure invocation of addaccess.cgi
#    
@retval = build_token($remote_addr, $remote_port);
$up_time = $retval[0];
$hash = $retval[1];
if ($up_time eq "0000") {
    print "<b>Failed to access the node. \n</b>";
    exit -1;
}

  
print "<font face=\"Times New Roman, Helvetica\">";
print "<form action= \"/cscbin/addeedlc.cgi\" method=\"post\">\n";
    
print "<table border=\"0\" cellpadding=\"0\" cellspacing=\"10\" width=\"100%\" style=\"border-collapse:separate; border-spacing:0px 10px;\"> ";
print "<tbody> ";

   # Define DLC name
print "<tr> <td>* DLC name : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"eedlcname_unique\"  maxlength=\"8\" value=\"$arg_ee_dlc_name\" required=\"required\" oninput=\"value=value.replace(/[^a-zA-Z0-9_.\$]/g,'')\" /></td></tr>";

    #   Define Description field
print "<tr> <td>Description :</td> <td><input type=\"text\" class=\"rightAligned\" name=\"description\" maxlength=\"31\" value=\"$arg_description\" /oninput=\"value=value.replace(/[^a-zA-Z0-9_-#!. @\(\)\$]/g,'')\" /></td></tr>";

    #   Define Initially active?
print "<tr> <td>Initially active ?</td> <td><select name=\"initially_active\" class=\"rightAligned\" value=\"$arg_initially_active\" > ";
print "<option value=\"YES\" selected=\"selected\">YES</option> ";
print "<option value=\"NO\">NO</option> </select></td></tr>";
    
    #   LLC UDP port number
print "<tr> <td>LLC UDP port number(0-65535) :</td> <td><input type=\"text\" class=\"rightAligned\" name=\"udp_port_llc\"  maxlength=\"5\"  value=\"$arg_udp_port_llc\" oninput=\"value=value.replace(/[^\\d]/g,'')\" /></td></tr>";
    
    #   Network UDP port number
print "<tr> <td>Network UDP port number(0-65535) : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"udp_port_network\"  maxlength=\"5\"  value=\"$arg_udp_port_network\" oninput=\"value=value.replace(/[^\\d]/g,'')\"/></td></tr>";
    
    #   High UDP port number
print "<tr> <td>High UDP port number(0-65535)  : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"udp_port_high\"  maxlength=\"5\"  value=\"$arg_udp_port_high\" oninput=\"value=value.replace(/[^\\d]/g,'')\"/></td></tr>";
    
    #   Medium UDP port number
print "<tr> <td>Medium UDP port number(0-65535) :</td> <td><input type=\"text\" class=\"rightAligned\" name=\"udp_port_medium\"  maxlength=\"5\"  value=\"$arg_udp_port_medium\" oninput=\"value=value.replace(/[^\\d]/g,'')\" /></td></tr>";
    
    #   Low UDP port number
print "<tr> <td>Low UDP port number(0-65535) :</td> <td> <input type=\"text\" class=\"rightAligned\" name=\"udp_port_low\"  maxlength=\"5\"  value=\"$arg_udp_port_low\" oninput=\"value=value.replace(/[^\\d]/g,'')\"/></td></tr>";

print "<input type=\"hidden\" name=\"up_time\" value=\"$up_time\"/>";

print "<input type=\"hidden\" name=\"hash\" value=\"$hash\"/>";
    
print "<tr> <td><input type=\"submit\"  value=\"Submit\"></td> <td><input type=\"reset\"/></td></tr>";
print "</tbody> ";
print "</table> ";
print "</form>";
print "<p>";

exit 0; 

