#!/usr/bin/perl -w
#############################################################
#                                                           #
# Copyright IBM Corporation 2004, 2025 All rights reserved. #
#                                                           #
#############################################################
use CGI qw(:standard);
use Digest::MD5 qw(md5_hex);
use strict;

my ($arg, $action, $cnname, $time, $token, $hash, $hash_parm, 
	$up_time, $description, $port_name, @result, $line, @contents);

my ($arg, $arg_tp_name, $arg_list_name, $arg_description, $arg_conv_type, 
    $arg_security_rqd, $arg_sync_level, $arg_pip_allowed, $description, 
    $list_name, $time, $token, $hash, $hash_parm, $up_time, $line, @data, 
    @contents, @retval);

print header('text/html');
open (SOURCE,"../cscdoc/CSLTMPL1.HTM") or die "Cannot open CS LINUX web template 1 $!\n";
@contents=<SOURCE>;
print @contents;
close (SOURCE);

$time=localtime;

print "<b> Communication Server Add Transaction Program Definition: $time</b>";
print "<font face=\"Times New Roman, Helvetica\">";
print "<p>\n";

if (! param) {
     print "Invalid invocation of Add Transaction Program Definition ";
} else {
#
#  Get Token from parameter up_time and the IP address and HTTP USER AGEBT Info for this session.
#  Check hash value passed in to verify a match, which must be same as the cfg_*.cgi HTTP Info
# 	
     $up_time=param('up_time');
     $token="$ENV{REMOTE_ADDR}_$ENV{HTTP_USER_AGENT}_$up_time"; 
     $hash_parm=param('hash');  # Get passed in checksum value
     $hash = md5_hex($token);   # Calculate our own 
     if ($hash ne $hash_parm) { # Check if these match

	print "Failed to validate invocation! <br>";
	exit 1;
     }
   $arg_tp_name=param('tp_name_unique');
   $arg_description=param('description');
   $arg_security_rqd=param('security_rqd');
   $arg_sync_level=param('sync_level');
   $arg_conv_type=param('conv_type');
   $arg_list_name=param('list_name');
   $arg_pip_allowed=param('pip_allowed');

    if ($arg_description eq "") {
        $description="";
    }else  {
        $description=",description=$arg_description";
    }
    
    if ($arg_list_name eq "") {
        $list_name="";
    }else  {
        $list_name=",list_name=$arg_list_name";
    }
    
   
    @contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin define_tp, tp_name=$arg_tp_name, security_rqd=$arg_security_rqd, pip_allowed=$arg_pip_allowed, conv_type=$arg_conv_type, sync_level=$arg_sync_level $list_name $description`;
    
    print "/opt/ibm/sna/bin/snaadmin define_tp, tp_name=$arg_tp_name, security_rqd=$arg_security_rqd, pip_allowed=$arg_pip_allowed, conv_type=$arg_conv_type, sync_level=$arg_sync_level $list_name $description";
   
    print "<br>Display Output from Add LU 6.2 Transaction Program Definition:";
    
   foreach $line (@contents) {
      next if ($line=~m/-----/);   # Do not display seperaters
      $line=~s/ /&nbsp;/g;
      print "$line";
   }
}
#
print "</b>";



print "</font></p>";
print "\n";
open (SOURCE,"../cscdoc/CSLTMPL2.HTM") or die "Cannot open CS Linux web template 2 $!\n";
@contents=<SOURCE>;
print @contents;
print "\n";
close (SOURCE);

exit 0; 

