#!/usr/bin/perl -w
#############################################################
#                                                           #
# Copyright IBM Corporation 2004, 2025 All rights reserved. #
#                                                           #
#############################################################
use CGI qw(:standard);
use Digest::MD5 qw(md5_hex);
use strict;

my ($arg, $arg_default_record, $arg_client_address, $arg_client_port, 
    $arg_listen_local_address, $arg_description, $arg_host_address, 
    $arg_host_port, $arg_host_ssl_enabled, $arg_serv_conn_security_level, 
    $arg_cli_ssl_enabled, $arg_cli_conn_security_levell, $client_address, 
    $listen_local_address, $description, $time, $token, $hash, $hash_parm, 
    $up_time, $line, @contents);

print header('text/html');
open (SOURCE,"../cscdoc/CSLTMPL1.HTM") or die "Cannot open CS LINUX web template 1 $!\n";
@contents=<SOURCE>;
print @contents;
close (SOURCE);

$time=localtime;

print "<b> Communication Server Config TN Redirector: $time</b>";
print "<font face=\"Times New Roman, Helvetica\">";
print "<p>\n";

if (! param) {
     print "Invalid invocation of Configure TN Redirector!";
} else {
#
#  Get Token from parameter up_time and the IP address and HTTP USER AGEBT Info for this session.
#  Check hash value passed in to verify a match, which must be same as the cfg_*.cgi HTTP Info
# 	
     $up_time=param('up_time');
     $token="$ENV{REMOTE_ADDR}_$ENV{HTTP_USER_AGENT}_$up_time"; 
     $hash_parm=param('hash');  # Get passed in checksum value
     $hash = md5_hex($token);   # Calculate our own 
     if ($hash ne $hash_parm) { # Check if these match

	print "Failed to validate invocation! <br>";
	exit 1;
     }
    $arg_default_record=param('default_record');
    $arg_client_address=param('client_address');
    $arg_client_port=param('client_port_unique');
    $arg_listen_local_address=param('listen_local_address');
    $arg_host_port=param('host_port');
    $arg_host_address=param('host_address');
    $arg_host_ssl_enabled=param('host_ssl_enabled');
    $arg_serv_conn_security_level=param('serv_conn_security_level');
    $arg_cli_ssl_enabled=param('cli_ssl_enabled');
    $arg_cli_conn_security_levell=param('cli_conn_security_levell');
    $arg_description=param('description');
    
    if ($arg_description eq "") {
        $description="";
    }else  {
        $description=",description=$arg_description";
    }
    
    if ($arg_client_address eq "") {
        $client_address="";
    }else  {
        $client_address=",client_address=$arg_client_address";
    }
    
    if ($arg_listen_local_address eq "") {
        $listen_local_address="";
    }else  {
        $listen_local_address=",listen_local_address=$arg_listen_local_address";
    }

    
    @contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin define_tn_redirect, default_record=$arg_default_record,  client_port=$arg_client_port, host_address=$arg_host_address, host_port=$arg_host_port,  host_ssl_enabled=$arg_host_ssl_enabled, serv_conn_security_level=$arg_serv_conn_security_level, cli_ssl_enabled=$arg_cli_ssl_enabled, cli_conn_security_level=$arg_cli_conn_security_levell $client_address $listen_local_address $description`;
    
   print "/opt/ibm/sna/bin/snaadmin define_tn_redirect, default_record=$arg_default_record,  client_port=$arg_client_port, host_address=$arg_host_address, host_port=$arg_host_port,  host_ssl_enabled=$arg_host_ssl_enabled, serv_conn_security_level=$arg_serv_conn_security_level, cli_ssl_enabled=$arg_cli_ssl_enabled, cli_conn_security_level=$arg_cli_conn_security_levell $client_address $listen_local_address $description";
   

   print "<br> Display Output from Add TN Redirector Access:";
    
   foreach $line (@contents) {
      next if ($line=~m/-----/);   # Do not display seperaters
      $line=~s/ /&nbsp;/g;
      print "<br>$line";
   }
}
#
print "</b>";



print "</font></p>";
print "\n";
open (SOURCE,"../cscdoc/CSLTMPL2.HTM") or die "Cannot open CS Linux web template 2 $!\n";
@contents=<SOURCE>;
print @contents;
print "\n";
close (SOURCE);

exit 0; 

