#!/usr/bin/perl -w
#############################################################
#                                                           #
# Copyright IBM Corporation 2004, 2025 All rights reserved. #
#                                                           #
#############################################################
use CGI qw(:standard);
use Digest::MD5 qw(md5_hex);
use strict;

my ($arg, $arg_default_record, $arg_client_address, $arg_port_number, 
    $arg_listen_local_address, $arg_description, $arg_lu_name, 
    $arg_printer_lu_name, $arg_tn3270_support, $arg_allow_specific_lu,
    $arg_ssl_enabled, $arg_security_level, $client_address, 
    $listen_local_address, $description, $lu_name, $printer_lu_name,
    $time, $token, $hash, $hash_parm, $up_time, $line, @contents);

print header('text/html');
open (SOURCE,"../cscdoc/CSLTMPL1.HTM") or die "Cannot open CS LINUX web template 1 $!\n";
@contents=<SOURCE>;
print @contents;
close (SOURCE);

$time=localtime;

print "<b> Communication Server Config TN3270 Access Definitions Results: $time</b>";
print "<font face=\"Times New Roman, Helvetica\">";
print "<p>\n";

if (! param) {
     print "Invalid invocation of Add TN3270 Access Definition!";
} else {
#
#  Get Token from parameter up_time and the IP address and HTTP USER AGEBT Info for this session.
#  Check hash value passed in to verify a match, which must be same as the cfg_*.cgi HTTP Info
# 	
     $up_time=param('up_time');
     $token="$ENV{REMOTE_ADDR}_$ENV{HTTP_USER_AGENT}_$up_time"; 
     $hash_parm=param('hash');  # Get passed in checksum value
     $hash = md5_hex($token);   # Calculate our own 
     if ($hash ne $hash_parm) { # Check if these match

	print "Failed to validate invocation! <br>";
	exit 1;
     }
    $arg_default_record=param('default_record');
    $arg_client_address=param('client_address');
    $arg_port_number=param('port_number_unique');
    $arg_listen_local_address=param('listen_local_address');
    $arg_description=param('description');
    $arg_printer_lu_name=param('printer_lu_name');
    $arg_lu_name=param('lu_name');
    $arg_tn3270_support=param('tn3270_support');
    $arg_allow_specific_lu=param('allow_specific_lu');
    $arg_ssl_enabled=param('ssl_enabled');
    $arg_security_level=param('security_level');
    
    if ($arg_description eq "") {
        $description="";
    }else  {
        $description=",description=$arg_description";
    }
    
    if ($arg_client_address eq "") {
        $client_address="";
    }else  {
        $client_address=",client_address=$arg_client_address";
    }
    
    if ($arg_listen_local_address eq "") {
        $listen_local_address="";
    }else  {
        $listen_local_address=",listen_local_address=$arg_listen_local_address";
    }
    
    if ($arg_lu_name eq "") {
        $lu_name="";
    }else  {
        $lu_name=",lu_name=$arg_lu_name";
    }
    
    if ($arg_printer_lu_name eq "") {
        $printer_lu_name="";
    }else  {
        $printer_lu_name=",printer_lu_name=$arg_printer_lu_name";
    }
    
    @contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin define_tn3270_access, default_record=$arg_default_record $client_address, {tn3270_session_data}, port_number=$arg_port_number, tn3270_support=$arg_tn3270_support, allow_specific_lu=$arg_allow_specific_lu, ssl_enabled=$arg_ssl_enabled, security_level=$arg_security_level $listen_local_address $description $lu_name $printer_lu_name`;
    
   print "/opt/ibm/sna/bin/snaadmin define_tn3270_access, default_record=$arg_default_record $client_address, {tn3270_session_data}, port_number=$arg_port_number, tn3270_support=$arg_tn3270_support, allow_specific_lu=$arg_allow_specific_lu, ssl_enabled=$arg_ssl_enabled, security_level=$arg_security_level $listen_local_address $description $lu_name $printer_lu_name";
   

   print "<br> Display Output from Add TN3270 Server Access:";
    
   foreach $line (@contents) {
      next if ($line=~m/-----/);   # Do not display seperaters
      $line=~s/ /&nbsp;/g;
      print "<br>$line";
   }
}
#

print "</b>";



print "</font></p>";
print "\n";
open (SOURCE,"../cscdoc/CSLTMPL2.HTM") or die "Cannot open CS Linux web template 2 $!\n";
@contents=<SOURCE>;
print @contents;
print "\n";
close (SOURCE);

exit 0; 

