#!/usr/bin/perl -w
#############################################################
#                                                           #
# Copyright IBM Corporation 2004, 2025 All rights reserved. #
#                                                           #
#############################################################
use CGI qw(:standard);
use Digest::MD5 qw(md5_hex);
use strict;

my ($arg, $action, $time, $token, $hash, $hash_parm, $up_time, 
    $arg_description, $arg_lu_alias, $arg_list_name, $arg_lu_name,
    $arg_lu_session_limit, $arg_syncpt_support, $arg_timeout, 
    $arg_sys_name, $arg_lu_attributes, $description, 
    $lu_session_limit, $sys_name, $list_name, $timeout, $line, 
    @contents);

print header('text/html');
open (SOURCE,"../cscdoc/CSLTMPL1.HTM") or die "Cannot open CS LINUX web template 1 $!\n";
@contents=<SOURCE>;
print @contents;
close (SOURCE);

$time=localtime;

print "<b> Add Independent LU Type 6.2 Results: $time</b>";
print "<font face=\"Times New Roman, Helvetica\">";
print "<p>\n";

if (! param) {
   print "Invalid invocation of Add Independent LU6.2!";
} else {
#
#  Get Token from parameter up_time and the IP address and port number for this session.
#  Check hash value passed in to verify a match, which must be same as the cfg_remove_focal_point.cgi session
# 	
   $up_time=param('up_time');
   $token ="$ENV{REMOTE_ADDR}_$ENV{HTTP_USER_AGENT}_$up_time"; # must be same as the cfg_add_indep_lu6.2.cgi session
   $hash_parm=param('hash');  # Get passed in checksum value
   $hash = md5_hex($token);   # Calculate our own 
   if ($hash ne $hash_parm) { # Check if these match

      print "Failed to validate invocation! <br>";
      exit 1;
   }
   $arg_lu_alias=param('indep_lu_alias_unique');
   $arg_description=param('description');
   $arg_syncpt_support=param('syncpt_support');
   $arg_timeout=param('timeout');
   $arg_lu_session_limit=param('lu_session_limit');
   $arg_list_name=param('list_name');
   $arg_lu_name=param('lu_name');
   $arg_lu_attributes=param('lu_attributes');
   $arg_sys_name=param('sys_name');
#
#  Need to set the following such that no parameter 
#   provided on input is written as "" on snaadmin
#   command syntax.
#
   if ($arg_description eq "") {
      $description="";
   }else {
      $description=",description=$arg_description";
   }
    
   if ($arg_timeout eq "") {
      $timeout="";
   }else {
      $timeout=",timeout=$arg_timeout";
   }

   if ($arg_lu_session_limit eq "") {
      $lu_session_limit="";
   }else {
      $lu_session_limit=",lu_session_limit=$arg_lu_session_limit";
   }
    
   if ($arg_list_name eq "") {
      $list_name="";
   }else {
      $list_name=",list_name=$arg_list_name";
   }
    
   if ($arg_sys_name eq "") {
      $sys_name="";
   }else {
      $sys_name=",sys_name=$arg_sys_name";
   }


   @contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin define_local_lu,lu_alias=$arg_lu_alias, lu_name=$arg_lu_name, syncpt_support=$arg_syncpt_support, lu_attributes=$arg_lu_attributes, nau_address=0 $list_name $description $timeout $sys_name $lu_session_limit`;
    
   print "/opt/ibm/sna/bin/snaadmin define_local_lu,lu_alias=$arg_lu_alias, lu_name=$arg_lu_name, syncpt_support=$arg_syncpt_support, lu_attributes=$arg_lu_attributes, nau_address=0 $list_name $description $timeout $sys_name $lu_session_limit";
   
  print "<br><br> Display Output from Add Independent LU Type 6.2:";
    
  foreach $line (@contents) {
    next if ($line=~m/-----/);   # Do not display seperaters
    $line=~s/ /&nbsp;/g;
    print "<br>$line";
  }
}

print "</font></p>";
print "\n";
open (SOURCE,"../cscdoc/CSLTMPL2.HTM") or die "Cannot open CS Linux web template 2 $!\n";
@contents=<SOURCE>;
print @contents;
print "\n";
close (SOURCE);

exit 0; 

