#!/usr/bin/perl -w
#############################################################
#                                                           #
# Copyright IBM Corporation 2004, 2025 All rights reserved. #
#                                                           #
#############################################################
use CGI qw(:standard);
use Digest::MD5 qw(md5_hex);
use strict;

my ($arg, $arg_ee_port_name, $arg_description, $arg_ip_version,$arg_dlc_name, 
    $arg_initially_active, $arg_implicit_uplink_to_en, $arg_max_rcv_btu_size, 
    $arg_tot_link_act_lim,$arg_local_ip_interface, $description, $dlc_name, 
    $local_ip_interface,$max_rcv_btu_size, $tot_link_act_lim,$ip_version, 
    $len, $time, $token, $hash, $hash_parm, $up_time, $line, @data, @contents, 
    @dlclist);

print header('text/html');
open (SOURCE,"../cscdoc/CSLTMPL1.HTM") or die "Cannot open CS LINUX web template 1 $!\n";
@contents=<SOURCE>;
print @contents;
close (SOURCE);

$time=localtime;

print "<b> Communication Server Config Manage Port Results: $time</b>";
print "<font face=\"Times New Roman, Helvetica\">";
print "<p>\n";

if (! param) {
     print "Invalid invocation of Port management!";
} else {
#
#  Get Token from parameter up_time and the IP address and port number for this session.
#  Check hash value passed in to verify a match, which must be same as the cfg_remove_focal_point.cgi session
# 	
     $up_time=param('up_time');
     $token ="$ENV{REMOTE_ADDR}_$ENV{HTTP_USER_AGENT}_$up_time"; # must be same as the cfg_remove_focal_point.cgi session
 
     $hash_parm=param('hash');  # Get passed in checksum value
     $hash = md5_hex($token);   # Calculate our own 
     if ($hash ne $hash_parm) { # Check if these match

	print "Failed to validate invocation! <br>";
	exit 1;
     }
   $arg_ee_port_name=param('eeportname_unique');
   $arg_description=param('description');
   $arg_dlc_name=param('dlc_name');
   $arg_initially_active=param('initially_active');
   $arg_local_ip_interface=param('local_ip_interface');
   $arg_implicit_uplink_to_en=param('implicit_uplink_to_en');
   $arg_max_rcv_btu_size=param('max_rcv_btu_size');
   $arg_tot_link_act_lim=param('tot_link_act_lim');
   $arg_ip_version=param('ip_version');
   
#  Make call to set items
#   Code to be added here
#
    if ($arg_description eq "") {
        $description="";
    }else {
        $description=",description=$arg_description";
    }
    
    if ($arg_local_ip_interface eq "") {
        $local_ip_interface="";
    }else {
        $local_ip_interface=",local_ip_interface=$arg_local_ip_interface";
    }
    
    if ($arg_max_rcv_btu_size eq "") {
        $max_rcv_btu_size="";
    }else {
        $max_rcv_btu_size=",max_rcv_btu_size=$arg_max_rcv_btu_size";
    }
    
    if ($arg_tot_link_act_lim eq "") {
        $tot_link_act_lim="";
    }else {
        $tot_link_act_lim=",tot_link_act_lim=$arg_tot_link_act_lim";
    }
    
    if ($arg_ip_version eq "") {
        $ip_version="";
    }else {
        $ip_version=",ip_version=$arg_ip_version";
    }
    
    @contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin define_ip_port,port_name= $arg_ee_port_name, dlc_name=$arg_dlc_name, initially_active=$arg_initially_active, implicit_uplink_to_en=$arg_implicit_uplink_to_en $ip_version $description $local_ip_interface  $max_rcv_btu_size $tot_link_act_lim  `;
    
    print "/opt/ibm/sna/bin/snaadmin define_ip_port,port_name= $arg_ee_port_name, dlc_name=$arg_dlc_name  , initially_active=$arg_initially_active  , implicit_uplink_to_en=$arg_implicit_uplink_to_en $ip_version $description $local_ip_interface  $max_rcv_btu_size $tot_link_act_lim ";
   
# Display output of snaadmin query_node
   print "Display Output from Add Enterprise Extender Port:";
    
   foreach $line (@contents) {
      next if ($line=~m/-----/);   # Do not display seperaters
      $line=~s/ /&nbsp;/g;
      print "<br>$line";
   }
}

print "</font></p>";
print "\n";
open (SOURCE,"../cscdoc/CSLTMPL2.HTM") or die "Cannot open CS Linux web template 2 $!\n";
@contents=<SOURCE>;
print @contents;
print "\n";
close (SOURCE);

exit 0; 

