#!/usr/bin/perl -w
#############################################################
#                                                           #
# Copyright IBM Corporation 2004, 2025 All rights reserved. #
#Fix issue with underscore in LS name                       #
#############################################################
use CGI qw(:standard);
use Digest::MD5 qw(md5_hex);
use strict;

my ($arg, $arg_ee_dlc_name, $arg_description,  $arg_initially_active, 
    $arg_udp_port_llc, $arg_udp_port_network, $arg_udp_port_high, 
    $arg_udp_port_medium, $arg_udp_port_low, $description, 
    $udp_port_network, $udp_port_llc, $udp_port_high, $udp_port_medium, 
    $udp_port_low, $time, $token, $hash, $hash_parm, $up_time, $line, @data, 
    @contents, @listing);

print header('text/html');
open (SOURCE,"../cscdoc/CSLTMPL1.HTM") or die "Cannot open CS LINUX web template 1 $!\n";
@contents=<SOURCE>;
print @contents;
close (SOURCE);

$time=localtime;

print "<b> Communication Server Config Manage DLC Results: $time</b>";
print "<font face=\"Times New Roman, Helvetica\">";
print "<p>\n";

if (! param) {
     print "Invalid invocation of DLC management!";
} else {
#
#  Get Token from parameter up_time and the IP address and port number for this session.
#  Check hash value passed in to verify a match, which must be same as the cfg_remove_focal_point.cgi session
# 	
     $up_time=param('up_time');
     $token ="$ENV{REMOTE_ADDR}_$ENV{HTTP_USER_AGENT}_$up_time"; # must be same as the cfg_remove_focal_point.cgi session
 
     $hash_parm=param('hash');  # Get passed in checksum value
     $hash = md5_hex($token);   # Calculate our own 
     if ($hash ne $hash_parm) { # Check if these match

	print "Failed to validate invocation! <br>";
	exit 1;
     }
     $arg_ee_dlc_name=param('eedlcname_unique');
     $arg_description=param('description');
     $arg_initially_active=param('initially_active');
     $arg_udp_port_llc=param('udp_port_llc');
     $arg_udp_port_network=param('udp_port_network');
     $arg_udp_port_high=param('udp_port_high');
     $arg_udp_port_medium=param('udp_port_medium');
     $arg_udp_port_low=param('udp_port_low');
    
   
#  Make call to set items
#   Code to be added here
#
    if ($arg_description eq "") {
        $description="";
    } else {
        $description=",description=$arg_description";
    }
    
    if ($arg_udp_port_network eq "") {
        $udp_port_network="";
    } else {
        $udp_port_network=",udp_port_network=$arg_udp_port_network";
    }
    
    if ($arg_udp_port_llc eq "") {
        $udp_port_llc="";
    } else {
        $udp_port_llc=",udp_port_llc=$arg_udp_port_llc";
    }
    if ($arg_udp_port_high eq "") {
        $udp_port_high="";
    } else {
        $udp_port_high=",udp_port_high=$arg_udp_port_high";
    }
    
    if ($arg_udp_port_medium eq "") {
        $udp_port_medium="";
    } else {
        $udp_port_medium=",udp_port_medium=$arg_udp_port_medium";
    }
    
    if ($arg_udp_port_low eq "") {
        $udp_port_low="";
    } else {
        $udp_port_low=",udp_port_low=$arg_udp_port_low";
    }
    @contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin define_ip_dlc,dlc_name=$arg_ee_dlc_name, initially_active=$arg_initially_active $udp_port_llc $udp_port_network $udp_port_high $udp_port_medium $udp_port_low $description`;
    
    print "/opt/ibm/sna/bin/snaadmin define_ip_dlc,dlc_name=$arg_ee_dlc_name, initially_active=$arg_initially_active $udp_port_llc $udp_port_network $udp_port_high $udp_port_medium $udp_port_low $description";
   
# Display output of snaadmin query_node
   print "<br> Display Output from Add Enterprise Extender DLC:";
    
   foreach $line (@contents) {
      next if ($line=~m/-----/);   # Do not display seperaters
      $line=~s/ /&nbsp;/g;
      print "<br>$line";
   }
}
#

print "</b>";



print "</font></p>";
print "\n";
open (SOURCE,"../cscdoc/CSLTMPL2.HTM") or die "Cannot open CS Linux web template 2 $!\n";
@contents=<SOURCE>;
print @contents;
print "\n";
close (SOURCE);

exit 0; 

