#!/usr/bin/perl -w
#############################################################
#                                                           #
# Copyright IBM Corporation 2004, 2025 All rights reserved. #
#                                                           #
#############################################################
use CGI qw(:standard);
use Digest::MD5 qw(md5_hex);
use strict;

my ($arg_fqplu_name, $arg_description, $arg_plu_alias, $arg_plu_un_name, 
    $arg_parallel_sess_supp, $arg_max_mc_ll_send_size, $arg_conv_security_ver, 
    $max_mc_ll_send_size, $plu_un_name, $description, $time, $token, $hash, 
    $hash_parm, $up_time, $line, @contents);

print header('text/html');
open (SOURCE,"../cscdoc/CSLTMPL1.HTM") or die "Cannot open CS LINUX web template 1 $!\n";
@contents=<SOURCE>;
print @contents;
close (SOURCE);

$time=localtime;

print "<b> Add Partner LU Results: $time</b>";
print "<font face=\"Times New Roman, Helvetica\">";
print "<p>\n";

if (! param) {
   print "Invalid invocation of Add Partner LU!";
} else {
#
#  Get Token from parameter up_time and the IP address and port number for this session.
#  Check hash value passed in to verify a match, which must be same as the cfg_remove_focal_point.cgi session
# 	
   $up_time=param('up_time');
   $token ="$ENV{REMOTE_ADDR}_$ENV{HTTP_USER_AGENT}_$up_time"; # must be same as the cfg_add_indep_lu6.2.cgi session
   $hash_parm=param('hash');  # Get passed in checksum value
   $hash = md5_hex($token);   # Calculate our own 
   if ($hash ne $hash_parm) { # Check if these match

      print "Failed to validate invocation! <br>";
      exit 1;
   }

   $arg_fqplu_name=param('fqplu_name_unique');
   $arg_description=param('description');
   $arg_plu_alias=param('plu_alias');
   $arg_plu_un_name=param('plu_un_name');
   $arg_parallel_sess_supp=param('parallel_sess_supp');
   $arg_max_mc_ll_send_size=param('max_mc_ll_send_size');
   $arg_conv_security_ver=param('conv_security_ver');

#  Make call to set items
#   Code to be added here
#
    if ($arg_description eq "") {
        $description="";
    }else  {
        $description=",description=$arg_description";
    }

    if ($arg_max_mc_ll_send_size eq "") {
        $max_mc_ll_send_size="";
    }else  {
        $max_mc_ll_send_size=",max_mc_ll_send_size=$arg_max_mc_ll_send_size";
    }

    if ($arg_plu_un_name eq "") {
        $plu_un_name="";
    }else  {
        $plu_un_name=",plu_un_name=$arg_plu_un_name";
    }
    
    @contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin define_partner_lu,fqplu_name=$arg_fqplu_name, plu_alias=$arg_plu_alias, parallel_sess_supp=$arg_parallel_sess_supp, conv_security_ver=$arg_conv_security_ver $description $plu_un_name $max_mc_ll_send_size`;
    
    print "/opt/ibm/sna/bin/snaadmin define_partner_lu,fqplu_name=$arg_fqplu_name, plu_alias=$arg_plu_alias, parallel_sess_supp=$arg_parallel_sess_supp, conv_security_ver=$arg_conv_security_ver $description $plu_un_name $max_mc_ll_send_size";
   
   print "<br>Display Output from LU 6.2 Partner LU :<br>";
    
   foreach $line (@contents) {
      next if ($line=~m/-----/);   # Do not display seperaters
      $line=~s/ /&nbsp;/g;
      print "<br>$line";
   }
}
#


print "</font></p>";
print "\n";
open (SOURCE,"../cscdoc/CSLTMPL2.HTM") or die "Cannot open CS Linux web template 2 $!\n";
@contents=<SOURCE>;
print @contents;
print "\n";
close (SOURCE);

exit 0; 

