#!/usr/bin/perl -w
#############################################################
#                                                           #
# Copyright IBM Corporation 2004, 2025 All rights reserved. #
#                                                           #
#############################################################
use CGI qw(:standard);
use Digest::MD5 qw(md5_hex);
use strict;

my ($arg, $arg_auth_type, $arg_ldap_addr, $arg_ldap_port, $arg_ldap_user, 
    $arg_ldap_password, $ldap_addr, $ldap_port, $ldap_user, $ldap_password, 
    $time, $cnname, $time, $token, $hash, $hash_parm, $up_time, $line, @contents);

print header('text/html');
open (SOURCE,"../cscdoc/CSLTMPL1.HTM") or die "Cannot open CS LINUX web template 1 $!\n";
@contents=<SOURCE>;
print @contents;
close (SOURCE);

$time=localtime;

print "<b> Communication Server Config Manage Connection Networks Results: $time</b>";
print "<font face=\"Times New Roman, Helvetica\">";
print "<p>\n";

if (! param) {
     print "Invalid invocation of Add SSL LDAP Information!";
} else {
#
#  Get Token from parameter up_time and the IP address and HTTP USER AGEBT Info for this session.
#  Check hash value passed in to verify a match, which must be same as the cfg_*.cgi HTTP Info
# 	
   $up_time=param('up_time');
   $token="$ENV{REMOTE_ADDR}_$ENV{HTTP_USER_AGENT}_$up_time"; 
   $hash_parm=param('hash');  # Get passed in checksum value
   $hash = md5_hex($token);   # Calculate our own 
   if ($hash ne $hash_parm) { # Check if these match

      print "Failed to validate invocation! <br>";
      exit 1;
   }
   $arg_auth_type=param('auth_type_unique');
   $arg_ldap_addr=param('ldap_addr');
   $arg_ldap_port=param('ldap_port');
   $arg_ldap_user=param('ldap_user');
   $arg_ldap_password=param('ldap_password');
    
    if ($arg_ldap_addr eq "") {
        $ldap_addr="";
    }else  {
        $ldap_addr=",ldap_addr=$arg_ldap_addr";
    }
    
    if ($arg_ldap_port eq "") {
        $ldap_port="";
    }else  {
        $ldap_port=",ldap_port=$arg_ldap_port";
    }
    if ($arg_ldap_user eq "") {
        $ldap_user="";
    }else  {
        $ldap_user=",ldap_user=$arg_ldap_user";
    }
    if ($arg_ldap_password eq "") {
        $ldap_password="";
    }else  {
        $ldap_password=",ldap_password=$arg_ldap_password";
    }
    
    @contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin define_tn3270_ssl_ldap, {tn3270_ssl_ldap_data}, auth_type=$arg_auth_type  $ldap_port $ldap_user $ldap_password $ldap_addr`;
    
    print "/opt/ibm/sna/bin/snaadmin define_tn3270_ssl_ldap, {tn3270_ssl_ldap_data}, auth_type=$arg_auth_type  $ldap_port $ldap_user $ldap_password $ldap_addr";
   

   print "<br> Display Output from Add TN Server SSL Client Authentication:<br>";
    
   foreach $line (@contents) {
      next if ($line=~m/-----/);   # Do not display seperaters
      $line=~s/ /&nbsp;/g;
      print "<br>$line";
   }
}
#
print "</b>";



print "</font></p>";
print "\n";
open (SOURCE,"../cscdoc/CSLTMPL2.HTM") or die "Cannot open CS Linux web template 2 $!\n";
@contents=<SOURCE>;
print @contents;
print "\n";
close (SOURCE);

exit 0; 

