#!/usr/bin/perl -w
#############################################################
#                                                           #
# Copyright IBM Corporation 2004, 2025 All rights reserved. #
#                                                           #
#############################################################
use CGI qw(:standard);
use Digest::MD5 qw(md5_hex);
use strict;

my ($arg_dslu_name, $arg_description, $arg_dspu_name, $arg_nau_address, 
    $arg_host_lu_name, $arg_delayed_logon, $arg_allow_timeout, $description, 
    $token, $hash, $hash_parm, $up_time, $time, $line, @data, @contents, @retval);

print header('text/html');
open (SOURCE,"../cscdoc/CSLTMPL1.HTM") or die "Cannot open CS LINUX web template 1 $!\n";
@contents=<SOURCE>;
print @contents;
close (SOURCE);

$time=localtime;

print "<b> Communication Server Define Downstream LU Results: $time</b>";
print "<font face=\"Times New Roman, Helvetica\">";
print "<p>\n";

if (! param) {
     print "Invalid invocation of Downstream LU management!";
} else {
#
#  Get Token from parameter up_time and the IP address and port number for this session.
#  Check hash value passed in to verify a match, which must be same as the cfg_remove_focal_point.cgi session
# 	
     $up_time=param('up_time');
     $token="$ENV{REMOTE_ADDR}_$ENV{HTTP_USER_AGENT}_$up_time";
 
     $hash_parm=param('hash');  # Get passed in checksum value
     $hash = md5_hex($token);   # Calculate our own 
     if ($hash ne $hash_parm) { # Check if these match

	print "Failed to validate invocation! <br>";
	exit 1;
     }
    $arg_dslu_name=param('dslu_name_unique');
    $arg_description=param('description');
    $arg_dspu_name=param('dspu_name');
    $arg_host_lu_name=param('host_lu_name');
    $arg_delayed_logon=param('delayed_logon');
    $arg_allow_timeout=param('allow_timeout');
    $arg_nau_address=param('nau_address');
   
#  Make call to set items
#   Code to be added here
#
    if ($arg_description eq "") {
        $description="";
    }else {
        $description=",description=$arg_description";
    }
    
    @contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin define_downstream_lu,dslu_name=$arg_dslu_name, nau_address=$arg_nau_address, dspu_name=$arg_dspu_name, delayed_logon=$arg_delayed_logon, host_lu_name= $arg_host_lu_name, allow_timeout=$arg_allow_timeout $description `;
    
    print "/opt/ibm/sna/bin/snaadmin define_downstream_lu,dslu_name=$arg_dslu_name, nau_address=$arg_nau_address, dspu_name=$arg_dspu_name, delayed_logon=$arg_delayed_logon, host_lu_name= $arg_host_lu_name, allow_timeout=$arg_allow_timeout $description ";
   
    print "Display Output from Add Downstream LU:";
    
   foreach $line (@contents) {
      next if ($line=~m/-----/);   # Do not display seperaters
      $line=~s/ /&nbsp;/g;
      print "<br>$line";
   }
}
#
print "</b>";



print "</font></p>";
print "\n";
open (SOURCE,"../cscdoc/CSLTMPL2.HTM") or die "Cannot open CS Linux web template 2 $!\n";
@contents=<SOURCE>;
print @contents;
print "\n";
close (SOURCE);

exit 0; 


