#!/usr/bin/perl -w
#######################################################
#                                                     #
# Copyright IBM Corporation 2004, 2025 All rights reserved. #
#                                                     #
#######################################################
use CGI qw(:standard);
use Digest::MD5 qw(md5_hex);
use strict;

my ($arg, $action, $nodename, $time, $token, $hash, $hash_parm, 
	$up_time, @result, $line, @contents, @retval);

print header('text/html');
open (SOURCE,"../cscdoc/CSLTMPL1.HTM") or die "Cannot open CS LINUX web template 1 $!\n";
@contents=<SOURCE>;
print @contents;
close (SOURCE);

$time=localtime;

print "<b> Communication Server Web Admin Manage Node Results: $time</b>";
print "<font face=\"Times New Roman, Helvetica\">";
print "<p>\n";

if (! param) {
     print "Invalid invocation of node management!";
} else {
#
#  Get Token from parameter up_time and the IP address and port number for this session.
#  Check hash value passed in to verify a match, which must be same as the cfg_remove_focal_point.cgi session
# 	
     $up_time=param('up_time');
     $token ="$ENV{REMOTE_ADDR}_$ENV{HTTP_USER_AGENT}_$up_time"; # must be same as the cfg_remove_focal_point.cgi session
 
     $hash_parm=param('hash');  # Get passed in checksum value
     $hash = md5_hex($token);   # Calculate our own 
     if ($hash ne $hash_parm) { # Check if these match

	print "Failed to validate invocation! <br>";
	exit 1;
     } 
     $arg=param('nodelist');
     ($action,$nodename) = (split(/_/,$arg) )[0,1];
     if ($action=~m/^alive/) {
	 @result=`sudo -u snauser /etc/init.d/snastart start`;
     } elsif ($action=~m/^dead/) {
         @result=`sudo -u snauser /opt/ibm/sna/bin/sna stop`;
     } elsif ($action=~m/^start/) {
	 @result=`sudo -u snauser /opt/ibm/sna/bin/snaadmin init_node`;
     } elsif ($action=~m/^stop/) {
         @result=`sudo -u snauser /opt/ibm/sna/bin/snaadmin term_node`;
     } else {
         print " Invalid action on node management!";
         exit 1;
     }       
}
print "<b>";
foreach(@result) {
   chomp;
   next if (/^------/);
   print $_; 
}
print "</b><br>";
print "<br><b> Node Status for <strong>$nodename</strong>: </b><br>";

@contents=`sudo -u snauser /opt/ibm/sna/bin/snaadmin status_node`;     # Command to get Node Status

foreach $line (@contents) {
#   chomp $line;
#  On none active lines, print end of list in html format
   $line=~s/ /&nbsp;/g;
   print "<br>$line";
}

print "</font></p>";
open (SOURCE,"../cscdoc/CSLTMPL2.HTM") or die "Cannot open CS Linux web template 2 $!\n";
@contents=<SOURCE>;
print @contents;
close (SOURCE);

exit 0; 

