#!/usr/bin/perl -w
#######################################################
#                                                     #
# Copyright IBM Corporation 2006, 2025 All rights reserved. #
#                                                     #
#######################################################
use CGI qw(:standard);
use Digest::MD5 qw(md5_hex);
use strict;

my ($arg, $trace_opt, $action, $linkname, $time, $token, $hash, $hash_parm, 
	$up_time, @result, $line, @contents);

print header('text/html');
open (SOURCE,"../cscdoc/CSLTMPL1.HTM") or die "Cannot open CS LINUX web template 1 $!\n";
@contents=<SOURCE>;
print @contents;
close (SOURCE);

$time=localtime;
$trace_opt = " ";
print "<b> Communication Server Web Admin DLC Trace: $time</b>";
print "<font face=\"Times New Roman, Helvetica\">";
print "<p>\n";

if (! param) {
   print "Invalid invocation of Trace activation!";
} else {
#
#  Get Token from parameter up_time and the IP address and port number for this session.
#  Check hash value passed in to verify a match, which must be same as the cfg_remove_focal_point.cgi session
# 	
   $up_time=param('up_time');
   $token ="$ENV{REMOTE_ADDR}_$ENV{HTTP_USER_AGENT}_$up_time"; # must be same as the cfg_remove_focal_point.cgi session
 
   $hash_parm=param('hash');  # Get passed in checksum value
   $hash = md5_hex($token);   # Calculate our own 
   if ($hash ne $hash_parm) { # Check if these match

     print "Failed to validate invocation! <br>";
     exit 1;
   }
   $arg=param('traceopt');
   if ($arg=~/^none/) {
 # Remove trace
      @result=`sudo -u snauser /opt/ibm/sna/bin/snaadmin remove_dlc_trace `;

   } elsif ($arg=~/^all/) {
 # Set trace
      @result=`sudo -u snauser /opt/ibm/sna/bin/snaadmin add_dlc_trace `;


   } else {
   # error in selection of trace flags
      print "Invalid selection of DLC Trace options!";
   }

}
print "<b>";
foreach(@result) {
   chomp;
   next if (/^------/);
   print $_;
}
print "</b><br>";

@contents=`sudo -u snauser /opt/ibm/sna/bin/snaadmin query_dlc_trace`; # Command to get Tracestatus

foreach $line (@contents) {
   $line=~s/ /&nbsp;/g;
   print "<br>$line";
}

print "</font></p>";
open (SOURCE,"../cscdoc/CSLTMPL2.HTM") or die "Cannot open CS Linux web template 2 $!\n";
@contents=<SOURCE>;
print @contents;
close (SOURCE);

exit 0;

