#!/usr/bin/perl -w

#

use strict;

 my ( $srv_index, $srvcnt, $port_num, $adj_ip_addr, $sysname,
      @servername, @data, @status );

#  Initialize for scalar declaration
$srvcnt = 0;

@status=`sudo -u snauser /opt/ibm/sna/bin/snaadmin query_node_all`;             # Get detailed Link Station information

foreach(@status) {
   chomp;
   if (/^query_node_all/) {
     print " Cannot process node $ARGV[0]\n";
     exit -1;
   }
 
  #  Skip headers
   next if (/^------/);
   next if (/^list_option/);

   next if (/^\n/);

   @data = split(/=/,$_);   #Break parameter = value

   next if (@data == 0);        # on blank line, skip

   if ($data[0]=~m/^node_name/) {       # get link station name  
     $servername[$srvcnt]=$data[1];
     $servername[$srvcnt]=~s/ //g;
#     printf("   Server %1d  %8s \n", $srvcnt+1, $servername[$srvcnt]);
     $srvcnt++;
     next;                                
   }
   
}
# print "\n------------------------------------------------\n";
   
#
#  Process the DLUR PU information
#

#  Initialize for scalar declaration
$srv_index = 0;

while ($srv_index < $srvcnt) 
{

   @status=`sudo -u snauser /opt/ibm/sna/bin/snaadmin -n $servername[$srv_index] query_rapi_clients` or die "Node $servername[$srv_index] not recognized $!\n";

#   Print header line

   printf("\n      Server: %s\n", $servername[$srv_index]);
   print "----------- ----------------- --------  --------  --------- \n";

   foreach(@status) {
      chomp;
      if (/^query_rapi_clients/) {
        print " Cannot process node $servername[$srv_index]\n";
        exit -1;
      }

     #  Skip headers
     next if (/^------/);
     next if (/^list_option/);
     next if (/^\n/);

     @data = split(/=/,$_);   #Break parameter = value

     next if (@data == 0);        # on blank line, skip

     if ($data[0]=~m/^sys_name/) {       # get sys_name  
        $sysname = $data[1];    #  save name
        $sysname=~s/ //g;       # remove any spaces as end
        next;   
     } elsif ($data[0]=~m/^adj_ip_addr/) { # adjacent IP address 
        $adj_ip_addr = $data[1];    #  save defined DLUS name
        $adj_ip_addr =~s/ //g;       # remove any spaces as end
        next;                              
     } elsif ($data[0]=~m/^port_number/) { # Determined Active DLUS
        $port_num = $data[1];    #  save Active DLUS name
        $port_num =~s/ //g;       # remove any spaces as end
#         printf(" Addr: %8s, Port: %8s, sys_name %8s, Server: %8s\n",
#               $adj_ip_addr, $port_num, $sysname, $servername[$srv_index]);          
         printf(" Addr: %8s, Port: %8s, sys_name %8s \n",
               $adj_ip_addr, $port_num, $sysname);
        next;
    } else {
        next;
    }

  }
  $srv_index++;
  print "\n";

}

print "\n------------------------------------------------\n";

