#!/usr/bin/perl -w
#######################################################
#                                                     #
# Copyright IBM Corporation 2013 All rights reserved. #
#                                                     #
#######################################################

#  Purpose of the script is to call snaadmin -a query_session,lu_name= and display
#  in a terse format the information.


use strict;

 my ( $luname, $display_flag, $count_flag, $len, @data, @status );

#  Initialize for scalar declaration
$display_flag = 0;

if ($#ARGV < 0)    # Check for input argument on line
{
  @status=`../cscbin/query_all_active_sess.sh`;

}

$len = @status;
if($len == 0){
   print " Cannot process node \n";
   exit -1;
}
#   Print header line

foreach(@status) {

   chomp;
   if (/^query_session/) {
     $display_flag = 1;
   }

  #  Skip headers
   next if (/^list_option/);

   next if (/^\n/);

   if (/^--------/) {       #  reset display flag 
     $display_flag = 0;
     next;
   }elsif ($display_flag > 0 ) { # display any line when this flag is set
     # print line and for sess_id and tp_id replace <> with html version of symbols
     if (/^session_id/) {  # Replace <> with &lt: and &gt;
        $_=~s/</&lt;/g;
        $_=~s/>/&gt;/g;
     }elsif (/^pcid/) {   # Replace <> with &lt: and &gt;
        $_=~s/</&lt;/g;
        $_=~s/>/&gt;/g;
     }
     print "$_\n";
     next;
   }

   @data = split(/=/,$_);   #Break label with value

   next if (@data == 0);        # on blank line, skip

# debug   print "line: $line:", @data;

   if ($data[0]=~m/^lu_name/) {       # get lu_alias for LU invoking this TP
     $luname = $data[1];
     $luname=~s/ //g;
     next;
   }elsif ($data[0]=m/^plu_alias/) {
     printf("\n --- LU Name: %8s --- \n",$luname);
     print "\n$_\n";
     $count_flag = 1;
     $display_flag = 1;
   }
}
if ($count_flag == 0) {
  printf("\n --- No sessions found --- \n");
} 
print "\n------------------------------------------------\n";

