/*
 * Decompiled with CFR 0.152.
 */
package hmcScanner;

import com.sshtools.j2ssh.SshClient;
import com.sshtools.j2ssh.authentication.PasswordAuthenticationClient;
import com.sshtools.j2ssh.authentication.PublicKeyAuthenticationClient;
import com.sshtools.j2ssh.authentication.SshAuthenticationClient;
import com.sshtools.j2ssh.connection.ChannelInputStream;
import com.sshtools.j2ssh.connection.ChannelOutputStream;
import com.sshtools.j2ssh.session.SessionChannelClient;
import com.sshtools.j2ssh.transport.HostKeyVerification;
import com.sshtools.j2ssh.transport.IgnoreHostKeyVerification;
import com.sshtools.j2ssh.transport.publickey.InvalidSshKeyException;
import com.sshtools.j2ssh.transport.publickey.SshPrivateKey;
import com.sshtools.j2ssh.transport.publickey.SshPrivateKeyFile;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.zip.GZIPOutputStream;

public class SSHManager {
    private SshClient ssh = new SshClient();
    private int status = 2;
    private static boolean DEBUG = false;

    public SSHManager(String logFile) {
        if (logFile != null) {
            try {
                FileHandler fh = new FileHandler(logFile);
                fh.setFormatter(new SimpleFormatter());
                Logger.getLogger("com.sshtools").setUseParentHandlers(false);
                Logger.getLogger("com.sshtools").addHandler(fh);
                Logger.getLogger("com.sshtools").setLevel(Level.ALL);
                System.out.println("Started logging SSH connection to " + logFile);
                return;
            }
            catch (IOException e) {
                System.out.println("Logging SSH connection to " + logFile + " failed");
            }
        }
        Logger.getLogger("com.sshtools").setLevel(Level.WARNING);
    }

    public SSHManager() {
        Logger.getLogger("com.sshtools").setLevel(Level.WARNING);
    }

    public static void main(String[] args) {
        SSHManager sshm = new SSHManager();
        if (!sshm.connect("127.0.0.1", "sysadmin", "passw0rd")) {
            System.out.println("Connection failed");
            System.exit(0);
        }
        int num = sshm.sendCommand("lsconfig -V", "c:\\lssyscfg.txt");
        System.out.println("Lette " + num + " righe");
    }

    public boolean connectKey(String host, String user, String keyFile) {
        SshPrivateKey sshPrivKey;
        PublicKeyAuthenticationClient sshClient;
        try {
            this.ssh.connect(host, (HostKeyVerification)new IgnoreHostKeyVerification());
            sshClient = new PublicKeyAuthenticationClient();
            SshPrivateKeyFile sshPrivKeyFile = SshPrivateKeyFile.parse((File)new File(keyFile));
            sshPrivKey = null;
            try {
                sshPrivKey = sshPrivKeyFile.toPrivateKey("");
            }
            catch (InvalidSshKeyException iske) {
                System.out.println("Wrong key or unsupported usage of passphrase.");
                return false;
            }
        }
        catch (IOException ioe) {
            System.out.println("Error in connecting to " + host + " with keyfile " + keyFile);
            System.out.println(ioe);
            return false;
        }
        sshClient.setKey(sshPrivKey);
        sshClient.setUsername(user);
        this.status = this.ssh.authenticate((SshAuthenticationClient)sshClient);
        return this.status == 4;
    }

    public boolean connect(String host, String user, String password) {
        try {
            this.ssh.connect(host, (HostKeyVerification)new IgnoreHostKeyVerification());
            PasswordAuthenticationClient pwd = new PasswordAuthenticationClient();
            pwd.setUsername(user);
            pwd.setPassword(password);
            this.status = this.ssh.authenticate((SshAuthenticationClient)pwd);
            return this.status == 4;
        }
        catch (IOException ioe) {
            System.out.println("Error in connecting to " + host + " with user " + user);
            return false;
        }
    }

    public void disconnect() {
        this.ssh.disconnect();
    }

    public int sendCommand(String command, String file) {
        return this.sendCommand(command, file, false, false);
    }

    public int sendCommand(String command, String file, boolean compressed) {
        return this.sendCommand(command, file, compressed, false);
    }

    public int sendCommand(String command, String file, boolean compressed, boolean progress) {
        SessionChannelClient session = null;
        ChannelOutputStream outStream = null;
        ChannelInputStream inStream = null;
        String end = "END-OF-TRANSMISSION";
        PrintWriter writer = null;
        int numLines = 0;
        long counter = 0L;
        long HASH = 0x100000L;
        try {
            int read;
            writer = !compressed ? new PrintWriter(new BufferedWriter(new FileWriter(file))) : new PrintWriter(new GZIPOutputStream(new FileOutputStream(file)));
            session = this.ssh.openSessionChannel();
            session.startShell();
            outStream = session.getOutputStream();
            end = "END-OF-TRANSMISSION";
            if (DEBUG) {
                System.out.println("Sending command: " + command);
                System.out.println("to file: " + file);
            }
            outStream.write(("LANG=C " + command + "; echo " + end + "\n").getBytes());
            inStream = session.getInputStream();
            byte[] buffer = new byte[20480];
            boolean stop = false;
            String inputLine = "";
            block2: while (!stop && (read = inStream.read(buffer)) > 0) {
                int eol;
                inputLine = String.valueOf(inputLine) + new String(buffer, 0, read);
                if (progress) {
                    counter += (long)read;
                    while (counter > 0x100000L) {
                        System.out.print(".");
                        counter -= 0x100000L;
                    }
                }
                while ((eol = inputLine.indexOf(10)) >= 0) {
                    String line = inputLine.substring(0, eol);
                    if (line.endsWith(end)) {
                        stop = true;
                        eol = line.indexOf(end);
                        if (eol <= 0) continue block2;
                        writer.println(line.substring(0, eol));
                        ++numLines;
                        continue block2;
                    }
                    writer.println(line);
                    ++numLines;
                    inputLine = inputLine.substring(eol + 1);
                }
            }
            session.close();
            writer.close();
            if (progress) {
                if (counter > 0L) {
                    System.out.print(". ");
                } else {
                    System.out.print(" ");
                }
            }
            return numLines;
        }
        catch (IOException ioe) {
            if (DEBUG) {
                System.out.println("IOException");
            }
            if (writer != null) {
                writer.close();
            }
            return 0;
        }
    }
}

