#!/bin/ksh

# Update the PATH variable to locate java executable
#  Minimum java version is 1.8
PATH=/usr/java8_64/bin:/usr/java8_64/jre/bin:/usr/java8/bin:/usr/java8/jre/bin:$PATH

# Set BASE to hmcScanner file location
BASE=$(dirname $0)

# Check that java is in the path
type java > /dev/null 2>&1
if [[ $? -ne 0 ]]
then
	echo "java is not in the path"
	exit 1
fi

# Start java version check
java -cp $BASE Test
if [[ $? -ne 0 ]]
then
	echo "java must be version 1.8 or higher"
	exit 1
fi
# End java version check

# Run the scanner
java -Xmx1024m -Duser.language=en -Djava.util.logging.config.file=$BASE/hmcScanner.properties -cp $BASE/bcprov-jdk15on-1.69.jar:$BASE/jsch-0.1.67.jar:$BASE/hmcScanner.jar:$BASE/jxl.jar hmcScanner.Loader $*
