/*
 * Decompiled with CFR 0.152.
 */
package hmcScanner;

import hmcScanner.StringChanger;
import java.util.GregorianCalendar;
import java.util.Vector;

public class NewLparStatus {
    private static int DAYS = 365;
    private static int HOURLY_DAYS = 60;
    private GregorianCalendar last;
    private String[][] msName = null;
    private String[][] poolName = null;
    private boolean[][] cap = null;
    private Vector<String> msNames = new Vector();
    private Vector<String> poolNames = new Vector();
    private static byte HOURLY = 0;
    private static byte DAILY = 1;
    private static byte MONTHLY = (byte)2;
    private boolean monthlyDone = false;

    public NewLparStatus(GregorianCalendar last) {
        this.last = (GregorianCalendar)last.clone();
        this.last.set(11, 23);
        this.last.set(12, 59);
        this.allocate();
    }

    private void createMonthlyData() {
        int j;
        int i;
        int[] poolCount = new int[this.poolNames.size()];
        int[] msCount = new int[this.msNames.size()];
        int capCount = 0;
        float num = 0.0f;
        GregorianCalendar curr = (GregorianCalendar)this.last.clone();
        GregorianCalendar prev = (GregorianCalendar)this.last.clone();
        int day = this.msName[DAILY].length - 1;
        int month = 12;
        while (day >= 0) {
            if (curr.get(2) == prev.get(2)) {
                if (this.msName[DAILY][day] != null) {
                    i = 0;
                    while (i < this.msNames.size()) {
                        if (this.msName[DAILY][day].equals(this.msName[DAILY][i])) {
                            int n = i;
                            msCount[n] = msCount[n] + 1;
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < this.poolNames.size()) {
                        if (this.poolName[DAILY][day].equals(this.poolName[DAILY][i])) {
                            int n = i;
                            poolCount[n] = poolCount[n] + 1;
                        }
                        ++i;
                    }
                    if (this.cap[DAILY][day]) {
                        ++capCount;
                    }
                    num += 1.0f;
                }
            } else {
                if (num > 0.0f) {
                    j = 0;
                    i = 0;
                    while (i < msCount.length) {
                        if (msCount[i] > msCount[j]) {
                            j = i;
                        }
                        ++i;
                    }
                    this.msName[NewLparStatus.MONTHLY][month] = this.msNames.elementAt(j);
                    j = 0;
                    i = 0;
                    while (i < poolCount.length) {
                        if (poolCount[i] > poolCount[j]) {
                            j = i;
                        }
                        ++i;
                    }
                    this.poolName[NewLparStatus.MONTHLY][month] = this.poolNames.elementAt(j);
                    if ((float)capCount > num / 2.0f) {
                        this.cap[NewLparStatus.MONTHLY][month] = true;
                    }
                }
                --month;
                i = 0;
                while (i < msCount.length) {
                    msCount[i] = 0;
                    ++i;
                }
                i = 0;
                while (i < poolCount.length) {
                    poolCount[i] = 0;
                    ++i;
                }
                capCount = 0;
                num = 0.0f;
                prev = (GregorianCalendar)curr.clone();
            }
            curr.add(5, -1);
            --day;
        }
        if (num > 0.0f) {
            j = 0;
            i = 0;
            while (i < msCount.length) {
                if (msCount[i] > msCount[j]) {
                    j = i;
                }
                ++i;
            }
            this.msName[NewLparStatus.MONTHLY][month] = this.msNames.elementAt(j);
            j = 0;
            i = 0;
            while (i < poolCount.length) {
                if (poolCount[i] > poolCount[j]) {
                    j = i;
                }
                ++i;
            }
            this.poolName[NewLparStatus.MONTHLY][month] = this.poolNames.elementAt(j);
            if ((float)capCount > num / 2.0f) {
                this.cap[NewLparStatus.MONTHLY][month] = true;
            }
        }
        this.monthlyDone = true;
    }

    private void allocate() {
        this.msName = new String[3][];
        this.poolName = new String[3][];
        this.cap = new boolean[3][];
        this.msName[NewLparStatus.HOURLY] = new String[1440];
        this.poolName[NewLparStatus.HOURLY] = new String[1440];
        this.cap[NewLparStatus.HOURLY] = new boolean[1440];
        this.msName[NewLparStatus.DAILY] = new String[365];
        this.poolName[NewLparStatus.DAILY] = new String[365];
        this.cap[NewLparStatus.DAILY] = new boolean[365];
        this.msName[NewLparStatus.MONTHLY] = new String[13];
        this.poolName[NewLparStatus.MONTHLY] = new String[13];
        this.cap[NewLparStatus.MONTHLY] = new boolean[13];
    }

    private int getSlot(GregorianCalendar gc, int type) {
        int slot = 0;
        float diff = this.last.getTimeInMillis() - gc.getTimeInMillis();
        if (type == HOURLY) {
            slot = HOURLY_DAYS * 24 - 1 - (int)(diff / 3600000.0f);
        } else if (type == DAILY) {
            slot = DAYS - 1 - (int)(diff / 8.64E7f);
        }
        return slot;
    }

    private String getMSString(String s) {
        int i = 0;
        while (i < this.msNames.size()) {
            if (s.equals(this.msNames.elementAt(i))) break;
            ++i;
        }
        if (i < this.msNames.size()) {
            return this.msNames.elementAt(i);
        }
        this.msNames.add(s);
        return s;
    }

    private String getPoolString(String s) {
        int i = 0;
        while (i < this.poolNames.size()) {
            if (s.equals(this.poolNames.elementAt(i))) break;
            ++i;
        }
        if (i < this.poolNames.size()) {
            return this.poolNames.elementAt(i);
        }
        this.poolNames.add(s);
        return s;
    }

    private void addData(GregorianCalendar gc, String ms, String pool, boolean cap, byte type) {
        int slot;
        if (pool.equals("")) {
            pool = "DefaultPool";
        }
        if ((slot = this.getSlot(gc, type)) < 0 || slot >= this.msName[type].length) {
            return;
        }
        if (this.msName[type][slot] != null) {
            // empty if block
        }
        this.msName[type][slot] = this.getMSString(ms);
        this.poolName[type][slot] = this.getPoolString(pool);
        this.cap[type][slot] = cap;
    }

    public void addHourData(GregorianCalendar gc, String ms, String pool, boolean cap) {
        this.addData(gc, ms, pool, cap, HOURLY);
    }

    public void addDayData(GregorianCalendar gc, String ms, String pool, boolean cap) {
        this.addData(gc, ms, pool, cap, DAILY);
    }

    public String[] getHourlyLabels() {
        String[] result = new String[this.msName[HOURLY].length];
        int i = 0;
        while (i < this.msName[HOURLY].length) {
            GregorianCalendar gc = (GregorianCalendar)this.last.clone();
            gc.add(10, -i);
            result[this.msName[NewLparStatus.HOURLY].length - 1 - i] = String.valueOf(gc.get(1)) + "/" + (gc.get(2) + 1) + "/" + gc.get(5) + " " + gc.get(11);
            ++i;
        }
        return result;
    }

    public String[] getDailyLabels() {
        String[] result = new String[this.msName[DAILY].length];
        int i = 0;
        while (i < this.msName[DAILY].length) {
            GregorianCalendar gc = (GregorianCalendar)this.last.clone();
            gc.add(5, -i);
            result[this.msName[NewLparStatus.DAILY].length - 1 - i] = String.valueOf(gc.get(1)) + "/" + (gc.get(2) + 1) + "/" + gc.get(5);
            ++i;
        }
        return result;
    }

    public String[] getMonthlyLabels() {
        if (!this.monthlyDone) {
            this.createMonthlyData();
        }
        String[] result = new String[this.msName[MONTHLY].length];
        int i = 0;
        while (i < this.msName[MONTHLY].length) {
            GregorianCalendar gc = (GregorianCalendar)this.last.clone();
            gc.add(2, -i);
            result[this.msName[NewLparStatus.MONTHLY].length - 1 - i] = String.valueOf(gc.get(1)) + "/" + (gc.get(2) + 1);
            ++i;
        }
        return result;
    }

    public String getHourMS(int hour) {
        if (hour < 0 || hour >= this.msName[HOURLY].length || this.msName[HOURLY][hour] == null) {
            return null;
        }
        return this.msName[HOURLY][hour];
    }

    public String getHourPool(int hour) {
        if (hour < 0 || hour >= this.poolName[HOURLY].length || this.poolName[HOURLY][hour] == null) {
            return null;
        }
        return this.poolName[HOURLY][hour];
    }

    public boolean getHourCap(int hour) {
        if (hour < 0 || hour >= this.cap[HOURLY].length || this.msName[HOURLY][hour] == null) {
            return true;
        }
        return this.cap[HOURLY][hour];
    }

    public String getDayMS(int day) {
        if (day < 0 || day >= this.msName[DAILY].length || this.msName[DAILY][day] == null) {
            return null;
        }
        return this.msName[DAILY][day];
    }

    public String getDayPool(int day) {
        if (day < 0 || day >= this.poolName[DAILY].length || this.poolName[DAILY][day] == null) {
            return null;
        }
        return this.poolName[DAILY][day];
    }

    public boolean getDayCap(int day) {
        if (day < 0 || day >= this.cap[DAILY].length || this.msName[DAILY][day] == null) {
            return true;
        }
        return this.cap[DAILY][day];
    }

    public String getMonthMS(int month) {
        if (!this.monthlyDone) {
            this.createMonthlyData();
        }
        if (this.msName[MONTHLY] == null || month < 0 || month > this.msName[MONTHLY].length || this.msName[MONTHLY][month] == null) {
            return null;
        }
        return this.msName[MONTHLY][month];
    }

    public String getMonthPool(int month) {
        if (!this.monthlyDone) {
            this.createMonthlyData();
        }
        if (this.poolName[MONTHLY] == null || month < 0 || month > this.poolName[MONTHLY].length || this.poolName[MONTHLY][month] == null) {
            return null;
        }
        return this.poolName[MONTHLY][month];
    }

    public boolean getMonthCap(int month) {
        if (!this.monthlyDone) {
            this.createMonthlyData();
        }
        if (this.cap[MONTHLY] == null || month < 0 || month > this.cap[MONTHLY].length) {
            return true;
        }
        return this.cap[MONTHLY][month];
    }

    public void sanitize(StringChanger msChange, StringChanger poolChange) {
        int j;
        int i = 0;
        while (this.msNames != null && i < this.msNames.size()) {
            this.msNames.setElementAt(msChange.translate(this.msNames.elementAt(i)), i);
            ++i;
        }
        i = 0;
        while (this.poolNames != null && i < this.poolNames.size()) {
            if (!this.poolNames.elementAt(i).equals("DefaultPool")) {
                this.poolNames.setElementAt(poolChange.translate(this.poolNames.elementAt(i)), i);
            }
            ++i;
        }
        i = 0;
        while (this.msName != null && i < this.msName.length) {
            j = 0;
            while (this.msName[i] != null && j < this.msName[i].length) {
                this.msName[i][j] = msChange.translate(this.msName[i][j]);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (this.poolName != null && i < this.poolName.length) {
            j = 0;
            while (this.poolName[i] != null && j < this.poolName[i].length) {
                if (this.poolName[i][j] != null && !this.poolName[i][j].equals("DefaultPool")) {
                    this.poolName[i][j] = poolChange.translate(this.poolName[i][j]);
                }
                ++j;
            }
            ++i;
        }
    }
}

