/*
 * Decompiled with CFR 0.152.
 */
package hmcScanner;

public class DiskData {
    private static byte STEP = (byte)30;
    private int num_uuid = 0;
    private int[] uuid = null;
    private int[] size = null;
    private int[][] u_vios = null;
    private int[][] u_name = null;
    private int[][] u_free = null;
    private static byte UUID = 0;
    private static byte VIOSNAME = 1;
    private static byte HDISKNAME = (byte)2;
    private static byte NUM_NAMES = (byte)3;
    private int[] counter = new int[NUM_NAMES];
    private String[][] name = new String[NUM_NAMES][];
    private int[][] index = new int[NUM_NAMES][];

    public void addSize(String ms, String vios, String hdisk, int mb) {
        int hdisk_index = this.getName(hdisk, HDISKNAME, 0, this.counter[HDISKNAME] - 1);
        int vios_index = this.getName(String.valueOf(ms) + "@" + vios, VIOSNAME, 0, this.counter[VIOSNAME] - 1);
        int i = 0;
        while (i < this.num_uuid) {
            int j = 0;
            while (j < this.u_vios[i].length) {
                if (this.u_vios[i][j] == vios_index && this.u_name[i][j] == hdisk_index) {
                    this.size[i] = mb;
                    return;
                }
                ++j;
            }
            ++i;
        }
    }

    public void addFree(String ms, String vios, String hdisk) {
        int hdisk_index = this.getName(hdisk, HDISKNAME, 0, this.counter[HDISKNAME] - 1);
        int vios_index = this.getName(String.valueOf(ms) + "@" + vios, VIOSNAME, 0, this.counter[VIOSNAME] - 1);
        int i = 0;
        while (i < this.num_uuid) {
            int j = 0;
            while (j < this.u_vios[i].length) {
                if (this.u_vios[i][j] == vios_index && this.u_name[i][j] == hdisk_index) {
                    this.u_free[i][j] = 1;
                    return;
                }
                ++j;
            }
            ++i;
        }
    }

    public int getNumUUID() {
        return this.num_uuid;
    }

    public String getUUIDname(int id) {
        return this.name[UUID][this.index[UUID][id]];
    }

    public int getSize(int id) {
        return this.size[this.index[UUID][id]];
    }

    public String[] getViosNames() {
        String[] result = new String[this.counter[VIOSNAME]];
        int i = 0;
        while (i < this.counter[VIOSNAME]) {
            result[i] = this.name[VIOSNAME][this.index[VIOSNAME][i]];
            ++i;
        }
        return result;
    }

    public String[] getHdiskOnViosNames(int id) {
        String[] result = new String[this.counter[VIOSNAME]];
        int i = 0;
        while (i < this.counter[VIOSNAME]) {
            int j = 0;
            while (j < this.u_vios[this.index[UUID][id]].length) {
                if (this.index[VIOSNAME][i] == this.u_vios[this.index[UUID][id]][j]) {
                    result[i] = this.name[HDISKNAME][this.u_name[this.index[UUID][id]][j]];
                    break;
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    public boolean[] getFreeOnViosNames(int id) {
        boolean[] result = new boolean[this.counter[VIOSNAME]];
        int i = 0;
        while (i < this.counter[VIOSNAME]) {
            int j = 0;
            while (j < this.u_vios[this.index[UUID][id]].length) {
                if (this.index[VIOSNAME][i] == this.u_vios[this.index[UUID][id]][j]) {
                    result[i] = this.u_free[this.index[UUID][id]][j] == 1;
                    break;
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    public void add_uuid(String new_uuid, String new_hdisk, String ms, String vios) {
        int uuid_index = this.getName(new_uuid, UUID, 0, this.counter[UUID] - 1);
        int hdisk_index = this.getName(new_hdisk, HDISKNAME, 0, this.counter[HDISKNAME] - 1);
        int vios_index = this.getName(String.valueOf(ms) + "@" + vios, VIOSNAME, 0, this.counter[VIOSNAME] - 1);
        if (this.num_uuid == 0) {
            this.uuid = new int[STEP];
            this.size = new int[STEP];
            this.u_vios = new int[STEP][];
            this.u_name = new int[STEP][];
            this.u_free = new int[STEP][];
        }
        int i = 0;
        while (i < this.num_uuid && this.uuid[i] != uuid_index) {
            ++i;
        }
        if (i == this.num_uuid) {
            if (this.num_uuid == this.uuid.length) {
                int[] tmp_uuid = new int[this.uuid.length + STEP];
                int[] tmp_size = new int[this.uuid.length + STEP];
                int[][] tmp_u_vios = new int[this.uuid.length + STEP][];
                int[][] tmp_u_name = new int[this.uuid.length + STEP][];
                int[][] tmp_u_free = new int[this.uuid.length + STEP][];
                int j = 0;
                while (j < this.uuid.length) {
                    tmp_uuid[j] = this.uuid[j];
                    tmp_size[j] = this.size[j];
                    tmp_u_vios[j] = this.u_vios[j];
                    tmp_u_name[j] = this.u_name[j];
                    tmp_u_free[j] = this.u_free[j];
                    ++j;
                }
                this.uuid = tmp_uuid;
                this.size = tmp_size;
                this.u_vios = tmp_u_vios;
                this.u_name = tmp_u_name;
                this.u_free = tmp_u_free;
            }
            this.uuid[this.num_uuid] = uuid_index;
            this.u_name[this.num_uuid] = this.addToList(hdisk_index, this.u_name[this.num_uuid]);
            this.u_vios[this.num_uuid] = this.addToList(vios_index, this.u_vios[this.num_uuid]);
            this.u_free[this.num_uuid] = this.addToList(0, this.u_free[this.num_uuid]);
            ++this.num_uuid;
        } else {
            this.u_name[i] = this.addToList(hdisk_index, this.u_name[i]);
            this.u_vios[i] = this.addToList(vios_index, this.u_vios[i]);
            this.u_free[i] = this.addToList(0, this.u_free[i]);
        }
    }

    private int[] addToList(int n, int[] list) {
        if (list == null) {
            int[] new_list = new int[]{n};
            return new_list;
        }
        int[] new_list = new int[list.length + 1];
        int i = 0;
        while (i < list.length) {
            new_list[i] = list[i];
            ++i;
        }
        new_list[list.length] = n;
        return new_list;
    }

    private int getName(String target, byte type, int from, int to) {
        if (this.counter[type] == 0) {
            this.name[type] = new String[STEP];
            this.name[type][0] = target;
            this.index[type] = new int[STEP];
            this.index[type][0] = 0;
            this.counter[type] = 1;
            return 0;
        }
        int res = this.name[type][this.index[type][(from + to) / 2]].compareTo(target);
        if (res == 0) {
            return this.index[type][(from + to) / 2];
        }
        if (from == to) {
            int i;
            if (this.counter[type] == this.name[type].length) {
                String[] new_name = new String[this.name[type].length + STEP];
                i = 0;
                while (i < this.counter[type]) {
                    new_name[i] = this.name[type][i];
                    ++i;
                }
                this.name[type] = new_name;
                int[] new_index = new int[this.name[type].length + STEP];
                i = 0;
                while (i < this.counter[type]) {
                    new_index[i] = this.index[type][i];
                    ++i;
                }
                this.index[type] = new_index;
            }
            this.name[type][this.counter[type]] = target;
            if (res < 0) {
                i = this.counter[type];
                while (i > from) {
                    this.index[type][i] = this.index[type][i - 1];
                    --i;
                }
                this.index[type][from] = this.counter[type];
            } else {
                i = this.counter[type];
                while (i > from + 1) {
                    this.index[type][i] = this.index[type][i - 1];
                    --i;
                }
                this.index[type][from + 1] = this.counter[type];
            }
            byte by = type;
            this.counter[by] = this.counter[by] + 1;
            return this.counter[type] - 1;
        }
        if (res < 0) {
            return this.getName(target, type, from, (from + to) / 2);
        }
        if (to == from + 1) {
            return this.getName(target, type, to, to);
        }
        return this.getName(target, type, (from + to) / 2, to);
    }
}

