/*
 * Decompiled with CFR 0.152.
 */
package hmcScanner;

import hmcScanner.StatManager;
import java.util.GregorianCalendar;

public class DataManager {
    private static int DAYS = 365;
    private static int HOURLY_DAYS = 60;
    private GregorianCalendar last;
    private float[] dailyData = new float[365];
    private float[] hourlyData = new float[1440];
    private float[] monthlyData = null;
    private StatManager dailyStat = new StatManager();
    private StatManager hourlyStat = new StatManager();
    private StatManager[] monthlyStat = new StatManager[13];

    private void createMonthlyData() {
        float sum = 0.0f;
        float num = 0.0f;
        int month = 0;
        while (month < 13) {
            this.monthlyStat[month] = new StatManager();
            ++month;
        }
        this.monthlyData = new float[13];
        GregorianCalendar curr = (GregorianCalendar)this.last.clone();
        GregorianCalendar prev = (GregorianCalendar)this.last.clone();
        int day = this.dailyData.length - 1;
        month = 12;
        while (day >= 0) {
            if (curr.get(2) == prev.get(2)) {
                if (this.dailyData[day] >= 0.0f) {
                    sum += this.dailyData[day];
                    num += 1.0f;
                    this.monthlyStat[month].addNumber(this.dailyData[day]);
                }
            } else {
                this.monthlyData[month] = num > 0.0f ? sum / num : -1.0f;
                --month;
                if (this.dailyData[day] >= 0.0f) {
                    sum = this.dailyData[day];
                    num = 1.0f;
                    this.monthlyStat[month].addNumber(this.dailyData[day]);
                } else {
                    sum = 0.0f;
                    num = 0.0f;
                }
                prev = (GregorianCalendar)curr.clone();
            }
            curr.add(5, -1);
            --day;
        }
        this.monthlyData[month] = num > 0.0f ? sum / num : -1.0f;
    }

    public void addHourData(GregorianCalendar gc, float value) {
        int slot = this.getHourSlot(gc);
        if (slot < 0 || slot >= this.hourlyData.length) {
            return;
        }
        if (this.hourlyData[slot] >= 0.0f) {
            // empty if block
        }
        this.hourlyData[slot] = value;
        this.hourlyStat.addNumber(value);
    }

    public float getHourData(GregorianCalendar gc) {
        int slot = this.getHourSlot(gc);
        if (slot < 0 || slot >= this.hourlyData.length) {
            System.out.println("Out of bound hourly data request: " + gc.get(1) + "/" + (gc.get(2) + 1) + "/" + gc.get(5) + " " + gc.get(11) + ":" + gc.get(12) + "/" + gc.get(13));
            return -1.0f;
        }
        return this.hourlyData[slot];
    }

    public float getHourData(int slot) {
        if (slot < 0 || slot >= this.hourlyData.length) {
            System.out.println("Out of bound hourly data request: slot " + slot);
            return -1.0f;
        }
        return this.hourlyData[slot];
    }

    public float getMonthData(int slot) {
        if (this.monthlyData == null) {
            this.createMonthlyData();
        }
        if (slot < 0 || slot >= this.monthlyData.length) {
            System.out.println("Out of bound monthly data request: slot " + slot);
            return -1.0f;
        }
        return this.monthlyData[slot];
    }

    public void addDayData(GregorianCalendar gc, float value) {
        int slot = this.getSlot(gc);
        if (slot < 0 || slot >= this.dailyData.length) {
            return;
        }
        if (this.dailyData[slot] >= 0.0f) {
            // empty if block
        }
        this.dailyData[slot] = value;
        this.dailyStat.addNumber(value);
    }

    public float getDayData(GregorianCalendar gc) {
        int slot = this.getSlot(gc);
        if (slot < 0 || slot >= this.dailyData.length) {
            System.out.println("Out of bound daily data request: " + gc.get(1) + "/" + (gc.get(2) + 1) + "/" + gc.get(5) + " " + gc.get(11) + ":" + gc.get(12) + "/" + gc.get(13));
            return -1.0f;
        }
        return this.dailyData[slot];
    }

    public float getDayData(int slot) {
        if (slot < 0 || slot >= this.dailyData.length) {
            System.out.println("Out of bound daily data request: slot" + slot);
            return -1.0f;
        }
        return this.dailyData[slot];
    }

    public DataManager(GregorianCalendar last) {
        this.last = (GregorianCalendar)last.clone();
        this.last.set(11, 23);
        this.last.set(12, 59);
        int i = 0;
        while (i < this.hourlyData.length) {
            this.hourlyData[i] = -1.0f;
            ++i;
        }
        i = 0;
        while (i < this.dailyData.length) {
            this.dailyData[i] = -1.0f;
            ++i;
        }
        this.dailyStat.setStep(0.01);
        this.hourlyStat.setStep(0.01);
    }

    public String[] getHourlyLabels() {
        String[] result = new String[this.hourlyData.length];
        int i = 0;
        while (i < this.hourlyData.length) {
            GregorianCalendar gc = (GregorianCalendar)this.last.clone();
            gc.add(10, -i);
            result[this.hourlyData.length - 1 - i] = String.valueOf(gc.get(1)) + "/" + (gc.get(2) + 1) + "/" + gc.get(5) + " " + gc.get(11);
            ++i;
        }
        return result;
    }

    public String getHourLabel(int n) {
        GregorianCalendar gc = (GregorianCalendar)this.last.clone();
        gc.add(10, n - this.hourlyData.length + 1);
        return String.valueOf(gc.get(1)) + "/" + (gc.get(2) + 1) + "/" + gc.get(5) + " " + gc.get(11);
    }

    public String[] getDailyLabels() {
        String[] result = new String[this.dailyData.length];
        int i = 0;
        while (i < this.dailyData.length) {
            GregorianCalendar gc = (GregorianCalendar)this.last.clone();
            gc.add(5, -i);
            result[this.dailyData.length - 1 - i] = String.valueOf(gc.get(1)) + "/" + (gc.get(2) + 1) + "/" + gc.get(5);
            ++i;
        }
        return result;
    }

    public String getDayLabel(int n) {
        GregorianCalendar gc = (GregorianCalendar)this.last.clone();
        gc.add(10, n - this.dailyData.length + 1);
        return String.valueOf(gc.get(1)) + "/" + (gc.get(2) + 1) + "/" + gc.get(5);
    }

    public String[] getMonthlyLabels() {
        if (this.monthlyData == null) {
            this.createMonthlyData();
        }
        String[] result = new String[this.monthlyData.length];
        int i = 0;
        while (i < this.monthlyData.length) {
            GregorianCalendar gc = (GregorianCalendar)this.last.clone();
            gc.add(2, -i);
            result[this.monthlyData.length - 1 - i] = String.valueOf(gc.get(1)) + "/" + (gc.get(2) + 1);
            ++i;
        }
        return result;
    }

    private int getSlot(GregorianCalendar gc) {
        float diff = this.last.getTimeInMillis() - gc.getTimeInMillis();
        int day = DAYS - 1 - (int)(diff / 8.64E7f);
        return day;
    }

    private int getHourSlot(GregorianCalendar gc) {
        float diff = this.last.getTimeInMillis() - gc.getTimeInMillis();
        int slot = HOURLY_DAYS * 24 - 1 - (int)(diff / 3600000.0f);
        return slot;
    }

    public double getDaily90p() {
        return this.dailyStat.getLevel(0.9);
    }

    public double getDaily95p() {
        return this.dailyStat.getLevel(0.95);
    }

    public double getHourly90p() {
        return this.hourlyStat.getLevel(0.9);
    }

    public double getHourly95p() {
        return this.hourlyStat.getLevel(0.95);
    }

    public double getDailyMax() {
        return this.dailyStat.getMax();
    }

    public double getDailyAvg() {
        return this.dailyStat.getAvg();
    }

    public double getHourlyMax() {
        return this.hourlyStat.getMax();
    }

    public double getHourlyAvg() {
        return this.hourlyStat.getAvg();
    }

    public double getMonthlyMax(int i) {
        if (this.monthlyData == null) {
            this.createMonthlyData();
        }
        return this.monthlyStat[i].getMax();
    }

    public double getMonthlyAvg(int i) {
        if (this.monthlyData == null) {
            this.createMonthlyData();
        }
        return this.monthlyStat[i].getAvg();
    }
}

