/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.rewrite;

import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.rewrite.RewritePolicy;
import org.apache.log4j.spi.LoggingEvent;

public class ReflectionRewritePolicy
implements RewritePolicy {
    @Override
    public LoggingEvent rewrite(LoggingEvent source) {
        block8: {
            Object msg = source.getMessage();
            if (!(msg instanceof String)) {
                Object newMsg = msg;
                HashMap<String, Object> rewriteProps = new HashMap<String, Object>(source.getProperties());
                try {
                    PropertyDescriptor[] props = Introspector.getBeanInfo(msg.getClass(), Object.class).getPropertyDescriptors();
                    if (props.length <= 0) break block8;
                    int i = 0;
                    while (i < props.length) {
                        try {
                            Object propertyValue = props[i].getReadMethod().invoke(msg, null);
                            if ("message".equalsIgnoreCase(props[i].getName())) {
                                newMsg = propertyValue;
                            } else {
                                rewriteProps.put(props[i].getName(), propertyValue);
                            }
                        }
                        catch (Exception e) {
                            LogLog.warn("Unable to evaluate property " + props[i].getName(), e);
                        }
                        ++i;
                    }
                    return new LoggingEvent(source.getFQNOfLoggerClass(), source.getLogger() != null ? source.getLogger() : Logger.getLogger(source.getLoggerName()), source.getTimeStamp(), source.getLevel(), newMsg, source.getThreadName(), source.getThrowableInformation(), source.getNDC(), source.getLocationInformation(), rewriteProps);
                }
                catch (Exception e) {
                    LogLog.warn("Unable to get property descriptors", e);
                }
            }
        }
        return source;
    }
}

