/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.AgentConnector;
import com.jcraft.jsch.AgentProxyException;
import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.Util;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.win32.W32APIOptions;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class PageantConnector
implements AgentConnector {
    private static final int AGENT_MAX_MSGLEN = 262144;
    private static final int AGENT_COPYDATA_ID = -2142351174;
    private User32 libU = null;
    private Kernel32 libK = null;

    public PageantConnector() throws AgentProxyException {
        if (!Util.getSystemProperty("os.name", "").startsWith("Windows")) {
            throw new AgentProxyException("PageantConnector only available on Windows.");
        }
        try {
            this.libU = User32.INSTANCE;
            this.libK = Kernel32.INSTANCE;
        }
        catch (NoClassDefFoundError | UnsatisfiedLinkError e) {
            throw new AgentProxyException(e.toString(), e);
        }
    }

    @Override
    public String getName() {
        return "pageant";
    }

    @Override
    public boolean isAvailable() {
        return this.libU.FindWindow("Pageant", "Pageant") != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void query(Buffer buffer) throws AgentProxyException {
        block12: {
            if (buffer.getLength() > 262144) {
                throw new AgentProxyException("Query too large.");
            }
            WinDef.HWND hwnd = this.libU.FindWindow("Pageant", "Pageant");
            if (hwnd == null) {
                throw new AgentProxyException("Pageant is not runnning.");
            }
            WinBase.SECURITY_ATTRIBUTES psa = null;
            String mapname = String.format("PageantRequest%08x", this.libK.GetCurrentThreadId());
            WinNT.HANDLE sharedFile = this.libK.CreateFileMapping(WinBase.INVALID_HANDLE_VALUE, psa, 4, 0, 262144, mapname);
            if (sharedFile == null || sharedFile == WinBase.INVALID_HANDLE_VALUE) {
                throw new AgentProxyException("Unable to create shared file mapping.");
            }
            Pointer sharedMemory = Kernel32.INSTANCE.MapViewOfFile(sharedFile, 2, 0, 0, 0);
            byte[] data = null;
            long rcode = 0L;
            try {
                sharedMemory.write(0L, buffer.buffer, 0, buffer.getLength());
                if (Platform.is64Bit()) {
                    COPYDATASTRUCT64 cds64 = new COPYDATASTRUCT64();
                    data = PageantConnector.install64(mapname, cds64);
                    rcode = this.sendMessage(hwnd, data);
                } else {
                    COPYDATASTRUCT32 cds32 = new COPYDATASTRUCT32();
                    data = PageantConnector.install32(mapname, cds32);
                    rcode = this.sendMessage(hwnd, data);
                }
                buffer.rewind();
                if (rcode != 0L) {
                    sharedMemory.read(0L, buffer.buffer, 0, 4);
                    int i = buffer.getInt();
                    if (i <= 0 || i > 262140) {
                        throw new AgentProxyException("Illegal length: " + i);
                    }
                    buffer.rewind();
                    buffer.checkFreeSize(i);
                    sharedMemory.read(4L, buffer.buffer, 0, i);
                    break block12;
                }
                throw new AgentProxyException("User32.SendMessage() returned 0");
            }
            finally {
                if (sharedMemory != null) {
                    this.libK.UnmapViewOfFile(sharedMemory);
                }
                if (sharedFile != null) {
                    this.libK.CloseHandle(sharedFile);
                }
            }
        }
    }

    private static byte[] install32(String mapname, COPYDATASTRUCT32 cds) {
        cds.dwData = -2142351174;
        cds.cbData = mapname.length() + 1;
        cds.lpData = new Memory((long)(mapname.length() + 1));
        byte[] foo = Util.str2byte(mapname, StandardCharsets.US_ASCII);
        cds.lpData.write(0L, foo, 0, foo.length);
        cds.lpData.setByte((long)foo.length, (byte)0);
        cds.write();
        byte[] data = new byte[12];
        Pointer cdsp = cds.getPointer();
        cdsp.read(0L, data, 0, 12);
        return data;
    }

    private static byte[] install64(String mapname, COPYDATASTRUCT64 cds) {
        cds.dwData = -2142351174;
        cds.cbData = mapname.length() + 1;
        cds.lpData = new Memory((long)(mapname.length() + 1));
        byte[] foo = Util.str2byte(mapname, StandardCharsets.US_ASCII);
        cds.lpData.write(0L, foo, 0, foo.length);
        cds.lpData.setByte((long)foo.length, (byte)0);
        cds.write();
        byte[] data = new byte[24];
        Pointer cdsp = cds.getPointer();
        cdsp.read(0L, data, 0, 24);
        return data;
    }

    long sendMessage(WinDef.HWND hwnd, byte[] data) {
        return this.libU.SendMessage(hwnd, 74, null, data);
    }

    private static interface User32
    extends com.sun.jna.platform.win32.User32 {
        public static final User32 INSTANCE = (User32)Native.load((String)"user32", User32.class, (Map)W32APIOptions.DEFAULT_OPTIONS);

        public long SendMessage(WinDef.HWND var1, int var2, WinDef.WPARAM var3, byte[] var4);
    }

    private static class COPYDATASTRUCT64
    extends Structure {
        public int dwData;
        public long cbData;
        public Pointer lpData;

        private COPYDATASTRUCT64() {
        }

        protected List<String> getFieldOrder() {
            return Arrays.asList("dwData", "cbData", "lpData");
        }
    }

    private static class COPYDATASTRUCT32
    extends Structure {
        public int dwData;
        public int cbData;
        public Pointer lpData;

        private COPYDATASTRUCT32() {
        }

        protected List<String> getFieldOrder() {
            return Arrays.asList("dwData", "cbData", "lpData");
        }
    }
}

