/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch.jce;

import com.jcraft.jsch.Cipher;
import com.jcraft.jsch.openjax.Poly1305;
import java.nio.ByteBuffer;
import java.security.Key;
import javax.crypto.AEADBadTagException;
import javax.crypto.spec.ChaCha20ParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class ChaCha20Poly1305
implements Cipher {
    private static final int ivsize = 8;
    private static final int bsize = 64;
    private static final int tagsize = 16;
    private javax.crypto.Cipher header_cipher;
    private javax.crypto.Cipher main_cipher;
    private SecretKeySpec K_1_spec;
    private SecretKeySpec K_2_spec;
    private int mode;
    private Poly1305 poly1305;

    @Override
    public int getIVSize() {
        return 8;
    }

    @Override
    public int getBlockSize() {
        return 64;
    }

    @Override
    public int getTagSize() {
        return 16;
    }

    @Override
    public void init(int mode, byte[] key, byte[] iv) throws Exception {
        if (key.length > 64) {
            byte[] tmp = new byte[64];
            System.arraycopy(key, 0, tmp, 0, tmp.length);
            key = tmp;
        }
        byte[] K_1 = new byte[32];
        byte[] K_2 = new byte[32];
        System.arraycopy(key, 32, K_1, 0, 32);
        System.arraycopy(key, 0, K_2, 0, 32);
        this.mode = mode == 0 ? 1 : 2;
        try {
            this.K_1_spec = new SecretKeySpec(K_1, "ChaCha20");
            this.K_2_spec = new SecretKeySpec(K_2, "ChaCha20");
            this.header_cipher = javax.crypto.Cipher.getInstance("ChaCha20");
            this.main_cipher = javax.crypto.Cipher.getInstance("ChaCha20");
        }
        catch (Exception e) {
            this.header_cipher = null;
            this.main_cipher = null;
            this.K_1_spec = null;
            this.K_2_spec = null;
            throw e;
        }
    }

    @Override
    public void update(int foo) throws Exception {
        ByteBuffer nonce = ByteBuffer.allocate(12);
        nonce.putLong(4, foo);
        this.header_cipher.init(this.mode, (Key)this.K_1_spec, new ChaCha20ParameterSpec(nonce.array(), 0));
        this.main_cipher.init(this.mode, (Key)this.K_2_spec, new ChaCha20ParameterSpec(nonce.array(), 0));
        byte[] poly_key = new byte[32];
        byte[] discard = new byte[32];
        this.main_cipher.update(poly_key, 0, 32, poly_key, 0);
        this.main_cipher.update(discard, 0, 32, discard, 0);
        this.poly1305 = new Poly1305(poly_key);
    }

    @Override
    public void update(byte[] foo, int s1, int len, byte[] bar, int s2) throws Exception {
        this.header_cipher.update(foo, s1, len, bar, s2);
    }

    @Override
    public void updateAAD(byte[] foo, int s1, int len) throws Exception {
    }

    @Override
    public void doFinal(byte[] foo, int s1, int len, byte[] bar, int s2) throws Exception {
        if (this.mode == 2) {
            byte[] actual_tag = new byte[16];
            System.arraycopy(foo, len, actual_tag, 0, 16);
            byte[] expected_tag = new byte[16];
            this.poly1305.update(foo, s1, len).finish(expected_tag, 0);
            if (!ChaCha20Poly1305.arraysequals(actual_tag, expected_tag)) {
                throw new AEADBadTagException("Tag mismatch");
            }
        }
        this.main_cipher.update(foo, s1 + 4, len - 4, bar, s2 + 4);
        if (this.mode == 1) {
            this.poly1305.update(bar, s2, len).finish(bar, len);
        }
    }

    @Override
    public boolean isCBC() {
        return false;
    }

    @Override
    public boolean isAEAD() {
        return true;
    }

    @Override
    public boolean isChaCha20() {
        return true;
    }

    private static boolean arraysequals(byte[] a, byte[] b) {
        if (a.length != b.length) {
            return false;
        }
        int res = 0;
        for (int i = 0; i < a.length; ++i) {
            res |= a[i] ^ b[i];
        }
        return res == 0;
    }
}

