/*
 * Decompiled with CFR 0.152.
 */
package hmcScanner;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.KeyPair;
import com.jcraft.jsch.Logger;
import com.jcraft.jsch.Proxy;
import com.jcraft.jsch.ProxyHTTP;
import com.jcraft.jsch.ProxySOCKS4;
import com.jcraft.jsch.ProxySOCKS5;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Console;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import java.util.zip.GZIPOutputStream;

public class SSHManager2 {
    private static java.util.logging.Logger logger = java.util.logging.Logger.getLogger("hmcScanner");
    private JSch ssh = null;
    private Session session = null;
    private ProxyHTTP proxyHTTP = null;
    private ProxySOCKS4 proxySOCKS4 = null;
    private ProxySOCKS5 proxySOCKS5 = null;
    private byte proxyType = 0;
    private static final byte NONE = 0;
    private static final byte HTTP = 1;
    private static final byte SOCKS4 = 2;
    private static final byte SOCKS5 = 3;
    private static boolean DEBUG = false;
    private MyLogger myLogger = null;
    private int timeout = 0;

    public void setTimeout(int timeout) {
        this.timeout = timeout * 1000;
    }

    public SSHManager2(String logFile) {
        logger.log(Level.INFO, "STARTING");
        if (logFile != null) {
            this.myLogger = new MyLogger(0, logFile);
            JSch.setLogger((Logger)this.myLogger);
            logger.log(Level.INFO, "SSH log is in file " + logFile);
        } else {
            this.myLogger = new MyLogger(0, logger);
            JSch.setLogger((Logger)this.myLogger);
        }
        this.ssh = new JSch();
    }

    public SSHManager2() {
        logger.log(Level.INFO, "STARTING");
        this.myLogger = new MyLogger(0, logger);
        JSch.setLogger((Logger)this.myLogger);
        this.ssh = new JSch();
    }

    public static void main(String[] args) {
        SSHManager2 sshm = new SSHManager2("c:\\aaa.log");
        if (!sshm.connectKey("9.71.196.28", "hscroot", "c:\\id_rsa.passphrase")) {
            System.out.println("Connection failed");
            System.exit(0);
        }
        int num = sshm.sendCommand("lshmc -v", "c:\\lssyscfg.txt");
        System.out.println("Lette " + num + " righe");
    }

    public void setProxyHTTP(String proxy_host, int proxy_port, String proxy_user, String proxy_password) {
        this.proxyHTTP = new ProxyHTTP(proxy_host, proxy_port);
        if (proxy_user != null) {
            this.proxyHTTP.setUserPasswd(proxy_user, proxy_password);
        }
        this.proxyType = 1;
        this.myLogger.log(0, "PROXY_HTTP host=" + proxy_host + "; port=" + proxy_port + "; user=" + proxy_user);
    }

    public void setProxySOCKS4(String proxy_host, int proxy_port, String proxy_user, String proxy_password) {
        this.proxySOCKS4 = new ProxySOCKS4(proxy_host, proxy_port);
        if (proxy_user != null) {
            this.proxySOCKS4.setUserPasswd(proxy_user, proxy_password);
        }
        this.proxyType = (byte)2;
        this.myLogger.log(0, "PROXY_SOCKS4 host=" + proxy_host + "; port=" + proxy_port + "; user=" + proxy_user);
    }

    public void setProxySOCKS5(String proxy_host, int proxy_port, String proxy_user, String proxy_password) {
        this.proxySOCKS5 = new ProxySOCKS5(proxy_host, proxy_port);
        if (proxy_user != null) {
            this.proxySOCKS5.setUserPasswd(proxy_user, proxy_password);
        }
        this.proxyType = (byte)3;
        this.myLogger.log(0, "PROXY_SOCKS5 host=" + proxy_host + "; port=" + proxy_port + "; user=" + proxy_user);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean connectKey(String host, String user, String keyFile) {
        try {
            KeyPair keypair = KeyPair.load((JSch)new JSch(), (String)keyFile);
            if (keypair.isEncrypted()) {
                System.out.println("The provided private key is encrypted.");
                this.myLogger.log(0, "Encrypted private key. Asking for password");
                Console c = System.console();
                if (c == null) {
                    String passPhrase;
                    System.err.println("No console available. Passphrase will be in clear text!");
                    this.myLogger.log(0, "No console available. Passphrase will be in clear text!");
                    BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
                    try {
                        passPhrase = in.readLine();
                    }
                    catch (IOException ioe) {
                        return false;
                    }
                    if (!keypair.decrypt(passPhrase)) {
                        System.out.println("Invalid passphrase.");
                        this.myLogger.log(0, "Invalid passphrase.");
                        return false;
                    }
                    this.ssh.addIdentity(keyFile, passPhrase);
                } else {
                    char[] passphrase = c.readPassword("Enter your passphrase: ", new Object[0]);
                    byte[] pfbyte = new byte[passphrase.length];
                    int i = 0;
                    while (i < passphrase.length) {
                        pfbyte[i] = (byte)passphrase[i];
                        ++i;
                    }
                    if (!keypair.decrypt(pfbyte)) {
                        System.out.println("Invalid passphrase.");
                        this.myLogger.log(0, "Invalid passphrase.");
                        return false;
                    }
                    this.ssh.addIdentity(keyFile, pfbyte);
                }
            } else {
                this.ssh.addIdentity(keyFile);
            }
            this.session = this.ssh.getSession(user, host, 22);
            if (this.timeout != 0) {
                System.out.println("Setting timeout to user defined " + this.timeout / 1000 + "seconds");
                this.myLogger.log(0, "Setting timeout to user defined " + this.timeout / 1000 + "seconds");
            }
            this.session.setTimeout(this.timeout);
            Properties config = new Properties();
            config.put("StrictHostKeyChecking", "no");
            config.put("PreferredAuthentications", "publickey,keyboard-interactive,password");
            this.session.setConfig(config);
            switch (this.proxyType) {
                case 1: {
                    this.session.setProxy((Proxy)this.proxyHTTP);
                    break;
                }
                case 2: {
                    this.session.setProxy((Proxy)this.proxySOCKS4);
                    break;
                }
                case 3: {
                    this.session.setProxy((Proxy)this.proxySOCKS5);
                }
            }
            MyUserInfo ui = new MyUserInfo();
            this.session.setUserInfo((UserInfo)ui);
            this.session.connect();
            this.myLogger.log(0, "Session is connected? " + this.session.isConnected());
            return this.session.isConnected();
        }
        catch (JSchException ioe) {
            System.out.println("Error in connecting to " + host + " with user " + user + " and keyfile " + keyFile);
            this.myLogger.log(3, "Error in connecting to " + host + " with user " + user + " and keyfile " + keyFile);
            return false;
        }
    }

    public boolean connect(String host, String user, String password) {
        try {
            this.session = this.ssh.getSession(user, host, 22);
            if (this.timeout != 0) {
                System.out.println("Setting timeout to user defined " + this.timeout / 1000 + " seconds");
                this.myLogger.log(0, "Setting timeout to user defined " + this.timeout / 1000 + "seconds");
            }
            this.session.setTimeout(this.timeout);
            Properties config = new Properties();
            config.put("StrictHostKeyChecking", "no");
            config.put("PreferredAuthentications", "password");
            this.session.setConfig(config);
            switch (this.proxyType) {
                case 1: {
                    this.session.setProxy((Proxy)this.proxyHTTP);
                    break;
                }
                case 2: {
                    this.session.setProxy((Proxy)this.proxySOCKS4);
                    break;
                }
                case 3: {
                    this.session.setProxy((Proxy)this.proxySOCKS5);
                }
            }
            this.session.setPassword(password);
            this.session.connect();
            this.myLogger.log(0, "Session is connected? " + this.session.isConnected());
            return this.session.isConnected();
        }
        catch (JSchException ioe) {
            System.out.println("Error in connecting to " + host + " with user " + user);
            System.out.println(ioe.getMessage());
            this.myLogger.log(3, "Error in connecting to " + host + " with user " + user + " : " + ioe.getMessage());
            return false;
        }
    }

    public void disconnect() {
        this.session.disconnect();
        this.myLogger.log(0, "Session disconnected");
    }

    public int sendCommand(String command, String file) {
        return this.sendCommand(command, file, false, false);
    }

    public int sendCommand(String command, String file, boolean compressed) {
        return this.sendCommand(command, file, compressed, false);
    }

    public int sendCommand(String command, String file, boolean compressed, boolean progress) {
        InputStream inStream = null;
        String end = "END-OF-TRANSMISSION";
        PrintWriter writer = null;
        int numLines = 0;
        long counter = 0L;
        long HASH = 0x100000L;
        try {
            int read;
            writer = !compressed ? new PrintWriter(new BufferedWriter(new FileWriter(file))) : new PrintWriter(new GZIPOutputStream(new FileOutputStream(file)));
            this.myLogger.log(0, "SSH command: " + command);
            command = "LANG=C " + command + "; echo " + end;
            Channel channel = this.session.openChannel("exec");
            ((ChannelExec)channel).setCommand(command);
            channel.setInputStream(null);
            ((ChannelExec)channel).setErrStream((OutputStream)System.err);
            inStream = channel.getInputStream();
            channel.connect();
            if (DEBUG) {
                System.out.println("Sending command: " + command);
                System.out.println("to file: " + file);
            }
            byte[] buffer = new byte[20480];
            boolean stop = false;
            String inputLine = "";
            block3: while (!stop && (read = inStream.read(buffer)) > 0) {
                int eol;
                inputLine = String.valueOf(inputLine) + new String(buffer, 0, read);
                if (progress) {
                    counter += (long)read;
                    while (counter > 0x100000L) {
                        System.out.print(".");
                        counter -= 0x100000L;
                    }
                }
                while ((eol = inputLine.indexOf(10)) >= 0) {
                    String line = inputLine.substring(0, eol);
                    if (line.endsWith(end)) {
                        stop = true;
                        eol = line.indexOf(end);
                        if (eol <= 0) continue block3;
                        writer.println(line.substring(0, eol));
                        ++numLines;
                        continue block3;
                    }
                    writer.println(line);
                    ++numLines;
                    inputLine = inputLine.substring(eol + 1);
                }
            }
            channel.disconnect();
            writer.close();
            if (progress) {
                if (counter > 0L) {
                    System.out.print(". ");
                } else {
                    System.out.print(" ");
                }
            }
            this.myLogger.log(0, "SSH output:  " + file);
            return numLines;
        }
        catch (IOException ioe) {
            if (DEBUG) {
                System.out.println("IOException");
            }
            if (writer != null) {
                writer.close();
            }
            this.myLogger.log(0, ioe.getMessage());
            return 0;
        }
        catch (JSchException ioe) {
            if (DEBUG) {
                System.out.println("JSchException");
            }
            if (writer != null) {
                writer.close();
            }
            this.myLogger.log(0, ioe.getMessage());
            return 0;
        }
    }

    public static class MyLogger
    implements Logger {
        static Hashtable name = new Hashtable();
        static Hashtable<Integer, Level> jlog_name;
        private int level = 0;
        private PrintWriter writer = null;
        private java.util.logging.Logger jlogger = null;

        static {
            name.put(0, "DEBUG: ");
            name.put(1, "INFO: ");
            name.put(2, "WARN: ");
            name.put(3, "ERROR: ");
            name.put(4, "FATAL: ");
            jlog_name = new Hashtable();
            jlog_name.put(0, Level.FINE);
            jlog_name.put(1, Level.INFO);
            jlog_name.put(2, Level.WARNING);
            jlog_name.put(3, Level.SEVERE);
            jlog_name.put(4, Level.SEVERE);
        }

        public MyLogger(int level, String file) {
            this.level = level;
            try {
                this.writer = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            }
            catch (IOException ioe) {
                System.out.println("MyLogger: could not create writer on " + file);
            }
        }

        public MyLogger(int level, java.util.logging.Logger jlogger) {
            this.level = level;
            this.jlogger = jlogger;
        }

        public boolean isEnabled(int level) {
            return level >= this.level;
        }

        public void log(int level, String message) {
            if (this.writer != null) {
                this.writer.println(name.get(level) + message);
                this.writer.flush();
            }
            if (this.jlogger != null) {
                this.jlogger.log(jlog_name.get(level), message);
            }
        }
    }

    public static class MyUserInfo
    implements UserInfo {
        private String password = null;

        public void setPassword(String password) {
            this.password = password;
        }

        public String getPassphrase() {
            return null;
        }

        public String getPassword() {
            return this.password;
        }

        public boolean promptPassword(String message) {
            return true;
        }

        public boolean promptPassphrase(String message) {
            return true;
        }

        public boolean promptYesNo(String message) {
            return true;
        }

        public void showMessage(String message) {
        }
    }
}

