/*
 * Decompiled with CFR 0.152.
 */
package hmcScanner;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JPanel;

public class PoolGraph
extends JPanel {
    private static final long serialVersionUID = 4412281173247423742L;
    private static int UPPER_GRAPH_SPACE = 40;
    private static int LOWER_GRAPH_SPACE = 120;
    private static int RIGHT_GRAPH_SPACE = 20;
    private static int LEFT_GRAPH_SPACE = 35;
    private String title = null;
    private float maxValue = 0.0f;
    private String[] label = null;
    private int step = 0;
    private static byte PC = 0;
    private static byte SIZE = 1;
    private static byte AVAIL = (byte)2;
    private static byte NUM_VAR = (byte)3;
    private float[][] data = null;
    private static byte MIN = 0;
    private static byte AVG = 1;
    private static byte MAX = (byte)2;
    private static byte DEVSTD = (byte)3;
    private static byte P90 = (byte)4;
    private static byte NUM = (byte)5;
    private static byte M = (byte)6;
    private static byte S = (byte)7;
    private static byte NUM_ST = (byte)8;
    private float[][] stats = null;
    private Color[] color = null;
    private String[] name = null;
    private static final float[] dash = new float[]{8.0f, 8.0f};
    private static BasicStroke lineStroke = new BasicStroke(2.0f, 1, 1);
    private static BasicStroke dotStroke = new BasicStroke(4.0f, 1, 1, 1.0f, dash, 2.0f);

    private void computeStats() {
        this.stats = new float[NUM_VAR][NUM_ST];
        int i = 0;
        while (i < NUM_VAR) {
            this.stats[i][PoolGraph.MIN] = Float.MAX_VALUE;
            this.stats[i][PoolGraph.MAX] = -1.0f;
            this.stats[i][PoolGraph.AVG] = 0.0f;
            this.stats[i][PoolGraph.NUM] = 0.0f;
            int j = 0;
            while (j < this.data[i].length) {
                if (!(this.data[i][j] < 0.0f)) {
                    if (this.stats[i][MIN] > this.data[i][j]) {
                        this.stats[i][PoolGraph.MIN] = this.data[i][j];
                    }
                    if (this.stats[i][MAX] < this.data[i][j]) {
                        this.stats[i][PoolGraph.MAX] = this.data[i][j];
                    }
                    float[] fArray = this.stats[i];
                    byte by = AVG;
                    fArray[by] = fArray[by] + this.data[i][j];
                    if (this.stats[i][NUM] == 0.0f) {
                        this.stats[i][PoolGraph.M] = this.data[i][j];
                        this.stats[i][PoolGraph.S] = 0.0f;
                        this.stats[i][PoolGraph.NUM] = 1.0f;
                    } else {
                        float prev_m = this.stats[i][M];
                        float prev_s = this.stats[i][S];
                        float[] fArray2 = this.stats[i];
                        byte by2 = NUM;
                        fArray2[by2] = fArray2[by2] + 1.0f;
                        this.stats[i][PoolGraph.M] = prev_m + (this.data[i][j] - prev_m) / this.stats[i][NUM];
                        this.stats[i][PoolGraph.S] = prev_s + (this.data[i][j] - prev_m) * (this.data[i][j] - this.stats[i][M]);
                    }
                }
                ++j;
            }
            this.stats[i][PoolGraph.AVG] = this.stats[i][AVG] / this.stats[i][NUM];
            this.stats[i][PoolGraph.DEVSTD] = (float)Math.sqrt(this.stats[i][S] / (this.stats[i][NUM] - 1.0f));
            this.stats[i][PoolGraph.P90] = (float)(1.282 * (double)this.stats[i][DEVSTD] + (double)this.stats[i][AVG]);
            this.stats[i][PoolGraph.MIN] = 1.0f * (float)((int)(this.stats[i][MIN] * 100.0f)) / 100.0f;
            this.stats[i][PoolGraph.MAX] = 1.0f * (float)((int)(this.stats[i][MAX] * 100.0f)) / 100.0f;
            this.stats[i][PoolGraph.AVG] = 1.0f * (float)((int)(this.stats[i][AVG] * 100.0f)) / 100.0f;
            this.stats[i][PoolGraph.DEVSTD] = 1.0f * (float)((int)(this.stats[i][DEVSTD] * 100.0f)) / 100.0f;
            this.stats[i][PoolGraph.P90] = 1.0f * (float)((int)(this.stats[i][P90] * 100.0f)) / 100.0f;
            ++i;
        }
    }

    public PoolGraph(String title, float[] pc, float[] size, float[] avail, String[] label, int step) {
        this.setup(title, pc, size, avail, label, step);
    }

    public PoolGraph(String title, float[] pc, float[] size, String[] label, int step) {
        this.setup(title, pc, size, size, label, step);
    }

    private void setup(String title, float[] pc, float[] size, float[] avail, String[] label, int step) {
        this.title = title;
        this.label = label;
        this.step = step;
        this.data = new float[NUM_VAR][];
        this.data[PoolGraph.PC] = pc;
        this.data[PoolGraph.SIZE] = size;
        this.data[PoolGraph.AVAIL] = avail;
        this.computeStats();
        int i = 0;
        while (i < NUM_VAR) {
            if (this.stats[i][MAX] > this.maxValue) {
                this.maxValue = this.stats[i][MAX];
            }
            ++i;
        }
        this.color = new Color[NUM_VAR];
        this.color[PoolGraph.SIZE] = Color.GREEN;
        this.color[PoolGraph.PC] = Color.BLUE;
        this.color[PoolGraph.AVAIL] = Color.YELLOW;
        this.name = new String[NUM_VAR];
        this.name[PoolGraph.SIZE] = "Pool size";
        this.name[PoolGraph.PC] = "Processor consumed";
        this.name[PoolGraph.AVAIL] = "Available CPU in parent pool";
    }

    private void drawGraph(Graphics g, float[] f, Color color, int xsize, int ysize) {
        int goodx = -1;
        int goody = -1;
        Graphics2D g2 = (Graphics2D)g;
        goodx = -1;
        goody = -1;
        g2.setColor(color);
        g2.setStroke(lineStroke);
        int i = 0;
        while (i < f.length) {
            if (f[i] < 0.0f) {
                goodx = -1;
                goody = -1;
            } else {
                int x = LEFT_GRAPH_SPACE + (int)(1.0f * (float)i * (float)(xsize - LEFT_GRAPH_SPACE - RIGHT_GRAPH_SPACE) / (float)f.length);
                int y = ysize - LOWER_GRAPH_SPACE - (int)(1.0f * f[i] * (float)(ysize - UPPER_GRAPH_SPACE - LOWER_GRAPH_SPACE) / this.maxValue);
                if (goodx >= 0) {
                    g2.drawLine(goodx, goody, x, y);
                }
                goodx = x;
                goody = y;
            }
            ++i;
        }
    }

    private void fillUnderGraph(Graphics g, float[] f, Color color, int xsize, int ysize) {
        int goodx = -1;
        int goody = -1;
        int[] px = new int[4];
        int[] py = new int[4];
        Graphics2D g2 = (Graphics2D)g;
        goodx = -1;
        goody = -1;
        g2.setColor(color);
        g2.setStroke(lineStroke);
        int i = 0;
        while (i < f.length) {
            if (f[i] < 0.0f) {
                goodx = -1;
                goody = -1;
            } else {
                int x = LEFT_GRAPH_SPACE + (int)(1.0f * (float)i * (float)(xsize - LEFT_GRAPH_SPACE - RIGHT_GRAPH_SPACE) / (float)f.length);
                int y = ysize - LOWER_GRAPH_SPACE - (int)(1.0f * f[i] * (float)(ysize - UPPER_GRAPH_SPACE - LOWER_GRAPH_SPACE) / this.maxValue);
                if (goodx >= 0) {
                    px[0] = goodx;
                    py[0] = ysize - LOWER_GRAPH_SPACE;
                    px[1] = goodx;
                    py[1] = goody;
                    px[2] = x;
                    py[2] = y;
                    px[3] = x;
                    py[3] = ysize - LOWER_GRAPH_SPACE;
                    g.drawPolygon(px, py, 4);
                    g.fillPolygon(px, py, 4);
                }
                goodx = x;
                goody = y;
            }
            ++i;
        }
    }

    private void axes(Graphics g, int xsize, int ysize) {
        int size;
        float f;
        Graphics2D g2 = (Graphics2D)g;
        float[] pattern = new float[]{10.0f, 5.0f};
        Font font = new Font("SansSerif", 1, 10);
        g2.setColor(Color.BLACK);
        g2.setStroke(lineStroke);
        g2.drawLine(LEFT_GRAPH_SPACE, UPPER_GRAPH_SPACE, LEFT_GRAPH_SPACE, ysize - LOWER_GRAPH_SPACE + 2);
        g2.drawLine(LEFT_GRAPH_SPACE - 2, ysize - LOWER_GRAPH_SPACE, xsize - RIGHT_GRAPH_SPACE + 2, ysize - LOWER_GRAPH_SPACE);
        g2.setPaint(Color.BLACK);
        g2.setFont(font);
        FontMetrics metrics = this.getFontMetrics(font);
        g2.setStroke(new BasicStroke(1.0f, 1, 1, 5.0f, pattern, 0.0f));
        int i = 1;
        while (i < 10) {
            int y = ysize - LOWER_GRAPH_SPACE - (int)(1.0f * (float)i * (this.maxValue / 10.0f) * (float)(ysize - UPPER_GRAPH_SPACE - LOWER_GRAPH_SPACE) / this.maxValue);
            g2.drawLine(LEFT_GRAPH_SPACE, y, xsize - RIGHT_GRAPH_SPACE, y);
            f = (float)((int)(1.0f * (float)i * (this.maxValue / 10.0f) * 100.0f)) / 100.0f;
            String s = Float.toString(f);
            size = metrics.stringWidth(s);
            g2.drawString(s, LEFT_GRAPH_SPACE - 4 - size, y);
            ++i;
        }
        g2.setPaint(Color.BLACK);
        g2.setFont(font);
        g2.setStroke(new BasicStroke(1.0f, 1, 1, 5.0f, pattern, 0.0f));
        metrics = this.getFontMetrics(font);
        f = this.step;
        i = 0;
        while (f < (float)this.data[PC].length) {
            int x = LEFT_GRAPH_SPACE + (int)(1.0f * f * (float)(xsize - LEFT_GRAPH_SPACE - RIGHT_GRAPH_SPACE) / (float)this.data[PC].length);
            g2.drawLine(x, UPPER_GRAPH_SPACE, x, ysize - LOWER_GRAPH_SPACE);
            size = metrics.stringWidth(this.label[i]);
            g2.drawString(this.label[i], x - size / 2, ysize - LOWER_GRAPH_SPACE + 4 + font.getSize());
            f += (float)this.step;
            ++i;
        }
    }

    private void title(Graphics g, int xsize, int ysize) {
        Font font = new Font("SansSerif", 1, 16);
        Graphics2D g2 = (Graphics2D)g;
        FontMetrics metrics = this.getFontMetrics(font);
        int size = metrics.stringWidth(this.title);
        g2.setFont(font);
        g2.setColor(Color.BLACK);
        g2.drawString(this.title, xsize / 2 - size / 2, font.getSize() + 2);
    }

    private void summary(Graphics g, int xsize, int ysize) {
        int j;
        Font font = new Font("SansSerif", 0, 12);
        Graphics2D g2 = (Graphics2D)g;
        int[] px = new int[4];
        int[] py = new int[4];
        int largerLabel = 0;
        int[] largerData = new int[NUM_ST];
        int labelTab = 0;
        int[] statsTab = new int[NUM_ST];
        String[] statsLabel = new String[]{"Min   ", "Avg   ", "Max   ", "StdDev", "90\ufffd Perc"};
        g2.setStroke(lineStroke);
        g2.setFont(font);
        g2.setColor(Color.BLACK);
        FontMetrics metrics = this.getFontMetrics(font);
        int i = 0;
        while (i < NUM_VAR) {
            if (this.name[i].length() > this.name[largerLabel].length()) {
                largerLabel = i;
            }
            j = 0;
            while (j < NUM_ST) {
                if (Float.toString(this.stats[i][j]).length() > Float.toString(this.stats[largerData[j]][j]).length()) {
                    largerData[j] = i;
                }
                ++j;
            }
            ++i;
        }
        labelTab = 30;
        statsTab[0] = labelTab + metrics.stringWidth(this.name[largerLabel]) + 20;
        i = 1;
        while (i <= P90) {
            int size = metrics.stringWidth(Float.toString(this.stats[largerData[i]][i]));
            if (metrics.stringWidth(statsLabel[i]) > size) {
                size = metrics.stringWidth(statsLabel[i]);
            }
            statsTab[i] = statsTab[i - 1] + size + 10;
            ++i;
        }
        int y = ysize - LOWER_GRAPH_SPACE + font.getSize() + 30;
        g2.setColor(Color.BLACK);
        i = 0;
        while (i <= P90) {
            g2.drawString(statsLabel[i], statsTab[i], y);
            ++i;
        }
        y += font.getSize() + 4;
        i = 0;
        while (i < NUM_VAR) {
            px[0] = 10;
            py[0] = y;
            px[1] = 20;
            py[1] = y;
            px[2] = 20;
            py[2] = y - 10;
            px[3] = 10;
            py[3] = y - 10;
            g2.setColor(Color.BLACK);
            g.drawPolygon(px, py, 4);
            g2.setColor(this.color[i]);
            g.fillPolygon(px, py, 4);
            g2.setColor(Color.BLACK);
            g2.drawString(this.name[i], labelTab, y);
            j = 0;
            while (j <= P90) {
                g2.drawString(Float.toString(this.stats[i][j]), statsTab[j], y);
                ++j;
            }
            y += font.getSize() + 4;
            ++i;
        }
    }

    private void drawP90(Graphics g, float p90, Color color, int xsize, int ysize) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(color);
        g2.setStroke(dotStroke);
        int y = ysize - LOWER_GRAPH_SPACE - (int)(1.0f * p90 * (float)(ysize - UPPER_GRAPH_SPACE - LOWER_GRAPH_SPACE) / this.maxValue);
        g2.drawLine(LEFT_GRAPH_SPACE, y, xsize - RIGHT_GRAPH_SPACE, y);
    }

    @Override
    public void paint(Graphics g) {
        super.paintComponent(g);
        int ysize = this.getHeight();
        int xsize = this.getWidth();
        g.setColor(Color.lightGray);
        g.fillRect(0, 0, xsize, ysize);
        this.title(g, xsize, ysize);
        this.fillUnderGraph(g, this.data[AVAIL], this.color[AVAIL], xsize, ysize);
        this.drawGraph(g, this.data[SIZE], this.color[SIZE], xsize, ysize);
        this.drawGraph(g, this.data[PC], this.color[PC], xsize, ysize);
        this.drawP90(g, this.stats[PC][P90], this.color[PC], xsize, ysize);
        this.axes(g, xsize, ysize);
        this.summary(g, xsize, ysize);
    }
}

