/*
 * Decompiled with CFR 0.152.
 */
package hmcScanner;

import hmcScanner.DataManager;
import hmcScanner.DataParser;
import hmcScanner.DataSheet;
import hmcScanner.DiskData;
import hmcScanner.GenericData;
import hmcScanner.LparGraph;
import hmcScanner.NewLparStatus;
import hmcScanner.PoolGraph;
import hmcScanner.SSHManager2;
import hmcScanner.StringChanger;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.Console;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.math.MathContext;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import jxl.Workbook;
import jxl.format.Alignment;
import jxl.format.Border;
import jxl.format.BorderLineStyle;
import jxl.format.CellFormat;
import jxl.format.Colour;
import jxl.format.Orientation;
import jxl.format.VerticalAlignment;
import jxl.write.Formula;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.NumberFormats;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;

public class Loader {
    private static Logger logger = Logger.getLogger("hmcScanner");
    private static String base_directory = null;
    private static String debug_zip = "hmcScanner-debug.zip";
    private static byte NUM_RETRY = (byte)3;
    private boolean onlyReadFile = true;
    private boolean produceStatistics = false;
    private boolean rowMode = false;
    private boolean verboseMode = false;
    private static String version = "0.11.52";
    private String user = null;
    private String password = null;
    private String startPerf = null;
    private String endPerf = null;
    private String samplePerf = null;
    private SSHManager2 sshm = null;
    private String sshLogfile = null;
    private String sshPrivKey = null;
    private String proxyType = null;
    private String proxyHost = null;
    private String proxyPort = null;
    private String proxyUser = null;
    private String proxyPassword = null;
    private String selectedMS = null;
    private char csvSeparator = (char)44;
    private int timeout = 0;
    private boolean novios = false;
    private boolean wip = false;
    private String[] args;
    private GenericData[] managedSystem = null;
    private GenericData scannerParams;
    private GregorianCalendar scannerDate = null;
    private GenericData hmc = null;
    private GenericData[] entPool = null;
    private GenericData[] sspcluster = null;
    private GenericData service_agent;
    private byte managerType = (byte)4;
    private WritableWorkbook workbook = null;
    private static final BigDecimal zero = new BigDecimal(0);
    private static String excel = "_scan.xls";
    private static String excelSane = "_scan_safe.xls";
    private static String systemData = "system_data.txt";
    private static String procSysData = "system_proc.txt";
    private static String memSysData = "system_mem.txt";
    private static String slotSysData = "system_slot.txt";
    private static String procLparData = "lpar_proc.txt";
    private static String memLparData = "mem_proc.txt";
    private static String procPoolData = "procpool.txt";
    private static String memPoolData = "mempool.txt";
    private static String lparConfigData = "lpar_config.txt";
    private static String vswitchData = "vswitch.txt";
    private static String vethData = "veth.txt";
    private static String vscsiData = "vscsi.txt";
    private static String vfcData = "vfc.txt";
    private static String utilDataConfig = "util_data_config.txt";
    private static String lslparutilData = "lslparutil.txt.gz";
    private static String viosList = "vioslist.txt";
    private static String npivData = "npiv_data.txt";
    private static String vscsiDiskData = "vscsidisk.txt";
    private static String lshmcv = "lshmc-v.txt";
    private static String lshmcn = "lshmc-n.txt";
    private static String lshmcb = "lshmc-b.txt";
    private static String lshmcV = "lshmc-vv.txt";
    private static String scannerInfo = "scannerInfo.txt";
    private static String lslicSyspower = "lslic_syspower.txt";
    private static String diskuuid = "disk_uuid.txt";
    private static String hmcdate = "hmc-date.txt";
    private static String ioslevel = "ioslevel.txt";
    private static String lslparutilHourlyStats = "lslparutilHourlyStat.txt.gz";
    private static String lslparutilDailyStats = "lslparutilDailyStat.txt.gz";
    private static String hmcScannerPic = "hmcScanner.png";
    private static String ivmversion = "ivmversion.txt";
    private static String seaCfg = "seacfg.txt";
    private static String slots = "slots.txt";
    private static String etherChannel = "etherChannel.txt";
    private static String entstatSEA = "entstatSEA.txt";
    private static String fcstat = "fcstat.txt";
    private static String fcattr = "fcattr.txt";
    private static String html = "_HTML";
    private static String html_sane = "_HTML_SANE";
    private static String lparProfiles = "profiles.txt";
    private static String lspv_size = "lspv_size.txt";
    private static String lspv_free = "lspv_free.txt";
    private static String slotchildren = "lshwres-slotchildren.txt";
    private static String csv = "_CSV";
    private static String csv_sane = "_CSV_SANE";
    private static String lscod_bill_proc = "lscod_bill_proc.txt";
    private static String lscod_bill_mem = "lscod_bill_mem.txt";
    private static String lscod_cap_proc_onoff = "lscod_cap_proc_onoff.txt";
    private static String lscod_cap_mem_onoff = "lscod_cap_mem_onoff.txt";
    private static String lscod_hist = "lscod_hist.txt";
    private static String proc0 = "proc0.txt";
    private static String lscodpool = "lscodpool.txt";
    private static String clusterlist = "clusterlist.txt";
    private static String ssp_status = "ssp_status.txt";
    private static String ssp_pool = "ssp_pool.txt";
    private static String ssp_lun = "ssp_lun.txt";
    private static String sriov_adapter = "sriov_adapter.txt";
    private static String sriov_logport = "sriov_logport.txt";
    private static String sriov_logport_eth = "sriov_logport_eth.txt";
    private static String sriov_logport_roce = "sriov_logport_roce.txt";
    private static String sriov_physport_eth = "sriov_physport_eth.txt";
    private static String sriov_physport_ethc = "sriov_physport_ethc.txt";
    private static String sriov_physport_roce = "sriov_physport_roce.txt";
    private static String vnic = "vnic.txt";
    private static String vnic_lpar = "vnic_lpar.txt";
    private static String sa_prefix = "lssacfg_";
    private static String cluster_status_field = "cluster_name cluster_id cluster_state repos_mode number_of_nodes nodes_ok nodes_down pool_name pool_id pool_state node_name node_id node_mtm node_partition_num node_state node_repos_state node_upgrade_status node_roles";
    private static String cluster_pool_field = "pool size free total overcommit lus type id";
    private static String cluster_lun_field = "luname size provisiontype usage unused luudid";
    private static String[] sa_cmd = new String[]{"authuser", "callhome", "callhomeserver", "connmon", "connmontimer", "custinfo", "email", "ftpfirewall", "ftpoffload", "snmp", "snmpopt", "snmptrapnames"};
    private static String header_html = "header.html";
    private static String hmc_html = "hmc.html";
    private static String systems_html = "systems.html";
    private static String slots_html = "slots.html";
    private static String index_html = "index.html";
    private static String menu_html = "fedmenu.html";
    private static String lpar_html = "lpar.html";
    private static String cpu_html = "cpu.html";
    private static String profile_html = "profile.html";
    private static String mem_html = "mem.html";
    private static String iochildren_html = "iochildren.html";
    private static String veth_html = "veth.html";
    private static String vscsi_html = "vscsi.html";
    private static String vscsimap_html = "vscsimap.html";
    private static String vfc_html = "vfc.html";
    private static String viosdisks_html = "viosdisks.html";
    private static String sea_html = "sea.html";
    private static String pfc_html = "pfc.html";
    private static String poolcpu_html = "poolcpu.html";
    private static String sysram_html = "sysram.html";
    private static String lparcpu_html = "lparcpu.html";
    private static String pooldaily_html = "pooldaily.html";
    private static String lpardaily_html = "lpardaily.html";
    private static String poolhourly_html = "poolhourly.html";
    private static String lparhourly_html = "lparhourly.html";
    private static String sysperfindex_html = "sysperfindex.html";
    private static String sysperfmenu_html = "sysperfmenu.html";
    private static String lparperfmenu_html = "lparperfmenu.html";
    private static String lparperfindex_html = "lparperfindex.html";
    private static String poolperfmenu_html = "poolperfmenu.html";
    private static String poolperfindex_html = "poolperfindex.html";
    private static String onoff_html = "onoff.html";
    private static String codlog_html = "codlog.html";
    private static String syspool_html = "syspool.html";
    private static String ssp_html = "ssp.html";
    private static String sriov_pysp_html = "sriov_pysp.html";
    private static String sriov_logp_html = "sriov_logp.html";
    private static String vnic_html = "vnic.html";
    private static String sa_html = "sa.html";
    private Vector<String> buttonName = null;
    private Vector<String> htmlName = null;
    private Vector<String> sysButtonName = null;
    private Vector<String> sysHtmlName = null;
    private Vector<String> lparButtonName = null;
    private Vector<String> lparHtmlName = null;
    private Vector<String> poolButtonName = null;
    private Vector<String> poolHtmlName = null;
    private static String header_csv = "header.csv";
    private static String hmc_csv = "hmc.csv";
    private static String systems_csv = "systems.csv";
    private static String slots_csv = "slots.csv";
    private static String lpar_csv = "lpar.csv";
    private static String cpu_csv = "cpu.csv";
    private static String profile_csv = "profile.csv";
    private static String mem_csv = "mem.csv";
    private static String iochildren_csv = "iochildren.csv";
    private static String veth_csv = "veth.csv";
    private static String vscsi_csv = "vscsi.csv";
    private static String vscsimap_csv = "vscsimap.csv";
    private static String vfc_csv = "vfc.csv";
    private static String viosdisks_csv = "viosdisks.csv";
    private static String sea_csv = "sea.csv";
    private static String pfc_csv = "pfc.csv";
    private static String poolcpu_csv = "poolcpu.csv";
    private static String sysram_csv = "sysram.csv";
    private static String lparcpu_csv = "lparcpu.csv";
    private static String pooldaily_csv = "pooldaily.csv";
    private static String lpardaily_csv = "lpardaily.csv";
    private static String poolhourly_csv = "poolhourly.csv";
    private static String lparhourly_csv = "lparhourly.csv";
    private static String onoff_csv = "onoff.csv";
    private static String codlog_csv = "codlog.csv";
    private static String syspool_csv = "syspool.csv";
    private static String ssp_csv = "ssp.csv";
    private static String sriov_pysp_csv = "sriov_pysp.csv";
    private static String sriov_logp_csv = "sriov_logp.csv";
    private static String vnic_csv = "vnic.csv";
    private static String sa_csv = "sa.csv";
    private static byte PROC = 0;
    private static byte MEM = 1;
    private static byte SLOT = (byte)2;
    private static byte PROC_LPAR = (byte)3;
    private static byte MEM_LPAR = (byte)4;
    private static byte PROC_POOL = (byte)5;
    private static byte MEM_POOL = (byte)6;
    private static byte CONFIG_LPAR = (byte)7;
    private static byte VSWITCH = (byte)8;
    private static byte VETH = (byte)9;
    private static byte VSCSI = (byte)10;
    private static byte VFC = (byte)11;
    private static byte VFCMAP = (byte)12;
    private static byte VSCSIMAP = (byte)13;
    private static byte SYSPOWERLIC = (byte)14;
    private static byte HDISK = (byte)15;
    private static byte SEA = (byte)16;
    private static byte ETH = (byte)17;
    private static byte ETHERCHANNEL = (byte)18;
    private static byte ENTSTATSEA = (byte)19;
    private static byte FC = (byte)20;
    private static byte FCSTAT = (byte)21;
    private static byte PROFILES = (byte)22;
    private static byte IOSLOTCHILDREN = (byte)23;
    private static byte LSCOD_BILL_PROC = (byte)24;
    private static byte LSCOD_BILL_MEM = (byte)25;
    private static byte LSCOD_CAP_PROC_ONOFF = (byte)26;
    private static byte LSCOD_CAP_MEM_ONOFF = (byte)27;
    private static byte LSCOD_HIST = (byte)28;
    private static byte ENTPOOLSYS = (byte)29;
    private static byte CLUSTERSTATUS = (byte)30;
    private static byte CLUSTERPOOL = (byte)31;
    private static byte CLUSTERLUN = (byte)32;
    private static byte SRIOV_PHP_ETH = (byte)33;
    private static byte SRIOV_PHP_ETHC = (byte)34;
    private static byte SRIOV_PHP_ROCE = (byte)35;
    private static byte SRIOV_LOGP_ETH = (byte)36;
    private static byte SRIOV_LOGP_ROCE = (byte)37;
    private static byte VNIC = (byte)38;
    private static byte HMC = 0;
    private static byte USER = 1;
    private static byte PASSWORD = (byte)2;
    private static byte DIR = (byte)3;
    private static byte STARTPERF = (byte)4;
    private static byte ENDPERF = (byte)5;
    private static byte SAMPLE = (byte)6;
    private static byte READLOCAL = (byte)7;
    private static byte SSHLOGFILE = (byte)8;
    private static byte SSHPRIVKEY = (byte)9;
    private static byte STATS = (byte)10;
    private static byte ROWMODE = (byte)11;
    private static byte SANITIZE = (byte)12;
    private static byte CSV = (byte)13;
    private static byte HTML = (byte)14;
    private static byte PROXY_TYPE = (byte)15;
    private static byte PROXY_HOST = (byte)16;
    private static byte PROXY_PORT = (byte)17;
    private static byte PROXY_USER = (byte)18;
    private static byte PROXY_PASSWORD = (byte)19;
    private static byte SELECTED_MS = (byte)20;
    private static byte CSV_SEPARATOR = (byte)21;
    private static byte TIMEOUT = (byte)22;
    private static byte CSVDIR = (byte)23;
    private static byte HTMLDIR = (byte)24;
    private static byte NOVIOS = (byte)25;
    private static byte NAME = (byte)26;
    private static byte WIP = (byte)27;
    private static byte NUM_CMD = (byte)28;
    private static int NONE = 0;
    private static int BOLD = 1;
    private static int CENTRE = 2;
    private static int RIGHT = 4;
    private static int LEFT = 8;
    private static int VCENTRE = 16;
    private static int B_TOP_MED = 32;
    private static int B_BOTTOM_MED = 64;
    private static int B_LEFT_MED = 128;
    private static int B_RIGHT_MED = 256;
    private static int B_ALL_MED = 512;
    private static int B_TOP_LOW = 1024;
    private static int B_BOTTOM_LOW = 2048;
    private static int B_LEFT_LOW = 4096;
    private static int B_RIGHT_LOW = 8192;
    private static int B_ALL_LOW = 16384;
    private static int GRAY_25 = 32768;
    private static int GREEN = 65536;
    private static int WRAP = 131072;
    private static int DIAG45 = 262144;
    private static int BLACK = 524288;
    private static int YELLOW = 0x100000;
    private static int RED = 0x200000;
    private static final byte M_HMC = 0;
    private static final byte M_SDMC = 1;
    private static final byte M_FSM = 2;
    private static final byte M_IVM = 3;
    private static final byte M_UNKNOWN = 4;
    private float[][][] managedSystemData = null;
    private boolean[][] goodSystemData = null;
    private String[] lparNames = null;
    private String[] lparID = null;
    private static final byte LPAR_TIME_CYCLES = 0;
    private static final byte LPAR_CYCLES = 1;
    private static final byte NUM_LPAR_CYCLES = 2;
    private DataManager[] msCoreConfig = null;
    private DataManager[] msCoreAvail = null;
    private DataManager[] msCoreUsed = null;
    private DataManager[] msMemConfig = null;
    private DataManager[] msMemAvail = null;
    private DataManager[] lparEnt = null;
    private DataManager[] lparVP = null;
    private DataManager[] lparPC = null;
    private NewLparStatus[] lparStatus = null;
    private DataManager[] procPoolConfig = null;
    private DataManager[] procPoolUsed = null;
    private String[] procPoolName = null;
    private static final byte HOURLY = 0;
    private static final byte DAILY = 1;
    private static final byte UTILIZED_POOL_CYCLES = 0;
    private static final byte TOTAL_POOL_CYCLES = 1;
    private static final byte POOL_TIME_CYCLES = 2;
    private static final byte NUM_POOLDATA = 3;
    private int Y_LEVEL = 70;
    private int R_LEVEL = 90;
    private double COLOR_LEVEL = 0.25;
    private int XSIZE = 800;
    private int YSIZE = 400;
    private DiskData diskData = new DiskData();

    public Loader(String user, String password, String startPerf, String endPerf, String samplePerf, boolean localOnly, String sshLogFile, String sshPrivKey, boolean produceStatistics, boolean rowMode, String proxyType, String proxyHost, String proxyPort, String proxyUser, String proxyPassword, String selectedMS, String csvSeparatorString, int timeout, boolean novios, boolean wip, String[] args) {
        this.user = user;
        this.password = password;
        this.startPerf = startPerf;
        this.endPerf = endPerf;
        this.samplePerf = samplePerf;
        this.onlyReadFile = localOnly;
        this.sshLogfile = sshLogFile;
        this.sshPrivKey = sshPrivKey;
        this.produceStatistics = produceStatistics;
        this.rowMode = rowMode;
        this.proxyType = proxyType;
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.proxyUser = proxyUser;
        this.proxyPassword = proxyPassword;
        this.selectedMS = selectedMS == null ? null : selectedMS.replace(',', '|');
        if (csvSeparatorString != null) {
            this.csvSeparator = csvSeparatorString.charAt(0);
        }
        this.timeout = timeout;
        this.novios = novios;
        this.wip = wip;
        this.args = args;
    }

    public boolean connect(String hmc) {
        this.sshm = new SSHManager2(this.sshLogfile);
        if (this.timeout != 0) {
            this.sshm.setTimeout(this.timeout);
        }
        if (this.sshPrivKey != null) {
            return this.sshm.connectKey(hmc, this.user, this.sshPrivKey);
        }
        if (this.proxyType != null) {
            if (this.proxyType.equalsIgnoreCase("HTTP")) {
                this.sshm.setProxyHTTP(this.proxyHost, Integer.parseInt(this.proxyPort), this.proxyUser, this.proxyPassword);
            }
            if (this.proxyType.equalsIgnoreCase("SOCKS4")) {
                this.sshm.setProxySOCKS4(this.proxyHost, Integer.parseInt(this.proxyPort), this.proxyUser, this.proxyPassword);
            }
            if (this.proxyType.equalsIgnoreCase("SOCKS5")) {
                this.sshm.setProxySOCKS5(this.proxyHost, Integer.parseInt(this.proxyPort), this.proxyUser, this.proxyPassword);
            }
        }
        return this.sshm.connect(hmc, this.user, this.password);
    }

    public void disconnect() {
        this.sshm.disconnect();
    }

    private static void showUsage() {
        Loader.showUsage(null);
    }

    private static void showUsage(String s) {
        String logfiles = LogManager.getLogManager().getProperty("java.util.logging.FileHandler.pattern").replace("%u", "*").replace("%g", "*");
        System.out.println("HMC Scanner Version " + version);
        System.out.println("Simplest syntax with maximum data collection: ");
        System.out.println("     hmcScanner.bat <HMC name/IP> <user> [-p <password>]");
        System.out.println("     hmcScanner.ksh <HMC name/IP> <user> [-p <password>]");
        System.out.println("");
        System.out.println("Full syntax:");
        System.out.println("hmcScanner.bat <HMC name/IP> <user> [-p <password>] [-dir <local dir>] [-perf <start> <end> <d|h>] [-readlocal] [-key <file> ] [-nostats] [-sanitize] [-csv] [-csvchar <char>] [-html] [-log <file>] [-proxy <http|socks4|socks5> <host> <port> [user] [password] ] [-m <managed system list>] [-timeout <secconds>] [-novios] [-name <excelFIle>] [-nowip]");
        System.out.println("hmcScanner.ksh <HMC name/IP> <user> [-p <password>] [-dir <local dir>] [-perf <start> <end> <d|h>] [-readlocal] [-key <file> ] [-nostats] [-sanitize] [-csv] [-csvchar <char>] [-html] [-log <file>] [-proxy <http|socks4|socks5> <host> <port> [user] [password] ] [-m <managed system list>] [-timeout <secconds>] [-novios] [-name <excelFIle>] [-nowip]");
        System.out.println("    -dir <local dir> is the directory where data will be stored. Default is current directory.");
        System.out.println("    -perf <start> and <end> is data collection retrieval interval. Syntax is: YYYYMMDD");
        System.out.println("\t       <d|h> d=daily data samples; h=hourly data samples");
        System.out.println("    -readlocal will force reading of existing local data without contacting HMC");
        System.out.println("    -key <file> to select OpenSSH private key (example $HOME/.ssh/id_rsa)");
        System.out.println("    -nostats will prevent system statistics collection.");
        System.out.println("    -sanitize will remove sensitive data.");
        System.out.println("    -csv creates one .csv file for each sheet in a separate directory.");
        System.out.println("    -csvchar defines che separator char is CSV (default is comma).");
        System.out.println("    -html creates HTML report in a separate directory.");
        System.out.println("    -log <file> logs SSH activity into file");
        System.out.println("    -proxy <http|socks4|socks5> <host> <port> [user] [password]");
        System.out.println("           select proxy type, host, port to use for SSH communication");
        System.out.println("    -m <managed system list> restrics the scan to the provided comma separated managed system list");
        System.out.println("    -timeout <seconds> Timeout SSH connection after idle seconds. Use with care! Default is no timeout.");
        System.out.println("    -csvdir <directory> directory where csv files will be written. Default is <hmc>_<date>_<time>_CSV");
        System.out.println("    -htmldir <directory> directory where html files will be written. Default is <hmc>_<date>_<time>_HTML");
        System.out.println("    -novios do not collect data from VIOS to speed up pure hardware config scanning.");
        System.out.println("    -name <excelFile> file name to be used for Excel output");
        System.out.println("    -nowip disable work-in-progress code (use it if you have runtime errors)");
        System.out.println("");
        System.out.println("hmcScanner logs activity in file(s) named " + logfiles);
        if (s != null) {
            System.out.println("Wrong argument is: " + s);
            logger.log(Level.SEVERE, "Halted due to wrong argument: " + s);
        }
        System.exit(1);
    }

    private static String getPassword() {
        Console console = System.console();
        if (console == null) {
            System.out.println("Couldn't get Console instance");
            logger.log(Level.SEVERE, "Halted. Couldn't get Console instance");
            System.exit(1);
        }
        console.printf("Missing authentication.%n", new Object[0]);
        char[] passwordArray = console.readPassword("Enter your password: ", new Object[0]);
        String password = new String(passwordArray);
        logger.log(Level.INFO, "Password entered on console.");
        return password;
    }

    private static String[] parseParams(String[] args) {
        File dir;
        logger.log(Level.INFO, "Parsing command line arguments");
        if (args.length < 2) {
            logger.log(Level.WARNING, "Missing required parameters. Showing usage page.");
            Loader.showUsage();
        }
        int i = 0;
        while (i < 2) {
            if (args[i].startsWith("-")) {
                logger.log(Level.WARNING, "Missing required parameters. Showing usage page.");
                Loader.showUsage();
            }
            ++i;
        }
        String[] result = new String[NUM_CMD];
        i = 0;
        while (i < NUM_CMD) {
            result[i] = null;
            ++i;
        }
        result[Loader.HMC] = args[0];
        result[Loader.USER] = args[1];
        logger.log(Level.INFO, "HMC: " + result[HMC] + ", User: " + result[USER]);
        i = 2;
        while (i < args.length) {
            if (args[i].equals("-p")) {
                if (i + 1 >= args.length || args[i + 1].startsWith("-")) {
                    Loader.showUsage();
                }
                result[Loader.PASSWORD] = args[i + 1];
                logger.log(Level.INFO, "Password has been provided");
                i += 2;
                continue;
            }
            if (args[i].equals("-dir")) {
                if (i + 1 >= args.length || args[i + 1].startsWith("-")) {
                    Loader.showUsage();
                }
                result[Loader.DIR] = args[i + 1];
                logger.log(Level.INFO, "Dir: " + result[DIR]);
                i += 2;
                continue;
            }
            if (args[i].equals("-perf")) {
                if (i + 3 >= args.length || args[i + 1].startsWith("-") || args[i + 2].startsWith("-") || args[i + 3].startsWith("-")) {
                    Loader.showUsage();
                }
                if (args[i + 1].length() != 8 || args[i + 2].length() != 8 || args[i + 3].length() != 1) {
                    Loader.showUsage();
                }
                int start = 0;
                int end = 0;
                try {
                    start = Integer.parseInt(args[i + 1]);
                    end = Integer.parseInt(args[i + 2]);
                }
                catch (NumberFormatException nfe) {
                    Loader.showUsage();
                }
                if (start > end) {
                    Loader.showUsage();
                }
                int month = start / 100 % 100;
                int day = start % 100;
                int year = start / 10000;
                if (month == 2 && year % 4 != 0 && day > 28 || month == 2 && year % 4 == 0 && day > 29 || (month == 1 || month == 3 || month == 5 || month == 7 || month == 8 || month == 10 || month == 12) && day > 31 || (month == 4 || month == 6 || month == 9 || month == 11) && day > 30) {
                    Loader.showUsage();
                }
                month = end / 100 % 100;
                day = end % 100;
                year = end / 10000;
                if (month == 2 && year % 4 != 0 && day > 28 || month == 2 && year % 4 == 0 && day > 29 || (month == 1 || month == 3 || month == 5 || month == 7 || month == 8 || month == 10 || month == 12) && day > 31 || (month == 4 || month == 6 || month == 9 || month == 11) && day > 30) {
                    Loader.showUsage();
                }
                if (!args[i + 3].equals("d") && !args[i + 3].equals("h")) {
                    Loader.showUsage();
                }
                result[Loader.STARTPERF] = args[i + 1];
                result[Loader.ENDPERF] = args[i + 2];
                result[Loader.SAMPLE] = args[i + 3];
                logger.log(Level.INFO, "Performance. Start: " + result[STARTPERF] + ", End: " + result[ENDPERF] + ", Sample: " + result[SAMPLE]);
                i += 4;
                continue;
            }
            if (args[i].equals("-readlocal")) {
                result[Loader.READLOCAL] = "true";
                logger.log(Level.INFO, "READLOCAL");
                ++i;
                continue;
            }
            if (args[i].equals("-log")) {
                if (i + 1 >= args.length || args[i + 1].startsWith("-")) {
                    Loader.showUsage();
                }
                result[Loader.SSHLOGFILE] = args[i + 1];
                logger.log(Level.INFO, "SSH log file: " + result[SSHLOGFILE]);
                i += 2;
                continue;
            }
            if (args[i].equals("-timeout")) {
                if (i + 1 >= args.length || args[i + 1].startsWith("-")) {
                    Loader.showUsage();
                }
                result[Loader.TIMEOUT] = args[i + 1];
                logger.log(Level.INFO, "Timeout: " + result[TIMEOUT]);
                i += 2;
                continue;
            }
            if (args[i].equals("-key")) {
                if (i + 1 >= args.length || args[i + 1].startsWith("-")) {
                    Loader.showUsage();
                }
                result[Loader.SSHPRIVKEY] = args[i + 1];
                logger.log(Level.INFO, "SSH private key: " + result[SSHPRIVKEY]);
                i += 2;
                continue;
            }
            if (args[i].equals("-stats")) {
                result[Loader.STATS] = "true";
                logger.log(Level.INFO, "Deprecated request of load CPU statistics");
                System.out.println("Warning: -stats is now implicit and deprecated, please remove it from parameters.");
                ++i;
                continue;
            }
            if (args[i].equals("-nostats")) {
                result[Loader.STATS] = "false";
                logger.log(Level.INFO, "Do not load CPU statistics");
                ++i;
                continue;
            }
            if (args[i].equals("-rowmode")) {
                result[Loader.ROWMODE] = "true";
                ++i;
                System.out.println("Warning: -rowmode is now implicit and deprecated, please remove it from parameters.");
                continue;
            }
            if (args[i].equals("-sanitize")) {
                result[Loader.SANITIZE] = "true";
                logger.log(Level.INFO, "Sanitize: " + result[SANITIZE]);
                ++i;
                continue;
            }
            if (args[i].equals("-csv")) {
                result[Loader.CSV] = "true";
                logger.log(Level.INFO, "CSV output: " + result[CSV]);
                ++i;
                continue;
            }
            if (args[i].equals("-html")) {
                result[Loader.HTML] = "true";
                logger.log(Level.INFO, "HTML output: " + result[HTML]);
                ++i;
                continue;
            }
            if (args[i].equals("-proxy")) {
                result[Loader.PROXY_TYPE] = args[++i];
                result[Loader.PROXY_HOST] = args[++i];
                result[Loader.PROXY_PORT] = args[++i];
                logger.log(Level.INFO, "Proxy. Type: " + result[PROXY_TYPE] + ", Host: " + result[PROXY_HOST] + ", Port: " + result[PROXY_PORT]);
                if (++i < args.length && !args[i].startsWith("-")) {
                    result[Loader.PROXY_USER] = args[i];
                    logger.log(Level.INFO, "Proxy user: " + result[PROXY_USER]);
                    if (++i < args.length && !args[i].startsWith("-")) {
                        result[Loader.PROXY_PASSWORD] = args[i];
                        logger.log(Level.INFO, "Proxy password provided");
                    }
                    ++i;
                }
                if (result[PROXY_TYPE].equalsIgnoreCase("HTTP") || result[PROXY_TYPE].equalsIgnoreCase("SOCKS4") || result[PROXY_TYPE].equalsIgnoreCase("SOCKS5")) continue;
                Loader.showUsage();
                continue;
            }
            if (args[i].equals("-m")) {
                result[Loader.SELECTED_MS] = args[++i];
                logger.log(Level.INFO, "Managed system: " + result[SELECTED_MS]);
                ++i;
                continue;
            }
            if (args[i].equals("-csvchar")) {
                result[Loader.CSV_SEPARATOR] = args[++i];
                logger.log(Level.INFO, "CSV separator: " + result[CSV_SEPARATOR]);
                ++i;
                continue;
            }
            if (args[i].equals("-csvdir")) {
                result[Loader.CSVDIR] = args[++i];
                logger.log(Level.INFO, "CSV directory: " + result[CSVDIR]);
                ++i;
                continue;
            }
            if (args[i].equals("-htmldir")) {
                result[Loader.HTMLDIR] = args[++i];
                logger.log(Level.INFO, "HTML directory: " + result[HTMLDIR]);
                ++i;
                continue;
            }
            if (args[i].equals("-novios")) {
                result[Loader.NOVIOS] = "true";
                logger.log(Level.INFO, "NOVIOS: " + result[NOVIOS]);
                ++i;
                continue;
            }
            if (args[i].equals("-name")) {
                result[Loader.NAME] = args[++i];
                logger.log(Level.INFO, "XLS name: " + result[NAME]);
                ++i;
                continue;
            }
            if (args[i].equals("-wip")) {
                result[Loader.WIP] = "true";
                System.out.println("Deprecated -wip flag. Work in progress is always enabled.");
                logger.log(Level.INFO, "Work in progress: " + result[WIP]);
                ++i;
                continue;
            }
            if (args[i].equals("-nowip")) {
                result[Loader.WIP] = "false";
                logger.log(Level.INFO, "Work in progress: " + result[WIP]);
                ++i;
                continue;
            }
            Loader.showUsage(args[i]);
        }
        result[Loader.ROWMODE] = "true";
        if (result[DIR] == null) {
            result[Loader.DIR] = System.getProperty("user.dir");
            logger.log(Level.INFO, "Dir set from user.dir property: " + result[DIR]);
        }
        if (!(dir = new File(result[DIR])).isDirectory() && !dir.mkdir()) {
            System.out.println("Error: can not create directory " + result[DIR]);
            logger.log(Level.SEVERE, "Could not create directory " + result[DIR]);
            System.exit(1);
        }
        if (result[PASSWORD] == null && result[SSHPRIVKEY] == null) {
            String home = System.getenv("HOME");
            if (home != null) {
                File f = new File(String.valueOf(home) + File.separatorChar + ".ssh" + File.separatorChar + "id_rsa");
                if (f.exists() && f.canRead()) {
                    result[Loader.SSHPRIVKEY] = String.valueOf(home) + File.separatorChar + ".ssh" + File.separatorChar + "id_rsa";
                    logger.log(Level.INFO, "Using home private key: " + result[SSHPRIVKEY]);
                } else {
                    result[Loader.PASSWORD] = Loader.getPassword();
                }
            } else {
                result[Loader.PASSWORD] = Loader.getPassword();
            }
        }
        return result;
    }

    private static void create_zip_debug(String file_name) throws FileNotFoundException, IOException {
        String item;
        logger.log(Level.INFO, "Creating ZIP file for debug into " + file_name);
        File dir = null;
        String[] files = null;
        int BUFFER_SIZE = 4096;
        ArrayList<String> logFiles = new ArrayList<String>();
        ArrayList<String> hmcFiles = new ArrayList<String>();
        String pattern = LogManager.getLogManager().getProperty("java.util.logging.FileHandler.pattern");
        final String regex = pattern.replace("%u", ".*").replace("%g", ".*");
        dir = new File(".");
        String[] stringArray = files = dir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.matches(regex);
            }
        });
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            item = stringArray[n2];
            logFiles.add(item);
            logger.log(Level.INFO, "Log file into ZIP: " + item);
            ++n2;
        }
        dir = new File(base_directory);
        stringArray = files = dir.list();
        n = files.length;
        n2 = 0;
        while (n2 < n) {
            item = stringArray[n2];
            hmcFiles.add(item);
            logger.log(Level.INFO, "HMC file into ZIP: " + item);
            ++n2;
        }
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(file_name));
        byte[] bytesIn = new byte[BUFFER_SIZE];
        String hmc_path = Paths.get(base_directory, new String[0]).getFileName().toString();
        for (String item2 : logFiles) {
            int read;
            zos.putNextEntry(new ZipEntry(item2));
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(item2));
            while ((read = bis.read(bytesIn)) != -1) {
                zos.write(bytesIn, 0, read);
            }
            zos.closeEntry();
        }
        for (String item2 : hmcFiles) {
            int read;
            zos.putNextEntry(new ZipEntry(String.valueOf(hmc_path) + File.separatorChar + item2));
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(String.valueOf(base_directory) + item2));
            while ((read = bis.read(bytesIn)) != -1) {
                zos.write(bytesIn, 0, read);
            }
            zos.closeEntry();
        }
        zos.close();
    }

    private static void error_message(Exception e) {
        String logfiles = LogManager.getLogManager().getProperty("java.util.logging.FileHandler.pattern").replace("%u", "*").replace("%g", "*");
        System.out.println("\n\nError detected in hmcScanner execution.");
        System.out.println("Look at the end of file(s) " + logfiles + " for some hints.");
        System.out.println("If you can not solve your issue, send an email to vagnini@it.ibm.com for bug fixing.");
        System.out.println("\nPlease collect and attach the following information:");
        System.out.println("1. Log file(s) named " + logfiles);
        System.out.println("2. A compressed archive of the directory generated by the scanner while connecting to HMC");
        System.out.println("3. Any data printed on console");
        System.out.println("4. The following lines");
        System.out.println(e);
        System.out.println("\nFor your convenience a ZIP file containing required data will be created.");
        try {
            Loader.create_zip_debug(debug_zip);
            System.out.println("Please attach to mail the file " + debug_zip);
        }
        catch (Exception exc) {
            System.out.println("Error in ZIP file creation. Please collect data by hand.");
            logger.log(Level.SEVERE, "Error in ZIP file creation");
        }
        System.exit(1);
    }

    public static void main(String[] args) {
        try {
            Loader.main_code(args);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Execution halted", e);
            Loader.error_message(e);
        }
    }

    public static void main_code(String[] args) {
        try {
            LogManager.getLogManager().readConfiguration();
        }
        catch (IOException ex) {
            System.out.println("Warning: logging configuration is bad. Running anyway with JVM defaults...");
        }
        logger.log(Level.INFO, "Scanner has started with log level " + logger.getLevel());
        boolean onlyLocal = false;
        boolean produceStatistics = false;
        boolean rowMode = false;
        int timeout = 0;
        boolean novios = false;
        boolean wip = true;
        String[] result = Loader.parseParams(args);
        if (result[READLOCAL] != null && result[READLOCAL].equals("true")) {
            onlyLocal = true;
        }
        produceStatistics = result[STATS] == null || !result[STATS].equals("false");
        if (result[ROWMODE] != null && result[ROWMODE].equals("true")) {
            rowMode = true;
        }
        if (result[TIMEOUT] != null) {
            timeout = Integer.parseInt(result[TIMEOUT]);
        }
        if (result[NOVIOS] != null && result[NOVIOS].equals("true")) {
            novios = true;
        }
        if (result[WIP] != null && result[WIP].equals("false")) {
            wip = false;
        }
        Loader l = new Loader(result[USER], result[PASSWORD], result[STARTPERF], result[ENDPERF], result[SAMPLE], onlyLocal, result[SSHLOGFILE], result[SSHPRIVKEY], produceStatistics, rowMode, result[PROXY_TYPE], result[PROXY_HOST], result[PROXY_PORT], result[PROXY_USER], result[PROXY_PASSWORD], result[SELECTED_MS], result[CSV_SEPARATOR], timeout, novios, wip, args);
        File dir = new File(String.valueOf(result[DIR]) + File.separatorChar + result[HMC]);
        if (!dir.isDirectory() && !dir.mkdir()) {
            System.out.println("Error: can not create directory " + dir.getAbsolutePath());
            logger.log(Level.SEVERE, "Could not create directory " + dir.getAbsolutePath());
            System.exit(1);
        }
        System.out.println("hmcScanner version " + version);
        logger.log(Level.INFO, "hmcScanner version " + version);
        String logfiles = LogManager.getLogManager().getProperty("java.util.logging.FileHandler.pattern").replace("%u", "*").replace("%g", "*");
        System.out.println("Log file(s) available: " + logfiles);
        l.startSession(result[HMC], String.valueOf(result[DIR]) + File.separatorChar + result[HMC] + File.separatorChar);
        l.parseData(result[HMC], String.valueOf(result[DIR]) + File.separatorChar + result[HMC] + File.separatorChar);
        l.endSession();
        String dirName = result[HTMLDIR] == null ? String.valueOf(result[DIR]) + File.separatorChar + result[HMC] + "_" + l.getHMCdate() + html : result[HTMLDIR];
        if (result[HTML] != null && result[HTML].equals("true")) {
            File f = new File(dirName);
            if (!f.isDirectory() && !f.mkdir()) {
                System.out.println("Error: can not create directory " + dirName);
                logger.log(Level.SEVERE, "Could not create directory " + dirName);
                return;
            }
        } else {
            dirName = null;
        }
        String csvName = String.valueOf(result[DIR]) + File.separatorChar + result[HMC] + "_" + l.getHMCdate() + csv;
        csvName = result[CSVDIR] == null ? String.valueOf(result[DIR]) + File.separatorChar + result[HMC] + "_" + l.getHMCdate() + csv : result[CSVDIR];
        if (result[CSV] != null && result[CSV].equals("true")) {
            File f = new File(csvName);
            if (!f.isDirectory() && !f.mkdir()) {
                System.out.println("Error: can not create directory " + csvName);
                logger.log(Level.SEVERE, "Could not create directory " + csvName);
                return;
            }
        } else {
            csvName = null;
        }
        String excelName = result[NAME] != null ? result[NAME] : String.valueOf(result[DIR]) + File.separatorChar + result[HMC] + "_" + l.getHMCdate() + excel;
        l.createExcel(excelName, dirName, csvName);
        if (result[SANITIZE] != null && result[SANITIZE].equals("true")) {
            File f;
            l.sanitizeData();
            csvName = result[CSVDIR] == null ? String.valueOf(result[DIR]) + File.separatorChar + result[HMC] + "_" + l.getHMCdate() + csv_sane : String.valueOf(result[CSVDIR]) + "_SANE";
            if (result[CSV] != null && result[CSV].equals("true")) {
                f = new File(csvName);
                if (!f.isDirectory() && !f.mkdir()) {
                    System.out.println("Error: can not create directory " + csvName);
                    logger.log(Level.SEVERE, "Could not create directory " + csvName);
                    return;
                }
            } else {
                csvName = null;
            }
            if (result[HTMLDIR] == null) {
                dirName = String.valueOf(result[DIR]) + File.separatorChar + result[HMC] + "_" + l.getHMCdate() + html_sane;
            } else {
                csvName = String.valueOf(result[HTMLDIR]) + "_SANE";
            }
            if (result[HTML] != null && result[HTML].equals("true")) {
                f = new File(dirName);
                if (!f.isDirectory() && !f.mkdir()) {
                    System.out.println("Error: can not create directory " + dirName);
                    logger.log(Level.SEVERE, "Could not create directory " + dirName);
                    return;
                }
            } else {
                dirName = null;
            }
            excelName = result[NAME] != null ? result[NAME].replaceAll("\\.xls$", "_sane.xls") : String.valueOf(result[DIR]) + File.separatorChar + result[HMC] + "_" + l.getHMCdate() + excelSane;
            l.createExcel(excelName, dirName, csvName);
        }
    }

    private void startSession(String hmc, String baseDir) {
        if (!this.onlyReadFile) {
            logger.log(Level.INFO, "Connecting to HMC " + hmc + ", data into " + baseDir);
            if (!this.connect(hmc)) {
                System.out.println("Connection to HMC failed");
                logger.log(Level.SEVERE, "Connection to HMC failed");
                System.exit(1);
            }
            this.collect_data(hmc, baseDir);
        } else {
            System.out.println("Reading local files. HMC will not be contacted.");
            logger.log(Level.INFO, "Reading local files. HMC will not be contacted.");
            this.identifyManagerType(baseDir);
        }
    }

    private void endSession() {
        if (!this.onlyReadFile) {
            logger.log(Level.INFO, "Closing HMC connection");
            this.disconnect();
        }
    }

    private void addEntPool(GenericData pool) {
        if (this.entPool == null) {
            this.entPool = new GenericData[1];
            this.entPool[0] = pool;
            return;
        }
        GenericData[] newPool = new GenericData[this.entPool.length + 1];
        int i = 0;
        while (i < this.entPool.length) {
            newPool[i] = this.entPool[i];
            ++i;
        }
        newPool[i] = pool;
        this.entPool = newPool;
    }

    private void parseEntPool(String baseDir) {
        String[] names = null;
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(String.valueOf(baseDir) + lscodpool), 0x100000);
            names = null;
            while ((line = br.readLine()) != null) {
                if (line.startsWith("HSC") || line.startsWith("No results were found")) continue;
                DataParser dp = new DataParser(line);
                names = dp.getNames();
                GenericData pool = new GenericData();
                int j = 0;
                while (j < names.length) {
                    pool.add(names[j], dp.getStringValue(names[j]));
                    ++j;
                }
                this.addEntPool(pool);
            }
        }
        catch (IOException ioe) {
            System.out.println("Loader.parseEntPool: IOException");
            System.out.println(ioe);
        }
    }

    private void parseEntPoolSystem(String baseDir) {
        if (this.entPool == null) {
            return;
        }
        int i = 0;
        while (i < this.entPool.length) {
            this.load_data(this.entPool[i], baseDir, lscodpool, ENTPOOLSYS);
            ++i;
        }
    }

    private void detect_enterprise_pool(String prefix, String baseDir) {
        System.out.print("Looking for Enterprise System Pools: ");
        this.sendCommand(this.sshm, String.valueOf(prefix) + "lscodpool --level pool", String.valueOf(baseDir) + lscodpool);
        this.parseEntPool(baseDir);
        if (this.entPool == null) {
            System.out.println("none detected");
            logger.log(Level.INFO, "No PEP1 detected");
        } else {
            System.out.println(String.valueOf(this.entPool.length) + " detected");
            System.out.println("Scanning Enterprise pools: ");
            int i = 0;
            while (i < this.entPool.length) {
                String name = this.entPool[i].getVarValues("name")[0];
                this.sendCommand(this.sshm, String.valueOf(prefix) + "lscodpool --level sys -p '" + name + "'", String.valueOf(baseDir) + name + "_" + lscodpool);
                System.out.print(".");
                this.sendCommand(this.sshm, String.valueOf(prefix) + "lscodpool -t hist -p '" + name + "'", String.valueOf(baseDir) + name + "_hist_" + lscodpool);
                System.out.print(".");
                ++i;
            }
            System.out.println(" DONE");
            logger.log(Level.INFO, "PEP1 detected and data collected");
        }
    }

    private void collect_data(String hmc, String baseDir) {
        int j;
        String filler;
        String name;
        int i;
        String prefix = "";
        FileWriter fw = null;
        GregorianCalendar cal = null;
        GregorianCalendar hmcDate = null;
        this.sendCommand(this.sshm, "date +\"%Y-%m-%d %H:%M:%S\"", String.valueOf(baseDir) + hmcdate);
        hmcDate = this.parseHMCDate(String.valueOf(baseDir) + hmcdate);
        try {
            fw = new FileWriter(String.valueOf(baseDir) + scannerInfo);
            fw.write("HMC=" + hmc + ",");
            fw.write("user=" + this.user + ",");
            cal = new GregorianCalendar();
            fw.write("date=" + cal.get(1) + "-");
            int n = cal.get(2) + 1;
            if (n < 10) {
                fw.write("0");
            }
            fw.write(String.valueOf(n) + "-");
            n = cal.get(5);
            if (n < 10) {
                fw.write("0");
            }
            fw.write(String.valueOf(n) + ",");
            fw.write("time=");
            n = cal.get(11);
            if (n < 10) {
                fw.write("0");
            }
            fw.write(String.valueOf(n) + ":");
            n = cal.get(12);
            if (n < 10) {
                fw.write("0");
            }
            fw.write(String.valueOf(n) + ":");
            n = cal.get(13);
            if (n < 10) {
                fw.write("0");
            }
            fw.write(String.valueOf(n) + ",");
            fw.write("HMCdate=" + hmcDate.get(1) + "-");
            n = hmcDate.get(2) + 1;
            if (n < 10) {
                fw.write("0");
            }
            fw.write(String.valueOf(n) + "-");
            n = hmcDate.get(5);
            if (n < 10) {
                fw.write("0");
            }
            fw.write(String.valueOf(n) + ",");
            fw.write("HMCtime=");
            n = hmcDate.get(11);
            if (n < 10) {
                fw.write("0");
            }
            fw.write(String.valueOf(n) + ":");
            n = hmcDate.get(12);
            if (n < 10) {
                fw.write("0");
            }
            fw.write(String.valueOf(n) + ":");
            n = hmcDate.get(13);
            if (n < 10) {
                fw.write("0");
            }
            fw.write(String.valueOf(n));
            fw.write("\n\"args=");
            i = 0;
            while (i < this.args.length) {
                fw.write(this.args[i]);
                if (this.args[i].equals("-p")) {
                    fw.write(" xxxxx");
                    ++i;
                }
                if (i < this.args.length - 1) {
                    fw.write(" ");
                }
                ++i;
            }
            fw.write("\"");
            fw.flush();
            fw.close();
        }
        catch (IOException e) {
            System.out.println("Error in writing output files...");
            logger.log(Level.SEVERE, "Error writing data into " + baseDir + scannerInfo);
            return;
        }
        System.out.print("Detecting manager type: ");
        this.sendCommand(this.sshm, "lshmc -V", String.valueOf(baseDir) + lshmcV);
        this.identifyManagerType(baseDir);
        if (this.managerType == 4) {
            this.sendCommand(this.sshm, "lsconfig -V", String.valueOf(baseDir) + lshmcV);
            this.identifyManagerType(baseDir);
        }
        if (this.managerType == 4) {
            this.sendCommand(this.sshm, "ioscli ioslevel", String.valueOf(baseDir) + ivmversion);
            this.identifyManagerType(baseDir);
        }
        switch (this.managerType) {
            case 0: {
                System.out.println("HMC");
                logger.log(Level.INFO, "HMC detected");
                this.sendCommand(this.sshm, "lshmc -n", String.valueOf(baseDir) + lshmcn);
                this.sendCommand(this.sshm, "lshmc -b", String.valueOf(baseDir) + lshmcb);
                this.sendCommand(this.sshm, "lshmc -v", String.valueOf(baseDir) + lshmcv);
                break;
            }
            case 1: {
                System.out.println("SDMC");
                logger.log(Level.INFO, "SDMC detected");
                prefix = "smcli ";
                break;
            }
            case 2: {
                System.out.println("FSM");
                logger.log(Level.INFO, "FSM detected");
                prefix = "smcli ";
                break;
            }
            case 3: {
                System.out.println("IVM");
                logger.log(Level.INFO, "IVM detected");
                System.out.println("Warning: IVM is experimental...");
                break;
            }
            default: {
                System.out.println("unknown... Aborting.");
                logger.log(Level.SEVERE, "Unknown manager type. Aborting.");
                System.exit(1);
            }
        }
        if (this.managerType == 0) {
            this.detect_enterprise_pool(prefix, baseDir);
        }
        System.out.print("Detecting managed systems: ");
        if (this.selectedMS != null) {
            this.sendCommand(this.sshm, String.valueOf(prefix) + "lslparutil -r config | egrep \"" + this.selectedMS + "\"", String.valueOf(baseDir) + utilDataConfig);
        } else {
            this.sendCommand(this.sshm, String.valueOf(prefix) + "lslparutil -r config", String.valueOf(baseDir) + utilDataConfig);
        }
        if (this.selectedMS != null) {
            this.sendCommand(this.sshm, String.valueOf(prefix) + "lssyscfg -r sys | egrep \"" + this.selectedMS + "\"", String.valueOf(baseDir) + systemData);
        } else {
            this.sendCommand(this.sshm, String.valueOf(prefix) + "lssyscfg -r sys", String.valueOf(baseDir) + systemData);
        }
        this.loadSysConfigData(hmc, baseDir);
        if (this.managedSystem == null) {
            System.out.println(" none detected!");
            return;
        }
        System.out.println(String.valueOf(this.managedSystem.length) + " systems present.");
        System.out.println("Starting managed system configuration collection:");
        logger.log(Level.INFO, "Managed systems detected = " + this.managedSystem.length);
        i = 0;
        while (i < this.managedSystem.length) {
            name = this.managedSystem[i].getVarValues("name")[0];
            filler = "";
            j = name.length();
            while (j < 28) {
                filler = String.valueOf(filler) + " ";
                ++j;
            }
            System.out.print("   Scanning " + name + ": " + filler);
            this.sendCommand(this.sshm, String.valueOf(prefix) + "lshwres -r proc     --level sys     -m '" + name + "'", String.valueOf(baseDir) + name + "_" + procSysData);
            System.out.print(".");
            this.sendCommand(this.sshm, String.valueOf(prefix) + "lshwres -r mem      --level sys     -m '" + name + "'", String.valueOf(baseDir) + name + "_" + memSysData);
            System.out.print(".");
            this.sendCommand(this.sshm, String.valueOf(prefix) + "lshwres -r io       --rsubtype slot -m '" + name + "'", String.valueOf(baseDir) + name + "_" + slotSysData);
            System.out.print(".");
            this.sendCommand(this.sshm, String.valueOf(prefix) + "lshwres -r proc     --level lpar    -m '" + name + "'", String.valueOf(baseDir) + name + "_" + procLparData);
            System.out.print(".");
            this.sendCommand(this.sshm, String.valueOf(prefix) + "lshwres -r procpool                 -m '" + name + "'", String.valueOf(baseDir) + name + "_" + procPoolData);
            System.out.print(".");
            this.sendCommand(this.sshm, String.valueOf(prefix) + "lshwres -r mem      --level lpar    -m '" + name + "'", String.valueOf(baseDir) + name + "_" + memLparData);
            System.out.print(".");
            this.sendCommand(this.sshm, String.valueOf(prefix) + "lshwres -r mempool                  -m '" + name + "'", String.valueOf(baseDir) + name + "_" + memPoolData);
            System.out.print(".");
            this.sendCommand(this.sshm, String.valueOf(prefix) + "lssyscfg -r lpar                    -m '" + name + "'", String.valueOf(baseDir) + name + "_" + lparConfigData);
            System.out.print(".");
            this.sendCommand(this.sshm, String.valueOf(prefix) + "lssyscfg -r prof                    -m '" + name + "'", String.valueOf(baseDir) + name + "_" + lparProfiles);
            System.out.print(".");
            this.sendCommand(this.sshm, String.valueOf(prefix) + "lslic                               -m '" + name + "'", String.valueOf(baseDir) + name + "_" + lslicSyspower);
            System.out.print(".");
            this.sendCommand(this.sshm, String.valueOf(prefix) + "lshwres -r virtualio --rsubtype vswitch          -m '" + name + "'", String.valueOf(baseDir) + name + "_" + vswitchData);
            System.out.print(".");
            this.sendCommand(this.sshm, String.valueOf(prefix) + "lshwres -r virtualio --rsubtype eth --level lpar -m '" + name + "'", String.valueOf(baseDir) + name + "_" + vethData);
            System.out.print(".");
            this.sendCommand(this.sshm, String.valueOf(prefix) + "lshwres -r virtualio --rsubtype scsi --level lpar -m '" + name + "'", String.valueOf(baseDir) + name + "_" + vscsiData);
            System.out.print(".");
            this.sendCommand(this.sshm, String.valueOf(prefix) + "lshwres -r virtualio --rsubtype fc --level lpar -m '" + name + "'", String.valueOf(baseDir) + name + "_" + vfcData);
            System.out.print(".");
            this.sendCommand(this.sshm, String.valueOf(prefix) + "lssyscfg -r lpar -m '" + name + "' -F name,lpar_env | grep vioserver", String.valueOf(baseDir) + name + "_" + viosList);
            System.out.print(".");
            this.sendCommand(this.sshm, String.valueOf(prefix) + "lshwres -m '" + name + "' -r io --rsubtype slotchildren", String.valueOf(baseDir) + name + "_" + slotchildren);
            System.out.print(".");
            this.sendCommand(this.sshm, String.valueOf(prefix) + "lscod -t bill -r proc -m '" + name + "'", String.valueOf(baseDir) + name + "_" + lscod_bill_proc);
            System.out.print(".");
            this.sendCommand(this.sshm, String.valueOf(prefix) + "lscod -t bill -r mem -m '" + name + "'", String.valueOf(baseDir) + name + "_" + lscod_bill_mem);
            System.out.print(".");
            this.sendCommand(this.sshm, String.valueOf(prefix) + "lscod -t cap -r proc -c onoff -m '" + name + "'", String.valueOf(baseDir) + name + "_" + lscod_cap_proc_onoff);
            System.out.print(".");
            this.sendCommand(this.sshm, String.valueOf(prefix) + "lscod -t cap -r mem -c onoff -m '" + name + "'", String.valueOf(baseDir) + name + "_" + lscod_cap_mem_onoff);
            System.out.print(".");
            this.sendCommand(this.sshm, String.valueOf(prefix) + "lscod -t hist -m '" + name + "'", String.valueOf(baseDir) + name + "_" + lscod_hist);
            System.out.print(".");
            this.sendCommand(this.sshm, String.valueOf(prefix) + "lshwres -r sriov --rsubtype adapter                  -m '" + name + "'", String.valueOf(baseDir) + name + "_" + sriov_adapter);
            System.out.print(".");
            this.sendCommand(this.sshm, String.valueOf(prefix) + "lshwres -r sriov --rsubtype logport                  -m '" + name + "'", String.valueOf(baseDir) + name + "_" + sriov_logport);
            System.out.print(".");
            this.sendCommand(this.sshm, String.valueOf(prefix) + "lshwres -r sriov --rsubtype logport --level eth      -m '" + name + "'", String.valueOf(baseDir) + name + "_" + sriov_logport_eth);
            System.out.print(".");
            this.sendCommand(this.sshm, String.valueOf(prefix) + "lshwres -r sriov --rsubtype logport --level roce     -m '" + name + "'", String.valueOf(baseDir) + name + "_" + sriov_logport_roce);
            System.out.print(".");
            this.sendCommand(this.sshm, String.valueOf(prefix) + "lshwres -r sriov --rsubtype physport --level eth     -m '" + name + "'", String.valueOf(baseDir) + name + "_" + sriov_physport_eth);
            System.out.print(".");
            this.sendCommand(this.sshm, String.valueOf(prefix) + "lshwres -r sriov --rsubtype physport --level ethc    -m '" + name + "'", String.valueOf(baseDir) + name + "_" + sriov_physport_ethc);
            System.out.print(".");
            this.sendCommand(this.sshm, String.valueOf(prefix) + "lshwres -r sriov --rsubtype physport --level roce    -m '" + name + "'", String.valueOf(baseDir) + name + "_" + sriov_physport_roce);
            System.out.print(".");
            this.sendCommand(this.sshm, String.valueOf(prefix) + "lshwres -r virtualio --rsubtype vnic                 -m '" + name + "'", String.valueOf(baseDir) + name + "_" + vnic);
            System.out.print(".");
            this.sendCommand(this.sshm, String.valueOf(prefix) + "lshwres -r virtualio --rsubtype vnic --level lpar    -m '" + name + "'", String.valueOf(baseDir) + name + "_" + vnic_lpar);
            System.out.print(".");
            if (this.wip) {
                // empty if block
            }
            this.get_vios_lsmap_config(prefix, name, baseDir);
            this.get_SSP_clusters(prefix, name, baseDir);
            System.out.println(" DONE");
            logger.log(Level.INFO, "Finished scanning MS " + name);
            ++i;
        }
        if (this.sspcluster != null) {
            System.out.println("Detected " + this.sspcluster.length + " SSP. ");
            logger.log(Level.INFO, "Detected " + this.sspcluster.length + " SSP. ");
            this.get_SSP_config(prefix, baseDir);
        }
        if (this.wip) {
            try {
                this.get_service_agent_config(prefix, baseDir);
            }
            catch (Exception e) {
                System.out.println("\n\nError in 'work in progress code'. Please run hmcScanner with '-nowip' to bypass code.");
                logger.log(Level.WARNING, "Error in WIP code");
                Loader.error_message(e);
            }
        }
        System.out.println("Collection successfully finished. Data is in " + baseDir);
        logger.log(Level.INFO, "Collection successfully finished. Data is in " + baseDir);
        if (this.startPerf != null) {
            System.out.println("Starting performance data collection from all managed system:");
            i = 0;
            while (i < this.managedSystem.length) {
                name = this.managedSystem[i].getVarValues("name")[0];
                filler = "";
                j = name.length();
                while (j < 28) {
                    filler = String.valueOf(filler) + " ";
                    ++j;
                }
                System.out.print("   Loading " + name + ": " + filler);
                this.sendCommand(this.sshm, String.valueOf(prefix) + "lslparutil -r all -m '" + name + "'" + " --startyear " + this.startPerf.substring(0, 4) + " --startmonth " + this.startPerf.substring(4, 6) + " --startday " + this.startPerf.substring(6) + " --endyear " + this.endPerf.substring(0, 4) + " --endmonth " + this.endPerf.substring(4, 6) + " --endday " + this.endPerf.substring(6) + " -s " + this.samplePerf, String.valueOf(baseDir) + name + "_" + lslparutilData, true);
                System.out.println(" DONE");
                logger.log(Level.INFO, "Collected perf data of " + name);
                ++i;
            }
            System.out.println("Performance data collection ended. Data is in " + baseDir);
            System.out.println("Use pGraph.jar or other tools to read data.");
            logger.log(Level.INFO, "Performance data collection ended. Data is in " + baseDir);
        }
        if (this.produceStatistics && this.managerType == 3) {
            System.out.println("\n stats are buggy on IVM!");
        }
        if (this.produceStatistics) {
            this.updateStatistics(prefix, baseDir);
        }
    }

    private void updateStatistics(String prefix, String baseDir) {
        int days = 0;
        days = 365;
        System.out.println("Performance data collection: ");
        int i = 0;
        while (i < this.managedSystem.length) {
            String name = this.managedSystem[i].getVarValues("name")[0];
            String filler = "";
            int j = name.length();
            while (j < 28) {
                filler = String.valueOf(filler) + " ";
                ++j;
            }
            System.out.print("   Loading " + name + ": " + filler);
            if (this.managerType == 3) {
                GregorianCalendar day = new GregorianCalendar();
                day.add(2, -2);
                this.sendCommand(this.sshm, String.valueOf(prefix) + "lslparutil -r sys " + " --startyear " + day.get(1) + " --startmonth " + (day.get(2) + 1) + " --startday " + day.get(5) + " -n " + 1440 + " --spread " + " ; " + "lslparutil -r pool " + " --startyear " + day.get(1) + " --startmonth " + (day.get(2) + 1) + " --startday " + day.get(5) + " -n " + 1440 + " --spread " + " ; " + "lslparutil -r lpar " + " --startyear " + day.get(1) + " --startmonth " + (day.get(2) + 1) + " --startday " + day.get(5) + " -n " + 1440 + " --spread ", String.valueOf(baseDir) + name + "_" + lslparutilHourlyStats, true, true);
                day = new GregorianCalendar();
                day.add(6, -days);
                this.sendCommand(this.sshm, String.valueOf(prefix) + "lslparutil -r sys " + " --startyear " + day.get(1) + " --startmonth " + (day.get(2) + 1) + " --startday " + day.get(5) + " -n " + days + " --spread " + " ; " + "lslparutil -r pool " + " --startyear " + day.get(1) + " --startmonth " + (day.get(2) + 1) + " --startday " + day.get(5) + " -n " + days + " --spread " + " ; " + "lslparutil -r lpar " + " --startyear " + day.get(1) + " --startmonth " + (day.get(2) + 1) + " --startday " + day.get(5) + " -n " + days + " --spread ", String.valueOf(baseDir) + name + "_" + lslparutilDailyStats, true, true);
            } else {
                this.sendCommand(this.sshm, String.valueOf(prefix) + "lslparutil -r all -m '" + name + "'" + " -d " + days + " -s h ", String.valueOf(baseDir) + name + "_" + lslparutilHourlyStats, true, true);
                this.sendCommand(this.sshm, String.valueOf(prefix) + "lslparutil -r all -m '" + name + "'" + " -d " + days + " -s d ", String.valueOf(baseDir) + name + "_" + lslparutilDailyStats, true, true);
            }
            System.out.println("");
            logger.log(Level.INFO, "Loaded hourly & daily data for " + name);
            ++i;
        }
    }

    private void parse_SSP_data(String baseDir) {
        if (this.managerType != 0) {
            return;
        }
        int i = 0;
        while (i < this.managedSystem.length) {
            String name = this.managedSystem[i].getVarValues("name")[0];
            try {
                String line;
                BufferedReader br = new BufferedReader(new FileReader(String.valueOf(baseDir) + name + "_" + viosList), 0x100000);
                while ((line = br.readLine()) != null) {
                    int comma = line.indexOf(44);
                    if (comma < 0) continue;
                    String vios = line.substring(0, comma);
                    this.get_SSP_data(String.valueOf(baseDir) + name + "_" + vios + "_" + clusterlist, vios, name);
                }
            }
            catch (IOException ioe) {
                System.out.println("Loader.parse_SSP_data: IOException");
                System.out.println(ioe);
                logger.log(Level.SEVERE, "Loader.parse_SSP_data: IOException");
            }
            ++i;
        }
        this.parse_SSP_status(baseDir);
    }

    private String get_SSP_poolname(String fileName) {
        String[] field_name = cluster_pool_field.split(" ");
        int i = 0;
        while (i < field_name.length) {
            if (field_name[i].equals("pool")) break;
            ++i;
        }
        if (i == field_name.length) {
            System.out.println("FATAL: Pool name was not collected!");
            logger.log(Level.SEVERE, "Pool name was not collected! Aborting...");
            System.exit(1);
        }
        try {
            BufferedReader br = new BufferedReader(new FileReader(fileName), 0x100000);
            String line = br.readLine();
            if (line != null) {
                String[] field_value = line.split(":");
                br.close();
                return field_value[i];
            }
        }
        catch (IOException ioe) {
            System.out.println("Loader.get_SSP_poolname: IOException in cluster_pool_field");
            System.out.println(ioe);
            logger.log(Level.SEVERE, "Loader.get_SSP_poolname: IOException in cluster_pool_field");
        }
        System.out.println("FATAL: Pool name was not collected!");
        logger.log(Level.SEVERE, "FATAL: Pool name was not collected!");
        return null;
    }

    private void parse_SSP_status(String baseDir) {
        if (this.managerType != 0) {
            return;
        }
        if (this.sspcluster == null) {
            return;
        }
        int i = 0;
        while (i < this.sspcluster.length) {
            String[] s;
            int j;
            GenericData gd;
            String[] field_value;
            String line;
            BufferedReader br;
            String[] ssp = this.sspcluster[i].getVarValues("nameid");
            String[] field_name = cluster_status_field.split(" ");
            try {
                br = new BufferedReader(new FileReader(String.valueOf(baseDir) + ssp[0] + "_" + ssp[1] + "_" + ssp_status), 0x100000);
                while ((line = br.readLine()) != null) {
                    field_value = line.split(":");
                    if (field_value.length != field_name.length) {
                        System.out.print("\nSKIPPING line: " + line + "\n");
                        logger.log(Level.WARNING, "File: " + baseDir + ssp[0] + "_" + ssp[1] + "_" + ssp_status + "Skipping line >" + line + "<");
                        continue;
                    }
                    gd = new GenericData();
                    j = 0;
                    while (j < field_value.length) {
                        s = new String[]{field_value[j]};
                        gd.add(field_name[j], s);
                        ++j;
                    }
                    this.sspcluster[i].addObject(CLUSTERSTATUS, gd);
                }
            }
            catch (IOException ioe) {
                System.out.println("Loader.parse_SSP_status: IOException in cluster_status_field");
                System.out.println(ioe);
                logger.log(Level.SEVERE, "Loader.parse_SSP_status: IOException in cluster_status_field");
            }
            field_name = cluster_pool_field.split(" ");
            try {
                br = new BufferedReader(new FileReader(String.valueOf(baseDir) + ssp[0] + "_" + ssp[1] + "_" + ssp_pool), 0x100000);
                while ((line = br.readLine()) != null) {
                    field_value = line.split(":");
                    if (field_value.length != field_name.length) {
                        System.out.print("\nSKIPPING line: " + line + "\n");
                        logger.log(Level.WARNING, "File: " + baseDir + ssp[0] + "_" + ssp[1] + "_" + ssp_pool + "Skipping line >" + line + "<");
                        continue;
                    }
                    gd = new GenericData();
                    j = 0;
                    while (j < field_value.length) {
                        s = new String[]{field_value[j]};
                        gd.add(field_name[j], s);
                        ++j;
                    }
                    this.sspcluster[i].addObject(CLUSTERPOOL, gd);
                }
            }
            catch (IOException ioe) {
                System.out.println("Loader.parse_SSP_status: IOException in cluster_pool_field");
                System.out.println(ioe);
                logger.log(Level.SEVERE, "Loader.parse_SSP_status: IOException in cluster_pool_field");
            }
            field_name = cluster_lun_field.split(" ");
            try {
                br = new BufferedReader(new FileReader(String.valueOf(baseDir) + ssp[0] + "_" + ssp[1] + "_" + ssp_lun), 0x100000);
                while ((line = br.readLine()) != null) {
                    field_value = line.split(":");
                    if (field_value.length != field_name.length) {
                        System.out.print("\nSKIPPING line: " + line + "\n");
                        logger.log(Level.WARNING, "File: " + baseDir + ssp[0] + "_" + ssp[1] + "_" + ssp_lun + "Skipping line >" + line + "<");
                        continue;
                    }
                    gd = new GenericData();
                    j = 0;
                    while (j < field_value.length) {
                        s = new String[]{field_value[j]};
                        gd.add(field_name[j], s);
                        ++j;
                    }
                    this.sspcluster[i].addObject(CLUSTERLUN, gd);
                }
            }
            catch (IOException ioe) {
                System.out.println("Loader.parse_SSP_status: IOException in cluster_lun_field");
                System.out.println(ioe);
                logger.log(Level.SEVERE, "Loader.parse_SSP_status: IOException in cluster_lun_field");
            }
            ++i;
        }
    }

    private void get_SSP_clusters(String prefix, String name, String baseDir) {
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(String.valueOf(baseDir) + name + "_" + viosList), 0x100000);
            while ((line = br.readLine()) != null) {
                int comma = line.indexOf(44);
                if (comma < 0) continue;
                String vios = line.substring(0, comma);
                if (this.managerType == 3 || this.novios) continue;
                this.sendCommand(this.sshm, String.valueOf(prefix) + "viosvrcmd -m '" + name + "' -p '" + vios + "' -c \"cluster -list -fmt ':' -field cluster_name cluster_id\"", String.valueOf(baseDir) + name + "_" + vios + "_" + clusterlist);
                System.out.print("v");
                this.get_SSP_data(String.valueOf(baseDir) + name + "_" + vios + "_" + clusterlist, vios, name);
            }
        }
        catch (IOException ioe) {
            System.out.println("Loader.get_SSP_clusters: IOException");
            System.out.println(ioe);
            logger.log(Level.SEVERE, "Loader.get_SSP_clusters: IOException");
        }
    }

    private void get_SSP_data(String fileName, String viosName, String msName) {
        String[] vios = new String[]{viosName};
        String[] ms = new String[]{msName};
        try {
            BufferedReader br = new BufferedReader(new FileReader(fileName), 0x100000);
            String line = br.readLine();
            if (line == null) {
                br.close();
                return;
            }
            if (line.startsWith("HSC")) {
                if (this.verboseMode) {
                    System.out.println("Warning: file " + fileName + " skipped due to invalid line");
                    System.out.println("         Offending line = " + line);
                }
                logger.log(Level.WARNING, "File " + fileName + " skipped due to invalid line: >" + line + "<");
                br.close();
                return;
            }
            String[] values = line.split(":");
            if (values.length != 2) {
                if (this.verboseMode) {
                    System.out.println("Warning: file " + fileName + " skipped due to invalid line");
                    System.out.println("         Offending line = " + line);
                    logger.log(Level.WARNING, "File " + fileName + " skipped due to invalid line: >" + line + "<");
                }
                br.close();
                return;
            }
            if (this.sspcluster == null) {
                this.sspcluster = new GenericData[1];
                this.sspcluster[0] = new GenericData();
                this.sspcluster[0].add("nameid", values);
                this.sspcluster[0].add("vios", vios);
                this.sspcluster[0].add("ms", ms);
                br.close();
                return;
            }
            int comp = 0;
            int pos = 0;
            while (pos < this.sspcluster.length && (comp = this.sspcluster[pos].getVarValues("nameid")[1].compareTo(values[1])) < 0) {
                ++pos;
            }
            if (comp == 0) {
                br.close();
                return;
            }
            GenericData[] newsspcluster = new GenericData[this.sspcluster.length + 1];
            int j = 0;
            while (j < pos) {
                newsspcluster[j] = this.sspcluster[j];
                ++j;
            }
            newsspcluster[pos] = new GenericData();
            newsspcluster[pos].add("nameid", values);
            newsspcluster[pos].add("vios", vios);
            newsspcluster[pos].add("ms", ms);
            j = pos;
            while (j < this.sspcluster.length) {
                newsspcluster[j + 1] = this.sspcluster[j];
                ++j;
            }
            this.sspcluster = newsspcluster;
            br.close();
        }
        catch (IOException ioe) {
            System.out.println("Loader.get_SSP_data: IOException");
            System.out.println(ioe);
            logger.log(Level.SEVERE, "Loader.get_SSP_data: IOException");
        }
    }

    private void get_SSP_config(String prefix, String baseDir) {
        int i = 0;
        while (i < this.sspcluster.length) {
            String[] ssp = this.sspcluster[i].getVarValues("nameid");
            String[] vios = this.sspcluster[i].getVarValues("vios");
            String[] ms = this.sspcluster[i].getVarValues("ms");
            System.out.print("   scanning " + ssp[0] + ":" + ssp[1] + "\t");
            this.sendCommand(this.sshm, String.valueOf(prefix) + "viosvrcmd -m '" + ms[0] + "' -p '" + vios[0] + "' -c \"cluster -status -verbose -fmt ':' -field " + cluster_status_field + "\"", String.valueOf(baseDir) + ssp[0] + "_" + ssp[1] + "_" + ssp_status);
            System.out.print(".");
            this.sendCommand(this.sshm, String.valueOf(prefix) + "viosvrcmd -m '" + ms[0] + "' -p '" + vios[0] + "' -c \"lssp -clustername " + ssp[0] + " -fmt ':' -field " + cluster_pool_field + "\"", String.valueOf(baseDir) + ssp[0] + "_" + ssp[1] + "_" + ssp_pool);
            System.out.print(".");
            String poolName = this.get_SSP_poolname(String.valueOf(baseDir) + ssp[0] + "_" + ssp[1] + "_" + ssp_pool);
            this.sendCommand(this.sshm, String.valueOf(prefix) + "viosvrcmd -m '" + ms[0] + "' -p '" + vios[0] + "' -c \"lssp -clustername " + ssp[0] + " -sp " + poolName + " -bd -fmt ':' -field " + cluster_lun_field + "\"", String.valueOf(baseDir) + ssp[0] + "_" + ssp[1] + "_" + ssp_lun);
            System.out.print(".");
            System.out.println("  DONE!");
            logger.log(Level.INFO, "Scanned SSP: " + ssp[0] + ":" + ssp[1]);
            ++i;
        }
    }

    private void get_service_agent_config(String prefix, String baseDir) {
        System.out.print("   scanning service agent configuration   ");
        int i = 0;
        while (i < sa_cmd.length) {
            this.sendCommand(this.sshm, String.valueOf(prefix) + "lssacfg -t " + sa_cmd[i], String.valueOf(baseDir) + sa_prefix + sa_cmd[i] + ".txt");
            System.out.print(".");
            ++i;
        }
        System.out.println("  DONE!");
        logger.log(Level.INFO, "Scanned Service Agent");
    }

    private void get_vios_lsmap_config(String prefix, String name, String baseDir) {
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(String.valueOf(baseDir) + name + "_" + viosList), 0x100000);
            while ((line = br.readLine()) != null) {
                int comma = line.indexOf(44);
                if (comma < 0) continue;
                String vios = line.substring(0, comma);
                if (this.managerType == 3) {
                    this.sendCommand(this.sshm, "ioscli ioslevel", String.valueOf(baseDir) + name + "_" + vios + "_" + ioslevel);
                    System.out.print(".");
                    this.sendCommand(this.sshm, "ioscli lsmap -all -npiv -fmt :", String.valueOf(baseDir) + name + "_" + vios + "_" + npivData);
                    System.out.print(".");
                    this.sendCommand(this.sshm, "ioscli lsmap -all -fmt :", String.valueOf(baseDir) + name + "_" + vios + "_" + vscsiDiskData);
                    System.out.print(".");
                    this.sendCommand(this.sshm, "ioscli chkdev -fmt : -field name identifier", String.valueOf(baseDir) + name + "_" + vios + "_" + diskuuid);
                    System.out.print(".");
                    this.sendCommand(this.sshm, "ioscli lsdev | grep \"Shared Ethernet Adapter\" | while read i j ; do echo \"#$i\"; ioscli lsdev -dev $i -attr | grep True; done", String.valueOf(baseDir) + name + "_" + vios + "_" + seaCfg);
                    System.out.print(".");
                    this.sendCommand(this.sshm, "ioscli lsdev | grep \"EtherChannel\" | while read i j ; do echo \"#$i\"; ioscli lsdev -dev $i -attr | grep True; done", String.valueOf(baseDir) + name + "_" + vios + "_" + etherChannel);
                    System.out.print(".");
                    this.sendCommand(this.sshm, "ioscli lsdev | grep \"Shared Ethernet Adapter\" | while read i j ; do echo \"#$i\"; ioscli entstat -all $i ; done", String.valueOf(baseDir) + name + "_" + vios + "_" + entstatSEA);
                    System.out.print(".");
                    this.sendCommand(this.sshm, "ioscli lsdev -vpd | grep -E \"^ *ent[0-9]+ +\"", String.valueOf(baseDir) + name + "_" + vios + "_" + slots);
                    System.out.print(".");
                    this.sendCommand(this.sshm, "ioscli lsdev | grep -E \"^fcs[0-9]+ +\" | while read i j ; do echo \"#$i\"; ioscli fcstat -e $i ; done", String.valueOf(baseDir) + name + "_" + vios + "_" + fcstat);
                    System.out.print(".");
                    this.sendCommand(this.sshm, "ioscli lsdev | grep -E \"^fcs[0-9]+ +\" | while read i j ; do echo \"#$i\"; ioscli lsdev -attr -dev $i ; done", String.valueOf(baseDir) + name + "_" + vios + "_" + fcattr);
                    System.out.print(".");
                    this.sendCommand(this.sshm, "ioscli lspv -size -fmt :", String.valueOf(baseDir) + name + "_" + vios + "_" + lspv_size);
                    System.out.print(".");
                    this.sendCommand(this.sshm, "ioscli lspv -free -fmt :", String.valueOf(baseDir) + name + "_" + vios + "_" + lspv_free);
                    System.out.print(".");
                    this.sendCommand(this.sshm, "ioscli lsdev -dev proc0 -attr", String.valueOf(baseDir) + name + "_" + vios + "_" + proc0);
                    System.out.print(".");
                    continue;
                }
                if (this.novios) continue;
                this.sendCommand(this.sshm, String.valueOf(prefix) + "viosvrcmd -m '" + name + "' -p '" + vios + "' -c \"ioslevel\"", String.valueOf(baseDir) + name + "_" + vios + "_" + ioslevel);
                System.out.print("v");
                this.sendCommand(this.sshm, String.valueOf(prefix) + "viosvrcmd -m '" + name + "' -p '" + vios + "' -c \"lsmap -all -npiv -fmt :\"", String.valueOf(baseDir) + name + "_" + vios + "_" + npivData);
                System.out.print("v");
                this.sendCommand(this.sshm, String.valueOf(prefix) + "viosvrcmd -m '" + name + "' -p '" + vios + "' -c \"lsmap -all -fmt :\"", String.valueOf(baseDir) + name + "_" + vios + "_" + vscsiDiskData);
                System.out.print("v");
                this.sendCommand(this.sshm, String.valueOf(prefix) + "viosvrcmd -m '" + name + "' -p '" + vios + "' -c \"chkdev -fmt : -field name identifier\"", String.valueOf(baseDir) + name + "_" + vios + "_" + diskuuid);
                System.out.print("v");
                this.sendCommand(this.sshm, String.valueOf(prefix) + "viosvrcmd -m '" + name + "' -p '" + vios + "' -c \"lsdev\" | grep \"Shared Ethernet Adapter\" | while read i j ; do echo \"#$i\"; " + prefix + "viosvrcmd -m '" + name + "' -p '" + vios + "' -c \"lsdev -dev $i -attr\" | grep True ; done", String.valueOf(baseDir) + name + "_" + vios + "_" + seaCfg);
                System.out.print("v");
                this.sendCommand(this.sshm, String.valueOf(prefix) + "viosvrcmd -m '" + name + "' -p '" + vios + "' -c \"lsdev\" | grep \"EtherChannel\" | while read i j ; do echo \"#$i\"; " + prefix + "viosvrcmd -m '" + name + "' -p '" + vios + "' -c \"lsdev -dev $i -attr\" | grep True ; done", String.valueOf(baseDir) + name + "_" + vios + "_" + etherChannel);
                System.out.print("v");
                this.sendCommand(this.sshm, String.valueOf(prefix) + "viosvrcmd -m '" + name + "' -p '" + vios + "' -c \"lsdev\" | grep \"Shared Ethernet Adapter\" | while read i j ; do echo \"#$i\"; " + prefix + "viosvrcmd -m '" + name + "' -p '" + vios + "' -c \"entstat -all $i\" ; done", String.valueOf(baseDir) + name + "_" + vios + "_" + entstatSEA);
                System.out.print("v");
                this.sendCommand(this.sshm, String.valueOf(prefix) + "viosvrcmd -m '" + name + "' -p '" + vios + "' -c \"lsdev -vpd\" | grep -E \"^ *ent[0-9]+ +\"", String.valueOf(baseDir) + name + "_" + vios + "_" + slots);
                System.out.print("v");
                this.sendCommand(this.sshm, String.valueOf(prefix) + "viosvrcmd -m '" + name + "' -p '" + vios + "' -c \"lsdev\" | grep -E \"^fcs[0-9]+ +\" | while read i j ; do echo \"#$i\"; " + prefix + "viosvrcmd -m '" + name + "' -p '" + vios + "' -c \"fcstat -e $i\" ; done", String.valueOf(baseDir) + name + "_" + vios + "_" + fcstat);
                System.out.print("v");
                this.sendCommand(this.sshm, String.valueOf(prefix) + "viosvrcmd -m '" + name + "' -p '" + vios + "' -c \"lsdev\" | grep -E \"^fcs[0-9]+ +\" | while read i j ; do echo \"#$i\"; " + prefix + "viosvrcmd -m '" + name + "' -p '" + vios + "' -c \"lsdev -attr -dev $i\" ; done", String.valueOf(baseDir) + name + "_" + vios + "_" + fcattr);
                System.out.print("v");
                this.sendCommand(this.sshm, String.valueOf(prefix) + "viosvrcmd -m '" + name + "' -p '" + vios + "' -c \"lspv -size -fmt :\"", String.valueOf(baseDir) + name + "_" + vios + "_" + lspv_size);
                System.out.print("v");
                this.sendCommand(this.sshm, String.valueOf(prefix) + "viosvrcmd -m '" + name + "' -p '" + vios + "' -c \"lspv -free -fmt :\"", String.valueOf(baseDir) + name + "_" + vios + "_" + lspv_free);
                System.out.print("v");
                this.sendCommand(this.sshm, String.valueOf(prefix) + "viosvrcmd -m '" + name + "' -p '" + vios + "' -c \"lsdev -dev proc0 -attr\"", String.valueOf(baseDir) + name + "_" + vios + "_" + proc0);
                System.out.print("v");
            }
        }
        catch (IOException ioe) {
            System.out.println("Loader.get_vios_lsmap_config: IOException");
            System.out.println(ioe);
            logger.log(Level.SEVERE, "Loader.get_vios_lsmap_config: IOException");
        }
    }

    private void load_npiv_data(GenericData ms, String baseDir) {
        String sysName = ms.getVarValues("name")[0];
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(String.valueOf(baseDir) + sysName + "_" + viosList), 0x100000);
            while ((line = br.readLine()) != null) {
                int comma = line.indexOf(44);
                if (comma < 0) continue;
                String vios = line.substring(0, comma);
                this.load_vios_npiv_data(ms, vios, baseDir);
                this.load_vios_vscsi_data(ms, vios, baseDir);
                this.load_vios_ioslevel(ms, vios, baseDir);
                this.load_vios_hdisk_data(ms, vios, baseDir);
                this.load_sea_data(ms, vios, baseDir);
                this.load_fc_data(ms, vios, baseDir);
                this.load_freq_data(ms, vios, baseDir);
            }
        }
        catch (IOException ioe) {
            System.out.println("Loader.load_npiv_data: IOException");
            System.out.println(ioe);
            logger.log(Level.SEVERE, "Loader.load_npiv_data: IOException");
        }
    }

    private void load_freq_data(GenericData ms, String viosName, String baseDir) {
        BufferedReader br = null;
        String[] values = null;
        String[] s = null;
        String sysName = ms.getVarValues("name")[0];
        try {
            String line;
            br = new BufferedReader(new FileReader(String.valueOf(baseDir) + sysName + "_" + viosName + "_" + proc0), 0x100000);
            while ((line = br.readLine()) != null) {
                if (line.startsWith("HSC")) {
                    if (this.verboseMode) {
                        System.out.println("Warning: file " + baseDir + sysName + "_" + viosName + "_" + proc0 + " skipped due to invalid line");
                        System.out.println("         Offending line = " + line);
                    }
                    logger.log(Level.WARNING, "File " + baseDir + sysName + "_" + viosName + "_" + proc0 + " skipped due to invalid line: >" + line + "<");
                    br.close();
                    return;
                }
                if (line.startsWith("AIX: ") || (s = line.split("\\s+")).length < 2) continue;
                if (s[0].equals("frequency")) {
                    try {
                        float freq = Float.parseFloat(s[1]);
                    }
                    catch (NumberFormatException nfe) {
                        System.out.println("Warning: could not evaluate CPU frequency from VIOS " + viosName + ": value=" + line);
                        logger.log(Level.INFO, "Could not evaluate CPU frequency from VIOS " + viosName + ": value=" + line);
                        continue;
                    }
                    values = new String[]{Float.toString(freq /= 1.0E9f)};
                    ms.add("frequency", values);
                    continue;
                }
                if (!s[0].equals("type")) continue;
                values = new String[]{s[1]};
                ms.add("cpu_type", values);
            }
            br.close();
        }
        catch (IOException ioe) {
            System.out.println("Loader.load_freq_data: IOException");
            System.out.println(ioe);
            logger.log(Level.SEVERE, "Loader.load_freq_data: IOException");
        }
    }

    private void load_vios_ioslevel(GenericData ms, String viosName, String baseDir) {
        String[] names = null;
        String[] values = null;
        String sysName = ms.getVarValues("name")[0];
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(String.valueOf(baseDir) + sysName + "_" + viosName + "_" + ioslevel), 0x100000);
            while ((line = br.readLine()) != null) {
                if (line.startsWith("HSC")) {
                    if (this.verboseMode) {
                        System.out.println("Warning: file " + baseDir + sysName + "_" + viosName + "_" + ioslevel + " skipped due to invalid line");
                        System.out.println("         Offending line = " + line);
                    }
                    logger.log(Level.WARNING, "File " + baseDir + sysName + "_" + viosName + "_" + ioslevel + " skipped due to invalid line: >" + line + "<");
                    br.close();
                    return;
                }
                if (line.startsWith("AIX: ")) continue;
                GenericData[] lpars = ms.getObjects(CONFIG_LPAR);
                int i = 0;
                while (i < lpars.length) {
                    names = lpars[i].getVarValues("name");
                    if (names[0].equals(viosName)) {
                        values = new String[]{"VIOS " + line};
                        lpars[i].add("os_version", values);
                        br.close();
                        return;
                    }
                    ++i;
                }
            }
            br.close();
        }
        catch (IOException ioe) {
            System.out.println("Loader.load_npiv_data: IOException");
            System.out.println(ioe);
            logger.log(Level.SEVERE, "Loader.load_npiv_data: IOException");
        }
    }

    private void load_vios_npiv_data(GenericData ms, String viosName, String baseDir) {
        String[] names = null;
        String viosSlot = null;
        String sysName = ms.getVarValues("name")[0];
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(String.valueOf(baseDir) + sysName + "_" + viosName + "_" + npivData), 0x100000);
            while ((line = br.readLine()) != null) {
                if (line.startsWith("HSC") || line.startsWith("NLS") || line.startsWith(":")) {
                    if (this.verboseMode) {
                        System.out.println("Warning: file " + baseDir + sysName + "_" + viosName + "_" + npivData + " skipped due to invalid line");
                        System.out.println("         Offending line = " + line);
                    }
                    logger.log(Level.WARNING, "File " + baseDir + sysName + "_" + viosName + "_" + npivData + " skipped due to invalid line: >" + line + "<");
                    br.close();
                    return;
                }
                if (line.startsWith("AIX: ")) continue;
                GenericData gd = new GenericData();
                int i = 0;
                int num = 0;
                while (i < line.length()) {
                    if (line.charAt(i) == ':') {
                        ++num;
                    }
                    ++i;
                }
                if (num != 11) {
                    System.out.println("Warning: npiv data line not in expected format -> " + line);
                    String newLine = br.readLine();
                    if (newLine.startsWith("vfchost")) {
                        System.out.println("NPIV data line skipped");
                        logger.log(Level.WARNING, "File " + baseDir + sysName + "_" + viosName + "_" + npivData + " skipped due to invalid line: >" + line + "<");
                        line = newLine;
                    } else {
                        line = String.valueOf(line) + newLine;
                        i = 0;
                        num = 0;
                        while (i < line.length()) {
                            if (line.charAt(i) == ':') {
                                ++num;
                            }
                            ++i;
                        }
                        if (num == 11) {
                            System.out.println("NPIV line recovered!");
                        } else {
                            System.out.println("Warning: npiv line skipped with following one --> " + newLine);
                            logger.log(Level.WARNING, "File " + baseDir + sysName + "_" + viosName + "_" + npivData + " skipped due to invalid line: >" + line + "<");
                            continue;
                        }
                    }
                }
                int begin = line.indexOf(58) + 1;
                int end = line.indexOf(58, begin);
                begin = line.indexOf("-C", begin) + 2;
                viosSlot = line.substring(begin, end);
                begin = line.indexOf(58, end + 1);
                begin = line.indexOf(58, begin + 1);
                begin = line.indexOf(58, begin + 1);
                begin = line.indexOf(58, begin + 1);
                begin = line.indexOf(58, begin + 1) + 1;
                end = line.indexOf(58, begin);
                names = new String[]{line.substring(begin, end)};
                gd.add(String.valueOf(viosName) + "@" + viosSlot, names);
                ms.addObject(VFCMAP, gd);
            }
            br.close();
        }
        catch (IOException ioe) {
            System.out.println("load_vios_npiv_data: IOException");
            System.out.println(ioe);
            logger.log(Level.SEVERE, "IOException", ioe);
        }
    }

    private void load_sea_data(GenericData ms, String viosName, String baseDir) {
        String varValue;
        int start;
        String varName;
        int end;
        String line;
        GenericData gd;
        BufferedReader br;
        String[] names = null;
        String sysName = ms.getVarValues("name")[0];
        try {
            br = new BufferedReader(new FileReader(String.valueOf(baseDir) + sysName + "_" + viosName + "_" + seaCfg), 0x100000);
            gd = null;
            while ((line = br.readLine()) != null) {
                if (line.startsWith("HSC") || line.startsWith("NLS") || line.startsWith(":")) {
                    if (this.verboseMode) {
                        System.out.println("Warning: file " + baseDir + sysName + "_" + viosName + "_" + seaCfg + " skipped due to invalid line");
                        System.out.println("         Offending line = " + line);
                    }
                    logger.log(Level.WARNING, "File " + baseDir + sysName + "_" + viosName + "_" + seaCfg + " skipped due to invalid line: >" + line + "<");
                    br.close();
                    return;
                }
                if (line.startsWith("AIX: ")) continue;
                if (line.startsWith("#")) {
                    if (gd != null) {
                        ms.addObject(SEA, gd);
                    }
                    gd = new GenericData();
                    names = new String[]{viosName};
                    gd.add("VIOS", names);
                    names = new String[]{line.substring(1)};
                    gd.add("SEA", names);
                    continue;
                }
                end = line.indexOf(32);
                varName = line.substring(0, end);
                start = end + 1;
                while (line.charAt(start) == ' ') {
                    ++start;
                }
                end = line.indexOf(32, start);
                varValue = line.substring(start, end);
                if (varValue.contains(",")) {
                    names = varValue.split(",");
                    gd.add(varName, names);
                    continue;
                }
                names = new String[]{varValue};
                if (varName.equals("ctl_chan") && !names[0].startsWith("ent")) {
                    names[0] = "";
                }
                gd.add(varName, names);
            }
            if (gd != null) {
                ms.addObject(SEA, gd);
            }
        }
        catch (IOException ioe) {
            System.out.println("Loader.load_sea_data: IOException");
            System.out.println(ioe);
            logger.log(Level.SEVERE, "IOException", ioe);
        }
        try {
            br = new BufferedReader(new FileReader(String.valueOf(baseDir) + sysName + "_" + viosName + "_" + slots), 0x100000);
            gd = new GenericData();
            names = new String[]{viosName};
            gd.add("VIOS", names);
            while ((line = br.readLine()) != null) {
                if (line.startsWith("HSC") || line.startsWith("NLS") || line.startsWith(":")) {
                    if (this.verboseMode) {
                        System.out.println("Warning: file " + baseDir + sysName + "_" + viosName + "_" + slots + " skipped due to invalid line");
                        System.out.println("         Offending line = " + line);
                    }
                    logger.log(Level.WARNING, "File " + baseDir + sysName + "_" + viosName + "_" + slots + " skipped due to invalid line: >" + line + "<");
                    br.close();
                    return;
                }
                if (line.startsWith("AIX: ")) continue;
                start = line.indexOf("ent");
                end = line.indexOf(32, start);
                varName = line.substring(start, end);
                if (line.contains("Virtual")) {
                    start = line.indexOf("-C") + 2;
                    end = line.indexOf("-T", start);
                    varValue = line.substring(start, end);
                } else {
                    start = line.indexOf("U");
                    end = line.indexOf(32, start);
                    varValue = line.substring(start, end);
                }
                names = new String[]{varValue};
                gd.add(varName, names);
            }
            ms.addObject(ETH, gd);
        }
        catch (IOException ioe) {
            System.out.println("Loader.load_sea_data: IOException");
            System.out.println(ioe);
            logger.log(Level.SEVERE, "IOException", ioe);
        }
        try {
            br = new BufferedReader(new FileReader(String.valueOf(baseDir) + sysName + "_" + viosName + "_" + etherChannel), 0x100000);
            gd = null;
            while ((line = br.readLine()) != null) {
                if (line.startsWith("HSC") || line.startsWith("NLS") || line.startsWith(":")) {
                    if (this.verboseMode) {
                        System.out.println("Warning: file " + baseDir + sysName + "_" + viosName + "_" + etherChannel + " skipped due to invalid line");
                        System.out.println("         Offending line = " + line);
                    }
                    logger.log(Level.WARNING, "File " + baseDir + sysName + "_" + viosName + "_" + etherChannel + " skipped due to invalid line: >" + line + "<");
                    br.close();
                    return;
                }
                if (line.startsWith("AIX: ")) continue;
                if (line.startsWith("#")) {
                    if (gd != null) {
                        ms.addObject(ETHERCHANNEL, gd);
                    }
                    gd = new GenericData();
                    names = new String[]{viosName};
                    gd.add("VIOS", names);
                    names = new String[]{line.substring(1)};
                    gd.add("ETHERCHANNEL", names);
                    continue;
                }
                end = line.indexOf(32);
                varName = line.substring(0, end);
                start = end + 1;
                while (line.charAt(start) == ' ') {
                    ++start;
                }
                end = line.indexOf(32, start);
                varValue = line.substring(start, end);
                if (varValue.contains(",")) {
                    names = varValue.split(",");
                    gd.add(varName, names);
                    continue;
                }
                names = new String[]{varValue};
                gd.add(varName, names);
            }
            if (gd != null) {
                ms.addObject(ETHERCHANNEL, gd);
            }
        }
        catch (IOException ioe) {
            System.out.println("Loader.load_sea_data: IOException");
            System.out.println(ioe);
            logger.log(Level.SEVERE, "IOException", ioe);
        }
        try {
            br = new BufferedReader(new FileReader(String.valueOf(baseDir) + sysName + "_" + viosName + "_" + entstatSEA), 0x100000);
            gd = null;
            GenericData vea = null;
            while ((line = br.readLine()) != null) {
                int i;
                String[] tokens;
                if (line.startsWith("AIX: ")) continue;
                if (line.startsWith("#ent")) {
                    if (vea != null) {
                        gd.addObject(ETH, vea);
                        vea = null;
                    }
                    if (gd != null) {
                        ms.addObject(ENTSTATSEA, gd);
                    }
                    gd = new GenericData();
                    names = new String[]{viosName};
                    gd.add("VIOS", names);
                    names = new String[]{line.substring(1)};
                    gd.add("SEA", names);
                    continue;
                }
                if (line.startsWith("Virtual Adapter:") || line.startsWith("Control Channel Adapter:")) {
                    if (vea != null) {
                        gd.addObject(ETH, vea);
                    }
                    vea = new GenericData();
                    tokens = line.split("\\s+");
                    names = new String[]{tokens[tokens.length - 1]};
                    vea.add("name", names);
                    names = new String[]{tokens[0].equals("Control") ? "Control" : "Data"};
                    vea.add("control_channel", names);
                    continue;
                }
                if (line.startsWith("Trunk")) {
                    tokens = line.split("\\s+");
                    if (!tokens[tokens.length - 1].equals("True")) continue;
                    line = br.readLine();
                    if (line == null || !line.startsWith("  Priority:")) break;
                    tokens = line.trim().split("\\s+");
                    names = new String[]{tokens[1], tokens[3]};
                    vea.add("trunk", names);
                    continue;
                }
                if (line.startsWith("Hypervisor Send Failures:")) {
                    tokens = line.split("\\s+");
                    names = new String[]{tokens[tokens.length - 1]};
                    vea.add("hyp_send_failures", names);
                    line = br.readLine();
                    if (line == null || !line.startsWith("  Receiver Failures:")) break;
                    tokens = line.split("\\s+");
                    names = new String[]{tokens[tokens.length - 1]};
                    vea.add("hyp_send_receiver_fail", names);
                    line = br.readLine();
                    if (line == null || !line.startsWith("  Send Errors:")) break;
                    tokens = line.split("\\s+");
                    names = new String[]{tokens[tokens.length - 1]};
                    vea.add("hyp_send_sender_fail", names);
                    line = br.readLine();
                    if (line == null || !line.startsWith("Hypervisor Receive Failures:")) break;
                    tokens = line.split("\\s+");
                    names = new String[]{tokens[tokens.length - 1]};
                    vea.add("hyp_receive_failures", names);
                    continue;
                }
                if (line.startsWith("Port VLAN ID:")) {
                    tokens = line.split("\\s+");
                    names = new String[]{tokens[tokens.length - 1]};
                    vea.add("PVID", names);
                    line = br.readLine();
                    if (line == null || !line.startsWith("VLAN Tag IDs:")) break;
                    tokens = line.split("\\s+");
                    names = new String[]{tokens[3]};
                    i = 4;
                    while (i < tokens.length) {
                        names[0] = String.valueOf(names[0]) + ", " + tokens[i];
                        ++i;
                    }
                    line = br.readLine();
                    if (line == null) break;
                    if (line.length() > 5) {
                        tokens = line.trim().split("\\s+");
                        i = 0;
                        while (i < tokens.length) {
                            names[0] = String.valueOf(names[0]) + ", " + tokens[i];
                            ++i;
                        }
                    }
                    vea.add("VLAN", names);
                    continue;
                }
                if (line.startsWith("Switch ID:")) {
                    tokens = line.split("\\s+");
                    names = new String[]{tokens[tokens.length - 1]};
                    vea.add("switch", names);
                    continue;
                }
                if (line.startsWith("    Buffer Size")) {
                    tokens = line.split("\\s+");
                    names = new String[]{tokens[tokens.length - 1]};
                    vea.add("bufsize", names);
                    line = br.readLine();
                    if (line == null || !line.startsWith("    Buffers")) break;
                    tokens = line.split("\\s+");
                    names = new String[]{tokens[tokens.length - 1]};
                    vea.add("numbufs", names);
                    line = br.readLine();
                    if (line == null || !line.startsWith("    History") || (line = br.readLine()) == null || !line.startsWith("      No Buffers")) break;
                    tokens = line.split("\\s+");
                    names = new String[]{tokens[tokens.length - 1]};
                    vea.add("nobufs", names);
                }
                if (!line.startsWith("    Min Buffers")) continue;
                tokens = line.trim().split("\\s+");
                names = new String[5];
                i = 0;
                while (i < 5) {
                    names[i] = tokens[2 + i];
                    ++i;
                }
                vea.add("minBufs", names);
                line = br.readLine();
                if (line == null || !line.startsWith("    Max Buffers")) break;
                tokens = line.trim().split("\\s+");
                names = new String[5];
                i = 0;
                while (i < 5) {
                    names[i] = tokens[2 + i];
                    ++i;
                }
                vea.add("maxBufs", names);
                line = br.readLine();
                if (line == null || !line.startsWith("    Allocated") || (line = br.readLine()) == null || !line.startsWith("    Registered") || (line = br.readLine()) == null || !line.startsWith("    History") || (line = br.readLine()) == null || !line.startsWith("      Max Allocated")) break;
                tokens = line.trim().split("\\s+");
                names = new String[5];
                i = 0;
                while (i < 5) {
                    names[i] = tokens[2 + i];
                    ++i;
                }
                vea.add("maxAlloc", names);
            }
            if (vea != null) {
                gd.addObject(ETH, vea);
            }
            if (gd != null) {
                ms.addObject(ENTSTATSEA, gd);
            }
        }
        catch (IOException ioe) {
            System.out.println("Loader.load_sea_data: IOException");
            System.out.println(ioe);
            logger.log(Level.SEVERE, "IOException", ioe);
        }
    }

    private void load_fc_data(GenericData ms, String viosName, String baseDir) {
        String line;
        GenericData gd;
        BufferedReader br;
        String[] names = null;
        int valueCol = 0;
        int descrCol = 0;
        String sysName = ms.getVarValues("name")[0];
        try {
            br = new BufferedReader(new FileReader(String.valueOf(baseDir) + sysName + "_" + viosName + "_" + fcattr), 0x100000);
            gd = null;
            while ((line = br.readLine()) != null) {
                if (line.startsWith("HSC") || line.startsWith("NLS") || line.startsWith(":")) {
                    if (this.verboseMode) {
                        System.out.println("Warning: file " + baseDir + sysName + "_" + viosName + "_" + fcattr + " skipped due to invalid line");
                        System.out.println("         Offending line = " + line);
                    }
                    logger.log(Level.WARNING, "File " + baseDir + sysName + "_" + viosName + "_" + fcattr + " skipped due to invalid line: >" + line + "<");
                    br.close();
                    return;
                }
                if (line.startsWith("AIX: ")) continue;
                if (line.startsWith("#")) {
                    if (gd != null) {
                        ms.addObject(FC, gd);
                    }
                    gd = new GenericData();
                    names = new String[]{viosName};
                    gd.add("VIOS", names);
                    names = new String[]{line.substring(1)};
                    gd.add("FC", names);
                    continue;
                }
                if (line.length() == 0) continue;
                if (line.length() == 0 || line.startsWith("attribute")) {
                    valueCol = line.indexOf("value");
                    descrCol = line.indexOf("description");
                    continue;
                }
                String varName = line.substring(0, valueCol).trim();
                String varValue = line.substring(valueCol, descrCol).trim();
                names = new String[]{varValue};
                gd.add(varName, names);
            }
            if (gd != null) {
                ms.addObject(FC, gd);
            }
        }
        catch (IOException ioe) {
            System.out.println("Loader.load_fc_data: IOException");
            System.out.println(ioe);
            logger.log(Level.SEVERE, "IOException", ioe);
        }
        try {
            br = new BufferedReader(new FileReader(String.valueOf(baseDir) + sysName + "_" + viosName + "_" + fcstat), 0x100000);
            gd = null;
            while ((line = br.readLine()) != null) {
                String[] tokens;
                if (line.startsWith("AIX: ")) continue;
                if (line.startsWith("#fc")) {
                    GenericData[] fc = ms.getObjects(FC);
                    int index = 0;
                    while (index < fc.length) {
                        if (fc[index].getVarValues("VIOS")[0].equals(viosName) && fc[index].getVarValues("FC")[0].equals(line.substring(1))) break;
                        ++index;
                    }
                    if (index == fc.length) {
                        gd = new GenericData();
                        names = new String[]{viosName};
                        gd.add("VIOS", names);
                        names = new String[]{line.substring(1)};
                        gd.add("FC", names);
                        ms.addObject(FC, gd);
                        continue;
                    }
                    gd = fc[index];
                    continue;
                }
                if (line.startsWith("ZA:")) {
                    tokens = line.split("\\s+");
                    names = new String[1];
                    if (tokens.length < 2) {
                        names[0] = "N/A";
                        gd.add("firmware", names);
                        continue;
                    }
                    names[0] = tokens[1];
                    gd.add("firmware", names);
                    continue;
                }
                if (line.startsWith("World Wide Node Name:")) {
                    tokens = line.split("\\s+");
                    names = new String[]{tokens[tokens.length - 1]};
                    gd.add("wwnn", names);
                    continue;
                }
                if (line.startsWith("World Wide Port Name:")) {
                    tokens = line.split("\\s+");
                    names = new String[]{tokens[tokens.length - 1]};
                    gd.add("wwpn", names);
                    continue;
                }
                if (line.startsWith("Port Speed (supported):")) {
                    tokens = line.split("\\s+");
                    names = new String[]{tokens[tokens.length - 2]};
                    gd.add("speed-supported", names);
                    continue;
                }
                if (line.startsWith("Port Speed (running):")) {
                    tokens = line.split("\\s+");
                    names = new String[]{tokens[tokens.length - 2]};
                    gd.add("speed-running", names);
                    continue;
                }
                if (line.startsWith("Port FC ID:")) {
                    tokens = line.split("\\s+");
                    names = new String[]{tokens[tokens.length - 1]};
                    gd.add("fcid", names);
                    continue;
                }
                if (line.startsWith("Port Type:")) {
                    tokens = line.split("\\s+");
                    names = new String[]{tokens[tokens.length - 1]};
                    gd.add("port_type", names);
                    continue;
                }
                if (line.startsWith("Seconds Since Last Reset:")) {
                    tokens = line.split("\\s+");
                    names = new String[]{tokens[tokens.length - 1]};
                    gd.add("reset", names);
                    continue;
                }
                if (line.startsWith("Error Frames:")) {
                    tokens = line.split("\\s+");
                    names = new String[]{tokens[tokens.length - 1]};
                    gd.add("errorf", names);
                    continue;
                }
                if (line.startsWith("Dumped Frames:")) {
                    tokens = line.split("\\s+");
                    names = new String[]{tokens[tokens.length - 1]};
                    gd.add("dumpedf", names);
                    continue;
                }
                if (line.startsWith("Invalid CRC Count:")) {
                    tokens = line.split("\\s+");
                    names = new String[]{tokens[tokens.length - 1]};
                    gd.add("invalidcrc", names);
                    continue;
                }
                if (line.startsWith("Invalid Tx Word Count:")) {
                    tokens = line.split("\\s+");
                    names = new String[]{tokens[tokens.length - 1]};
                    gd.add("invalidtx", names);
                    continue;
                }
                if (line.startsWith("IP over FC Adapter Driver Information")) {
                    line = br.readLine();
                    if (line == null || !line.startsWith("  No DMA Resource Count:")) break;
                    tokens = line.split("\\s+");
                    names = new String[]{tokens[tokens.length - 1]};
                    gd.add("ip_nodma", names);
                    line = br.readLine();
                    if (line == null || !line.startsWith("  No Adapter Elements Count:")) break;
                    tokens = line.split("\\s+");
                    names = new String[]{tokens[tokens.length - 1]};
                    gd.add("ip_noadapter", names);
                    continue;
                }
                if (line.startsWith("FC SCSI Adapter Driver Information")) {
                    line = br.readLine();
                    if (line == null || !line.startsWith("  No DMA Resource Count:")) break;
                    tokens = line.split("\\s+");
                    names = new String[]{tokens[tokens.length - 1]};
                    gd.add("scsi_nodma", names);
                    line = br.readLine();
                    if (line == null || !line.startsWith("  No Adapter Elements Count:")) break;
                    tokens = line.split("\\s+");
                    names = new String[]{tokens[tokens.length - 1]};
                    gd.add("scsi_noadapter", names);
                    line = br.readLine();
                    if (line == null || !line.startsWith("  No Command Resource Count:")) break;
                    tokens = line.split("\\s+");
                    names = new String[]{tokens[tokens.length - 1]};
                    gd.add("scsi_nocmd", names);
                    continue;
                }
                if (!line.startsWith("Adapter Effective max transfer value:")) continue;
                tokens = line.split("\\s+");
                names = new String[]{tokens[tokens.length - 1]};
                gd.add("e_max_transfer", names);
            }
            if (gd != null) {
                ms.addObject(FCSTAT, gd);
            }
        }
        catch (IOException ioe) {
            System.out.println("Loader.load_fc_data: IOException");
            System.out.println(ioe);
            logger.log(Level.SEVERE, "IOException", ioe);
        }
    }

    private void load_vios_hdisk_data(GenericData ms, String viosName, String baseDir) {
        String hdisk;
        int end;
        String line;
        BufferedReader br;
        String[] names = null;
        String sysName = ms.getVarValues("name")[0];
        try {
            br = new BufferedReader(new FileReader(String.valueOf(baseDir) + sysName + "_" + viosName + "_" + diskuuid), 0x100000);
            GenericData gd = new GenericData();
            names = new String[]{viosName};
            gd.add("VIOS", names);
            while ((line = br.readLine()) != null) {
                if (line.startsWith("HSC") || line.startsWith("NLS") || line.startsWith(":")) {
                    if (this.verboseMode) {
                        System.out.println("Warning: file " + baseDir + sysName + "_" + viosName + "_" + diskuuid + " skipped due to invalid line");
                        System.out.println("         Offending line = " + line);
                    }
                    logger.log(Level.WARNING, "File " + baseDir + sysName + "_" + viosName + "_" + diskuuid + " skipped due to invalid line: >" + line + "<");
                    br.close();
                    return;
                }
                if (line.startsWith("AIX: ")) continue;
                end = line.indexOf(58);
                hdisk = line.substring(0, end);
                String uuid = line.substring(end + 1);
                names = new String[]{uuid};
                gd.add(hdisk, names);
                this.diskData.add_uuid(uuid, hdisk, sysName, viosName);
            }
            ms.addObject(HDISK, gd);
        }
        catch (IOException ioe) {
            System.out.println("Loader.load_npiv_data: IOException");
            System.out.println(ioe);
            logger.log(Level.SEVERE, "IOException", ioe);
        }
        try {
            br = new BufferedReader(new FileReader(String.valueOf(baseDir) + sysName + "_" + viosName + "_" + lspv_size), 0x100000);
            while ((line = br.readLine()) != null) {
                if (line.startsWith("HSC") || line.startsWith("NLS") || line.startsWith(":")) {
                    if (this.verboseMode) {
                        System.out.println("Warning: file " + baseDir + sysName + "_" + viosName + "_" + lspv_size + " skipped due to invalid line");
                        System.out.println("         Offending line = " + line);
                    }
                    logger.log(Level.WARNING, "File " + baseDir + sysName + "_" + viosName + "_" + lspv_size + " skipped due to invalid line: >" + line + "<");
                    br.close();
                    return;
                }
                if (line.startsWith("AIX: ")) continue;
                end = line.indexOf(58);
                hdisk = line.substring(0, end);
                end = line.indexOf(58, end + 1);
                String size = line.substring(end + 1);
                this.diskData.addSize(sysName, viosName, hdisk, Integer.valueOf(size));
            }
        }
        catch (IOException ioe) {
            System.out.println("Loader.load_npiv_data: IOException");
            System.out.println(ioe);
            logger.log(Level.SEVERE, "IOException", ioe);
        }
        try {
            br = new BufferedReader(new FileReader(String.valueOf(baseDir) + sysName + "_" + viosName + "_" + lspv_free), 0x100000);
            while ((line = br.readLine()) != null) {
                if (line.startsWith("HSC") || line.startsWith("NLS") || line.startsWith(":")) {
                    if (this.verboseMode) {
                        System.out.println("Warning: file " + baseDir + sysName + "_" + viosName + "_" + lspv_free + " skipped due to invalid line");
                        System.out.println("         Offending line = " + line);
                    }
                    logger.log(Level.WARNING, "File " + baseDir + sysName + "_" + viosName + "_" + lspv_free + " skipped due to invalid line: >" + line + "<");
                    br.close();
                    return;
                }
                if (line.startsWith("AIX: ")) continue;
                end = line.indexOf(58);
                hdisk = line.substring(0, end);
                this.diskData.addFree(sysName, viosName, hdisk);
            }
        }
        catch (IOException ioe) {
            System.out.println("Loader.load_npiv_data: IOException");
            System.out.println(ioe);
            logger.log(Level.SEVERE, "IOException", ioe);
        }
    }

    private void load_vios_vscsi_data(GenericData ms, String viosName, String baseDir) {
        String[] names = null;
        String[] data = null;
        String SVSA = null;
        String slot = null;
        String client = null;
        Vector<String> VTD = null;
        Vector<String> status = null;
        Vector<String> LUN = null;
        Vector<String> backingDevice = null;
        Vector<String> physloc = null;
        Vector<String> mirror = null;
        int numparams = 0;
        String sysName = ms.getVarValues("name")[0];
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(String.valueOf(baseDir) + sysName + "_" + viosName + "_" + vscsiDiskData), 0x100000);
            while ((line = br.readLine()) != null) {
                if (line.startsWith("HSC") || line.startsWith("NLS") || line.startsWith(":")) {
                    if (this.verboseMode) {
                        System.out.println("Warning: file " + baseDir + sysName + "_" + viosName + "_" + vscsiDiskData + " skipped due to invalid line");
                        System.out.println("         Offending line = " + line);
                    }
                    logger.log(Level.WARNING, "File " + baseDir + sysName + "_" + viosName + "_" + vscsiDiskData + " skipped due to invalid line: >" + line + "<");
                    br.close();
                    return;
                }
                if (line.startsWith("AIX: ") || !line.contains(":")) continue;
                data = line.split(":");
                numparams = line.contains(":true") || line.contains(":false") || line.contains(":N/A") ? 6 : (line.contains(":Available") || line.contains(":Defined") ? 5 : 4);
                GenericData gd = new GenericData();
                SVSA = data[0];
                int begin = data[1].indexOf("-C");
                slot = data[1].substring(begin + 2);
                client = data[2];
                VTD = new Vector<String>();
                status = new Vector<String>();
                LUN = new Vector<String>();
                backingDevice = new Vector<String>();
                physloc = new Vector<String>();
                mirror = new Vector<String>();
                int index = 3;
                while (index <= data.length - numparams) {
                    VTD.add(data[index++]);
                    if (numparams != 4) {
                        status.add(data[index++]);
                    }
                    LUN.add(data[index++]);
                    backingDevice.add(data[index++]);
                    physloc.add(data[index++]);
                    if (numparams != 6) continue;
                    mirror.add(data[index++]);
                }
                names = new String[]{viosName};
                gd.add("VIOS", names);
                names = new String[]{slot};
                gd.add("slot", names);
                names = new String[]{SVSA};
                gd.add("SVSA", names);
                names = new String[]{client};
                gd.add("client", names);
                names = new String[1];
                gd.add("VTD", VTD.toArray(names));
                names = new String[1];
                gd.add("Status", status.toArray(names));
                names = new String[1];
                gd.add("LUN", LUN.toArray(names));
                names = new String[1];
                gd.add("BackingDevice", backingDevice.toArray(names));
                names = new String[1];
                gd.add("physloc", physloc.toArray(names));
                names = new String[1];
                gd.add("mirror", mirror.toArray(names));
                ms.addObject(VSCSIMAP, gd);
            }
        }
        catch (IOException ioe) {
            System.out.println("Loader.load_vios_vscsi_data: IOException");
            System.out.println(ioe);
            logger.log(Level.SEVERE, "IOException", ioe);
        }
    }

    private GregorianCalendar parseHMCDate(String filename) {
        GregorianCalendar result = null;
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(filename), 0x100000);
            int e = 0;
            int s = 0;
            while ((line = br.readLine()) != null) {
                e = line.indexOf(45);
                int Y = Integer.parseInt(line.substring(0, e));
                s = e + 1;
                e = line.indexOf(45, s);
                int M = Integer.parseInt(line.substring(s, e));
                s = e + 1;
                e = line.indexOf(32, s);
                int D = Integer.parseInt(line.substring(s, e));
                s = e + 1;
                e = line.indexOf(58, s);
                int hh = Integer.parseInt(line.substring(s, e));
                s = e + 1;
                e = line.indexOf(58, s);
                int mm = Integer.parseInt(line.substring(s, e));
                s = e + 1;
                int ss = Integer.parseInt(line.substring(s));
                result = new GregorianCalendar(Y, M - 1, D, hh, mm, ss);
            }
            br.close();
            return result;
        }
        catch (Exception exc) {
            System.out.println("Loader.parseHMCDate Exception");
            System.out.println(exc);
            logger.log(Level.SEVERE, "Exception", exc);
            return null;
        }
    }

    private void load_data(GenericData ms, String baseDir, String fileName, byte objName) {
        BufferedReader br = null;
        String[] names = null;
        String sysName = ms.getVarValues("name")[0];
        logger.log(Level.INFO, "Loading file: " + baseDir + sysName + "_" + fileName);
        try {
            String line;
            br = new BufferedReader(new FileReader(String.valueOf(baseDir) + sysName + "_" + fileName), 0x100000);
            while ((line = br.readLine()) != null) {
                if (line.startsWith("HSC") || line.startsWith("The managed system") || line.startsWith("No results were found")) {
                    if (this.verboseMode) {
                        System.out.println("Warning: file " + baseDir + sysName + "_" + fileName + " skipped due to invalid line");
                        System.out.println("         Offending line = " + line);
                    }
                    logger.log(Level.WARNING, "File " + baseDir + sysName + "_" + fileName + " skipped due to invalid line: >" + line + "<");
                    br.close();
                    return;
                }
                DataParser dp = new DataParser(line);
                names = dp.getNames();
                if (names == null || names.length == 0 || names[0] == null) {
                    if (this.verboseMode) {
                        System.out.println("Warning: " + baseDir + sysName + "_" + fileName + "line with no detected data: \"" + line + "\"");
                    }
                    logger.log(Level.WARNING, "File " + baseDir + sysName + "_" + fileName + " skipped due to invalid line: >" + line + "<");
                    continue;
                }
                GenericData gd = new GenericData();
                int i = 0;
                while (i < names.length) {
                    gd.add(names[i], dp.getStringValue(names[i]));
                    ++i;
                }
                ms.addObject(objName, gd);
            }
        }
        catch (IOException ioe) {
            System.out.println("Loader.load_data: IOException");
            System.out.println(ioe);
            logger.log(Level.SEVERE, "IOException", ioe);
        }
    }

    private void load_service_agent_data(String baseDir) {
        BufferedReader br = null;
        String[] names = null;
        this.service_agent = new GenericData();
        byte cmd = 0;
        while (cmd < sa_cmd.length) {
            String file_name = String.valueOf(baseDir) + sa_prefix + sa_cmd[cmd] + ".txt";
            logger.log(Level.INFO, "Loading file: " + file_name);
            try {
                String line;
                br = new BufferedReader(new FileReader(file_name), 0x100000);
                while ((line = br.readLine()) != null) {
                    if (line.startsWith("An invalid parameter value was entered") || line.startsWith("No results were found")) {
                        if (this.verboseMode) {
                            System.out.println("Warning: file " + file_name + " skipped due to invalid line");
                            System.out.println("         Offending line = " + line);
                        }
                        logger.log(Level.WARNING, "File " + file_name + " skipped due to invalid line: >" + line + "<");
                        break;
                    }
                    DataParser dp = new DataParser(line);
                    names = dp.getNames();
                    if (names == null || names.length == 0 || names[0] == null) {
                        if (this.verboseMode) {
                            System.out.println("Warning: " + file_name + "line with no detected data: \"" + line + "\"");
                        }
                        logger.log(Level.WARNING, "File " + file_name + " skipped due to invalid line: >" + line + "<");
                        break;
                    }
                    GenericData gd = new GenericData();
                    int i = 0;
                    while (i < names.length) {
                        gd.add(names[i], dp.getStringValue(names[i]));
                        ++i;
                    }
                    this.service_agent.addObject(cmd, gd);
                }
                br.close();
            }
            catch (IOException ioe) {
                System.out.println("Loader.load_service_agent_data: IOException");
                System.out.println(ioe);
                logger.log(Level.SEVERE, "IOException", ioe);
            }
            cmd = (byte)(cmd + 1);
        }
    }

    private void parseHMCFiles(String baseDir) {
        String s;
        int i;
        String line;
        BufferedReader br;
        if (this.managerType != 0) {
            return;
        }
        String[] values = null;
        Vector<String> fixes = new Vector<String>();
        this.hmc = new GenericData();
        try {
            br = new BufferedReader(new FileReader(String.valueOf(baseDir) + lshmcb), 0x100000);
            line = br.readLine();
            if (line != null && (i = line.indexOf(61)) >= 0) {
                s = line.substring(i + 1);
                values = new String[]{s};
                this.hmc.add("bios", values);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            br = new BufferedReader(new FileReader(String.valueOf(baseDir) + lshmcv), 0x100000);
            while ((line = br.readLine()) != null) {
                if (line.startsWith("*TM")) {
                    s = line.substring(4);
                    values = new String[]{s};
                    this.hmc.add("model", values);
                }
                if (!line.startsWith("*SE")) continue;
                s = line.substring(4);
                values = new String[]{s};
                this.hmc.add("serial", values);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            br = new BufferedReader(new FileReader(String.valueOf(baseDir) + lshmcV), 0x100000);
            while ((line = br.readLine()) != null) {
                i = line.indexOf("Version:");
                if (i >= 0) {
                    s = line.substring(i + 9);
                    values = new String[]{s};
                    this.hmc.add("version", values);
                }
                if ((i = line.indexOf("Release:")) >= 0) {
                    s = line.substring(i + 9);
                    values = new String[]{s};
                    this.hmc.add("release", values);
                }
                if ((i = line.indexOf("Service Pack:")) >= 0) {
                    s = line.substring(i + 14);
                    values = new String[]{s};
                    this.hmc.add("sp", values);
                }
                if ((i = line.indexOf("HMC Build level")) >= 0) {
                    s = line.substring(i + 16);
                    values = new String[]{s};
                    this.hmc.add("build_level", values);
                }
                if ((i = line.indexOf("base_version")) >= 0) {
                    s = line.substring(i + 13);
                    values = new String[]{s};
                    this.hmc.add("base_version", values);
                }
                if (!line.startsWith("MH")) continue;
                fixes.add(line);
            }
            if (fixes.size() > 0) {
                values = new String[fixes.size()];
                i = 0;
                while (i < fixes.size()) {
                    values[i] = (String)fixes.elementAt(i);
                    ++i;
                }
                this.hmc.add("fixes", values);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            br = new BufferedReader(new FileReader(String.valueOf(baseDir) + lshmcn), 0x100000);
            while ((line = br.readLine()) != null) {
                DataParser dp = new DataParser(line);
                String[] names = dp.getNames();
                if (names == null || names.length == 0 || names[0] == null) continue;
                i = 0;
                while (i < names.length) {
                    this.hmc.add(names[i], dp.getStringValue(names[i]));
                    ++i;
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void parseData(String hmc, String baseDir) {
        base_directory = baseDir;
        logger.log(Level.INFO, "Loading scanner parameters");
        this.loadScannerParams(baseDir);
        if (this.onlyReadFile) {
            logger.log(Level.INFO, "Loading system data");
            this.loadSysConfigData(hmc, baseDir);
            if (this.managerType == 0) {
                this.parseEntPool(baseDir);
            }
        }
        if (this.managedSystem == null) {
            System.out.println(" no managed systems detected!");
            logger.log(Level.SEVERE, "No managed systems detected!");
            return;
        }
        int i = 0;
        while (i < this.managedSystem.length) {
            this.load_data(this.managedSystem[i], baseDir, procSysData, PROC);
            this.load_data(this.managedSystem[i], baseDir, memSysData, MEM);
            this.load_data(this.managedSystem[i], baseDir, slotSysData, SLOT);
            this.load_data(this.managedSystem[i], baseDir, procLparData, PROC_LPAR);
            this.load_data(this.managedSystem[i], baseDir, procPoolData, PROC_POOL);
            this.load_data(this.managedSystem[i], baseDir, memLparData, MEM_LPAR);
            this.load_data(this.managedSystem[i], baseDir, memPoolData, MEM_POOL);
            this.load_data(this.managedSystem[i], baseDir, lparConfigData, CONFIG_LPAR);
            this.load_data(this.managedSystem[i], baseDir, lparProfiles, PROFILES);
            this.load_data(this.managedSystem[i], baseDir, vswitchData, VSWITCH);
            this.load_data(this.managedSystem[i], baseDir, vethData, VETH);
            this.load_data(this.managedSystem[i], baseDir, vscsiData, VSCSI);
            this.load_data(this.managedSystem[i], baseDir, vfcData, VFC);
            this.load_data(this.managedSystem[i], baseDir, lslicSyspower, SYSPOWERLIC);
            this.load_data(this.managedSystem[i], baseDir, slotchildren, IOSLOTCHILDREN);
            this.load_data(this.managedSystem[i], baseDir, lscod_bill_proc, LSCOD_BILL_PROC);
            this.load_data(this.managedSystem[i], baseDir, lscod_bill_mem, LSCOD_BILL_MEM);
            this.load_data(this.managedSystem[i], baseDir, lscod_cap_proc_onoff, LSCOD_CAP_PROC_ONOFF);
            this.load_data(this.managedSystem[i], baseDir, lscod_cap_mem_onoff, LSCOD_CAP_MEM_ONOFF);
            this.load_data(this.managedSystem[i], baseDir, lscod_hist, LSCOD_HIST);
            this.load_data(this.managedSystem[i], baseDir, sriov_physport_eth, SRIOV_PHP_ETH);
            this.load_data(this.managedSystem[i], baseDir, sriov_physport_ethc, SRIOV_PHP_ETHC);
            this.load_data(this.managedSystem[i], baseDir, sriov_physport_roce, SRIOV_PHP_ROCE);
            this.load_data(this.managedSystem[i], baseDir, sriov_logport_eth, SRIOV_LOGP_ETH);
            this.load_data(this.managedSystem[i], baseDir, sriov_logport_roce, SRIOV_LOGP_ROCE);
            this.load_data(this.managedSystem[i], baseDir, vnic, VNIC);
            if (this.wip) {
                try {
                    logger.log(Level.INFO, "Loading WIP data for MS, but I have no code for that!");
                }
                catch (Exception e) {
                    System.out.println("\n\nError in 'work in progress code'. Please run hmcScanner with '-nowip' to bypass code.");
                    logger.log(Level.WARNING, "Error in WIP code");
                    Loader.error_message(e);
                }
            }
            logger.log(Level.INFO, "Loading NPIV data");
            this.load_npiv_data(this.managedSystem[i], baseDir);
            System.out.print(".");
            ++i;
        }
        if (this.wip) {
            try {
                this.load_service_agent_data(baseDir);
            }
            catch (Exception e) {
                System.out.println("\n\nError in 'work in progress code'. Please run hmcScanner with '-nowip' to bypass code.");
                logger.log(Level.WARNING, "Error in WIP code");
                Loader.error_message(e);
            }
        }
        if (this.managerType == 0) {
            logger.log(Level.INFO, "Loading Ent Pool data");
            this.parseEntPoolSystem(baseDir);
        }
        if (this.managerType == 0) {
            logger.log(Level.INFO, "Loading HMC files");
            this.parseHMCFiles(baseDir);
        }
        if (this.managerType == 0) {
            logger.log(Level.INFO, "Loading SSP data");
            this.parse_SSP_data(baseDir);
        }
        if (this.produceStatistics) {
            // empty if block
        }
        if (this.produceStatistics) {
            GenericData[] gd;
            logger.log(Level.INFO, "Loading CPU usage statistics");
            int num = 0;
            i = 0;
            while (i < this.managedSystem.length) {
                gd = this.managedSystem[i].getObjects(CONFIG_LPAR);
                if (gd != null) {
                    num += gd.length;
                }
                ++i;
            }
            this.lparNames = new String[num];
            this.lparID = new String[num];
            this.msCoreConfig = new DataManager[this.managedSystem.length];
            this.msCoreAvail = new DataManager[this.managedSystem.length];
            this.msCoreUsed = new DataManager[this.managedSystem.length];
            this.msMemConfig = new DataManager[this.managedSystem.length];
            this.msMemAvail = new DataManager[this.managedSystem.length];
            this.lparEnt = new DataManager[this.lparNames.length];
            this.lparVP = new DataManager[this.lparNames.length];
            this.lparPC = new DataManager[this.lparNames.length];
            this.lparStatus = new NewLparStatus[this.lparNames.length];
            num = 0;
            i = 0;
            while (i < this.managedSystem.length) {
                gd = this.managedSystem[i].getObjects(CONFIG_LPAR);
                if (gd != null) {
                    int j = 0;
                    while (j < gd.length) {
                        this.lparNames[num] = gd[j].getVarValues("name")[0];
                        this.lparID[num] = gd[j].getVarValues("lpar_id")[0];
                        ++num;
                        ++j;
                    }
                }
                ++i;
            }
            i = 0;
            while (i < this.managedSystem.length) {
                this.msCoreConfig[i] = new DataManager(this.scannerDate);
                this.msCoreAvail[i] = new DataManager(this.scannerDate);
                this.msCoreUsed[i] = new DataManager(this.scannerDate);
                this.msMemConfig[i] = new DataManager(this.scannerDate);
                this.msMemAvail[i] = new DataManager(this.scannerDate);
                ++i;
            }
            i = 0;
            while (i < this.lparNames.length) {
                this.lparEnt[i] = new DataManager(this.scannerDate);
                this.lparVP[i] = new DataManager(this.scannerDate);
                this.lparPC[i] = new DataManager(this.scannerDate);
                this.lparStatus[i] = new NewLparStatus(this.scannerDate);
                ++i;
            }
            this.load_all_stats(baseDir);
            this.sortManagedData();
            this.sortLparData();
        }
        System.out.println(" DONE");
    }

    private int getLparIdByName(String name) {
        int i = 0;
        while (i < this.lparNames.length && !this.lparNames[i].equals(name)) {
            ++i;
        }
        if (i < this.lparNames.length) {
            return i;
        }
        return -1;
    }

    private int getLparIdById(String name) {
        int i = 0;
        while (i < this.lparID.length && !this.lparID[i].equals(name)) {
            ++i;
        }
        if (i < this.lparID.length) {
            return i;
        }
        return -1;
    }

    private void load_all_stats(String baseDir) {
        String sysName;
        int i = 0;
        while (i < this.managedSystem.length) {
            sysName = this.managedSystem[i].getVarValues("name")[0];
            this.load_single_stats(i, String.valueOf(baseDir) + sysName + "_" + lslparutilHourlyStats, (byte)0);
            ++i;
        }
        i = 0;
        while (i < this.managedSystem.length) {
            sysName = this.managedSystem[i].getVarValues("name")[0];
            this.load_single_stats(i, String.valueOf(baseDir) + sysName + "_" + lslparutilDailyStats, (byte)1);
            ++i;
        }
    }

    private int getProcPoolId(String ms, String poolName) {
        String s = String.valueOf(poolName) + "\n" + ms;
        if (this.procPoolName == null) {
            this.procPoolName = new String[1];
            this.procPoolName[0] = s;
            this.procPoolConfig = new DataManager[1];
            this.procPoolConfig[0] = new DataManager(this.scannerDate);
            this.procPoolUsed = new DataManager[1];
            this.procPoolUsed[0] = new DataManager(this.scannerDate);
            return 0;
        }
        int n = 0;
        while (n < this.procPoolName.length && !s.equals(this.procPoolName[n])) {
            ++n;
        }
        if (n == this.procPoolName.length) {
            String[] oldNames = this.procPoolName;
            DataManager[] oldPoolConfig = this.procPoolConfig;
            DataManager[] oldPoolUsed = this.procPoolUsed;
            this.procPoolName = new String[this.procPoolName.length + 1];
            this.procPoolConfig = new DataManager[this.procPoolConfig.length + 1];
            this.procPoolUsed = new DataManager[this.procPoolUsed.length + 1];
            int i = 0;
            while (i < oldNames.length) {
                this.procPoolName[i] = oldNames[i];
                this.procPoolConfig[i] = oldPoolConfig[i];
                this.procPoolUsed[i] = oldPoolUsed[i];
                ++i;
            }
            this.procPoolName[n] = s;
            this.procPoolConfig[n] = new DataManager(this.scannerDate);
            this.procPoolUsed[n] = new DataManager(this.scannerDate);
            return n;
        }
        return n;
    }

    private void load_single_stats(int num, String fileName, byte type) {
        String[] names = null;
        BigDecimal[] currPoolData = new BigDecimal[3];
        BigDecimal[] prevPoolData = new BigDecimal[3];
        GregorianCalendar prevPoolSample = null;
        BigDecimal[][] currLparData = new BigDecimal[this.lparNames.length][2];
        BigDecimal[][] prevLparData = new BigDecimal[this.lparNames.length][2];
        GregorianCalendar[] prevLparSample = new GregorianCalendar[this.lparNames.length];
        int MAX_POOLS = 256;
        BigDecimal[][] currProcPoolData = new BigDecimal[256][3];
        BigDecimal[][] prevProcPoolData = new BigDecimal[256][3];
        String[] currProcPoolName = new String[256];
        GregorianCalendar[] prevProcPoolSample = new GregorianCalendar[256];
        logger.log(Level.INFO, "Loading stats from " + fileName);
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(fileName))), 0x100000);
            while ((line = br.readLine()) != null) {
                String poolName;
                int id;
                BigDecimal bi3;
                BigDecimal bi2;
                BigDecimal bi1;
                String event_type;
                DataParser dp;
                if (line.startsWith("HSC") || line.startsWith("The managed system") || line.startsWith("No results were found")) {
                    logger.log(Level.INFO, "No results were found in file " + fileName);
                    break;
                }
                if (line.contains("state=Standby") || (names = (dp = new DataParser(line)).getNames()) == null || names.length == 0 || names[0] == null || (event_type = dp.getStringValue("event_type")[0]) == null || !event_type.equals("sample")) continue;
                String resource_type = dp.getStringValue("resource_type")[0];
                String s = dp.getStringValue("time")[0];
                GregorianCalendar sample = new GregorianCalendar(Integer.parseInt(s.substring(6, 10)), Integer.parseInt(s.substring(0, 2)) - 1, Integer.parseInt(s.substring(3, 5)), Integer.parseInt(s.substring(11, 13)), Integer.parseInt(s.substring(14, 16)));
                if (resource_type.equals("sys")) {
                    String[] ss = dp.getStringValue("state");
                    if (ss == null) {
                        ss = dp.getStringValue("primary_state");
                    }
                    if (ss == null) {
                        System.out.println("load_single_stats: sys sample with missing state? Aborting.");
                        logger.log(Level.SEVERE, "sys sample with missing state? Aborting on file " + fileName);
                        System.exit(1);
                    }
                    if (!ss[0].equals("Operating") && !ss[0].equals("Started")) continue;
                    if (type == 0) {
                        this.msMemConfig[num].addHourData(sample, Float.parseFloat(dp.getStringValue("configurable_sys_mem")[0]) / 1024.0f);
                        this.msMemAvail[num].addHourData(sample, Float.parseFloat(dp.getStringValue("curr_avail_sys_mem")[0]) / 1024.0f);
                        continue;
                    }
                    if (type != 1) continue;
                    this.msMemConfig[num].addDayData(sample, Float.parseFloat(dp.getStringValue("configurable_sys_mem")[0]) / 1024.0f);
                    this.msMemAvail[num].addDayData(sample, Float.parseFloat(dp.getStringValue("curr_avail_sys_mem")[0]) / 1024.0f);
                    continue;
                }
                if (resource_type.equals("pool")) {
                    if (type == 0) {
                        this.msCoreConfig[num].addHourData(sample, Float.parseFloat(dp.getStringValue("configurable_pool_proc_units")[0]) + Float.parseFloat(dp.getStringValue("borrowed_pool_proc_units")[0]));
                        this.msCoreAvail[num].addHourData(sample, Float.parseFloat(dp.getStringValue("curr_avail_pool_proc_units")[0]));
                    } else if (type == 1) {
                        this.msCoreConfig[num].addDayData(sample, Float.parseFloat(dp.getStringValue("configurable_pool_proc_units")[0]) + Float.parseFloat(dp.getStringValue("borrowed_pool_proc_units")[0]));
                        this.msCoreAvail[num].addDayData(sample, Float.parseFloat(dp.getStringValue("curr_avail_pool_proc_units")[0]));
                    }
                    currPoolData[1] = new BigDecimal(dp.getStringValue("total_pool_cycles")[0]);
                    currPoolData[0] = new BigDecimal(dp.getStringValue("utilized_pool_cycles")[0]);
                    currPoolData[2] = new BigDecimal(dp.getStringValue("time_cycles")[0]);
                    if (prevPoolSample != null && prevPoolData[0] != null && prevPoolData[2] != null && currPoolData[0] != null && currPoolData[2] != null && prevPoolData[2].compareTo(currPoolData[2]) > 0 && prevPoolData[0].compareTo(currPoolData[0]) > 0) {
                        bi1 = prevPoolData[0].subtract(currPoolData[0]);
                        bi2 = prevPoolData[2].subtract(currPoolData[2]);
                        bi3 = bi1.divide(bi2, new MathContext(5));
                        if (type == 0) {
                            this.msCoreUsed[num].addHourData(prevPoolSample, bi3.floatValue());
                        } else if (type == 1) {
                            this.msCoreUsed[num].addDayData(prevPoolSample, bi3.floatValue());
                        }
                    }
                    prevPoolSample = sample;
                    prevPoolData[0] = currPoolData[0];
                    prevPoolData[2] = currPoolData[2];
                    continue;
                }
                if (resource_type.equals("procpool")) {
                    int poolID = Integer.parseInt(dp.getStringValue("shared_proc_pool_id")[0]);
                    if (poolID == 0) continue;
                    if (currProcPoolName[poolID] == null) {
                        currProcPoolName[poolID] = dp.getStringValue("shared_proc_pool_name")[0];
                    }
                    currProcPoolData[poolID][1] = new BigDecimal(dp.getStringValue("total_pool_cycles")[0]);
                    currProcPoolData[poolID][0] = new BigDecimal(dp.getStringValue("utilized_pool_cycles")[0]);
                    currProcPoolData[poolID][2] = new BigDecimal(dp.getStringValue("time_cycles")[0]);
                    if (prevProcPoolData[poolID][0] != null && prevProcPoolData[poolID][2] != null && currProcPoolData[poolID][0] != null && currProcPoolData[poolID][2] != null && prevProcPoolData[poolID][2].compareTo(currProcPoolData[poolID][2]) > 0 && prevProcPoolData[poolID][0].compareTo(currProcPoolData[poolID][0]) > 0) {
                        id = this.getProcPoolId(this.managedSystem[num].getVarValues("name")[0], currProcPoolName[poolID]);
                        bi1 = prevProcPoolData[poolID][1].subtract(currProcPoolData[poolID][1]);
                        BigDecimal bi4 = prevProcPoolData[poolID][2].subtract(currProcPoolData[poolID][2]);
                        bi2 = bi1.divide(bi4, new MathContext(5));
                        if (type == 0) {
                            this.procPoolConfig[id].addHourData(prevProcPoolSample[poolID], bi2.floatValue());
                        } else if (type == 1) {
                            this.procPoolConfig[id].addDayData(prevProcPoolSample[poolID], bi2.floatValue());
                        }
                        bi3 = prevProcPoolData[poolID][0].subtract(currProcPoolData[poolID][0]);
                        bi4 = bi3.divide(bi4, new MathContext(5));
                        if (type == 0) {
                            this.procPoolUsed[id].addHourData(prevProcPoolSample[poolID], bi4.floatValue());
                        } else if (type == 1) {
                            this.procPoolUsed[id].addDayData(prevProcPoolSample[poolID], bi4.floatValue());
                        }
                    }
                    prevProcPoolSample[poolID] = sample;
                    prevProcPoolData[poolID][0] = currProcPoolData[poolID][0];
                    prevProcPoolData[poolID][2] = currProcPoolData[poolID][2];
                    prevProcPoolData[poolID][1] = currProcPoolData[poolID][1];
                    continue;
                }
                if (!resource_type.equals("lpar")) continue;
                String mode = dp.getStringValue("curr_proc_mode")[0];
                id = this.managerType == 3 ? this.getLparIdById(dp.getStringValue("lpar_id")[0]) : this.getLparIdByName(dp.getStringValue("lpar_name")[0]);
                if (id < 0) {
                    if (this.verboseMode) {
                        System.out.println("File: " + fileName + " Skipping unknown LPAR: " + dp.getStringValue("lpar_name")[0]);
                    }
                    logger.log(Level.INFO, "File: " + fileName + " Skipping unknown LPAR: " + dp.getStringValue("lpar_name")[0]);
                    continue;
                }
                boolean dedicated = false;
                if (!mode.equals("shared")) {
                    dedicated = true;
                }
                if (type == 0) {
                    if (!dedicated) {
                        this.lparEnt[id].addHourData(sample, Float.parseFloat(dp.getStringValue("curr_proc_units")[0]));
                    } else {
                        this.lparEnt[id].addHourData(sample, Float.parseFloat(dp.getStringValue("curr_procs")[0]));
                    }
                    this.lparVP[id].addHourData(sample, Float.parseFloat(dp.getStringValue("curr_procs")[0]));
                } else if (type == 1) {
                    if (!dedicated) {
                        this.lparEnt[id].addDayData(sample, Float.parseFloat(dp.getStringValue("curr_proc_units")[0]));
                    } else {
                        this.lparEnt[id].addDayData(sample, Float.parseFloat(dp.getStringValue("curr_procs")[0]));
                    }
                    this.lparVP[id].addDayData(sample, Float.parseFloat(dp.getStringValue("curr_procs")[0]));
                }
                boolean cap = !dedicated ? !(s = dp.getStringValue("curr_sharing_mode")[0]).equals("uncap") : true;
                if (!dedicated) {
                    poolName = dp.getStringValue("curr_shared_proc_pool_name")[0];
                    if (poolName == null) {
                        poolName = "DefaultPool";
                    }
                } else {
                    poolName = "DefaultPool";
                }
                if (type == 0) {
                    this.lparStatus[id].addHourData(sample, this.managedSystem[num].getVarValues("name")[0], poolName, cap);
                } else if (type == 1) {
                    this.lparStatus[id].addDayData(sample, this.managedSystem[num].getVarValues("name")[0], poolName, cap);
                }
                bi1 = new BigDecimal(dp.getStringValue("capped_cycles")[0]);
                bi2 = new BigDecimal(dp.getStringValue("uncapped_cycles")[0]);
                currLparData[id][1] = bi1.add(bi2);
                currLparData[id][0] = bi1 = new BigDecimal(dp.getStringValue("time_cycles")[0]);
                if (prevLparSample[id] != null && prevLparData[id][1] != null && prevLparData[id][0] != null && currLparData[id][1] != null && currLparData[id][0] != null && prevLparData[id][0].compareTo(currLparData[id][0]) > 0 && prevLparData[id][1].compareTo(currLparData[id][1]) >= 0) {
                    bi1 = prevLparData[id][1].subtract(currLparData[id][1]);
                    bi2 = prevLparData[id][0].subtract(currLparData[id][0]);
                    if (bi2.compareTo(zero) != 0) {
                        bi3 = bi1.divide(bi2, new MathContext(5));
                        if (type == 0) {
                            this.lparPC[id].addHourData(prevLparSample[id], bi3.floatValue());
                        } else if (type == 1) {
                            this.lparPC[id].addDayData(prevLparSample[id], bi3.floatValue());
                        }
                    }
                }
                prevLparData[id][1] = currLparData[id][1];
                prevLparData[id][0] = currLparData[id][0];
                prevLparSample[id] = sample;
            }
        }
        catch (IOException ioe) {
            System.out.println("Loader.load_single_stats: IOException");
            System.out.println(ioe);
            logger.log(Level.SEVERE, "IOException", ioe);
        }
        System.out.print(".");
    }

    private void createExcel(String excelPath, String htmlDir, String csvDir) {
        if (this.managedSystem == null) {
            System.out.println("No managed systems are present: aborting report generation.");
            logger.log(Level.INFO, "No managed systems are present: aborting report generation.");
            return;
        }
        System.out.print("Starting Excel file creation. ");
        try {
            this.workbook = Workbook.createWorkbook((File)new File(excelPath));
        }
        catch (IOException ioe) {
            System.out.println("Error in creating Excel file " + excelPath);
            logger.log(Level.SEVERE, "Error in creating Excel file " + excelPath);
            return;
        }
        logger.log(Level.INFO, "Starting Excel file creation: " + excelPath);
        try {
            int num = 0;
            WritableSheet sheet = this.workbook.createSheet("Header", num++);
            this.createHeaderExcel(sheet);
            if (htmlDir != null) {
                this.createHeaderHTML(String.valueOf(htmlDir) + File.separatorChar + header_html);
            }
            if (csvDir != null) {
                this.createHeaderCSV(String.valueOf(csvDir) + File.separatorChar + header_csv);
            }
            if (this.managerType == 0) {
                sheet = this.workbook.createSheet("HMC", num++);
                this.createHMCExcel(sheet);
                if (htmlDir != null) {
                    this.createHMCHTML(String.valueOf(htmlDir) + File.separatorChar + hmc_html);
                }
                if (csvDir != null) {
                    this.createHMCCSV(String.valueOf(csvDir) + File.separatorChar + hmc_csv);
                }
            }
            if (this.managerType == 0 && this.wip) {
                try {
                    sheet = this.workbook.createSheet("Service Agent", num++);
                    this.createSAExcel(sheet);
                    if (htmlDir != null) {
                        this.createSAHTML(String.valueOf(htmlDir) + File.separatorChar + sa_html);
                    }
                    if (csvDir != null) {
                        this.createSACSV(String.valueOf(csvDir) + File.separatorChar + sa_csv);
                    }
                }
                catch (Exception e) {
                    System.out.println("\n\nError in 'work in progress code'. Please run hmcScanner with '-nowip' to bypass code.");
                    logger.log(Level.WARNING, "Error in WIP code");
                    Loader.error_message(e);
                }
            }
            sheet = this.workbook.createSheet("System_Summary", num++);
            if (this.rowMode) {
                this.createSystemsSheetExcel(sheet);
                if (htmlDir != null) {
                    this.createSystemsSheetHTML(String.valueOf(htmlDir) + File.separatorChar + systems_html);
                }
                if (csvDir != null) {
                    this.createSystemsSheetCSV(String.valueOf(csvDir) + File.separatorChar + systems_csv);
                }
            } else {
                this.createSystemsSheet(sheet);
            }
            sheet = this.workbook.createSheet("Ent_Sys_Pools", num++);
            this.createSysPoolRowBasedExcel(sheet);
            if (htmlDir != null) {
                this.createSysPoolRowBasedHTML(String.valueOf(htmlDir) + File.separatorChar + syspool_html);
            }
            if (csvDir != null) {
                this.createSysPoolRowBasedCSV(String.valueOf(csvDir) + File.separatorChar + syspool_csv);
            }
            sheet = this.workbook.createSheet("OnOff CoD", num++);
            this.createOnOffSheetExcel(sheet);
            if (htmlDir != null) {
                this.createOnOffSheetHTML(String.valueOf(htmlDir) + File.separatorChar + onoff_html);
            }
            if (csvDir != null) {
                this.createOnOffSheetCSV(String.valueOf(csvDir) + File.separatorChar + onoff_csv);
            }
            sheet = this.workbook.createSheet("CoD Events", num++);
            this.createCoDLogSheetExcel(sheet);
            if (htmlDir != null) {
                this.createCoDLogSheetHTML(String.valueOf(htmlDir) + File.separatorChar + codlog_html);
            }
            if (csvDir != null) {
                this.createCoDLogSheetCSV(String.valueOf(csvDir) + File.separatorChar + codlog_csv);
            }
            sheet = this.workbook.createSheet("LPAR_Summary", num++);
            if (this.rowMode) {
                this.createLparSheetRowBasedExcel(sheet);
                if (htmlDir != null) {
                    this.createLparSheetRowBasedHTML(String.valueOf(htmlDir) + File.separatorChar + lpar_html);
                }
                if (csvDir != null) {
                    this.createLparSheetRowBasedCSV(String.valueOf(csvDir) + File.separatorChar + lpar_csv);
                }
            } else {
                this.createLparSheet(sheet);
            }
            sheet = this.workbook.createSheet("LPAR_Profiles", num++);
            this.createProfileSheetExcel(sheet);
            if (htmlDir != null) {
                this.createProfileSheetHTML(String.valueOf(htmlDir) + File.separatorChar + profile_html);
            }
            if (csvDir != null) {
                this.createProfileSheetCSV(String.valueOf(csvDir) + File.separatorChar + profile_csv);
            }
            sheet = this.workbook.createSheet("LPAR_CPU", num++);
            if (this.rowMode) {
                this.createCPUSheetRowBasedExcel(sheet);
                if (htmlDir != null) {
                    this.createCPUSheetRowBasedHTML(String.valueOf(htmlDir) + File.separatorChar + cpu_html);
                }
                if (csvDir != null) {
                    this.createCPUSheetRowBasedCSV(String.valueOf(csvDir) + File.separatorChar + cpu_csv);
                }
            } else {
                this.createCPUSheet(sheet);
            }
            sheet = this.workbook.createSheet("LPAR_MEM", num++);
            if (this.rowMode) {
                this.createMemSheetRowBasedExcel(sheet);
                if (htmlDir != null) {
                    this.createMemSheetRowBasedHTML(String.valueOf(htmlDir) + File.separatorChar + mem_html);
                }
                if (csvDir != null) {
                    this.createMemSheetRowBasedCSV(String.valueOf(csvDir) + File.separatorChar + mem_csv);
                }
            } else {
                this.createMemSheet(sheet);
            }
            sheet = this.workbook.createSheet("Physical_Slots", num++);
            if (this.rowMode) {
                this.createSystemSlotSheetRowBasedExcel(sheet);
                if (htmlDir != null) {
                    this.createSystemSlotSheetRowBasedHTML(String.valueOf(htmlDir) + File.separatorChar + slots_html);
                }
                if (csvDir != null) {
                    this.createSystemSlotSheetRowBasedCSV(String.valueOf(csvDir) + File.separatorChar + slots_csv);
                }
            } else {
                this.createSystemSlotSheet(sheet);
            }
            sheet = this.workbook.createSheet("IO_slot_children", num++);
            this.createIOChildrenSheetExcel(sheet);
            if (htmlDir != null) {
                this.createIOChildrenSheetHTML(String.valueOf(htmlDir) + File.separatorChar + iochildren_html);
            }
            if (csvDir != null) {
                this.createIOChildrenSheetCSV(String.valueOf(csvDir) + File.separatorChar + iochildren_csv);
            }
            sheet = this.workbook.createSheet("Virtual_Ethernet", num++);
            this.createVEthSheetExcel(sheet);
            if (htmlDir != null) {
                this.createVEthSheetHTML(String.valueOf(htmlDir) + File.separatorChar + veth_html);
            }
            if (csvDir != null) {
                this.createVEthSheetCSV(String.valueOf(csvDir) + File.separatorChar + veth_csv);
            }
            sheet = this.workbook.createSheet("Virtual_SCSI", num++);
            if (this.rowMode) {
                this.createVSCSISheetRowBasedExcel(sheet);
                if (htmlDir != null) {
                    this.createVSCSISheetRowBasedHTML(String.valueOf(htmlDir) + File.separatorChar + vscsi_html);
                }
                if (csvDir != null) {
                    this.createVSCSISheetRowBasedCSV(String.valueOf(csvDir) + File.separatorChar + vscsi_csv);
                }
            } else {
                this.createVSCSISheet(sheet);
            }
            sheet = this.workbook.createSheet("VSCSI_Map", num++);
            if (this.rowMode) {
                this.createVSCSIMapSheetRowBasedExcel(sheet);
                if (htmlDir != null) {
                    this.createVSCSIMapSheetRowBasedHTML(String.valueOf(htmlDir) + File.separatorChar + vscsimap_html);
                }
                if (csvDir != null) {
                    this.createVSCSIMapSheetRowBasedCSV(String.valueOf(csvDir) + File.separatorChar + vscsimap_csv);
                }
            } else {
                this.createVSCSIMapSheet(sheet);
            }
            sheet = this.workbook.createSheet("Virtual_Fibre", num++);
            if (this.rowMode) {
                this.createVFCSheetRowBasedExcel(sheet);
                if (htmlDir != null) {
                    this.createVFCSheetRowBasedHTML(String.valueOf(htmlDir) + File.separatorChar + vfc_html);
                }
                if (csvDir != null) {
                    this.createVFCSheetRowBasedCSV(String.valueOf(htmlDir) + File.separatorChar + vfc_csv);
                }
            } else {
                this.createVFCSheet(sheet);
            }
            sheet = this.workbook.createSheet("VIOS disks", num++);
            this.createViosDiskSheetExcel(sheet);
            if (htmlDir != null) {
                this.createViosDiskSheetHTML(String.valueOf(htmlDir) + File.separatorChar + viosdisks_html);
            }
            if (csvDir != null) {
                this.createViosDiskSheetCSV(String.valueOf(csvDir) + File.separatorChar + viosdisks_csv);
            }
            if (this.sspcluster != null) {
                sheet = this.workbook.createSheet("SSP", num++);
                this.createSspSheetExcel(sheet);
                if (htmlDir != null) {
                    this.createSspSheetHTML(String.valueOf(htmlDir) + File.separatorChar + ssp_html);
                }
                if (csvDir != null) {
                    this.createSspSheetCSV(String.valueOf(csvDir) + File.separatorChar + ssp_csv);
                }
            }
            sheet = this.workbook.createSheet("SEA", num++);
            this.createSEASheetExcel(sheet);
            if (htmlDir != null) {
                this.createSEASheetHTML(String.valueOf(htmlDir) + File.separatorChar + sea_html);
            }
            if (csvDir != null) {
                this.createSEASheetCSV(String.valueOf(csvDir) + File.separatorChar + sea_csv);
            }
            sheet = this.workbook.createSheet("FC", num++);
            try {
                this.createFCSheetExcel(sheet);
                if (htmlDir != null) {
                    this.createFCSheetHTML(String.valueOf(htmlDir) + File.separatorChar + pfc_html);
                }
                if (csvDir != null) {
                    this.createFCSheetCSV(String.valueOf(csvDir) + File.separatorChar + pfc_csv);
                }
            }
            catch (Exception e) {
                System.out.println("Exception in FC sheet.");
            }
            sheet = this.workbook.createSheet("SRIOV Phys Ports", num++);
            try {
                this.createSRIOVPhysPortExcel(sheet);
                if (htmlDir != null) {
                    this.createSRIOVPhysPortHTML(String.valueOf(htmlDir) + File.separatorChar + sriov_pysp_html);
                }
                if (csvDir != null) {
                    this.createSRIOVPhysPortCSV(String.valueOf(csvDir) + File.separatorChar + sriov_pysp_csv);
                }
            }
            catch (Exception e) {
                System.out.println("Exception in SRIOV Physical Port sheet.");
            }
            sheet = this.workbook.createSheet("SRIOV Logical Ports", num++);
            try {
                this.createSRIOVLogicalPortExcel(sheet);
                if (htmlDir != null) {
                    this.createSRIOVLogicalPortHTML(String.valueOf(htmlDir) + File.separatorChar + sriov_logp_html);
                }
                if (csvDir != null) {
                    this.createSRIOVLogicalPortCSV(String.valueOf(csvDir) + File.separatorChar + sriov_logp_csv);
                }
            }
            catch (Exception e) {
                System.out.println("Exception in SRIOV Logical Port sheet.");
            }
            sheet = this.workbook.createSheet("vNIC", num++);
            try {
                this.createVNICExcel(sheet);
                if (htmlDir != null) {
                    this.createVNICHTML(String.valueOf(htmlDir) + File.separatorChar + vnic_html);
                }
                if (csvDir != null) {
                    this.createVNICCSV(String.valueOf(csvDir) + File.separatorChar + vnic_csv);
                }
            }
            catch (Exception e) {
                System.out.println("Exception in vNIC sheet.");
            }
            sheet = this.workbook.createSheet("SW_cores", num++);
            this.createSWSheet(sheet);
            if (this.produceStatistics) {
                int to;
                sheet = this.workbook.createSheet("CPU_Pool_Usage", num++);
                this.createSysPoolUsageSheetExcel(sheet);
                if (htmlDir != null) {
                    this.createSysPoolUsageSheetHTML(String.valueOf(htmlDir) + File.separatorChar + poolcpu_html);
                }
                if (csvDir != null) {
                    this.createSysPoolUsageSheetCSV(String.valueOf(csvDir) + File.separatorChar + poolcpu_csv);
                }
                sheet = this.workbook.createSheet("Sys_RAM_Usage", num++);
                this.createSysRAMUsageSheetExcel(sheet);
                if (htmlDir != null) {
                    this.createSysRAMUsageSheetHTML(String.valueOf(htmlDir) + File.separatorChar + sysram_html);
                }
                if (csvDir != null) {
                    this.createSysRAMUsageSheetCSV(String.valueOf(csvDir) + File.separatorChar + sysram_csv);
                }
                sheet = this.workbook.createSheet("LPAR_CPU_Usage", num++);
                this.createLparCoreUsageSheetExcel(sheet);
                if (htmlDir != null) {
                    this.createLparCoreUsageSheetHTML(String.valueOf(htmlDir) + File.separatorChar + lparcpu_html);
                }
                if (csvDir != null) {
                    this.createLparCoreUsageSheetCSV(String.valueOf(csvDir) + File.separatorChar + lparcpu_csv);
                }
                sheet = this.workbook.createSheet("CPU_Pool_Daily_Usage", num++);
                this.createSysPoolDailyUsageSheetExcel(sheet);
                if (htmlDir != null) {
                    this.createSysPoolDailyUsageSheetHTML(String.valueOf(htmlDir) + File.separatorChar + pooldaily_html);
                }
                if (csvDir != null) {
                    this.createSysPoolDailyUsageSheetCSV(String.valueOf(csvDir) + File.separatorChar + pooldaily_csv);
                }
                int MAXCOL = 25;
                int from = 0;
                int count = 1;
                while (from < this.lparNames.length) {
                    to = from + 25 - 1;
                    if (to >= this.lparNames.length) {
                        to = this.lparNames.length - 1;
                    }
                    sheet = this.workbook.createSheet("LPAR_Daily_Usage_N" + count, num++);
                    this.createLparDailyUsageSheetExcel(sheet, from, to);
                    if (htmlDir != null) {
                        this.createLparDailyUsageSheetHTML(String.valueOf(htmlDir) + File.separatorChar + count + "_" + lpardaily_html, from, to, count);
                    }
                    if (csvDir != null) {
                        this.createLparDailyUsageSheetCSV(String.valueOf(csvDir) + File.separatorChar + count + "_" + lpardaily_csv, from, to, count);
                    }
                    ++count;
                    from = to + 1;
                }
                sheet = this.workbook.createSheet("CPU_Pool_Hourly_Usage", num++);
                this.createSysPoolHourlyUsageSheetExcel(sheet);
                if (htmlDir != null) {
                    this.createSysPoolHourlyUsageSheetHTML(String.valueOf(htmlDir) + File.separatorChar + poolhourly_html);
                }
                if (csvDir != null) {
                    this.createSysPoolHourlyUsageSheetCSV(String.valueOf(csvDir) + File.separatorChar + poolhourly_csv);
                }
                from = 0;
                count = 1;
                while (from < this.lparNames.length) {
                    to = from + 25 - 1;
                    if (to >= this.lparNames.length) {
                        to = this.lparNames.length - 1;
                    }
                    sheet = this.workbook.createSheet("LPAR_Hourly_Usage_N" + count, num++);
                    this.createLparHourlyUsageSheetExcel(sheet, from, to);
                    if (htmlDir != null) {
                        this.createLparHourlyUsageSheetHTML(String.valueOf(htmlDir) + File.separatorChar + count + "_" + lparhourly_html, from, to, count);
                    }
                    if (csvDir != null) {
                        this.createLparHourlyUsageSheetCSV(String.valueOf(csvDir) + File.separatorChar + count + "_" + lparhourly_csv, from, to, count);
                    }
                    ++count;
                    from = to + 1;
                }
                if (htmlDir != null) {
                    this.createSystemHtmlStructure(htmlDir);
                    this.addButton("System Graphs", sysperfindex_html);
                    this.createPoolHtmlStructure(htmlDir);
                    this.addButton("SubPool Graphs", poolperfindex_html);
                    this.createLPARHtmlStructure(htmlDir);
                    this.addButton("LPAR Graphs", lparperfindex_html);
                }
            }
        }
        catch (RowsExceededException rowsExceededException) {
        }
        catch (WriteException writeException) {
            // empty catch block
        }
        try {
            this.workbook.write();
            this.workbook.close();
        }
        catch (IOException iOException) {
        }
        catch (WriteException writeException) {
            // empty catch block
        }
        System.out.println("Done: " + excelPath);
        if (htmlDir != null) {
            System.out.println("HTML report generated. See index.html inside " + htmlDir);
        }
        if (csvDir != null) {
            System.out.println("CSV files generated. See inside " + csvDir);
        }
        if (htmlDir != null) {
            this.createIndexHtml(htmlDir);
            this.createMenuHtml(htmlDir);
        }
    }

    private WritableCellFormat formatLabel(int map) throws WriteException {
        WritableCellFormat wcf = (map & BOLD) != 0 ? new WritableCellFormat(new WritableFont(WritableFont.ARIAL, 10, WritableFont.BOLD, true)) : new WritableCellFormat(new WritableFont(WritableFont.ARIAL, 10));
        return this.setParam(wcf, map);
    }

    private WritableCellFormat formatInt(int map) throws WriteException {
        WritableCellFormat wcf = new WritableCellFormat(NumberFormats.INTEGER);
        return this.setParam(wcf, map);
    }

    private WritableCellFormat formatFloat(int map) throws WriteException {
        WritableCellFormat wcf = (map & BOLD) != 0 ? new WritableCellFormat(new WritableFont(WritableFont.ARIAL, 10, WritableFont.BOLD, true), NumberFormats.FORMAT3) : new WritableCellFormat(NumberFormats.FORMAT3);
        return this.setParam(wcf, map);
    }

    private WritableCellFormat setParam(WritableCellFormat wcf, int map) throws WriteException {
        if ((map & CENTRE) != 0) {
            wcf.setAlignment(Alignment.CENTRE);
        }
        if ((map & RIGHT) != 0) {
            wcf.setAlignment(Alignment.RIGHT);
        }
        if ((map & LEFT) != 0) {
            wcf.setAlignment(Alignment.LEFT);
        }
        if ((map & VCENTRE) != 0) {
            wcf.setVerticalAlignment(VerticalAlignment.CENTRE);
        }
        if ((map & B_TOP_MED) != 0) {
            wcf.setBorder(Border.TOP, BorderLineStyle.MEDIUM);
        }
        if ((map & B_BOTTOM_MED) != 0) {
            wcf.setBorder(Border.BOTTOM, BorderLineStyle.MEDIUM);
        }
        if ((map & B_LEFT_MED) != 0) {
            wcf.setBorder(Border.LEFT, BorderLineStyle.MEDIUM);
        }
        if ((map & B_RIGHT_MED) != 0) {
            wcf.setBorder(Border.RIGHT, BorderLineStyle.MEDIUM);
        }
        if ((map & B_ALL_MED) != 0) {
            wcf.setBorder(Border.RIGHT, BorderLineStyle.MEDIUM);
            wcf.setBorder(Border.LEFT, BorderLineStyle.MEDIUM);
            wcf.setBorder(Border.TOP, BorderLineStyle.MEDIUM);
            wcf.setBorder(Border.BOTTOM, BorderLineStyle.MEDIUM);
        }
        if ((map & B_TOP_LOW) != 0) {
            wcf.setBorder(Border.TOP, BorderLineStyle.THIN);
        }
        if ((map & B_BOTTOM_LOW) != 0) {
            wcf.setBorder(Border.BOTTOM, BorderLineStyle.THIN);
        }
        if ((map & B_LEFT_LOW) != 0) {
            wcf.setBorder(Border.LEFT, BorderLineStyle.THIN);
        }
        if ((map & B_RIGHT_LOW) != 0) {
            wcf.setBorder(Border.RIGHT, BorderLineStyle.THIN);
        }
        if ((map & B_ALL_LOW) != 0) {
            wcf.setBorder(Border.RIGHT, BorderLineStyle.THIN);
            wcf.setBorder(Border.LEFT, BorderLineStyle.THIN);
            wcf.setBorder(Border.TOP, BorderLineStyle.THIN);
            wcf.setBorder(Border.BOTTOM, BorderLineStyle.THIN);
        }
        if ((map & GRAY_25) != 0) {
            wcf.setBackground(Colour.GRAY_25);
        }
        if ((map & GREEN) != 0) {
            wcf.setBackground(Colour.LIGHT_GREEN);
        }
        if ((map & BLACK) != 0) {
            wcf.setBackground(Colour.BLACK);
        }
        if ((map & YELLOW) != 0) {
            wcf.setBackground(Colour.YELLOW);
        }
        if ((map & RED) != 0) {
            wcf.setBackground(Colour.RED);
        }
        if ((map & WRAP) != 0) {
            wcf.setWrap(true);
        }
        if ((map & DIAG45) != 0) {
            wcf.setOrientation(Orientation.PLUS_45);
        }
        return wcf;
    }

    private void createLparSheet(WritableSheet sheet) throws RowsExceededException, WriteException {
        int lparNameSize = 0;
        int osNameSize = 0;
        int row = 0;
        int i = 0;
        while (i < this.managedSystem.length) {
            String[] s = this.managedSystem[i].getVarValues("name");
            sheet.mergeCells(0, row, 8, row + 1);
            this.addLabel(sheet, 0, row, s[0], this.formatLabel(BOLD | CENTRE | VCENTRE | GREEN));
            ++row;
            this.addLabel(sheet, 0, ++row, "Name", this.formatLabel(BOLD | B_ALL_MED));
            this.addLabel(sheet, 1, row, "ID", this.formatLabel(BOLD | B_ALL_MED));
            this.addLabel(sheet, 2, row, "Status", this.formatLabel(BOLD | B_ALL_MED));
            this.addLabel(sheet, 3, row, "Environment", this.formatLabel(BOLD | B_ALL_MED));
            this.addLabel(sheet, 4, row, "OS Version", this.formatLabel(BOLD | CENTRE | B_ALL_MED));
            this.addLabel(sheet, 5, row, "Pool data available", this.formatLabel(BOLD | B_ALL_MED));
            this.addLabel(sheet, 6, row, "Proc mode", this.formatLabel(BOLD | B_ALL_MED));
            this.addLabel(sheet, 7, row, "RMC IP", this.formatLabel(BOLD | B_ALL_MED));
            this.addLabel(sheet, 8, row, "RMC State", this.formatLabel(BOLD | B_ALL_MED));
            ++row;
            GenericData[] lpar = this.managedSystem[i].getObjects(CONFIG_LPAR);
            if (lpar == null) {
                row += 2;
            } else {
                int j = 0;
                while (j < lpar.length) {
                    s = lpar[j].getVarValues("name");
                    this.addLabel(sheet, 0, row, s, 0, this.formatLabel(B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW));
                    if (s[0].length() > lparNameSize) {
                        lparNameSize = s[0].length();
                    }
                    this.addNumber(sheet, 1, row, lpar[j].getVarValues("lpar_id"), 0, this.formatInt(B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW));
                    this.addLabel(sheet, 2, row, lpar[j].getVarValues("state"), 0, this.formatLabel(B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW));
                    this.addLabel(sheet, 3, row, lpar[j].getVarValues("lpar_env"), 0, this.formatLabel(B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW));
                    s = lpar[j].getVarValues("os_version");
                    this.addLabel(sheet, 4, row, s, 0, this.formatLabel(B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW));
                    if (s[0].length() > osNameSize) {
                        osNameSize = s[0].length();
                    }
                    if ((s = lpar[j].getVarValues("allow_perf_collection")) == null) {
                        s = lpar[j].getVarValues("shared_proc_pool_util_auth");
                    }
                    Label label = s == null ? new Label(5, row, "N/A", (CellFormat)this.formatLabel(B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) : (s[0].equals("1") ? new Label(5, row, "true", (CellFormat)this.formatLabel(B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) : new Label(5, row, "false", (CellFormat)this.formatLabel(B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)));
                    sheet.addCell((WritableCell)label);
                    this.addLabel(sheet, 6, row, lpar[j].getVarValues("curr_lpar_proc_compat_mode"), 0, this.formatLabel(B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW));
                    this.addLabel(sheet, 7, row, lpar[j].getVarValues("rmc_ipaddr"), 0, this.formatLabel(B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW));
                    this.addLabel(sheet, 8, row, lpar[j].getVarValues("rmc_state"), 0, this.formatLabel(B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW));
                    ++row;
                    ++j;
                }
                row += 2;
            }
            ++i;
        }
        if (lparNameSize == 0) {
            lparNameSize = 10;
        }
        sheet.setColumnView(0, lparNameSize + 2);
        sheet.setColumnView(1, 5);
        sheet.setColumnView(2, 12);
        sheet.setColumnView(3, 13);
        sheet.setColumnView(4, osNameSize);
        sheet.setColumnView(6, 18);
        sheet.setColumnView(7, 15);
        sheet.setColumnView(8, 15);
    }

    private void createLparSheetRowBasedExcel(WritableSheet sheet) {
        DataSheet ds = this.createLparSheetRowBased();
        if (ds != null) {
            ds.createExcelSheet(sheet);
        }
    }

    private void createLparSheetRowBasedHTML(String fileName) {
        DataSheet ds = this.createLparSheetRowBased();
        if (ds != null) {
            ds.createHTMLSheet(fileName);
            this.addButton("LPAR Summary", new File(fileName).getName());
        }
    }

    private void createLparSheetRowBasedCSV(String fileName) {
        DataSheet ds = this.createLparSheetRowBased();
        if (ds != null) {
            ds.setSeparator(this.csvSeparator);
            ds.createCSVSheet(fileName);
        }
    }

    private DataSheet createLparSheetRowBased() {
        DataSheet ds = new DataSheet();
        int[] size = new int[20];
        int i = 0;
        while (i < size.length) {
            size[i] = 0;
            ++i;
        }
        int row = 0;
        int col = 0;
        int n = ds.addLabel(col, row, "Name", BOLD | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "ID", BOLD | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Status", BOLD | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Environment", BOLD | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "OS Version", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Pool data available", BOLD | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Proc mode", BOLD | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "RMC IP", BOLD | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "RMC State", BOLD | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Default profile", BOLD | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Current profile", BOLD | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Migration disabled", BOLD | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Auto start", BOLD | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Suspend capable", BOLD | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Remote restart capable", BOLD | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Simplified remote restart capable", BOLD | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Remote restart status", BOLD | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Sync current profile", BOLD | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Managed System Name", BOLD | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Managed System Serial", BOLD | B_ALL_MED | GREEN | DIAG45);
        ++col;
        ++row;
        i = 0;
        while (i < this.managedSystem.length) {
            String[] sysName = this.managedSystem[i].getVarValues("name");
            String[] serial = this.managedSystem[i].getVarValues("serial_num");
            GenericData[] lpar = this.managedSystem[i].getObjects(CONFIG_LPAR);
            if (lpar != null) {
                int j = 0;
                while (j < lpar.length) {
                    String str;
                    col = 0;
                    String[] s = lpar[j].getVarValues("name");
                    n = ds.addLabel(col, row, s, 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                    if (n > size[col]) {
                        size[col] = n;
                    }
                    ds.addInteger(++col, row, lpar[j].getVarValues("lpar_id"), 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                    n = 4;
                    if (n > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, lpar[j].getVarValues("state"), 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, lpar[j].getVarValues("lpar_env"), 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, s = lpar[j].getVarValues("os_version"), 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    ++col;
                    s = lpar[j].getVarValues("allow_perf_collection");
                    if (s == null) {
                        s = lpar[j].getVarValues("shared_proc_pool_util_auth");
                    }
                    if ((n = ds.addLabel(col, row, str = s == null ? "N/A" : (s[0].equals("1") ? "true" : "false"), B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, lpar[j].getVarValues("curr_lpar_proc_compat_mode"), 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, lpar[j].getVarValues("rmc_ipaddr"), 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, lpar[j].getVarValues("rmc_state"), 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, lpar[j].getVarValues("default_profile"), 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, lpar[j].getVarValues("curr_profile"), 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, str = (s = lpar[j].getVarValues("migration_disabled")) == null || s[0].equals("0") ? "false" : "true", B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, str = (s = lpar[j].getVarValues("auto_start")) == null || s[0].equals("0") ? "false" : "true", B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, str = (s = lpar[j].getVarValues("suspend_capable")) == null || s[0].equals("0") ? "false" : "true", B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, str = (s = lpar[j].getVarValues("remote_restart_capable")) == null || s[0].equals("0") ? "false" : "true", B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, str = (s = lpar[j].getVarValues("simplified_remote_restart_capable")) == null || s[0].equals("0") ? "false" : "true", B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, str = (s = lpar[j].getVarValues("remote_restart_status")) == null ? "N/A" : s[0], B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, str = (s = lpar[j].getVarValues("sync_curr_profile")) == null || s[0].equals("0") ? "false" : "true", B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, sysName, 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, serial, 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    ++col;
                    ++row;
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < size.length) {
            ds.setColSize(i, size[i] + 2);
            ++i;
        }
        return ds;
    }

    private void createMemSheet(WritableSheet sheet) throws RowsExceededException, WriteException {
        int lparNameSize = 0;
        int viosNameSize = 0;
        int row = 0;
        int i = 0;
        while (i < this.managedSystem.length) {
            String[] s = this.managedSystem[i].getVarValues("name");
            sheet.mergeCells(0, row, 12, row + 1);
            this.addLabel(sheet, 0, row, s[0], this.formatLabel(BOLD | CENTRE | VCENTRE | GREEN));
            ++row;
            sheet.mergeCells(0, ++row, 0, row + 1);
            this.addLabel(sheet, 0, row, "Name", this.formatLabel(BOLD | VCENTRE | B_ALL_MED));
            sheet.mergeCells(1, row, 1, row + 1);
            this.addLabel(sheet, 1, row, "Mode", this.formatLabel(BOLD | VCENTRE | B_ALL_MED));
            sheet.mergeCells(2, row, 5, row);
            this.addLabel(sheet, 2, row, "Memory (MB)", this.formatLabel(BOLD | B_ALL_MED));
            this.addLabel(sheet, 2, row + 1, "Min", this.formatLabel(BOLD | RIGHT | B_ALL_MED));
            this.addLabel(sheet, 3, row + 1, "Curr", this.formatLabel(BOLD | RIGHT | B_ALL_MED));
            this.addLabel(sheet, 4, row + 1, "Max", this.formatLabel(BOLD | RIGHT | B_ALL_MED));
            this.addLabel(sheet, 5, row + 1, "ExpFact", this.formatLabel(BOLD | RIGHT | B_ALL_MED));
            sheet.mergeCells(6, row, 12, row);
            this.addLabel(sheet, 6, row, "Active Memory Sharing", this.formatLabel(BOLD | B_ALL_MED));
            this.addLabel(sheet, 6, row + 1, "Weight", this.formatLabel(BOLD | RIGHT | B_ALL_MED));
            this.addLabel(sheet, 7, row + 1, "Prim VIOS", this.formatLabel(BOLD | RIGHT | B_ALL_MED));
            this.addLabel(sheet, 8, row + 1, "Sec VIOS", this.formatLabel(BOLD | RIGHT | B_ALL_MED));
            this.addLabel(sheet, 9, row + 1, "Curr VIOS", this.formatLabel(BOLD | RIGHT | B_ALL_MED));
            this.addLabel(sheet, 10, row + 1, "Active", this.formatLabel(BOLD | RIGHT | B_ALL_MED));
            this.addLabel(sheet, 11, row + 1, "Max", this.formatLabel(BOLD | RIGHT | B_ALL_MED));
            this.addLabel(sheet, 12, row + 1, "Firmw", this.formatLabel(BOLD | RIGHT | B_ALL_MED));
            row += 2;
            GenericData[] lpar = this.managedSystem[i].getObjects(MEM_LPAR);
            if (lpar == null) {
                row += 2;
            } else {
                int j = 0;
                while (j < lpar.length) {
                    s = lpar[j].getVarValues("lpar_name");
                    this.addLabel(sheet, 0, row, s, 0, this.formatLabel(B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW));
                    if (s[0].length() > lparNameSize) {
                        lparNameSize = s[0].length();
                    }
                    boolean dedicated = true;
                    s = lpar[j].getVarValues("mem_mode");
                    if (s == null) {
                        s = new String[]{"ded"};
                        dedicated = true;
                    } else if (s[0].equals("shared")) {
                        dedicated = false;
                    }
                    this.addLabel(sheet, 1, row, s, 0, this.formatLabel(B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW));
                    this.addNumber(sheet, 2, row, lpar[j].getVarValues("curr_min_mem"), 0, this.formatInt(B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW));
                    this.addNumber(sheet, 3, row, lpar[j].getVarValues("curr_mem"), 0, this.formatInt(B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW));
                    this.addNumber(sheet, 4, row, lpar[j].getVarValues("curr_max_mem"), 0, this.formatInt(B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW));
                    s = lpar[j].getVarValues("curr_mem_expansion");
                    if (s == null) {
                        sheet.addCell((WritableCell)new Number(5, row, 0.0, (CellFormat)this.formatFloat(B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)));
                    } else {
                        this.addNumber(sheet, 5, row, s, 0, this.formatFloat(B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW));
                    }
                    this.addNumber(sheet, 6, row, lpar[j].getVarValues("run_mem_weight"), 0, this.formatInt(B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW));
                    s = lpar[j].getVarValues("primary_paging_vios_name");
                    this.addLabel(sheet, 7, row, s, 0, this.formatLabel(B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW));
                    if (s != null && s[0] != null && s[0].length() > viosNameSize) {
                        viosNameSize = s[0].length();
                    }
                    s = lpar[j].getVarValues("secondary_paging_vios_name");
                    this.addLabel(sheet, 8, row, s, 0, this.formatLabel(B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW));
                    if (s != null && s[0] != null && s[0].length() > viosNameSize) {
                        viosNameSize = s[0].length();
                    }
                    s = lpar[j].getVarValues("curr_paging_vios_name");
                    this.addLabel(sheet, 9, row, s, 0, this.formatLabel(B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW));
                    if (s != null && s[0] != null && s[0].length() > viosNameSize) {
                        viosNameSize = s[0].length();
                    }
                    GenericData[] pool = this.managedSystem[i].getObjects(MEM_POOL);
                    if (!dedicated && pool != null && pool[0] != null) {
                        this.addNumber(sheet, 10, row, pool[0].getVarValues("curr_pool_mem"), 0, this.formatInt(B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW));
                        this.addNumber(sheet, 11, row, pool[0].getVarValues("curr_max_pool_mem"), 0, this.formatInt(B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW));
                        this.addNumber(sheet, 12, row, pool[0].getVarValues("sys_firmware_pool_mem"), 0, this.formatInt(B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW));
                    }
                    ++row;
                    ++j;
                }
                row += 2;
            }
            ++i;
        }
        if (viosNameSize < 10) {
            viosNameSize = 8;
        }
        sheet.setColumnView(0, lparNameSize + 2);
        sheet.setColumnView(2, 8);
        sheet.setColumnView(3, 8);
        sheet.setColumnView(4, 8);
        sheet.setColumnView(5, 8);
        sheet.setColumnView(6, 8);
        sheet.setColumnView(7, viosNameSize + 2);
        sheet.setColumnView(8, viosNameSize + 2);
        sheet.setColumnView(9, viosNameSize + 2);
        sheet.setColumnView(10, 8);
        sheet.setColumnView(11, 8);
        sheet.setColumnView(12, 8);
    }

    private DataSheet createMemSheetRowBased() {
        DataSheet ds = new DataSheet();
        int[] size = new int[18];
        String currentProfileName = null;
        GenericData currentProfileData = null;
        int row = 0;
        int col = 0;
        int i = 0;
        while (i < size.length) {
            size[i] = 0;
            ++i;
        }
        int n = ds.addLabel(col, row, "Name", BOLD | VCENTRE | B_ALL_MED | GREEN);
        if (n > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Mode", BOLD | VCENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Min GB", BOLD | RIGHT | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Curr GB", BOLD | RIGHT | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Tgt GB", BOLD | RIGHT | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Max GB", BOLD | RIGHT | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "ExpFact", BOLD | RIGHT | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "AMS->", BOLD | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Weight", BOLD | RIGHT | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Prim VIOS", BOLD | RIGHT | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Sec VIOS", BOLD | RIGHT | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Curr VIOS", BOLD | RIGHT | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Active", BOLD | RIGHT | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Max", BOLD | RIGHT | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Firmw", BOLD | RIGHT | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "<-AMS", BOLD | RIGHT | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Managed System Name", BOLD | CENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Managed System Serial", BOLD | CENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        ++col;
        ++row;
        i = 0;
        while (i < this.managedSystem.length) {
            GenericData[] lpar = this.managedSystem[i].getObjects(MEM_LPAR);
            if (lpar != null) {
                int map = B_RIGHT_LOW | B_BOTTOM_LOW | B_LEFT_LOW;
                int j = 0;
                while (j < lpar.length) {
                    double desired;
                    double active;
                    col = 0;
                    String[] s = lpar[j].getVarValues("lpar_name");
                    n = ds.addLabel(col, row, s, 0, map);
                    if (n > size[col]) {
                        size[col] = n;
                    }
                    ++col;
                    currentProfileName = this.getActiveProfileName(i, s[0]);
                    currentProfileData = this.getProfileData(i, s[0], currentProfileName);
                    boolean poweredOff = false;
                    boolean dedicated = true;
                    s = lpar[j].getVarValues("mem_mode");
                    if (s == null) {
                        s = new String[]{"ded"};
                        dedicated = true;
                    } else if (s[0].equals("shared")) {
                        dedicated = false;
                    }
                    n = ds.addLabel(col, row, s, 0, map);
                    if (n > size[col]) {
                        size[col] = n;
                    }
                    ds.addFloatDiv1024(++col, row, lpar[j].getVarValues("curr_min_mem"), 0, map);
                    n = 8;
                    if (n > size[col]) {
                        size[col] = n;
                    }
                    ++col;
                    if (currentProfileData != null && !poweredOff) {
                        active = Double.parseDouble(lpar[j].getVarValues("run_mem")[0]);
                        s = currentProfileData.getVarValues("desired_mem");
                        if (s != null && active != (desired = Double.parseDouble(s[0]))) {
                            map |= YELLOW;
                        }
                    }
                    ds.addFloatDiv1024(col, row, lpar[j].getVarValues("run_mem"), 0, map);
                    n = 8;
                    if (n > size[col]) {
                        size[col] = n;
                    }
                    map = B_RIGHT_LOW | B_BOTTOM_LOW | B_LEFT_LOW;
                    ds.addFloatDiv1024(++col, row, lpar[j].getVarValues("curr_mem"), 0, map);
                    n = 8;
                    if (n > size[col]) {
                        size[col] = n;
                    }
                    map = B_RIGHT_LOW | B_BOTTOM_LOW | B_LEFT_LOW;
                    ds.addFloatDiv1024(++col, row, lpar[j].getVarValues("curr_max_mem"), 0, map);
                    n = 8;
                    if (n > size[col]) {
                        size[col] = n;
                    }
                    ++col;
                    s = lpar[j].getVarValues("curr_mem_expansion");
                    if (s != null) {
                        double d = Double.parseDouble(s[0]);
                        if (currentProfileData != null && !poweredOff) {
                            active = d;
                            s = currentProfileData.getVarValues("mem_expansion");
                            if (s != null && !s[0].equals("null") && active != (desired = Double.parseDouble(s[0]))) {
                                map |= YELLOW;
                            }
                        }
                    }
                    ds.addFloat(col, row, s, 0, map);
                    n = 6;
                    if (n > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, " ", (map = B_RIGHT_LOW | B_BOTTOM_LOW | B_LEFT_LOW) | BLACK)) > size[col]) {
                        size[col] = n;
                    }
                    ds.addInteger(++col, row, lpar[j].getVarValues("run_mem_weight"), 0, map);
                    n = 8;
                    if (n > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, lpar[j].getVarValues("primary_paging_vios_name"), 0, map)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, lpar[j].getVarValues("secondary_paging_vios_name"), 0, map)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, lpar[j].getVarValues("curr_paging_vios_name"), 0, map)) > size[col]) {
                        size[col] = n;
                    }
                    ++col;
                    GenericData[] pool = this.managedSystem[i].getObjects(MEM_POOL);
                    if (!dedicated && pool != null && pool[0] != null) {
                        ds.addInteger(col, row, pool[0].getVarValues("curr_pool_mem"), 0, map);
                        n = 8;
                        if (n > size[col]) {
                            size[col] = n;
                        }
                        ds.addInteger(++col, row, pool[0].getVarValues("curr_max_pool_mem"), 0, map);
                        n = 8;
                        if (n > size[col]) {
                            size[col] = n;
                        }
                        ds.addInteger(++col, row, pool[0].getVarValues("sys_firmware_pool_mem"), 0, map);
                        n = 8;
                        if (n > size[col]) {
                            size[col] = n;
                        }
                        ++col;
                    } else {
                        col += 3;
                    }
                    n = ds.addLabel(col, row, " ", map | BLACK);
                    if (n > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, this.managedSystem[i].getVarValues("name"), 0, map)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, this.managedSystem[i].getVarValues("serial_num"), 0, map)) > size[col]) {
                        size[col] = n;
                    }
                    ++col;
                    ++row;
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < size.length) {
            ds.setColSize(i, size[i] + 2);
            ++i;
        }
        return ds;
    }

    private void createMemSheetRowBasedExcel(WritableSheet sheet) {
        DataSheet ds = this.createMemSheetRowBased();
        if (ds != null) {
            ds.createExcelSheet(sheet);
        }
    }

    private void createMemSheetRowBasedHTML(String fileName) {
        DataSheet ds = this.createMemSheetRowBased();
        if (ds != null) {
            ds.createHTMLSheet(fileName);
            this.addButton("LPAR Mem", new File(fileName).getName());
        }
    }

    private void createMemSheetRowBasedCSV(String fileName) {
        DataSheet ds = this.createMemSheetRowBased();
        if (ds != null) {
            ds.setSeparator(this.csvSeparator);
            ds.createCSVSheet(fileName);
        }
    }

    private DataSheet createSysPoolRowBased() {
        String[] s;
        String str;
        if (this.entPool == null) {
            return null;
        }
        DataSheet ds = new DataSheet();
        int[] size = new int[14];
        int row = 0;
        int col = 0;
        int i = 0;
        while (i < size.length) {
            size[i] = 0;
            ++i;
        }
        int map = BOLD | B_ALL_MED | GREEN | DIAG45;
        int n = ds.addLabel(col, row, "Name", map);
        n = ds.addLabel(++col, row, "ID", map);
        n = ds.addLabel(++col, row, "State", map);
        n = ds.addLabel(++col, row, "Grace Period", map);
        n = ds.addLabel(++col, row, "Master Name", map);
        n = ds.addLabel(++col, row, "Master Serial", map);
        n = ds.addLabel(++col, row, "Backup Serial", map);
        n = ds.addLabel(++col, row, "Mobile Procs", map);
        n = ds.addLabel(++col, row, "Avail Mob Procs", map);
        n = ds.addLabel(++col, row, "Unreturned Mob Procs", map);
        n = ds.addLabel(++col, row, "Mobile Mem", map);
        n = ds.addLabel(++col, row, "Avail Mob Mem", map);
        n = ds.addLabel(++col, row, "Unreturned Mob Mem", map);
        ++col;
        ++row;
        i = 0;
        while (i < this.entPool.length) {
            map = B_RIGHT_LOW | B_BOTTOM_LOW | B_LEFT_LOW;
            col = 0;
            n = ds.addLabel(col, row, this.entPool[i].getVarValues("name"), 0, map);
            if (n > size[col]) {
                size[col] = n;
            }
            ds.addInteger(++col, row, this.entPool[i].getVarValues("id"), 0, map);
            n = 4;
            if (n > size[col]) {
                size[col] = n;
            }
            if ((n = ds.addLabel(++col, row, this.entPool[i].getVarValues("state"), 0, map)) > size[col]) {
                size[col] = n;
            }
            ++col;
            str = "";
            s = this.entPool[i].getVarValues("grace_period_days_remaining");
            if (s != null && s[0] != null) {
                str = String.valueOf(str) + s[0] + "D ";
            }
            if ((s = this.entPool[i].getVarValues("grace_period_hours_remaining")) != null && s[0] != null) {
                str = String.valueOf(str) + s[0] + "H";
            }
            if ((n = ds.addLabel(col, row, str, map)) < 5) {
                n = 5;
            }
            if (n > size[col]) {
                size[col] = n;
            }
            if ((n = ds.addLabel(++col, row, this.entPool[i].getVarValues("master_mc_name"), 0, map)) > size[col]) {
                size[col] = n;
            }
            if ((n = ds.addLabel(++col, row, this.entPool[i].getVarValues("master_mc_mtms"), 0, map)) > size[col]) {
                size[col] = n;
            }
            if ((n = ds.addLabel(++col, row, this.entPool[i].getVarValues("backup_master_mc_mtms"), 0, map)) > size[col]) {
                size[col] = n;
            }
            ds.addInteger(++col, row, this.entPool[i].getVarValues("mobile_procs"), 0, map);
            n = 4;
            if (n > size[col]) {
                size[col] = n;
            }
            ds.addInteger(++col, row, this.entPool[i].getVarValues("avail_mobile_procs"), 0, map);
            n = 4;
            if (n > size[col]) {
                size[col] = n;
            }
            ds.addInteger(++col, row, this.entPool[i].getVarValues("unreturned_mobile_procs"), 0, map);
            n = 4;
            if (n > size[col]) {
                size[col] = n;
            }
            ds.addFloatDiv1024(++col, row, this.entPool[i].getVarValues("mobile_mem"), 0, map);
            n = 8;
            if (n > size[col]) {
                size[col] = n;
            }
            ds.addFloatDiv1024(++col, row, this.entPool[i].getVarValues("avail_mobile_mem"), 0, map);
            n = 8;
            if (n > size[col]) {
                size[col] = n;
            }
            ds.addFloatDiv1024(++col, row, this.entPool[i].getVarValues("unreturned_mobile_mem"), 0, map);
            n = 8;
            if (n > size[col]) {
                size[col] = n;
            }
            ++col;
            ++row;
            ++i;
        }
        col = 0;
        map = BOLD | B_ALL_MED | GREEN | DIAG45;
        n = ds.addLabel(col, row += 2, "Pool Name", map);
        n = ds.addLabel(++col, row, "System", map);
        n = ds.addLabel(++col, row, "Installed CPU", map);
        n = ds.addLabel(++col, row, "Inactive CPU", map);
        n = ds.addLabel(++col, row, "Non mobile CPU", map);
        n = ds.addLabel(++col, row, "Mobile CPU", map);
        n = ds.addLabel(++col, row, "Unreturned mobile CPU", map);
        n = ds.addLabel(++col, row, "CPU Grace Period", map);
        n = ds.addLabel(++col, row, "Installed Mem", map);
        n = ds.addLabel(++col, row, "Inactive Mem", map);
        n = ds.addLabel(++col, row, "Non mobile Mem", map);
        n = ds.addLabel(++col, row, "Mobile Mem", map);
        n = ds.addLabel(++col, row, "Unreturned mobile Mem", map);
        n = ds.addLabel(++col, row, "Mem Grace Period", map);
        ++col;
        ++row;
        i = 0;
        while (i < this.entPool.length) {
            GenericData[] sys = this.entPool[i].getObjects(ENTPOOLSYS);
            int j = 0;
            while (sys != null && j < sys.length) {
                map = B_RIGHT_LOW | B_BOTTOM_LOW | B_LEFT_LOW;
                col = 0;
                n = ds.addLabel(col, row, this.entPool[i].getVarValues("name"), 0, map);
                if (n > size[col]) {
                    size[col] = n;
                }
                if ((n = ds.addLabel(++col, row, sys[j].getVarValues("name"), 0, map)) > size[col]) {
                    size[col] = n;
                }
                ds.addInteger(++col, row, sys[j].getVarValues("installed_procs"), 0, map);
                n = 4;
                if (n > size[col]) {
                    size[col] = n;
                }
                ds.addInteger(++col, row, sys[j].getVarValues("inactive_procs"), 0, map);
                n = 4;
                if (n > size[col]) {
                    size[col] = n;
                }
                ds.addInteger(++col, row, sys[j].getVarValues("non_mobile_procs"), 0, map);
                n = 4;
                if (n > size[col]) {
                    size[col] = n;
                }
                ds.addInteger(++col, row, sys[j].getVarValues("mobile_procs"), 0, map);
                n = 4;
                if (n > size[col]) {
                    size[col] = n;
                }
                ds.addInteger(++col, row, sys[j].getVarValues("unreturned_mobile_procs"), 0, map);
                n = 4;
                if (n > size[col]) {
                    size[col] = n;
                }
                ++col;
                str = "";
                s = sys[j].getVarValues("proc_grace_period_days_remaining");
                if (s != null && s[0] != null) {
                    str = String.valueOf(str) + s[0] + "D ";
                }
                if ((s = sys[j].getVarValues("proc_grace_period_hours_remaining")) != null && s[0] != null) {
                    str = String.valueOf(str) + s[0] + "H";
                }
                if ((n = ds.addLabel(col, row, str, map)) < 5) {
                    n = 5;
                }
                if (n > size[col]) {
                    size[col] = n;
                }
                ds.addFloatDiv1024(++col, row, sys[j].getVarValues("installed_mem"), 0, map);
                n = 8;
                if (n > size[col]) {
                    size[col] = n;
                }
                ds.addFloatDiv1024(++col, row, sys[j].getVarValues("inactive_mem"), 0, map);
                n = 8;
                if (n > size[col]) {
                    size[col] = n;
                }
                ds.addFloatDiv1024(++col, row, sys[j].getVarValues("non_mobile_mem"), 0, map);
                n = 8;
                if (n > size[col]) {
                    size[col] = n;
                }
                ds.addFloatDiv1024(++col, row, sys[j].getVarValues("mobile_mem"), 0, map);
                n = 8;
                if (n > size[col]) {
                    size[col] = n;
                }
                ds.addFloatDiv1024(++col, row, sys[j].getVarValues("unreturned_mobile_mem"), 0, map);
                n = 8;
                if (n > size[col]) {
                    size[col] = n;
                }
                ++col;
                str = "";
                s = sys[j].getVarValues("mem_grace_period_days_remaining");
                if (s != null && s[0] != null) {
                    str = String.valueOf(str) + s[0] + "D ";
                }
                if ((s = sys[j].getVarValues("mem_grace_period_hours_remaining")) != null && s[0] != null) {
                    str = String.valueOf(str) + s[0] + "H";
                }
                if ((n = ds.addLabel(col, row, str, map)) < 5) {
                    n = 5;
                }
                if (n > size[col]) {
                    size[col] = n;
                }
                ++col;
                ++row;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < size.length) {
            ds.setColSize(i, size[i] + 2);
            ++i;
        }
        return ds;
    }

    private void createSysPoolRowBasedExcel(WritableSheet sheet) {
        DataSheet ds = this.createSysPoolRowBased();
        if (ds != null) {
            ds.createExcelSheet(sheet);
        }
    }

    private void createSysPoolRowBasedHTML(String fileName) {
        DataSheet ds = this.createSysPoolRowBased();
        if (ds != null) {
            ds.createHTMLSheet(fileName);
            this.addButton("LPAR Mem", new File(fileName).getName());
        }
    }

    private void createSysPoolRowBasedCSV(String fileName) {
        DataSheet ds = this.createSysPoolRowBased();
        if (ds != null) {
            ds.setSeparator(this.csvSeparator);
            ds.createCSVSheet(fileName);
        }
    }

    private void createSystemSlotSheet(WritableSheet sheet) throws RowsExceededException, WriteException {
        int lparNameSize = 0;
        int descriptionSize = 0;
        int locationSize = 0;
        int row = 0;
        int i = 0;
        while (i < this.managedSystem.length) {
            String[] s = this.managedSystem[i].getVarValues("name");
            sheet.mergeCells(0, row, 3, row + 1);
            this.addLabel(sheet, 0, row, s[0], this.formatLabel(BOLD | CENTRE | VCENTRE | GREEN));
            ++row;
            this.addLabel(sheet, 0, ++row, "LPAR", this.formatLabel(BOLD | B_ALL_MED));
            this.addLabel(sheet, 1, row, "Adapter description", this.formatLabel(BOLD | B_ALL_MED));
            this.addLabel(sheet, 2, row, "Location", this.formatLabel(BOLD | B_ALL_MED));
            this.addLabel(sheet, 3, row, "drc_index", this.formatLabel(CENTRE | BOLD | B_ALL_MED));
            ++row;
            GenericData[] slot = this.managedSystem[i].getObjects(SLOT);
            if (slot == null) {
                row += 2;
            } else {
                int j = 0;
                while (j < slot.length) {
                    s = slot[j].getVarValues("lpar_name");
                    if (s != null) {
                        this.addLabel(sheet, 0, row, s, 0, this.formatLabel(B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW));
                        if (s[0].length() > lparNameSize) {
                            lparNameSize = s[0].length();
                        }
                    } else {
                        this.addLabel(sheet, 0, row, null, 0, this.formatLabel(B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW));
                    }
                    s = slot[j].getVarValues("description");
                    this.addLabel(sheet, 1, row, s, 0, this.formatLabel(B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW));
                    if (s[0].length() > descriptionSize) {
                        descriptionSize = s[0].length();
                    }
                    s = slot[j].getVarValues("drc_name");
                    this.addLabel(sheet, 2, row, s, 0, this.formatLabel(B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW));
                    if (s[0].length() > locationSize) {
                        locationSize = s[0].length();
                    }
                    s = slot[j].getVarValues("drc_index");
                    this.addLabel(sheet, 3, row, s, 0, this.formatLabel(CENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW));
                    ++row;
                    ++j;
                }
                row += 2;
            }
            ++i;
        }
        if (lparNameSize < 10) {
            lparNameSize = 8;
        }
        sheet.setColumnView(0, lparNameSize + 2);
        sheet.setColumnView(1, descriptionSize + 2);
        sheet.setColumnView(2, locationSize + 2);
        sheet.setColumnView(3, 10);
    }

    private void createSystemSlotSheetRowBasedExcel(WritableSheet sheet) {
        DataSheet ds = this.createSystemSlotSheetRowBased();
        if (ds != null) {
            ds.createExcelSheet(sheet);
        }
    }

    private void createSystemSlotSheetRowBasedHTML(String fileName) {
        DataSheet ds = this.createSystemSlotSheetRowBased();
        if (ds != null) {
            ds.createHTMLSheet(fileName);
            this.addButton("Physical Slots", new File(fileName).getName());
        }
    }

    private void createSystemSlotSheetRowBasedCSV(String fileName) {
        DataSheet ds = this.createSystemSlotSheetRowBased();
        if (ds != null) {
            ds.setSeparator(this.csvSeparator);
            ds.createCSVSheet(fileName);
        }
    }

    private DataSheet createSystemSlotSheetRowBased() {
        DataSheet ds = new DataSheet();
        String currentProfileName = null;
        GenericData currentProfileData = null;
        int[] size = new int[9];
        int i = 0;
        while (i < size.length) {
            size[i] = 0;
            ++i;
        }
        int col = 0;
        int row = 0;
        int n = ds.addLabel(col, row, "LPAR", BOLD | B_ALL_MED | GREEN);
        if (n > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Reqrd", BOLD | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Adapter description", BOLD | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Location", BOLD | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "drc_index", CENTRE | BOLD | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Profiles desiring", CENTRE | BOLD | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Profiles requiring", CENTRE | BOLD | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Managed System Name", BOLD | CENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Managed System Serial", BOLD | CENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        ++col;
        ++row;
        i = 0;
        while (i < this.managedSystem.length) {
            GenericData[] slot = this.managedSystem[i].getObjects(SLOT);
            if (slot != null) {
                int j = 0;
                while (j < slot.length) {
                    col = 0;
                    int map = B_RIGHT_LOW | B_BOTTOM_LOW | B_LEFT_LOW;
                    boolean reqrd = false;
                    String[] s = slot[j].getVarValues("lpar_name");
                    if (s != null) {
                        currentProfileName = this.getActiveProfileName(i, s[0]);
                        currentProfileData = this.getProfileData(i, s[0], currentProfileName);
                        String[] profSlots = currentProfileData == null ? null : currentProfileData.getVarValues("io_slots");
                        String drcindex = slot[j].getVarValues("drc_index")[0];
                        map |= YELLOW;
                        if (currentProfileData != null && currentProfileData.getVarValues("all_resources")[0].equals("1")) {
                            map ^= YELLOW;
                            reqrd = true;
                        }
                        int k = 0;
                        while (profSlots != null && k < profSlots.length) {
                            if (profSlots[k].startsWith(drcindex)) {
                                map ^= YELLOW;
                                if (!profSlots[k].endsWith("1")) break;
                                reqrd = true;
                                break;
                            }
                            ++k;
                        }
                    }
                    if ((n = ds.addLabel(col, row, s, 0, map)) > size[col]) {
                        size[col] = n;
                    }
                    ++col;
                    map = B_RIGHT_LOW | B_BOTTOM_LOW | B_LEFT_LOW;
                    if (reqrd) {
                        n = ds.addLabel(col, row, "yes", map);
                        if (n > size[col]) {
                            size[col] = n;
                        }
                        ++col;
                    } else {
                        ++col;
                    }
                    s = slot[j].getVarValues("description");
                    n = ds.addLabel(col, row, s, 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                    if (n > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, s = slot[j].getVarValues("drc_name"), 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, s = slot[j].getVarValues("drc_index"), 0, CENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    ++col;
                    String[][] profiles = this.getProfilesUsingAdapter(i, s[0]);
                    if (profiles != null) {
                        ds.addMultipleLabelsWrap(col, row, profiles[0], B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW | WRAP);
                        size[col] = 20;
                        ds.addMultipleLabelsWrap(++col, row, profiles[1], B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW | WRAP);
                        size[col] = 20;
                        ++col;
                    } else {
                        col += 2;
                    }
                    n = ds.addLabel(col, row, this.managedSystem[i].getVarValues("name"), 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                    if (n > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, this.managedSystem[i].getVarValues("serial_num"), 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    ++col;
                    ++row;
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < size.length) {
            ds.setColSize(i, size[i] + 2);
            ++i;
        }
        return ds;
    }

    private void createVEthSheetExcel(WritableSheet sheet) {
        DataSheet ds = this.createVEthSheet();
        if (ds != null) {
            ds.createExcelSheet(sheet);
        }
    }

    private void createVEthSheetHTML(String fileName) {
        DataSheet ds = this.createVEthSheet();
        if (ds != null) {
            ds.createHTMLSheet(fileName);
            this.addButton("Virtual Ethernet", new File(fileName).getName());
        }
    }

    private void createVEthSheetCSV(String fileName) {
        DataSheet ds = this.createVEthSheet();
        if (ds != null) {
            ds.setSeparator(this.csvSeparator);
            ds.createCSVSheet(fileName);
        }
    }

    private DataSheet createVEthSheet() {
        DataSheet ds = new DataSheet();
        int lparNameSize = 0;
        int row = 0;
        int i = 0;
        while (i < this.managedSystem.length) {
            int j;
            String[] s = this.managedSystem[i].getVarValues("name");
            ds.mergeCells(0, row, 9, row + 1);
            ds.addLabel(0, row, s[0], BOLD | CENTRE | VCENTRE | GREEN);
            ++row;
            ++row;
            GenericData[] object = this.managedSystem[i].getObjects(VSWITCH);
            if (object != null) {
                ds.mergeCells(0, row, 9, row);
                ds.addLabel(0, row, "Virtual Switches", BOLD | CENTRE | B_ALL_MED);
                ds.addLabel(0, row + 1, "Name", BOLD | CENTRE | B_ALL_MED);
                ds.addLabel(0, row + 2, "VLAN ids", BOLD | CENTRE | VCENTRE | B_ALL_MED);
                j = 0;
                while (j < object.length) {
                    s = object[j].getVarValues("vswitch");
                    ds.addLabel(1 + j, row + 1, s, 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                    s = object[j].getVarValues("vlan_ids");
                    ds.addMultipleLabelsWrap(1 + j, row + 2, s, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW | WRAP);
                    ++j;
                }
                row += 4;
            }
            ds.mergeCells(0, row, 9, row);
            ds.addLabel(0, row, "Virtual Ethernet Slots", BOLD | B_ALL_MED | CENTRE);
            ds.addLabel(0, row + 1, "LPAR name", BOLD | B_ALL_MED);
            ds.addLabel(1, row + 1, "Slot", BOLD | B_ALL_MED);
            ds.addLabel(2, row + 1, "State", BOLD | B_ALL_MED);
            ds.addLabel(3, row + 1, "Required", BOLD | B_ALL_MED);
            ds.addLabel(4, row + 1, "Trunk", BOLD | B_ALL_MED);
            ds.addLabel(5, row + 1, "Trunk Priority", BOLD | B_ALL_MED);
            ds.addLabel(6, row + 1, "MAC Addresss", BOLD | B_ALL_MED);
            ds.addLabel(7, row + 1, "Virtual Switch", BOLD | B_ALL_MED);
            ds.addLabel(8, row + 1, "Port VLAN id", BOLD | B_ALL_MED);
            ds.addLabel(9, row + 1, "IEEE VLAN ids", BOLD | B_ALL_MED);
            row += 2;
            object = this.managedSystem[i].getObjects(VETH);
            if (object != null) {
                j = 0;
                while (j < object.length) {
                    s = object[j].getVarValues("lpar_name");
                    ds.addLabel(0, row, s, 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                    if (s != null && s[0] != null && s[0].length() > lparNameSize) {
                        lparNameSize = s[0].length();
                    }
                    s = object[j].getVarValues("slot_num");
                    ds.addInteger(1, row, s, 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                    s = object[j].getVarValues("state");
                    if (s != null) {
                        if (s[0].equals("1")) {
                            ds.addLabel(2, row, "On", B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                        } else {
                            ds.addLabel(2, row, "Off", B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                        }
                    }
                    if ((s = object[j].getVarValues("is_required")) != null) {
                        if (s[0].equals("1")) {
                            ds.addLabel(3, row, "True", B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                        } else {
                            ds.addLabel(3, row, "False", B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                        }
                    }
                    if ((s = object[j].getVarValues("is_trunk")) != null) {
                        if (s[0].equals("1")) {
                            ds.addLabel(4, row, "True", B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                        } else {
                            ds.addLabel(4, row, "False", B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                        }
                    }
                    if ((s = object[j].getVarValues("trunk_priority")) != null) {
                        ds.addInteger(5, row, s, 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                    }
                    s = object[j].getVarValues("mac_addr");
                    ds.addLabel(6, row, s, 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                    s = object[j].getVarValues("vswitch");
                    ds.addLabel(7, row, s, 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                    s = object[j].getVarValues("port_vlan_id");
                    ds.addInteger(8, row, s, 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                    s = object[j].getVarValues("addl_vlan_ids");
                    ds.addMultipleLabelsWrap(9, row, s, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW | WRAP);
                    ++row;
                    ++j;
                }
            }
            row += 2;
            ++i;
        }
        if (lparNameSize == 0) {
            lparNameSize = 10;
        }
        ds.setColSize(0, lparNameSize + 2);
        i = 1;
        while (i <= 9) {
            ds.setColSize(i, 20);
            ++i;
        }
        return ds;
    }

    private void createVSCSISheet(WritableSheet sheet) throws RowsExceededException, WriteException {
        int lparNameSize = 0;
        int remoteLparNameSize = 0;
        int row = 0;
        int i = 0;
        while (i < this.managedSystem.length) {
            String[] s = this.managedSystem[i].getVarValues("name");
            sheet.mergeCells(0, row, 6, row + 1);
            this.addLabel(sheet, 0, row, s[0], this.formatLabel(BOLD | CENTRE | VCENTRE | GREEN));
            ++row;
            this.addLabel(sheet, 0, ++row, "LPAR name", this.formatLabel(BOLD | CENTRE | B_ALL_MED));
            this.addLabel(sheet, 1, row, "Slot", this.formatLabel(BOLD | CENTRE | B_ALL_MED));
            this.addLabel(sheet, 2, row, "State", this.formatLabel(BOLD | CENTRE | B_ALL_MED));
            this.addLabel(sheet, 3, row, "Required", this.formatLabel(BOLD | CENTRE | B_ALL_MED));
            this.addLabel(sheet, 4, row, "Type", this.formatLabel(BOLD | CENTRE | B_ALL_MED));
            this.addLabel(sheet, 5, row, "Remote LPAR", this.formatLabel(BOLD | CENTRE | B_ALL_MED));
            this.addLabel(sheet, 6, row, "Remote Slot", this.formatLabel(BOLD | CENTRE | B_ALL_MED));
            ++row;
            GenericData[] object = this.managedSystem[i].getObjects(VSCSI);
            if (object != null) {
                int j = 0;
                while (j < object.length) {
                    Label label;
                    s = object[j].getVarValues("lpar_name");
                    this.addLabel(sheet, 0, row, s, 0, this.formatLabel(B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW));
                    if (s != null && s[0] != null && s[0].length() > lparNameSize) {
                        lparNameSize = s[0].length();
                    }
                    s = object[j].getVarValues("slot_num");
                    this.addNumber(sheet, 1, row, s, 0, this.formatInt(B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW));
                    s = object[j].getVarValues("state");
                    if (s != null) {
                        label = s[0].equals("1") ? new Label(2, row, "On", (CellFormat)this.formatLabel(B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) : new Label(2, row, "Off", (CellFormat)this.formatLabel(B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW));
                        sheet.addCell((WritableCell)label);
                    }
                    if ((s = object[j].getVarValues("is_required")) != null) {
                        label = s[0].equals("1") ? new Label(3, row, "True", (CellFormat)this.formatLabel(B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) : new Label(3, row, "False", (CellFormat)this.formatLabel(B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW));
                        sheet.addCell((WritableCell)label);
                    }
                    s = object[j].getVarValues("adapter_type");
                    this.addLabel(sheet, 4, row, s, 0, this.formatLabel(B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW));
                    s = object[j].getVarValues("remote_lpar_name");
                    this.addLabel(sheet, 5, row, s, 0, this.formatLabel(B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW));
                    if (s != null && s[0] != null && s[0].length() > remoteLparNameSize) {
                        remoteLparNameSize = s[0].length();
                    }
                    if ((s = object[j].getVarValues("remote_slot_num")) != null && s[0].equals("any")) {
                        this.addLabel(sheet, 6, row, s, 0, this.formatLabel(B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW));
                    } else {
                        this.addNumber(sheet, 6, row, s, 0, this.formatInt(B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW));
                    }
                    ++row;
                    ++j;
                }
            }
            row += 2;
            ++i;
        }
        if (lparNameSize == 0) {
            lparNameSize = 10;
        }
        if (remoteLparNameSize == 0) {
            remoteLparNameSize = 10;
        }
        sheet.setColumnView(0, lparNameSize + 2);
        sheet.setColumnView(1, 5);
        sheet.setColumnView(2, 9);
        sheet.setColumnView(3, 9);
        sheet.setColumnView(4, 9);
        sheet.setColumnView(5, remoteLparNameSize + 2);
        sheet.setColumnView(6, 15);
        sheet.setColumnView(7, 125);
    }

    private void createVSCSISheetRowBasedExcel(WritableSheet sheet) {
        DataSheet ds = this.createVSCSISheetRowBased();
        if (ds != null) {
            ds.createExcelSheet(sheet);
        }
    }

    private void createVSCSISheetRowBasedHTML(String fileName) {
        DataSheet ds = this.createVSCSISheetRowBased();
        if (ds != null) {
            ds.createHTMLSheet(fileName);
            this.addButton("Virtual SCSI", new File(fileName).getName());
        }
    }

    private void createVSCSISheetRowBasedCSV(String fileName) {
        DataSheet ds = this.createVSCSISheetRowBased();
        if (ds != null) {
            ds.setSeparator(this.csvSeparator);
            ds.createCSVSheet(fileName);
        }
    }

    private DataSheet createVSCSISheetRowBased() {
        DataSheet ds = new DataSheet();
        int[] size = new int[9];
        int i = 0;
        while (i < size.length) {
            size[i] = 0;
            ++i;
        }
        int col = 0;
        int row = 0;
        int n = ds.addLabel(col, row, "LPAR name", BOLD | CENTRE | B_ALL_MED | GREEN);
        if (n > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Slot", BOLD | CENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "State", BOLD | CENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Required", BOLD | CENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Type", BOLD | CENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Remote LPAR", BOLD | CENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Remote Slot", BOLD | CENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Managed System Name", BOLD | CENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Managed System Serial", BOLD | CENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        ++col;
        ++row;
        i = 0;
        while (i < this.managedSystem.length) {
            GenericData[] object = this.managedSystem[i].getObjects(VSCSI);
            if (object != null) {
                int j = 0;
                while (j < object.length) {
                    col = 0;
                    String[] s = object[j].getVarValues("lpar_name");
                    n = ds.addLabel(col, row, s, 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                    if (n > size[col]) {
                        size[col] = n;
                    }
                    s = object[j].getVarValues("slot_num");
                    ds.addInteger(++col, row, s, 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                    n = 6;
                    if (n > size[col]) {
                        size[col] = n;
                    }
                    ++col;
                    s = object[j].getVarValues("state");
                    if (s != null) {
                        n = s[0].equals("1") ? ds.addLabel(col, row, "On", B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW) : ds.addLabel(col, row, "Off", B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                        if (n > size[col]) {
                            size[col] = n;
                        }
                        ++col;
                    } else {
                        ++col;
                    }
                    s = object[j].getVarValues("is_required");
                    if (s != null) {
                        n = s[0].equals("1") ? ds.addLabel(col, row, "True", B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW) : ds.addLabel(col, row, "False", B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                        if (n > size[col]) {
                            size[col] = n;
                        }
                        ++col;
                    } else {
                        ++col;
                    }
                    s = object[j].getVarValues("adapter_type");
                    n = ds.addLabel(col, row, s, 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                    if (n > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, s = object[j].getVarValues("remote_lpar_name"), 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    ++col;
                    s = object[j].getVarValues("remote_slot_num");
                    if (s != null && s[0].equals("any")) {
                        n = ds.addLabel(col, row, s, 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                    } else {
                        ds.addInteger(col, row, s, 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                    }
                    n = 6;
                    if (n > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, this.managedSystem[i].getVarValues("name"), 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, this.managedSystem[i].getVarValues("serial_num"), 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    ++col;
                    ++row;
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < size.length) {
            ds.setColSize(i, size[i] + 2);
            ++i;
        }
        return ds;
    }

    private void createHMCExcel(WritableSheet sheet) {
        DataSheet ds = this.createHMCSheet();
        if (ds != null) {
            ds.createExcelSheet(sheet);
        }
    }

    private void createHMCHTML(String fileName) {
        DataSheet ds = this.createHMCSheet();
        if (ds != null) {
            ds.createHTMLSheet(fileName);
            this.addButton("HMC", new File(fileName).getName());
        }
    }

    private void createHMCCSV(String fileName) {
        DataSheet ds = this.createHMCSheet();
        if (ds != null) {
            ds.setSeparator(this.csvSeparator);
            ds.createCSVSheet(fileName);
        }
    }

    private DataSheet createHMCSheet() {
        int i;
        DataSheet ds = new DataSheet();
        int row = 0;
        ds.mergeCells(0, row, 1, row);
        ds.addLabel(0, row, "Hardware", BOLD | CENTRE | VCENTRE | B_ALL_MED);
        ds.addLabel(0, ++row, "BIOS", BOLD | B_ALL_MED);
        ds.addLabel(1, row, this.hmc.getVarValues("bios"), 0, B_ALL_LOW);
        ds.addLabel(0, ++row, "Model", BOLD | B_ALL_MED);
        ds.addLabel(1, row, this.hmc.getVarValues("model"), 0, B_ALL_LOW);
        ds.addLabel(0, ++row, "Serial", BOLD | B_ALL_MED);
        ds.addLabel(1, row, this.hmc.getVarValues("serial"), 0, B_ALL_LOW);
        ++row;
        row = 0;
        ds.mergeCells(3, row, 4, row);
        ds.addLabel(3, row, "Software", BOLD | CENTRE | VCENTRE | B_ALL_MED);
        ds.addLabel(3, ++row, "Version", BOLD | B_ALL_MED);
        ds.addLabel(4, row, this.hmc.getVarValues("version"), 0, B_ALL_LOW);
        ds.addLabel(3, ++row, "Release", BOLD | B_ALL_MED);
        ds.addLabel(4, row, this.hmc.getVarValues("release"), 0, B_ALL_LOW);
        ds.addLabel(3, ++row, "Service Pack", BOLD | B_ALL_MED);
        ds.addLabel(4, row, this.hmc.getVarValues("sp"), 0, B_ALL_LOW);
        ds.addLabel(3, ++row, "Build Level", BOLD | B_ALL_MED);
        ds.addLabel(4, row, this.hmc.getVarValues("build_level"), 0, B_ALL_LOW);
        ds.addLabel(3, ++row, "Base Version", BOLD | B_ALL_MED);
        ds.addLabel(4, row, this.hmc.getVarValues("base_version"), 0, B_ALL_LOW);
        ds.addLabel(3, ++row, "Fixes", BOLD | B_ALL_MED);
        String[] s = this.hmc.getVarValues("fixes");
        if (s != null) {
            i = 0;
            while (i < s.length) {
                ds.addLabel(4 + i, row, s[i], B_ALL_LOW);
                ++i;
            }
        }
        ++row;
        row = 15;
        ds.mergeCells(0, row, 6, row);
        ds.addLabel(0, row, "Network", BOLD | CENTRE | VCENTRE | B_ALL_MED);
        ds.addLabel(0, ++row, "Hostname", BOLD | B_ALL_MED);
        ds.addLabel(1, row, this.hmc.getVarValues("hostname"), 0, B_ALL_LOW);
        ds.addLabel(0, ++row, "Domain", BOLD | B_ALL_MED);
        ds.addLabel(1, row, this.hmc.getVarValues("domain"), 0, B_ALL_LOW);
        ds.addLabel(0, ++row, "Gateway", BOLD | B_ALL_MED);
        ds.addLabel(1, row, this.hmc.getVarValues("gateway"), 0, B_ALL_LOW);
        ds.addLabel(0, ++row, "Name Server", BOLD | B_ALL_MED);
        ds.addLabel(1, row, this.hmc.getVarValues("nameserver"), 0, B_ALL_LOW);
        ds.addLabel(0, ++row, "DNS suffix", BOLD | B_ALL_MED);
        ds.addLabel(1, row, this.hmc.getVarValues("domainsuffix"), 0, B_ALL_LOW);
        ++row;
        ++row;
        i = 1;
        while (i <= 6) {
            ds.addLabel(i, row, "eth" + (i - 1), BOLD | B_ALL_MED);
            ++i;
        }
        ds.addLabel(0, ++row, "IPv4 addr", BOLD | B_ALL_MED);
        ds.addLabel(0, row + 1, "IPv4 netmask", BOLD | B_ALL_MED);
        ds.addLabel(0, row + 2, "IPv4 dhcp", BOLD | B_ALL_MED);
        ds.addLabel(0, row + 3, "IPv6 addr", BOLD | B_ALL_MED);
        ds.addLabel(0, row + 4, "IPv6 auto", BOLD | B_ALL_MED);
        ds.addLabel(0, row + 5, "IPv6 privacy", BOLD | B_ALL_MED);
        ds.addLabel(0, row + 6, "IPv6 dhcp", BOLD | B_ALL_MED);
        ds.addLabel(0, row + 7, "LPAR comm", BOLD | B_ALL_MED);
        ds.addLabel(0, row + 8, "Jumbo frame", BOLD | B_ALL_MED);
        ds.addLabel(0, row + 9, "Speed", BOLD | B_ALL_MED);
        ds.addLabel(0, row + 10, "Duplex", BOLD | B_ALL_MED);
        ds.addLabel(0, row + 11, "TSO", BOLD | B_ALL_MED);
        i = 1;
        while (i <= 6) {
            ds.addLabel(i, row, this.hmc.getVarValues("ipv4addr_eth" + (i - 1)), 0, B_ALL_LOW);
            ds.addLabel(i, row + 1, this.hmc.getVarValues("ipv4netmask_eth" + (i - 1)), 0, B_ALL_LOW);
            ds.addLabel(i, row + 2, this.hmc.getVarValues("ipv4dhcp_eth" + (i - 1)), 0, B_ALL_LOW);
            ds.addLabel(i, row + 3, this.hmc.getVarValues("ipv6addr_eth" + (i - 1)), 0, B_ALL_LOW);
            ds.addLabel(i, row + 4, this.hmc.getVarValues("ipv6auto_eth" + (i - 1)), 0, B_ALL_LOW);
            ds.addLabel(i, row + 5, this.hmc.getVarValues("ipv6privacy_eth" + (i - 1)), 0, B_ALL_LOW);
            ds.addLabel(i, row + 6, this.hmc.getVarValues("ipv6dhcp_eth" + (i - 1)), 0, B_ALL_LOW);
            ds.addLabel(i, row + 7, this.hmc.getVarValues("lparcomm_eth" + (i - 1)), 0, B_ALL_LOW);
            ds.addLabel(i, row + 8, this.hmc.getVarValues("jumboframe_eth" + (i - 1)), 0, B_ALL_LOW);
            ds.addLabel(i, row + 9, this.hmc.getVarValues("speed_eth" + (i - 1)), 0, B_ALL_LOW);
            ds.addLabel(i, row + 10, this.hmc.getVarValues("duplex_eth" + (i - 1)), 0, B_ALL_LOW);
            ds.addLabel(i, row + 11, this.hmc.getVarValues("tso_eth" + (i - 1)), 0, B_ALL_LOW);
            ++i;
        }
        i = 0;
        while (i < 10) {
            ds.setColSize(i, 28);
            ++i;
        }
        return ds;
    }

    private String lparid_to_name(GenericData ms, String id) {
        if (id.equals("0x00000000")) {
            return "";
        }
        GenericData[] object = ms.getObjects(CONFIG_LPAR);
        int lpar_id = Integer.parseInt(id.substring(2), 16);
        int i = 0;
        while (i < object.length) {
            int n = Integer.parseInt(object[i].getVarValues("lpar_id")[0]);
            if (n == lpar_id) {
                return object[i].getVarValues("name")[0];
            }
            ++i;
        }
        return "ERROR";
    }

    private void createVSCSIMapSheet(WritableSheet sheet) throws RowsExceededException, WriteException {
        int lines = 0;
        int[] size = new int[11];
        int row = 0;
        int i = 0;
        while (i < size.length) {
            size[i] = 0;
            ++i;
        }
        i = 0;
        while (i < this.managedSystem.length) {
            String[] s = this.managedSystem[i].getVarValues("name");
            sheet.mergeCells(0, row, 10, row + 1);
            this.addLabel(sheet, 0, row, s[0], this.formatLabel(BOLD | CENTRE | VCENTRE | GREEN));
            ++row;
            int n = this.addLabel(sheet, 0, ++row, "VIOS", this.formatLabel(BOLD | CENTRE | B_ALL_MED));
            if (n > size[0]) {
                size[0] = n;
            }
            if ((n = this.addLabel(sheet, 1, row, "Slot", this.formatLabel(BOLD | CENTRE | B_ALL_MED))) > size[1]) {
                size[1] = n;
            }
            if ((n = this.addLabel(sheet, 2, row, "Name", this.formatLabel(BOLD | CENTRE | B_ALL_MED))) > size[2]) {
                size[2] = n;
            }
            if ((n = this.addLabel(sheet, 3, row, "Client", this.formatLabel(BOLD | CENTRE | B_ALL_MED))) > size[3]) {
                size[3] = n;
            }
            if ((n = this.addLabel(sheet, 4, row, "VTD", this.formatLabel(BOLD | CENTRE | B_ALL_MED))) > size[4]) {
                size[4] = n;
            }
            if ((n = this.addLabel(sheet, 5, row, "Status", this.formatLabel(BOLD | CENTRE | B_ALL_MED))) > size[5]) {
                size[5] = n;
            }
            if ((n = this.addLabel(sheet, 6, row, "LUN", this.formatLabel(BOLD | CENTRE | B_ALL_MED))) > size[6]) {
                size[6] = n;
            }
            if ((n = this.addLabel(sheet, 7, row, "Backing device", this.formatLabel(BOLD | CENTRE | B_ALL_MED))) > size[7]) {
                size[7] = n;
            }
            if ((n = this.addLabel(sheet, 8, row, "Phys Loc", this.formatLabel(BOLD | CENTRE | B_ALL_MED))) > size[8]) {
                size[8] = n;
            }
            if ((n = this.addLabel(sheet, 9, row, "Mirrored", this.formatLabel(BOLD | CENTRE | B_ALL_MED))) > size[9]) {
                size[9] = n;
            }
            if ((n = this.addLabel(sheet, 10, row, "Identifier", this.formatLabel(BOLD | CENTRE | B_ALL_MED))) > size[10]) {
                size[10] = n;
            }
            ++row;
            GenericData[] hdisk = this.managedSystem[i].getObjects(HDISK);
            GenericData[] object = this.managedSystem[i].getObjects(VSCSIMAP);
            if (object != null) {
                int j = 0;
                while (j < object.length) {
                    lines = object[j].getVarValues("VTD").length;
                    s = object[j].getVarValues("VIOS");
                    sheet.mergeCells(0, row, 0, row + lines - 1);
                    n = this.addLabel(sheet, 0, row, s, 0, this.formatLabel(VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW));
                    if (n > size[0]) {
                        size[0] = n;
                    }
                    String vios = s[0];
                    s = object[j].getVarValues("slot");
                    sheet.mergeCells(1, row, 1, row + lines - 1);
                    this.addNumber(sheet, 1, row, s, 0, this.formatInt(VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW));
                    s = object[j].getVarValues("SVSA");
                    sheet.mergeCells(2, row, 2, row + lines - 1);
                    n = this.addLabel(sheet, 2, row, s, 0, this.formatLabel(VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW));
                    if (n > size[2]) {
                        size[2] = n;
                    }
                    s = object[j].getVarValues("client");
                    sheet.mergeCells(3, row, 3, row + lines - 1);
                    n = this.addLabel(sheet, 3, row, String.valueOf(s[0]) + " \"" + this.lparid_to_name(this.managedSystem[i], s[0]) + "\"", this.formatLabel(VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW));
                    if (n > size[3]) {
                        size[3] = n;
                    }
                    s = object[j].getVarValues("VTD");
                    int k = 0;
                    while (k < lines) {
                        n = this.addLabel(sheet, 4, row + k, object[j].getVarValues("VTD"), k, this.formatLabel(B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW));
                        if (n > size[4]) {
                            size[4] = n;
                        }
                        if ((n = this.addLabel(sheet, 5, row + k, object[j].getVarValues("Status"), k, this.formatLabel(B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW))) > size[5]) {
                            size[5] = n;
                        }
                        if ((n = this.addLabel(sheet, 6, row + k, object[j].getVarValues("LUN"), k, this.formatLabel(B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW))) > size[6]) {
                            size[6] = n;
                        }
                        if ((n = this.addLabel(sheet, 7, row + k, object[j].getVarValues("BackingDevice"), k, this.formatLabel(B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW))) > size[7]) {
                            size[7] = n;
                        }
                        String device = object[j].getVarValues("BackingDevice")[k];
                        n = this.addLabel(sheet, 8, row + k, object[j].getVarValues("physloc"), k, this.formatLabel(B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW));
                        if (n > size[8]) {
                            size[8] = n;
                        }
                        if ((n = this.addLabel(sheet, 9, row + k, object[j].getVarValues("mirror"), k, this.formatLabel(B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW))) > size[9]) {
                            size[9] = n;
                        }
                        if (device != null && device.startsWith("hdisk") && hdisk != null) {
                            int v = 0;
                            while (v < hdisk.length) {
                                String[] s2 = hdisk[v].getVarValues("VIOS");
                                if (s2 != null && s2[0] != null && s2[0].equals(vios) && (s2 = hdisk[v].getVarValues(device)) != null && (n = this.addLabel(sheet, 10, row + k, s2, 0, this.formatLabel(B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW))) > size[10]) {
                                    size[10] = n;
                                }
                                ++v;
                            }
                        }
                        ++k;
                    }
                    row += s.length;
                    ++j;
                }
            }
            row += 2;
            ++i;
        }
        i = 0;
        while (i < size.length) {
            sheet.setColumnView(i, size[i] + 2);
            ++i;
        }
    }

    private void createVSCSIMapSheetRowBasedExcel(WritableSheet sheet) {
        DataSheet ds = this.createVSCSIMapSheetRowBased();
        if (ds != null) {
            ds.createExcelSheet(sheet);
        }
    }

    private void createVSCSIMapSheetRowBasedHTML(String fileName) {
        DataSheet ds = this.createVSCSIMapSheetRowBased();
        if (ds != null) {
            ds.createHTMLSheet(fileName);
            this.addButton("VSCSI Map", new File(fileName).getName());
        }
    }

    private void createVSCSIMapSheetRowBasedCSV(String fileName) {
        DataSheet ds = this.createVSCSIMapSheetRowBased();
        if (ds != null) {
            ds.setSeparator(this.csvSeparator);
            ds.createCSVSheet(fileName);
        }
    }

    private DataSheet createVSCSIMapSheetRowBased() {
        DataSheet ds = new DataSheet();
        int lines = 0;
        int[] size = new int[13];
        int row = 0;
        int col = 0;
        int i = 0;
        while (i < size.length) {
            size[i] = 0;
            ++i;
        }
        int n = ds.addLabel(col, row, "VIOS", BOLD | CENTRE | B_ALL_MED | GREEN);
        if (n > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Slot", BOLD | CENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Name", BOLD | CENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Client", BOLD | CENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "VTD", BOLD | CENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Status", BOLD | CENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "LUN", BOLD | CENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Backing device", BOLD | CENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Phys Loc", BOLD | CENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Mirrored", BOLD | CENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Identifier", BOLD | CENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Managed System Name", BOLD | CENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Managed System Serial", BOLD | CENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        ++col;
        ++row;
        i = 0;
        while (i < this.managedSystem.length) {
            GenericData[] hdisk = this.managedSystem[i].getObjects(HDISK);
            GenericData[] object = this.managedSystem[i].getObjects(VSCSIMAP);
            if (object != null) {
                int j = 0;
                while (j < object.length) {
                    col = 0;
                    lines = object[j].getVarValues("VTD").length;
                    String vios = object[j].getVarValues("VIOS")[0];
                    int k = 0;
                    while (k < lines) {
                        n = ds.addLabel(col, row + k, vios, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                        if (n > size[col]) {
                            size[col] = n;
                        }
                        ++k;
                    }
                    ++col;
                    String[] slot = object[j].getVarValues("slot");
                    k = 0;
                    while (k < lines) {
                        ds.addInteger(col, row + k, slot, 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                        n = 5;
                        if (n > size[col]) {
                            size[col] = n;
                        }
                        ++k;
                    }
                    ++col;
                    String[] svsa = object[j].getVarValues("SVSA");
                    k = 0;
                    while (k < lines) {
                        n = ds.addLabel(col, row + k, svsa, 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                        if (n > size[col]) {
                            size[col] = n;
                        }
                        ++k;
                    }
                    ++col;
                    String[] client = object[j].getVarValues("client");
                    k = 0;
                    while (k < lines) {
                        n = ds.addLabel(col, row + k, String.valueOf(client[0]) + " \"" + this.lparid_to_name(this.managedSystem[i], client[0]) + "\"", VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                        if (n > size[col]) {
                            size[col] = n;
                        }
                        ++k;
                    }
                    ++col;
                    k = 0;
                    while (k < lines) {
                        n = ds.addLabel(col, row + k, object[j].getVarValues("VTD"), k, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                        if (n > size[col]) {
                            size[col] = n;
                        }
                        if ((n = ds.addLabel(col + 1, row + k, object[j].getVarValues("Status"), k, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col + 1]) {
                            size[col + 1] = n;
                        }
                        if ((n = ds.addLabel(col + 2, row + k, object[j].getVarValues("LUN"), k, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col + 2]) {
                            size[col + 2] = n;
                        }
                        if ((n = ds.addLabel(col + 3, row + k, object[j].getVarValues("BackingDevice"), k, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col + 3]) {
                            size[col + 3] = n;
                        }
                        String device = object[j].getVarValues("BackingDevice")[k];
                        n = ds.addLabel(col + 4, row + k, object[j].getVarValues("physloc"), k, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                        if (n > size[col + 4]) {
                            size[col + 4] = n;
                        }
                        if ((n = ds.addLabel(col + 5, row + k, object[j].getVarValues("mirror"), k, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col + 5]) {
                            size[col + 5] = n;
                        }
                        if (device != null && device.startsWith("hdisk") && hdisk != null) {
                            int v = 0;
                            while (v < hdisk.length) {
                                String[] s2 = hdisk[v].getVarValues("VIOS");
                                if (s2 != null && s2[0] != null && s2[0].equals(vios) && (s2 = hdisk[v].getVarValues(device)) != null && (n = ds.addLabel(col + 6, row + k, s2, 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col + 6]) {
                                    size[col + 6] = n;
                                }
                                ++v;
                            }
                        }
                        ++k;
                    }
                    col += 7;
                    String[] sysName = this.managedSystem[i].getVarValues("name");
                    String[] serial = this.managedSystem[i].getVarValues("serial_num");
                    k = 0;
                    while (k < lines) {
                        n = ds.addLabel(col, row + k, sysName, 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                        if (n > size[col]) {
                            size[col] = n;
                        }
                        ++k;
                    }
                    ++col;
                    k = 0;
                    while (k < lines) {
                        n = ds.addLabel(col, row + k, serial, 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                        if (n > size[col]) {
                            size[col] = n;
                        }
                        ++k;
                    }
                    ++col;
                    row += lines;
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < size.length) {
            ds.setColSize(i, size[i] + 2);
            ++i;
        }
        return ds;
    }

    private void createSEASheetExcel(WritableSheet sheet) {
        DataSheet ds = this.createSEASheet();
        if (ds != null) {
            ds.createExcelSheet(sheet);
        }
    }

    private void createSEASheetHTML(String fileName) {
        DataSheet ds = this.createSEASheet();
        if (ds != null) {
            ds.createHTMLSheet(fileName);
            this.addButton("SEA", new File(fileName).getName());
        }
    }

    private void createSEASheetCSV(String fileName) {
        DataSheet ds = this.createSEASheet();
        if (ds != null) {
            ds.setSeparator(this.csvSeparator);
            ds.createCSVSheet(fileName);
        }
    }

    private DataSheet createSEASheet() {
        GenericData myEth;
        String vios;
        GenericData[] eth;
        String[] names;
        int j;
        GenericData[] object;
        DataSheet ds = new DataSheet();
        int[] size = new int[1000];
        int maxVirt = 0;
        int i = 0;
        while (i < size.length) {
            size[i] = 4;
            ++i;
        }
        int row = 0;
        i = 0;
        while (i < this.managedSystem.length) {
            object = this.managedSystem[i].getObjects(SEA);
            j = 0;
            while (object != null && j < object.length) {
                names = object[j].getVarValues("virt_adapters");
                if (names.length > maxVirt) {
                    maxVirt = names.length;
                }
                ++j;
            }
            ++i;
        }
        int col = 0;
        int n = ds.addLabel(col, row, "Managed System Name", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Managed System Serial", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "VIOS", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "SEA", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "ctl_chan", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "ctl_chan slot", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "gvrp", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "ha_mode", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "jumbo_frames", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "large_receive", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "largesend", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "netaddr", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "accounting", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "lldpsvc", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "qos_mode", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "thread", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "pvid", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "pvid_adapter", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "real_adapter", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "real_adapter slot", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "thread", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        ++col;
        int k = 1;
        while (k <= maxVirt) {
            n = ds.addLabel(col, row, "Virt#" + k, BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
            n = ds.addLabel(++col, row, "Virt#" + k + " slot", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
            ++col;
            ++k;
        }
        ++row;
        i = 0;
        while (i < this.managedSystem.length) {
            eth = this.managedSystem[i].getObjects(ETH);
            object = this.managedSystem[i].getObjects(SEA);
            if (object != null) {
                j = 0;
                while (j < object.length) {
                    vios = object[j].getVarValues("VIOS")[0];
                    k = 0;
                    myEth = null;
                    while (k < eth.length) {
                        myEth = eth[k];
                        if (myEth.getVarValues("VIOS")[0].equals(vios)) break;
                        ++k;
                    }
                    col = 0;
                    n = ds.addLabel(col, row, this.managedSystem[i].getVarValues("name"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                    if (n > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, this.managedSystem[i].getVarValues("serial_num"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, object[j].getVarValues("VIOS"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, object[j].getVarValues("SEA"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, object[j].getVarValues("ctl_chan"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, myEth.getVarValues(object[j].getVarValues("ctl_chan")[0]), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, object[j].getVarValues("gvrp"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, object[j].getVarValues("ha_mode"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, object[j].getVarValues("jumbo_frames"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, object[j].getVarValues("large_receive"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, object[j].getVarValues("largesend"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, object[j].getVarValues("netaddr"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, object[j].getVarValues("accounting"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, object[j].getVarValues("lldpsvc"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, object[j].getVarValues("qos_mode"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, object[j].getVarValues("thread"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, object[j].getVarValues("pvid"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, object[j].getVarValues("pvid_adapter"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, object[j].getVarValues("real_adapter"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, myEth.getVarValues(object[j].getVarValues("real_adapter")[0]), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, object[j].getVarValues("thread"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    ++col;
                    names = object[j].getVarValues("virt_adapters");
                    k = 0;
                    while (k < maxVirt) {
                        if (k < names.length) {
                            n = ds.addLabel(col, row, names, k, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                            if (n > size[col]) {
                                size[col] = n;
                            }
                            if ((n = ds.addLabel(++col, row, myEth.getVarValues(names[k]), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                                size[col] = n;
                            }
                            ++col;
                        } else {
                            col += 2;
                        }
                        ++k;
                    }
                    ++row;
                    ++j;
                }
            }
            ++i;
        }
        ++row;
        ++row;
        ++row;
        i = 0;
        while (i < this.managedSystem.length) {
            object = this.managedSystem[i].getObjects(ETHERCHANNEL);
            j = 0;
            while (object != null && j < object.length) {
                names = object[j].getVarValues("adapter_names");
                if (names.length > maxVirt) {
                    maxVirt = names.length;
                }
                ++j;
            }
            ++i;
        }
        col = 0;
        n = ds.addLabel(col, row, "Managed System Name", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Managed System Serial", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "VIOS", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Etherchannel", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "alt_addr", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "auto_recovery", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "hash_mode", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "interval", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "mode", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "netaddr", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "noloss_failover", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "num_retries", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "retry_time", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "use_alt_addr", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "use_jumbo_frame", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "backup_adapter", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "backup_adapter slot", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        ++col;
        k = 1;
        while (k <= maxVirt) {
            n = ds.addLabel(col, row, "Adapter#" + k, BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
            n = ds.addLabel(++col, row, "Adapter#" + k + " slot", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
            ++col;
            ++k;
        }
        ++row;
        i = 0;
        while (i < this.managedSystem.length) {
            eth = this.managedSystem[i].getObjects(ETH);
            object = this.managedSystem[i].getObjects(ETHERCHANNEL);
            if (object != null) {
                j = 0;
                while (j < object.length) {
                    vios = object[j].getVarValues("VIOS")[0];
                    k = 0;
                    myEth = null;
                    while (k < eth.length) {
                        myEth = eth[k];
                        if (myEth.getVarValues("VIOS")[0].equals(vios)) break;
                        ++k;
                    }
                    col = 0;
                    n = ds.addLabel(col, row, this.managedSystem[i].getVarValues("name"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                    if (n > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, this.managedSystem[i].getVarValues("serial_num"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, object[j].getVarValues("VIOS"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, object[j].getVarValues("ETHERCHANNEL"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, object[j].getVarValues("alt_addr"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, object[j].getVarValues("auto_recovery"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, object[j].getVarValues("hash_mode"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, object[j].getVarValues("interval"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, object[j].getVarValues("mode"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, object[j].getVarValues("netaddr"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, object[j].getVarValues("noloss_failover"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, object[j].getVarValues("num_retries"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, object[j].getVarValues("retry_time"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, object[j].getVarValues("use_alt_addr"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, object[j].getVarValues("use_jumbo_frame"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, object[j].getVarValues("backup_adapter"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, myEth.getVarValues(object[j].getVarValues("backup_adapter")[0]), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    ++col;
                    names = object[j].getVarValues("adapter_names");
                    k = 0;
                    while (k < maxVirt) {
                        if (k < names.length) {
                            n = ds.addLabel(col, row, names, k, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                            if (n > size[col]) {
                                size[col] = n;
                            }
                            if ((n = ds.addLabel(++col, row, myEth.getVarValues(names[k]), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                                size[col] = n;
                            }
                            ++col;
                        } else {
                            col += 2;
                        }
                        ++k;
                    }
                    ++row;
                    ++j;
                }
            }
            ++i;
        }
        ++row;
        ++row;
        col = 0;
        n = ds.addLabel(col, ++row, "Managed System Name", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Managed System Serial", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "VIOS", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "SEA", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Virt Eth", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Data/Control", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Priority", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Active", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Port VLAN", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "VLANs", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Switch", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Hyp Send Failures", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Hyp Send Fail (LPAR)", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Hyp Send Fail (VIOS)", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Hyp Receive Failures", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Transmit Bufsize", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Transmit Num Buffers", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Transmit no buffers", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Receive MinBufs Tiny", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Receive MinBufs Small", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Receive MinBufs Medium", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Receive MinBufs Large", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Receive MinBufs Huge", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Receive MaxBufs Tiny", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Receive MaxBufs Small", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Receive MaxBufs Medium", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Receive MaxBufs Large", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Receive MaxBufs Huge", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Receive MaxAlloc Tiny", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Receive MaxAlloc Small", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Receive MaxAlloc Medium", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Receive MaxAlloc Large", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Receive MaxAlloc Huge", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        ++col;
        ++row;
        int normal = VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW;
        int yellow = VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW | YELLOW;
        int red = VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW | RED;
        boolean hyp_send_fail = false;
        i = 0;
        while (i < this.managedSystem.length) {
            object = this.managedSystem[i].getObjects(ENTSTATSEA);
            if (object != null) {
                j = 0;
                while (j < object.length) {
                    eth = object[j].getObjects(ETH);
                    if (eth != null) {
                        k = 0;
                        while (k < eth.length) {
                            hyp_send_fail = false;
                            if (eth[k].getVarValues("hyp_send_failures") != null && Float.parseFloat(eth[k].getVarValues("hyp_send_failures")[0]) > 0.0f) {
                                hyp_send_fail = true;
                            }
                            col = 0;
                            int map = normal;
                            n = ds.addLabel(col, row, this.managedSystem[i].getVarValues("name"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                            if (n > size[col]) {
                                size[col] = n;
                            }
                            if ((n = ds.addLabel(++col, row, this.managedSystem[i].getVarValues("serial_num"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                                size[col] = n;
                            }
                            if ((n = ds.addLabel(++col, row, object[j].getVarValues("VIOS"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                                size[col] = n;
                            }
                            if ((n = ds.addLabel(++col, row, object[j].getVarValues("SEA"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                                size[col] = n;
                            }
                            if ((n = ds.addLabel(++col, row, eth[k].getVarValues("name"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                                size[col] = n;
                            }
                            if ((n = ds.addLabel(++col, row, eth[k].getVarValues("control_channel"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                                size[col] = n;
                            }
                            if ((n = ds.addLabel(++col, row, eth[k].getVarValues("trunk"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                                size[col] = n;
                            }
                            if ((n = ds.addLabel(++col, row, eth[k].getVarValues("trunk"), 1, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                                size[col] = n;
                            }
                            if ((n = ds.addLabel(++col, row, eth[k].getVarValues("PVID"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                                size[col] = n;
                            }
                            if ((n = ds.addLabel(++col, row, eth[k].getVarValues("VLAN"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                                size[col] = n;
                            }
                            if ((n = ds.addLabel(++col, row, eth[k].getVarValues("switch"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                                size[col] = n;
                            }
                            ++col;
                            if (hyp_send_fail) {
                                map = yellow;
                            }
                            if ((n = ds.addLabel(col, row, eth[k].getVarValues("hyp_send_failures"), 0, map)) > size[col]) {
                                size[col] = n;
                            }
                            if ((n = ds.addLabel(++col, row, eth[k].getVarValues("hyp_send_receiver_fail"), 0, map)) > size[col]) {
                                size[col] = n;
                            }
                            if ((n = ds.addLabel(++col, row, eth[k].getVarValues("hyp_send_sender_fail"), 0, map)) > size[col]) {
                                size[col] = n;
                            }
                            ++col;
                            map = normal;
                            if (hyp_send_fail) {
                                map = yellow;
                            }
                            if ((n = ds.addLabel(col, row, eth[k].getVarValues("hyp_receive_failures"), 0, map)) > size[col]) {
                                size[col] = n;
                            }
                            map = normal;
                            if ((n = ds.addLabel(++col, row, eth[k].getVarValues("bufsize"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                                size[col] = n;
                            }
                            if ((n = ds.addLabel(++col, row, eth[k].getVarValues("numbufs"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                                size[col] = n;
                            }
                            ++col;
                            if (hyp_send_fail) {
                                map = yellow;
                            }
                            if ((n = ds.addLabel(col, row, eth[k].getVarValues("nobufs"), 0, map)) > size[col]) {
                                size[col] = n;
                            }
                            ++col;
                            map = normal;
                            String[] min = eth[k].getVarValues("minBufs");
                            String[] max = eth[k].getVarValues("maxBufs");
                            String[] mAlloc = eth[k].getVarValues("maxAlloc");
                            int x = 0;
                            while (x < 5) {
                                n = min != null ? ds.addLabel(col, row, min, x, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW) : 0;
                                if (n > size[col]) {
                                    size[col] = n;
                                }
                                ++col;
                                ++x;
                            }
                            x = 0;
                            while (x < 5) {
                                n = max != null ? ds.addLabel(col, row, max, x, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW) : 0;
                                if (n > size[col]) {
                                    size[col] = n;
                                }
                                ++col;
                                ++x;
                            }
                            x = 0;
                            while (x < 5) {
                                if (mAlloc != null) {
                                    map = Integer.parseInt(mAlloc[x]) == Integer.parseInt(max[x]) ? red : (Integer.parseInt(mAlloc[x]) > Integer.parseInt(min[x]) ? yellow : normal);
                                    n = ds.addLabel(col, row, mAlloc, x, map);
                                } else {
                                    n = 0;
                                }
                                if (n > size[col]) {
                                    size[col] = n;
                                }
                                ++col;
                                ++x;
                            }
                            ++row;
                            ++k;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < size.length && i < row) {
            ds.setColSize(i, size[i] + 2);
            ++i;
        }
        return ds;
    }

    private void createFCSheetExcel(WritableSheet sheet) {
        DataSheet ds = this.createFCSheet();
        if (ds != null) {
            ds.createExcelSheet(sheet);
        }
    }

    private void createFCSheetHTML(String fileName) {
        DataSheet ds = this.createFCSheet();
        if (ds != null) {
            ds.createHTMLSheet(fileName);
            this.addButton("Physical FC", new File(fileName).getName());
        }
    }

    private void createFCSheetCSV(String fileName) {
        DataSheet ds = this.createFCSheet();
        if (ds != null) {
            ds.setSeparator(this.csvSeparator);
            ds.createCSVSheet(fileName);
        }
    }

    private DataSheet createFCSheet() {
        DataSheet ds = new DataSheet();
        int[] size = new int[36];
        int row = 0;
        int i = 0;
        while (i < size.length) {
            size[i] = 4;
            ++i;
        }
        int col = 0;
        int n = ds.addLabel(col, row, "Managed System Name", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Managed System Serial", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "VIOS", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "FC", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "DIF_enabled", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "bus_intr_lvl", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "bus_io_addr", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "bus_mem_addr", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "bus_mem_addr2", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "init_link", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "intr_msi_1", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "intr_priority", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "lg_term_dma", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "max_xfer_size", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "num_cmd_elems", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "pref_alpa", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "sw_fc_class", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "tme", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "firmware", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "wwnn", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "wwpn", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Speed supported", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Speed running", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "fcid", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "port_type", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Secs since reset", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Error frames", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Dumped frames", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Invalid CRC", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Invalid Tx", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "IP no DMA", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "IP no Adapter", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "SCSI no DMA", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "SCSI no Adapter", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "SCSI no Cmd", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Effective num_cmds", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        ++col;
        ++row;
        i = 0;
        while (i < this.managedSystem.length) {
            GenericData[] gd = this.managedSystem[i].getObjects(FC);
            if (gd != null) {
                int j = 0;
                while (j < gd.length) {
                    col = 0;
                    n = ds.addLabel(col, row, this.managedSystem[i].getVarValues("name"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                    if (n > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, this.managedSystem[i].getVarValues("serial_num"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, gd[j].getVarValues("VIOS"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, gd[j].getVarValues("FC"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, gd[j].getVarValues("DIF_enabled"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, gd[j].getVarValues("bus_intr_lvl"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, gd[j].getVarValues("bus_io_addr"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, gd[j].getVarValues("bus_mem_addr"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, gd[j].getVarValues("bus_mem_addr2"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, gd[j].getVarValues("init_link"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, gd[j].getVarValues("intr_msi_1"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, gd[j].getVarValues("intr_priority"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, gd[j].getVarValues("lg_term_dma"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, gd[j].getVarValues("max_xfer_size"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, gd[j].getVarValues("num_cmd_elems"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, gd[j].getVarValues("pref_alpa"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, gd[j].getVarValues("sw_fc_class"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, gd[j].getVarValues("tme"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, gd[j].getVarValues("firmware"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, gd[j].getVarValues("wwnn"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, gd[j].getVarValues("wwpn"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, gd[j].getVarValues("speed-supported"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, gd[j].getVarValues("speed-running"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, gd[j].getVarValues("fcid"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, gd[j].getVarValues("port_type"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, gd[j].getVarValues("reset"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, gd[j].getVarValues("errorf"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, gd[j].getVarValues("dumpedf"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, gd[j].getVarValues("invalidcrc"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, gd[j].getVarValues("invalidtx"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, gd[j].getVarValues("ip_nodma"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, gd[j].getVarValues("ip_noadapter"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, gd[j].getVarValues("scsi_nodma"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, gd[j].getVarValues("scsi_noadapter"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, gd[j].getVarValues("scsi_nocmd"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, gd[j].getVarValues("e_max_transfer"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    ++col;
                    ++row;
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < size.length) {
            ds.setColSize(i, size[i] + 2);
            ++i;
        }
        return ds;
    }

    private DataSheet createSRIOVPhysPort() {
        DataSheet ds = new DataSheet();
        int[] size = new int[19];
        int row = 0;
        int i = 0;
        while (i < size.length) {
            size[i] = 4;
            ++i;
        }
        int col = 0;
        int n = ds.addLabel(col, row, "Managed System Name", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Managed System Serial", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Physical Port", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Label", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Type", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "State", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Max logical ports", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Curr logical ports", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Connection speed", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Configured connection speed", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Max recv packet size", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Config recv packet size", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Recv flow control", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Config recv flow control", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Trans flow control", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Config tras flow control", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "VEB mode", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "VEPA mode", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Priority flow control active", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        ++col;
        ++row;
        i = 0;
        while (i < this.managedSystem.length) {
            byte[] nameList = new byte[]{SRIOV_PHP_ETH, SRIOV_PHP_ETHC, SRIOV_PHP_ROCE};
            int name = 0;
            while (name < nameList.length) {
                GenericData[] gd = this.managedSystem[i].getObjects(nameList[name]);
                if (gd != null) {
                    int j = 0;
                    while (j < gd.length) {
                        col = 0;
                        n = ds.addLabel(col, row, this.managedSystem[i].getVarValues("name"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                        if (n > size[col]) {
                            size[col] = n;
                        }
                        if ((n = ds.addLabel(++col, row, this.managedSystem[i].getVarValues("serial_num"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                            size[col] = n;
                        }
                        if ((n = ds.addLabel(++col, row, gd[j].getVarValues("phys_port_loc"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                            size[col] = n;
                        }
                        if ((n = ds.addLabel(++col, row, gd[j].getVarValues("phys_port_label"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                            size[col] = n;
                        }
                        if ((n = ds.addLabel(++col, row, gd[j].getVarValues("phys_port_type"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                            size[col] = n;
                        }
                        ds.addInteger(++col, row, gd[j].getVarValues("state"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                        ds.addInteger(++col, row, gd[j].getVarValues("phys_port_max_logical_ports"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                        ds.addInteger(++col, row, gd[j].getVarValues("config_logical_ports"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                        ds.addInteger(++col, row, gd[j].getVarValues("conn_speed"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                        n = ds.addLabel(++col, row, gd[j].getVarValues("config_conn_speed"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                        if (n > size[col]) {
                            size[col] = n;
                        }
                        ds.addInteger(++col, row, gd[j].getVarValues("max_recv_packet_size"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                        ds.addInteger(++col, row, gd[j].getVarValues("config_max_recv_packet_size"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                        ds.addInteger(++col, row, gd[j].getVarValues("recv_flow_control"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                        ds.addInteger(++col, row, gd[j].getVarValues("config_recv_flow_control"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                        ds.addInteger(++col, row, gd[j].getVarValues("trans_flow_control"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                        ds.addInteger(++col, row, gd[j].getVarValues("config_trans_flow_control"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                        ds.addInteger(++col, row, gd[j].getVarValues("veb_mode"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                        ds.addInteger(++col, row, gd[j].getVarValues("vepa_mode"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                        ds.addInteger(++col, row, gd[j].getVarValues("priority_flow_control_active"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                        ++col;
                        ++row;
                        ++j;
                    }
                }
                ++name;
            }
            ++i;
        }
        i = 0;
        while (i < size.length) {
            ds.setColSize(i, size[i] + 2);
            ++i;
        }
        return ds;
    }

    private void createSRIOVPhysPortExcel(WritableSheet sheet) {
        DataSheet ds = this.createSRIOVPhysPort();
        if (ds != null) {
            ds.createExcelSheet(sheet);
        }
    }

    private void createSRIOVPhysPortHTML(String fileName) {
        DataSheet ds = this.createSRIOVPhysPort();
        if (ds != null) {
            ds.createHTMLSheet(fileName);
            this.addButton("SRIOV Phys Ports", new File(fileName).getName());
        }
    }

    private void createSRIOVPhysPortCSV(String fileName) {
        DataSheet ds = this.createSRIOVPhysPort();
        if (ds != null) {
            ds.setSeparator(this.csvSeparator);
            ds.createCSVSheet(fileName);
        }
    }

    private DataSheet createSRIOVLogicalPort() {
        DataSheet ds = new DataSheet();
        int[] size = new int[18];
        int row = 0;
        int i = 0;
        while (i < size.length) {
            size[i] = 4;
            ++i;
        }
        size[8] = 7;
        size[9] = 7;
        size[17] = 30;
        int col = 0;
        int n = ds.addLabel(col, row, "Managed System Name", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Managed System Serial", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "LPAR", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "LPAR State", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Physical Port", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Logical Port", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Required", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Type", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Max capacity", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Capacity", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "MAC", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Curr MAC", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Allowed OS MAC", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Allowed VLAN", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Port VLAN", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "VNIC backing device", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Mode", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Client LPARs", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        ++col;
        ++row;
        i = 0;
        while (i < this.managedSystem.length) {
            byte[] nameList = new byte[]{SRIOV_LOGP_ETH, SRIOV_LOGP_ROCE};
            int name = 0;
            while (name < nameList.length) {
                GenericData[] gd = this.managedSystem[i].getObjects(nameList[name]);
                if (gd != null) {
                    int j = 0;
                    while (j < gd.length) {
                        col = 0;
                        n = ds.addLabel(col, row, this.managedSystem[i].getVarValues("name"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                        if (n > size[col]) {
                            size[col] = n;
                        }
                        if ((n = ds.addLabel(++col, row, this.managedSystem[i].getVarValues("serial_num"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                            size[col] = n;
                        }
                        if ((n = ds.addLabel(++col, row, gd[j].getVarValues("lpar_name"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                            size[col] = n;
                        }
                        if ((n = ds.addLabel(++col, row, gd[j].getVarValues("lpar_state"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                            size[col] = n;
                        }
                        String location = gd[j].getVarValues("location_code")[0];
                        String[] parts = location.split("-");
                        if ((n = ds.addLabel(++col, row, location = location.substring(0, location.length() - parts[parts.length - 1].length() - 1), VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                            size[col] = n;
                        }
                        if ((n = ds.addLabel(++col, row, parts, parts.length - 1, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                            size[col] = n;
                        }
                        ds.addInteger(++col, row, gd[j].getVarValues("is_required"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                        n = ds.addLabel(++col, row, gd[j].getVarValues("logical_port_type"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                        if (n > size[col]) {
                            size[col] = n;
                        }
                        ds.addFloat(++col, row, gd[j].getVarValues("max_capacity"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                        ds.addFloat(++col, row, gd[j].getVarValues("capacity"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                        n = ds.addLabel(++col, row, gd[j].getVarValues("mac_addr"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                        if (n > size[col]) {
                            size[col] = n;
                        }
                        if ((n = ds.addLabel(++col, row, gd[j].getVarValues("curr_mac_addr"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                            size[col] = n;
                        }
                        ds.addMultipleLabelsWrap(++col, row, gd[j].getVarValues("allowed_os_mac_addrs"), VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                        ds.addMultipleLabelsWrap(++col, row, gd[j].getVarValues("allowed_vlan_ids"), VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                        ds.addInteger(++col, row, gd[j].getVarValues("port_vlan_id"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                        ds.addInteger(++col, row, gd[j].getVarValues("is_vnic_backing_device"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                        n = ds.addLabel(++col, row, gd[j].getVarValues("mode"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                        if (n > size[col]) {
                            size[col] = n;
                        }
                        ds.addMultipleLabelsWrap(++col, row, gd[j].getVarValues("client_lpar_names"), VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                        ++col;
                        ++row;
                        ++j;
                    }
                }
                ++name;
            }
            ++i;
        }
        i = 0;
        while (i < size.length) {
            ds.setColSize(i, size[i] + 2);
            ++i;
        }
        return ds;
    }

    private void createSRIOVLogicalPortExcel(WritableSheet sheet) {
        DataSheet ds = this.createSRIOVLogicalPort();
        if (ds != null) {
            ds.createExcelSheet(sheet);
        }
    }

    private void createSRIOVLogicalPortHTML(String fileName) {
        DataSheet ds = this.createSRIOVLogicalPort();
        if (ds != null) {
            ds.createHTMLSheet(fileName);
            this.addButton("SRIOV Logical Ports", new File(fileName).getName());
        }
    }

    private void createSRIOVLogicalPortCSV(String fileName) {
        DataSheet ds = this.createSRIOVLogicalPort();
        if (ds != null) {
            ds.setSeparator(this.csvSeparator);
            ds.createCSVSheet(fileName);
        }
    }

    private DataSheet createVNIC() {
        DataSheet ds = new DataSheet();
        int[] size = new int[36];
        int row = 0;
        int i = 0;
        while (i < size.length) {
            size[i] = 4;
            ++i;
        }
        int col = 0;
        int n = ds.addLabel(col, row, "Managed System Name", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Managed System Serial", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "LPAR", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Slot", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Des mode", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Curr mode", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Auto failover", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Port VLAN", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "PVID priority", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Allowed VLANs", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "MAC", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        n = ds.addLabel(++col, row, "Allowerd MACs", BOLD | CENTRE | B_ALL_MED | GREEN | DIAG45);
        ++col;
        i = 0;
        while (i < 6) {
            n = ds.addLabel(col, row, "VIOS", BOLD | CENTRE | B_LEFT_MED | B_BOTTOM_MED | B_TOP_MED | GREEN | DIAG45);
            n = ds.addLabel(++col, row, "Priority", BOLD | CENTRE | B_BOTTOM_MED | B_TOP_MED | GREEN | DIAG45);
            n = ds.addLabel(++col, row, "Physical Port", BOLD | CENTRE | B_BOTTOM_MED | B_TOP_MED | B_TOP_MED | GREEN | DIAG45);
            n = ds.addLabel(++col, row, "Logical Port", BOLD | CENTRE | B_RIGHT_MED | B_BOTTOM_MED | B_TOP_MED | GREEN | DIAG45);
            ++col;
            ++i;
        }
        ++row;
        i = 0;
        while (i < this.managedSystem.length) {
            GenericData[] gd = this.managedSystem[i].getObjects(VNIC);
            if (gd != null) {
                int j = 0;
                while (j < gd.length) {
                    col = 0;
                    n = ds.addLabel(col, row, this.managedSystem[i].getVarValues("name"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                    if (n > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, this.managedSystem[i].getVarValues("serial_num"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, gd[j].getVarValues("lpar_name"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    ds.addInteger(++col, row, gd[j].getVarValues("slot_num"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                    n = ds.addLabel(++col, row, gd[j].getVarValues("desired_mode"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                    if (n > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, gd[j].getVarValues("curr_mode"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    ds.addInteger(++col, row, gd[j].getVarValues("auto_priority_failover"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                    ds.addInteger(++col, row, gd[j].getVarValues("port_vlan_id"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                    ds.addInteger(++col, row, gd[j].getVarValues("pvid_priority"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                    ds.addMultipleLabelsWrap(++col, row, gd[j].getVarValues("allowed_vlan_ids"), VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                    n = ds.addLabel(++col, row, gd[j].getVarValues("mac_addr"), 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                    if (n > size[col]) {
                        size[col] = n;
                    }
                    ds.addMultipleLabelsWrap(++col, row, gd[j].getVarValues("allowed_os_mac_addrs"), VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                    ++col;
                    String[] devices = gd[j].getVarValues("backing_devices");
                    int dev = 0;
                    while (dev < 6 && dev < devices.length) {
                        String location;
                        String[] parts = devices[dev].split("/");
                        n = ds.addLabel(col, row, parts, 1, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                        if (n > size[col]) {
                            size[col] = n;
                        }
                        ds.addInteger(++col, row, parts, 8, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                        ++col;
                        String sriov_port = parts[5];
                        int item = 0;
                        GenericData[] eth = this.managedSystem[i].getObjects(SRIOV_LOGP_ETH);
                        if (eth != null) {
                            item = 0;
                            while (item < eth.length) {
                                if (eth[item].getVarValues("logical_port_id")[0].equals(sriov_port)) break;
                                ++item;
                            }
                        }
                        if ((eth == null || item == eth.length) && (eth = this.managedSystem[i].getObjects(SRIOV_LOGP_ROCE)) != null) {
                            item = 0;
                            while (item < eth.length) {
                                if (eth[item].getVarValues("logical_port_id")[0].equals(sriov_port)) break;
                                ++item;
                            }
                        }
                        if (eth == null || item == eth.length) {
                            location = "Unknown";
                        } else {
                            location = eth[item].getVarValues("location_code")[0];
                            parts = location.split("-");
                            location = location.substring(0, location.length() - parts[parts.length - 1].length() - 1);
                        }
                        n = ds.addLabel(col, row, location, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                        if (n > size[col]) {
                            size[col] = n;
                        }
                        if ((n = ds.addLabel(++col, row, parts, parts.length - 1, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                            size[col] = n;
                        }
                        ++col;
                        ++dev;
                    }
                    ++row;
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < size.length) {
            ds.setColSize(i, size[i] + 2);
            ++i;
        }
        return ds;
    }

    private void createVNICExcel(WritableSheet sheet) {
        DataSheet ds = this.createVNIC();
        if (ds != null) {
            ds.createExcelSheet(sheet);
        }
    }

    private void createVNICHTML(String fileName) {
        DataSheet ds = this.createVNIC();
        if (ds != null) {
            ds.createHTMLSheet(fileName);
            this.addButton("vNIC Ports", new File(fileName).getName());
        }
    }

    private void createVNICCSV(String fileName) {
        DataSheet ds = this.createVNIC();
        if (ds != null) {
            ds.setSeparator(this.csvSeparator);
            ds.createCSVSheet(fileName);
        }
    }

    private void createVFCSheet(WritableSheet sheet) throws RowsExceededException, WriteException {
        int[] size = new int[10];
        int row = 0;
        int i = 0;
        while (i < size.length) {
            size[i] = 0;
            ++i;
        }
        i = 0;
        while (i < this.managedSystem.length) {
            String[] s = this.managedSystem[i].getVarValues("name");
            sheet.mergeCells(0, row, 9, row);
            this.addLabel(sheet, 0, row, s[0], this.formatLabel(BOLD | CENTRE | VCENTRE | GREEN));
            int n = this.addLabel(sheet, 0, ++row, "LPAR name", this.formatLabel(BOLD | CENTRE | B_ALL_MED));
            if (n > size[0]) {
                size[0] = n;
            }
            if ((n = this.addLabel(sheet, 1, row, "Slot", this.formatLabel(BOLD | CENTRE | B_ALL_MED))) > size[1]) {
                size[1] = n;
            }
            if ((n = this.addLabel(sheet, 2, row, "State", this.formatLabel(BOLD | CENTRE | B_ALL_MED))) > size[2]) {
                size[2] = n;
            }
            if ((n = this.addLabel(sheet, 3, row, "Required", this.formatLabel(BOLD | CENTRE | B_ALL_MED))) > size[3]) {
                size[3] = n;
            }
            if ((n = this.addLabel(sheet, 4, row, "Type", this.formatLabel(BOLD | CENTRE | B_ALL_MED))) > size[4]) {
                size[4] = n;
            }
            if ((n = this.addLabel(sheet, 5, row, "Remote LPAR", this.formatLabel(BOLD | CENTRE | B_ALL_MED))) > size[5]) {
                size[5] = n;
            }
            if ((n = this.addLabel(sheet, 6, row, "Remote Slot", this.formatLabel(BOLD | CENTRE | B_ALL_MED))) > size[6]) {
                size[6] = n;
            }
            if ((n = this.addLabel(sheet, 7, row, "WWPN #1", this.formatLabel(BOLD | CENTRE | B_ALL_MED))) > size[7]) {
                size[7] = n;
            }
            if ((n = this.addLabel(sheet, 8, row, "WWPN #2", this.formatLabel(BOLD | CENTRE | B_ALL_MED))) > size[8]) {
                size[8] = n;
            }
            if ((n = this.addLabel(sheet, 9, row, "Physical FC Slot", this.formatLabel(BOLD | CENTRE | B_ALL_MED))) > size[9]) {
                size[9] = n;
            }
            ++row;
            String viosSlot = null;
            String viosName = null;
            GenericData[] object = this.managedSystem[i].getObjects(VFC);
            if (object != null) {
                int j = 0;
                while (j < object.length) {
                    GenericData[] vfcObject;
                    s = object[j].getVarValues("lpar_name");
                    n = this.addLabel(sheet, 0, row, s, 0, this.formatLabel(B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW));
                    if (n > size[0]) {
                        size[0] = n;
                    }
                    if (s != null) {
                        viosName = s[0];
                    }
                    s = object[j].getVarValues("slot_num");
                    this.addNumber(sheet, 1, row, s, 0, this.formatInt(VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW));
                    if (s != null) {
                        viosSlot = s[0];
                    }
                    if ((s = object[j].getVarValues("state")) != null) {
                        if (s[0].equals("1")) {
                            this.addLabel(sheet, 2, row, "On", this.formatLabel(B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW));
                        } else {
                            this.addLabel(sheet, 2, row, "Off", this.formatLabel(B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW));
                        }
                    }
                    if ((s = object[j].getVarValues("is_required")) != null) {
                        if (s[0].equals("1")) {
                            this.addLabel(sheet, 3, row, "True", this.formatLabel(B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW));
                        } else {
                            this.addLabel(sheet, 3, row, "False", this.formatLabel(B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW));
                        }
                    }
                    if ((n = this.addLabel(sheet, 4, row, s = object[j].getVarValues("adapter_type"), 0, this.formatLabel(B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW))) > size[4]) {
                        size[4] = n;
                    }
                    boolean isVios = s != null && s[0].equals("server");
                    s = object[j].getVarValues("remote_lpar_name");
                    n = this.addLabel(sheet, 5, row, s, 0, this.formatLabel(B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW));
                    if (n > size[5]) {
                        size[5] = n;
                    }
                    if (!isVios && s != null) {
                        viosName = s[0];
                    }
                    if ((s = object[j].getVarValues("remote_slot_num")) != null && s[0].equals("any")) {
                        this.addLabel(sheet, 6, row, s, 0, this.formatLabel(B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW));
                    } else {
                        this.addNumber(sheet, 6, row, s, 0, this.formatInt(VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW));
                    }
                    if (!isVios && s != null) {
                        viosSlot = s[0];
                    }
                    if ((n = this.addLabel(sheet, 7, row, s = object[j].getVarValues("wwpns"), 0, this.formatLabel(B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW))) > size[7]) {
                        size[7] = n;
                    }
                    if ((n = this.addLabel(sheet, 8, row, s, 1, this.formatLabel(B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW))) > size[8]) {
                        size[8] = n;
                    }
                    if ((vfcObject = this.managedSystem[i].getObjects(VFCMAP)) != null) {
                        int k = 0;
                        while (k < vfcObject.length) {
                            s = vfcObject[k].getVarValues(String.valueOf(viosName) + "@" + viosSlot);
                            if (s != null) break;
                            ++k;
                        }
                        n = this.addLabel(sheet, 9, row, s, 0, this.formatLabel(B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW));
                        if (n > size[9]) {
                            size[9] = n;
                        }
                    }
                    ++row;
                    ++j;
                }
            }
            row += 2;
            ++i;
        }
        i = 0;
        while (i < size.length) {
            sheet.setColumnView(i, size[i] + 2);
            ++i;
        }
    }

    private void createVFCSheetRowBasedExcel(WritableSheet sheet) {
        DataSheet ds = this.createVFCSheetRowBased();
        if (ds != null) {
            ds.createExcelSheet(sheet);
        }
    }

    private void createVFCSheetRowBasedHTML(String fileName) {
        DataSheet ds = this.createVFCSheetRowBased();
        if (ds != null) {
            ds.createHTMLSheet(fileName);
            this.addButton("Virtual Fibre", new File(fileName).getName());
        }
    }

    private void createVFCSheetRowBasedCSV(String fileName) {
        DataSheet ds = this.createVFCSheetRowBased();
        if (ds != null) {
            ds.setSeparator(this.csvSeparator);
            ds.createCSVSheet(fileName);
        }
    }

    private DataSheet createVFCSheetRowBased() {
        DataSheet ds = new DataSheet();
        int[] size = new int[12];
        int row = 0;
        int col = 0;
        int i = 0;
        while (i < size.length) {
            size[i] = 0;
            ++i;
        }
        int n = ds.addLabel(col, row, "LPAR name", BOLD | CENTRE | B_ALL_MED | GREEN);
        if (n > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Slot", BOLD | CENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "State", BOLD | CENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Required", BOLD | CENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Type", BOLD | CENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Remote LPAR", BOLD | CENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Remote Slot", BOLD | CENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "WWPN #1", BOLD | CENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "WWPN #2", BOLD | CENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Physical FC Slot", BOLD | CENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Managed System Name", BOLD | CENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Managed System Serial", BOLD | CENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        ++col;
        ++row;
        i = 0;
        while (i < this.managedSystem.length) {
            String viosSlot = null;
            String viosName = null;
            GenericData[] object = this.managedSystem[i].getObjects(VFC);
            if (object != null) {
                int j = 0;
                while (j < object.length) {
                    col = 0;
                    String[] s = object[j].getVarValues("lpar_name");
                    n = ds.addLabel(col, row, s, 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                    if (n > size[col]) {
                        size[col] = n;
                    }
                    ++col;
                    if (s != null) {
                        viosName = s[0];
                    }
                    s = object[j].getVarValues("slot_num");
                    ds.addInteger(col, row, s, 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                    n = 5;
                    if (n > size[col]) {
                        size[col] = n;
                    }
                    ++col;
                    if (s != null) {
                        viosSlot = s[0];
                    }
                    if ((s = object[j].getVarValues("state")) != null && (n = s[0].equals("1") ? ds.addLabel(col, row, "On", B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW) : ds.addLabel(col, row, "Off", B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((s = object[j].getVarValues("is_required")) != null && (n = s[0].equals("1") ? ds.addLabel(col, row, "True", B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW) : ds.addLabel(++col, row, "False", B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, s = object[j].getVarValues("adapter_type"), 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    boolean isVios = s != null && s[0].equals("server");
                    s = object[j].getVarValues("remote_lpar_name");
                    if ((n = ds.addLabel(++col, row, s, 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    ++col;
                    if (!isVios && s != null) {
                        viosName = s[0];
                    }
                    if ((s = object[j].getVarValues("remote_slot_num")) != null && s[0].equals("any")) {
                        n = ds.addLabel(col, row, s, 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                    } else {
                        ds.addInteger(col, row, s, 0, VCENTRE | B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                        n = 5;
                    }
                    if (n > size[col]) {
                        size[col] = n;
                    }
                    ++col;
                    if (!isVios && s != null) {
                        viosSlot = s[0];
                    }
                    if ((n = ds.addLabel(col, row, s = object[j].getVarValues("wwpns"), 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, s, 1, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    ++col;
                    GenericData[] vfcObject = this.managedSystem[i].getObjects(VFCMAP);
                    if (vfcObject != null) {
                        int k = 0;
                        while (k < vfcObject.length) {
                            s = vfcObject[k].getVarValues(String.valueOf(viosName) + "@" + viosSlot);
                            if (s != null) break;
                            ++k;
                        }
                        n = ds.addLabel(col, row, s, 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                        if (n > size[col]) {
                            size[col] = n;
                        }
                        ++col;
                    } else {
                        ++col;
                    }
                    n = ds.addLabel(col, row, this.managedSystem[i].getVarValues("name"), 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                    if (n > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, this.managedSystem[i].getVarValues("serial_num"), 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    ++col;
                    ++row;
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < size.length) {
            ds.setColSize(i, size[i] + 2);
            ++i;
        }
        return ds;
    }

    private void createCPUSheetRowBasedExcel(WritableSheet sheet) {
        DataSheet ds = this.createCPUSheetRowBased();
        if (ds != null) {
            ds.createExcelSheet(sheet);
        }
    }

    private void createCPUSheetRowBasedHTML(String fileName) {
        DataSheet ds = this.createCPUSheetRowBased();
        if (ds != null) {
            ds.createHTMLSheet(fileName);
            this.addButton("LPAR CPU", new File(fileName).getName());
        }
    }

    private void createCPUSheetRowBasedCSV(String fileName) {
        DataSheet ds = this.createCPUSheetRowBased();
        if (ds != null) {
            ds.setSeparator(this.csvSeparator);
            ds.createCSVSheet(fileName);
        }
    }

    private DataSheet createCPUSheetRowBased() {
        DataSheet ds = new DataSheet();
        String currentProfileName = null;
        GenericData currentProfileData = null;
        boolean profModeChange = false;
        int[] size = new int[19];
        int i = 0;
        while (i < size.length) {
            size[i] = 0;
            ++i;
        }
        int col = 0;
        int row = 0;
        int n = ds.addLabel(col, row, "Name", BOLD | B_ALL_MED | GREEN);
        if (n > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Status", BOLD | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Mode", BOLD | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Min CPU", BOLD | RIGHT | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Curr CPU", BOLD | RIGHT | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Tgt CPU", BOLD | RIGHT | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Max CPU", BOLD | RIGHT | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Min Ent", BOLD | RIGHT | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Curr Ent", BOLD | RIGHT | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Tgt Ent", BOLD | RIGHT | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Max Ent", BOLD | RIGHT | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Weight", BOLD | CENTRE | VCENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Sharing Mode", BOLD | CENTRE | VCENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Pool Name", BOLD | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Pool Resv", BOLD | RIGHT | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Pool Max", BOLD | RIGHT | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "VP:E %", BOLD | CENTRE | VCENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Managed System Name", BOLD | CENTRE | VCENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Managed System Serial", BOLD | CENTRE | VCENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        ++col;
        ++row;
        i = 0;
        while (i < this.managedSystem.length) {
            GenericData[] lpar = this.managedSystem[i].getObjects(PROC_LPAR);
            if (lpar != null) {
                int map = B_RIGHT_LOW | B_BOTTOM_LOW | B_LEFT_LOW;
                int j = 0;
                while (j < lpar.length) {
                    double desired;
                    double active;
                    String profMode;
                    String str;
                    col = 0;
                    String[] s = lpar[j].getVarValues("lpar_name");
                    n = ds.addLabel(col, row, s, 0, map);
                    if (n > size[col]) {
                        size[col] = n;
                    }
                    ++col;
                    currentProfileName = this.getActiveProfileName(i, s[0]);
                    currentProfileData = this.getProfileData(i, s[0], currentProfileName);
                    boolean poweredOff = false;
                    s = lpar[j].getVarValues("run_procs");
                    if (s[0].equals("0") || s[0].equals("null")) {
                        str = "off";
                        poweredOff = true;
                    } else {
                        str = "On";
                    }
                    n = ds.addLabel(col, row, str, map);
                    if (n > size[col]) {
                        size[col] = n;
                    }
                    ++col;
                    s = lpar[j].getVarValues("curr_proc_mode");
                    if (currentProfileData != null && !poweredOff && !(profMode = currentProfileData.getVarValues("all_resources")[0].equals("1") ? "ded" : currentProfileData.getVarValues("proc_mode")[0]).equals(s[0])) {
                        map |= YELLOW;
                        profModeChange = true;
                    }
                    if ((n = ds.addLabel(col, row, lpar[j].getVarValues("curr_proc_mode"), 0, map)) > size[col]) {
                        size[col] = n;
                    }
                    map = B_RIGHT_LOW | B_BOTTOM_LOW | B_LEFT_LOW;
                    ds.addInteger(++col, row, lpar[j].getVarValues("curr_min_procs"), 0, map);
                    n = 3;
                    if (n > size[col]) {
                        size[col] = n;
                    }
                    ++col;
                    if (!profModeChange && currentProfileData != null && !poweredOff) {
                        active = Double.parseDouble(lpar[j].getVarValues("run_procs")[0]);
                        s = currentProfileData.getVarValues("desired_procs");
                        if (s != null && active != (desired = Double.parseDouble(s[0]))) {
                            map |= YELLOW;
                        }
                    }
                    ds.addInteger(col, row, lpar[j].getVarValues("run_procs"), 0, map);
                    n = 3;
                    if (n > size[col]) {
                        size[col] = n;
                    }
                    ++col;
                    map = B_RIGHT_LOW | B_BOTTOM_LOW | B_LEFT_LOW;
                    if (poweredOff) {
                        ds.addInteger(col, row, lpar[j].getVarValues("curr_procs"), 0, map);
                        n = 3;
                        if (n > size[col]) {
                            size[col] = n;
                        }
                    }
                    map = B_RIGHT_LOW | B_BOTTOM_LOW | B_LEFT_LOW;
                    ds.addInteger(++col, row, lpar[j].getVarValues("curr_max_procs"), 0, map);
                    n = 3;
                    if (n > size[col]) {
                        size[col] = n;
                    }
                    ds.addFloat(++col, row, lpar[j].getVarValues("curr_min_proc_units"), 0, map);
                    n = 6;
                    if (n > size[col]) {
                        size[col] = n;
                    }
                    ++col;
                    s = lpar[j].getVarValues("run_proc_units");
                    if (!profModeChange && currentProfileData != null && s != null && !poweredOff && (active = Double.parseDouble(lpar[j].getVarValues("run_proc_units")[0])) != (desired = Double.parseDouble(currentProfileData.getVarValues("desired_proc_units")[0]))) {
                        map |= YELLOW;
                    }
                    ds.addFloat(col, row, lpar[j].getVarValues("run_proc_units"), 0, map);
                    n = 6;
                    if (n > size[col]) {
                        size[col] = n;
                    }
                    ++col;
                    map = B_RIGHT_LOW | B_BOTTOM_LOW | B_LEFT_LOW;
                    if (poweredOff) {
                        ds.addFloat(col, row, lpar[j].getVarValues("curr_proc_units"), 0, map);
                        n = 6;
                        if (n > size[col]) {
                            size[col] = n;
                        }
                    }
                    map = B_RIGHT_LOW | B_BOTTOM_LOW | B_LEFT_LOW;
                    ds.addFloat(++col, row, lpar[j].getVarValues("curr_max_proc_units"), 0, map);
                    n = 6;
                    if (n > size[col]) {
                        size[col] = n;
                    }
                    ds.addInteger(++col, row, lpar[j].getVarValues("run_uncap_weight"), 0, map);
                    n = 3;
                    if (n > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, lpar[j].getVarValues("curr_sharing_mode"), 0, map)) > size[col]) {
                        size[col] = n;
                    }
                    ++col;
                    s = lpar[j].getVarValues("curr_shared_proc_pool_name");
                    if (s != null) {
                        GenericData[] pool = this.managedSystem[i].getObjects(PROC_POOL);
                        int k = 0;
                        while (k < pool.length) {
                            if (pool[k].getVarValues("name")[0].equals(s[0])) break;
                            ++k;
                        }
                        if (k != pool.length) {
                            n = ds.addLabel(col, row, s, 0, map);
                            if (n > size[col]) {
                                size[col] = n;
                            }
                            ds.addFloat(++col, row, pool[k].getVarValues("curr_reserved_pool_proc_units"), 0, map);
                            n = 6;
                            if (n > size[col]) {
                                size[col] = n;
                            }
                            ds.addInteger(++col, row, pool[k].getVarValues("max_pool_proc_units"), 0, map);
                            n = 3;
                            if (n > size[col]) {
                                size[col] = n;
                            }
                            ++col;
                        } else {
                            col += 3;
                        }
                    } else {
                        col += 3;
                    }
                    double vpe = 0.0;
                    if (poweredOff) {
                        str = "Off";
                    } else if (lpar[j].getVarValues("curr_proc_mode")[0].equals("ded")) {
                        str = "Dedicated";
                    } else if (lpar[j].getVarValues("run_procs")[0].equals("1")) {
                        str = "MicroLPAR";
                    } else {
                        vpe = 100.0 * Double.parseDouble(lpar[j].getVarValues("run_procs")[0]) / Double.parseDouble(lpar[j].getVarValues("run_proc_units")[0]);
                    }
                    if (vpe > 0.0) {
                        ds.addFloat(col, row, vpe, map);
                    } else {
                        ds.addLabel(col, row, str, map);
                    }
                    n = 8;
                    if (n > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, this.managedSystem[i].getVarValues("name"), 0, map)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, this.managedSystem[i].getVarValues("serial_num"), 0, map)) > size[col]) {
                        size[col] = n;
                    }
                    ++col;
                    ++row;
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < size.length) {
            ds.setColSize(i, size[i] + 2);
            ++i;
        }
        return ds;
    }

    private void createSAExcel(WritableSheet sheet) {
        DataSheet ds = this.createSA();
        if (ds != null) {
            ds.createExcelSheet(sheet);
        }
    }

    private void createSAHTML(String fileName) {
        DataSheet ds = this.createSA();
        if (ds != null) {
            ds.createHTMLSheet(fileName);
            this.addButton("Service Agent", new File(fileName).getName());
        }
    }

    private void createSACSV(String fileName) {
        DataSheet ds = this.createSA();
        if (ds != null) {
            ds.setSeparator(this.csvSeparator);
            ds.createCSVSheet(fileName);
        }
    }

    private byte get_sa_id(String s) {
        byte i = 0;
        while (i < sa_cmd.length) {
            if (sa_cmd[i] == s) {
                return i;
            }
            i = (byte)(i + 1);
        }
        return -1;
    }

    private DataSheet createSA() {
        String[] names;
        String[] s;
        int map;
        DataSheet ds = new DataSheet();
        int[] size = new int[19];
        int i = 0;
        while (i < size.length) {
            size[i] = 0;
            ++i;
        }
        int row = 0;
        int col = 0;
        ds.addLabel(col, row, "Call home states", BOLD);
        ++row;
        String cmd_name = "callhome";
        byte cmd = this.get_sa_id(cmd_name);
        if (cmd < 0) {
            System.out.println("createSA: internal error searching object " + cmd_name);
            logger.log(Level.SEVERE, "Unknown object name" + cmd_name);
            System.exit(1);
        }
        GenericData[] objects = this.service_agent.getObjects(cmd);
        col = 0;
        int n = ds.addLabel(col, row, "Name", BOLD | B_ALL_MED | GREEN);
        if (n > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Status", BOLD | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Identifier", BOLD | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        ++col;
        ++row;
        if (objects != null && objects.length == 1) {
            String[] systems = objects[0].getVarValues("systems");
            map = B_RIGHT_LOW | B_BOTTOM_LOW | B_LEFT_LOW;
            i = 0;
            while (i < systems.length) {
                s = systems[i].split("/");
                n = ds.addLabel(0, row, s, 0, map);
                if (n > size[0]) {
                    size[0] = n;
                }
                if ((n = ds.addLabel(1, row, s, 2, map)) > size[1]) {
                    size[1] = n;
                }
                if ((n = ds.addLabel(2, row, s, 1, map)) > size[2]) {
                    size[2] = n;
                }
                ++row;
                ++i;
            }
        } else {
            logger.log(Level.WARNING, "Invalid objects for " + cmd_name);
        }
        ++row;
        col = 0;
        ds.addLabel(col, ++row, "Connection monitoring", BOLD);
        ++row;
        cmd_name = "connmon";
        cmd = this.get_sa_id(cmd_name);
        if (cmd < 0) {
            System.out.println("createSA: internal error searching object " + cmd_name);
            logger.log(Level.SEVERE, "Unknown object name" + cmd_name);
            System.exit(1);
        }
        objects = this.service_agent.getObjects(cmd);
        col = 0;
        n = ds.addLabel(col, row, "Name", BOLD | B_ALL_MED | GREEN);
        if (n > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Status", BOLD | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Identifier", BOLD | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        ++col;
        ++row;
        map = B_RIGHT_LOW | B_BOTTOM_LOW | B_LEFT_LOW;
        i = 0;
        while (objects != null && i < objects.length) {
            col = 0;
            n = ds.addLabel(col, row, objects[i].getVarValues("name")[0], map);
            if (n > size[col]) {
                size[col] = n;
            }
            if ((n = ds.addLabel(col = 1, row, objects[i].getVarValues("state")[0], map)) > size[col]) {
                size[col] = n;
            }
            if ((n = ds.addLabel(col = 2, row, objects[i].getVarValues("mtms")[0], map)) > size[col]) {
                size[col] = n;
            }
            ++row;
            ++i;
        }
        ++row;
        col = 0;
        ds.addLabel(col, ++row, "Connection monitoring timer", BOLD);
        ++row;
        cmd_name = "connmontimer";
        cmd = this.get_sa_id(cmd_name);
        if (cmd < 0) {
            System.out.println("createSA: internal error searching object " + cmd_name);
            logger.log(Level.SEVERE, "Unknown object name" + cmd_name);
            System.exit(1);
        }
        objects = this.service_agent.getObjects(cmd);
        col = 0;
        n = ds.addLabel(col, row, "Parameter", BOLD | B_ALL_MED | GREEN);
        if (n > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Value", BOLD | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        ++col;
        ++row;
        if (objects != null && objects.length == 1) {
            names = objects[0].getVarNames();
            map = B_RIGHT_LOW | B_BOTTOM_LOW | B_LEFT_LOW;
            i = 0;
            while (i < names.length) {
                s = objects[0].getVarValues(names[i]);
                col = 0;
                n = ds.addLabel(col, row, names[i], map);
                if (n > size[col]) {
                    size[col] = n;
                }
                ds.addInteger(++col, row, objects[0].getVarValues(names[i]), 0, map);
                ++row;
                ++i;
            }
        } else {
            logger.log(Level.WARNING, "Invalid objects for " + cmd_name);
        }
        ++row;
        col = 0;
        ds.addLabel(col, ++row, "Call home settings", BOLD);
        ++row;
        cmd_name = "callhomeserver";
        cmd = this.get_sa_id(cmd_name);
        if (cmd < 0) {
            System.out.println("createSA: internal error searching object " + cmd_name);
            logger.log(Level.SEVERE, "Unknown object name" + cmd_name);
            System.exit(1);
        }
        objects = this.service_agent.getObjects(cmd);
        col = 0;
        n = ds.addLabel(col, row, "Parameter", BOLD | B_ALL_MED | GREEN);
        if (n > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Value", BOLD | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        ++col;
        ++row;
        if (objects != null && objects.length == 1) {
            names = objects[0].getVarNames();
            map = B_RIGHT_LOW | B_BOTTOM_LOW | B_LEFT_LOW;
            i = 0;
            while (i < names.length) {
                s = objects[0].getVarValues(names[i]);
                col = 0;
                n = ds.addLabel(col, row, names[i], map);
                if (n > size[col]) {
                    size[col] = n;
                }
                if ((n = s.length == 1 ? ds.addLabel(col, row, s, 0, map) : ds.addMultipleLabelsWrap(++col, row, s, map)) > size[col]) {
                    size[col] = n;
                }
                ++row;
                ++i;
            }
        } else {
            logger.log(Level.WARNING, "Invalid objects for " + cmd_name);
        }
        ++row;
        col = 0;
        ds.addLabel(col, ++row, "Users authorized to access collected info", BOLD);
        ++row;
        cmd_name = "authuser";
        cmd = this.get_sa_id(cmd_name);
        if (cmd < 0) {
            System.out.println("createSA: internal error searching object " + cmd_name);
            logger.log(Level.SEVERE, "Unknown object name" + cmd_name);
            System.exit(1);
        }
        objects = this.service_agent.getObjects(cmd);
        col = 0;
        if (objects != null && objects.length == 1) {
            n = ds.addLabel(col, row, "Parameter", BOLD | B_ALL_MED | GREEN);
            if (n > size[col]) {
                size[col] = n;
            }
            if ((n = ds.addLabel(++col, row, "Value", BOLD | B_ALL_MED | GREEN)) > size[col]) {
                size[col] = n;
            }
            ++col;
            col = 0;
            if ((n = ds.addLabel(col, ++row, "email_addresses", map)) > size[col]) {
                size[col] = n;
            }
            if ((n = (s = objects[0].getVarValues("email_addresses")).length == 1 ? ds.addLabel(col, row, s, 0, map) : ds.addMultipleLabelsWrap(++col, row, s, map)) > size[col]) {
                size[col] = n;
            }
            ++row;
        } else {
            logger.log(Level.WARNING, "Invalid objects for " + cmd_name);
        }
        ++row;
        col = 0;
        ds.addLabel(col, ++row, "FTP for service information", BOLD);
        ++row;
        cmd_name = "ftpoffload";
        cmd = this.get_sa_id(cmd_name);
        if (cmd < 0) {
            System.out.println("createSA: internal error searching object " + cmd_name);
            logger.log(Level.SEVERE, "Unknown object name" + cmd_name);
            System.exit(1);
        }
        objects = this.service_agent.getObjects(cmd);
        col = 0;
        n = ds.addLabel(col, row, "Parameter", BOLD | B_ALL_MED | GREEN);
        if (n > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Value", BOLD | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        ++col;
        ++row;
        if (objects != null && objects.length == 1) {
            names = objects[0].getVarNames();
            map = B_RIGHT_LOW | B_BOTTOM_LOW | B_LEFT_LOW;
            i = 0;
            while (i < names.length) {
                s = objects[0].getVarValues(names[i]);
                col = 0;
                n = ds.addLabel(col, row, names[i], map);
                if (n > size[col]) {
                    size[col] = n;
                }
                if ((n = s.length == 1 ? ds.addLabel(col, row, s, 0, map) : ds.addMultipleLabelsWrap(++col, row, s, map)) > size[col]) {
                    size[col] = n;
                }
                ++row;
                ++i;
            }
        } else {
            logger.log(Level.WARNING, "Invalid objects for " + cmd_name);
        }
        ++row;
        col = 0;
        ds.addLabel(col, ++row, "FTP firewall settings", BOLD);
        ++row;
        cmd_name = "ftpfirewall";
        cmd = this.get_sa_id(cmd_name);
        if (cmd < 0) {
            System.out.println("createSA: internal error searching object " + cmd_name);
            logger.log(Level.SEVERE, "Unknown object name" + cmd_name);
            System.exit(1);
        }
        objects = this.service_agent.getObjects(cmd);
        col = 0;
        n = ds.addLabel(col, row, "Parameter", BOLD | B_ALL_MED | GREEN);
        if (n > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Value", BOLD | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        ++col;
        ++row;
        if (objects != null && objects.length == 1) {
            names = objects[0].getVarNames();
            map = B_RIGHT_LOW | B_BOTTOM_LOW | B_LEFT_LOW;
            i = 0;
            while (i < names.length) {
                s = objects[0].getVarValues(names[i]);
                col = 0;
                n = ds.addLabel(col, row, names[i], map);
                if (n > size[col]) {
                    size[col] = n;
                }
                if ((n = s.length == 1 ? ds.addLabel(col, row, s, 0, map) : ds.addMultipleLabelsWrap(++col, row, s, map)) > size[col]) {
                    size[col] = n;
                }
                ++row;
                ++i;
            }
        } else {
            logger.log(Level.WARNING, "Invalid objects for " + cmd_name);
        }
        ++row;
        col = 0;
        ds.addLabel(col, ++row, "Customer info", BOLD);
        ++row;
        cmd_name = "custinfo";
        cmd = this.get_sa_id(cmd_name);
        if (cmd < 0) {
            System.out.println("createSA: internal error searching object " + cmd_name);
            logger.log(Level.SEVERE, "Unknown object name" + cmd_name);
            System.exit(1);
        }
        objects = this.service_agent.getObjects(cmd);
        col = 0;
        n = ds.addLabel(col, row, "Parameter", BOLD | B_ALL_MED | GREEN);
        if (n > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Value", BOLD | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        ++col;
        ++row;
        if (objects != null && objects.length == 1) {
            names = objects[0].getVarNames();
            map = B_RIGHT_LOW | B_BOTTOM_LOW | B_LEFT_LOW;
            i = 0;
            while (i < names.length) {
                s = objects[0].getVarValues(names[i]);
                col = 0;
                n = ds.addLabel(col, row, names[i], map);
                if (n > size[col]) {
                    size[col] = n;
                }
                if ((n = s.length == 1 ? ds.addLabel(col, row, s, 0, map) : ds.addMultipleLabelsWrap(++col, row, s, map)) > size[col]) {
                    size[col] = n;
                }
                ++row;
                ++i;
            }
        } else {
            logger.log(Level.WARNING, "Invalid objects for " + cmd_name);
        }
        ++row;
        col = 0;
        ds.addLabel(col, ++row, "email notification settings", BOLD);
        ++row;
        cmd_name = "email";
        cmd = this.get_sa_id(cmd_name);
        if (cmd < 0) {
            System.out.println("createSA: internal error searching object " + cmd_name);
            logger.log(Level.SEVERE, "Unknown object name" + cmd_name);
            System.exit(1);
        }
        objects = this.service_agent.getObjects(cmd);
        col = 0;
        n = ds.addLabel(col, row, "Parameter", BOLD | B_ALL_MED | GREEN);
        if (n > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Value", BOLD | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        ++col;
        ++row;
        if (objects != null && objects.length == 1) {
            names = objects[0].getVarNames();
            map = B_RIGHT_LOW | B_BOTTOM_LOW | B_LEFT_LOW;
            i = 0;
            while (i < names.length) {
                s = objects[0].getVarValues(names[i]);
                col = 0;
                n = ds.addLabel(col, row, names[i], map);
                if (n > size[col]) {
                    size[col] = n;
                }
                if ((n = s.length == 1 ? ds.addLabel(col, row, s, 0, map) : ds.addMultipleLabelsWrap(++col, row, s, map)) > size[col]) {
                    size[col] = n;
                }
                ++row;
                ++i;
            }
        } else {
            logger.log(Level.WARNING, "Invalid objects for " + cmd_name);
        }
        ++row;
        i = 0;
        while (i < size.length) {
            ds.setColSize(i, size[i] + 2);
            ++i;
        }
        return ds;
    }

    private void createCPUSheet(WritableSheet sheet) throws RowsExceededException, WriteException {
        int lparNameSize = 0;
        int poolNameSize = 0;
        int ded = 0;
        int vp = 0;
        int ent100 = 0;
        int row = 0;
        int i = 0;
        while (i < this.managedSystem.length) {
            vp = 0;
            ded = 0;
            ent100 = 0;
            String[] s = this.managedSystem[i].getVarValues("name");
            sheet.mergeCells(0, row, 14, row + 1);
            this.addLabel(sheet, 0, row, s[0], this.formatLabel(BOLD | CENTRE | VCENTRE | GREEN));
            ++row;
            sheet.mergeCells(0, ++row, 0, row + 1);
            this.addLabel(sheet, 0, row, "Name", this.formatLabel(BOLD | B_ALL_MED));
            sheet.mergeCells(1, row, 1, row + 1);
            this.addLabel(sheet, 1, row, "Status", this.formatLabel(BOLD | B_ALL_MED));
            sheet.mergeCells(2, row, 2, row + 1);
            this.addLabel(sheet, 2, row, "Mode", this.formatLabel(BOLD | B_ALL_MED));
            sheet.mergeCells(3, row, 5, row);
            this.addLabel(sheet, 3, row, "Virt/Phys procs", this.formatLabel(BOLD | CENTRE | B_ALL_MED));
            this.addLabel(sheet, 3, row + 1, "Min", this.formatLabel(BOLD | RIGHT | B_ALL_MED));
            this.addLabel(sheet, 4, row + 1, "Curr", this.formatLabel(BOLD | RIGHT | B_ALL_MED));
            this.addLabel(sheet, 5, row + 1, "Max", this.formatLabel(BOLD | RIGHT | B_ALL_MED));
            sheet.mergeCells(6, row, 8, row);
            this.addLabel(sheet, 6, row, "Entitlement", this.formatLabel(BOLD | CENTRE | B_ALL_MED));
            this.addLabel(sheet, 6, row + 1, "Min", this.formatLabel(BOLD | RIGHT | B_ALL_MED));
            this.addLabel(sheet, 7, row + 1, "Curr", this.formatLabel(BOLD | RIGHT | B_ALL_MED));
            this.addLabel(sheet, 8, row + 1, "Max", this.formatLabel(BOLD | RIGHT | B_ALL_MED));
            sheet.mergeCells(9, row, 9, row + 1);
            this.addLabel(sheet, 9, row, "Weight", this.formatLabel(BOLD | CENTRE | VCENTRE | B_ALL_MED));
            sheet.mergeCells(10, row, 10, row + 1);
            this.addLabel(sheet, 10, row, "Sharing Mode", this.formatLabel(BOLD | CENTRE | VCENTRE | B_ALL_MED));
            sheet.mergeCells(11, row, 13, row);
            this.addLabel(sheet, 11, row, "Shared Pool", this.formatLabel(BOLD | CENTRE | B_ALL_MED));
            this.addLabel(sheet, 11, row + 1, "Name", this.formatLabel(BOLD | B_ALL_MED));
            this.addLabel(sheet, 12, row + 1, "Resv", this.formatLabel(BOLD | RIGHT | B_ALL_MED));
            this.addLabel(sheet, 13, row + 1, "Max", this.formatLabel(BOLD | RIGHT | B_ALL_MED));
            sheet.mergeCells(14, row, 14, row + 1);
            this.addLabel(sheet, 14, row, "E:VP %", this.formatLabel(BOLD | CENTRE | VCENTRE | B_ALL_MED));
            row += 2;
            GenericData[] lpar = this.managedSystem[i].getObjects(PROC_LPAR);
            if (lpar == null) {
                row += 2;
            } else {
                int j = 0;
                while (j < lpar.length) {
                    s = lpar[j].getVarValues("lpar_name");
                    this.addLabel(sheet, 0, row, s, 0, this.formatLabel(B_RIGHT_LOW | B_BOTTOM_LOW | B_LEFT_LOW));
                    if (s[0].length() > lparNameSize) {
                        lparNameSize = s[0].length();
                    }
                    Label label = lpar[j].getVarValues("run_procs")[0].equals("0") ? new Label(1, row, "Off", (CellFormat)this.formatLabel(B_RIGHT_LOW | B_BOTTOM_LOW | B_LEFT_LOW)) : new Label(1, row, "On", (CellFormat)this.formatLabel(B_RIGHT_LOW | B_BOTTOM_LOW | B_LEFT_LOW));
                    sheet.addCell((WritableCell)label);
                    this.addLabel(sheet, 2, row, lpar[j].getVarValues("curr_proc_mode"), 0, this.formatLabel(B_RIGHT_LOW | B_BOTTOM_LOW | B_LEFT_LOW));
                    this.addNumber(sheet, 3, row, lpar[j].getVarValues("curr_min_procs"), 0, this.formatInt(B_RIGHT_LOW | B_BOTTOM_LOW | B_LEFT_LOW));
                    this.addNumber(sheet, 4, row, lpar[j].getVarValues("run_procs"), 0, this.formatInt(B_RIGHT_LOW | B_BOTTOM_LOW | B_LEFT_LOW));
                    this.addNumber(sheet, 5, row, lpar[j].getVarValues("curr_max_procs"), 0, this.formatInt(B_RIGHT_LOW | B_BOTTOM_LOW | B_LEFT_LOW));
                    this.addNumber(sheet, 6, row, lpar[j].getVarValues("curr_min_proc_units"), 0, this.formatFloat(B_RIGHT_LOW | B_BOTTOM_LOW | B_LEFT_LOW));
                    this.addNumber(sheet, 7, row, lpar[j].getVarValues("run_proc_units"), 0, this.formatFloat(B_RIGHT_LOW | B_BOTTOM_LOW | B_LEFT_LOW));
                    this.addNumber(sheet, 8, row, lpar[j].getVarValues("curr_max_proc_units"), 0, this.formatFloat(B_RIGHT_LOW | B_BOTTOM_LOW | B_LEFT_LOW));
                    this.addNumber(sheet, 9, row, lpar[j].getVarValues("run_uncap_weight"), 0, this.formatInt(B_RIGHT_LOW | B_BOTTOM_LOW | B_LEFT_LOW));
                    this.addLabel(sheet, 10, row, lpar[j].getVarValues("curr_sharing_mode"), 0, this.formatLabel(B_RIGHT_LOW | B_BOTTOM_LOW | B_LEFT_LOW));
                    if (lpar[j].getVarValues("curr_proc_mode")[0].equals("shared")) {
                        vp += this.textToInt(lpar[j].getVarValues("run_procs")[0]);
                        ent100 = (int)((float)ent100 + 100.0f * Float.parseFloat(lpar[j].getVarValues("run_proc_units")[0]));
                    } else {
                        ded += this.textToInt(lpar[j].getVarValues("run_procs")[0]);
                    }
                    s = lpar[j].getVarValues("curr_shared_proc_pool_name");
                    if (s != null) {
                        if (s[0].length() > poolNameSize) {
                            poolNameSize = s[0].length();
                        }
                        GenericData[] pool = this.managedSystem[i].getObjects(PROC_POOL);
                        int k = 0;
                        while (k < pool.length) {
                            if (pool[k].getVarValues("name")[0].equals(s[0])) break;
                            ++k;
                        }
                        if (k != pool.length) {
                            this.addLabel(sheet, 11, row, s, 0, this.formatLabel(B_RIGHT_LOW | B_BOTTOM_LOW | B_LEFT_LOW));
                            this.addNumber(sheet, 12, row, pool[k].getVarValues("curr_reserved_pool_proc_units"), 0, this.formatFloat(B_RIGHT_LOW | B_BOTTOM_LOW | B_LEFT_LOW));
                            this.addNumber(sheet, 13, row, pool[k].getVarValues("max_pool_proc_units"), 0, this.formatInt(B_RIGHT_LOW | B_BOTTOM_LOW | B_LEFT_LOW));
                        }
                    }
                    Formula f = new Formula(14, row, "IF(C" + (row + 1) + "=\"ded\",\"Dedicated\",IF(E" + (row + 1) + "=0,\"Off\",IF(E" + (row + 1) + ">1,ROUND(E" + (row + 1) + "/H" + (row + 1) + "*100,0),\"MicroLPAR\")))", (CellFormat)this.formatFloat(B_RIGHT_LOW | B_BOTTOM_LOW | B_LEFT_LOW));
                    sheet.addCell((WritableCell)f);
                    ++row;
                    ++j;
                }
                this.addLabel(sheet, 3, ++row, "Size", this.formatLabel(BOLD | CENTRE));
                this.addLabel(sheet, 4, row, "Assigned", this.formatLabel(BOLD | CENTRE));
                this.addLabel(sheet, 5, row, "Available", this.formatLabel(BOLD | CENTRE));
                sheet.mergeCells(0, ++row, 2, row);
                this.addLabel(sheet, 0, row, "Active Physical Cores", this.formatLabel(BOLD));
                double sysProcs = Double.parseDouble(this.managedSystem[i].getObjects(PROC)[0].getVarValues("configurable_sys_proc_units")[0]);
                sheet.addCell((WritableCell)new Number(3, row, sysProcs, (CellFormat)this.formatInt(CENTRE | B_TOP_MED | B_LEFT_MED | B_BOTTOM_LOW | B_RIGHT_LOW)));
                this.addLabel(sheet, 4, row, "", this.formatLabel(CENTRE | VCENTRE | B_TOP_MED | GRAY_25));
                this.addLabel(sheet, 5, row, "", this.formatLabel(CENTRE | VCENTRE | B_TOP_MED | B_RIGHT_MED | GRAY_25));
                sheet.mergeCells(0, ++row, 2, row);
                this.addLabel(sheet, 0, row, "Dedicated Cores", this.formatLabel(BOLD));
                this.addLabel(sheet, 3, row, "", this.formatLabel(CENTRE | VCENTRE | B_LEFT_MED | GRAY_25));
                sheet.addCell((WritableCell)new Number(4, row, (double)ded, (CellFormat)this.formatInt(CENTRE | VCENTRE | B_ALL_LOW)));
                this.addLabel(sheet, 5, row, "", this.formatLabel(CENTRE | VCENTRE | B_RIGHT_MED | GRAY_25));
                sheet.mergeCells(0, ++row, 2, row);
                this.addLabel(sheet, 0, row, "Shared Pool", this.formatLabel(BOLD));
                sheet.addCell((WritableCell)new Number(3, row, sysProcs - (double)ded, (CellFormat)this.formatInt(CENTRE | VCENTRE | B_LEFT_MED | B_TOP_LOW | B_BOTTOM_LOW)));
                sheet.addCell((WritableCell)new Number(4, row, 1.0 * (double)ent100 / 100.0, (CellFormat)this.formatFloat(CENTRE | VCENTRE | B_ALL_LOW)));
                sheet.addCell((WritableCell)new Number(5, row, sysProcs - (double)ded - (double)ent100 / 100.0, (CellFormat)this.formatFloat(CENTRE | VCENTRE | B_RIGHT_MED | B_TOP_LOW | B_BOTTOM_LOW)));
                sheet.mergeCells(0, ++row, 2, row);
                this.addLabel(sheet, 0, row, "Virtual Processors", this.formatLabel(BOLD));
                this.addLabel(sheet, 3, row, "", this.formatLabel(CENTRE | VCENTRE | B_LEFT_MED | B_BOTTOM_MED | GRAY_25));
                sheet.addCell((WritableCell)new Number(4, row, (double)vp, (CellFormat)this.formatInt(CENTRE | VCENTRE | B_BOTTOM_MED | B_LEFT_LOW | B_RIGHT_LOW)));
                this.addLabel(sheet, 5, row, "", this.formatLabel(CENTRE | VCENTRE | B_RIGHT_MED | B_BOTTOM_MED | GRAY_25));
                ++row;
                row += 2;
            }
            ++i;
        }
        sheet.setColumnView(0, lparNameSize + 2);
        sheet.setColumnView(11, poolNameSize + 2);
        sheet.setColumnView(3, 10);
        sheet.setColumnView(4, 10);
        sheet.setColumnView(5, 10);
        sheet.setColumnView(6, 10);
        sheet.setColumnView(7, 10);
        sheet.setColumnView(8, 10);
        sheet.setColumnView(9, 10);
        sheet.setColumnView(10, 24);
        sheet.setColumnView(12, 5);
        sheet.setColumnView(13, 7);
        sheet.setColumnView(14, 10);
    }

    private void createSWSheet(WritableSheet sheet) throws RowsExceededException, WriteException {
        GenericData[] gd = null;
        WritableFont arial10font = new WritableFont(WritableFont.ARIAL, 10);
        WritableFont arial10boldfont = new WritableFont(WritableFont.ARIAL, 10, WritableFont.BOLD, true);
        WritableCellFormat arial10format = new WritableCellFormat(arial10font);
        WritableCellFormat centre = new WritableCellFormat(arial10boldfont);
        centre.setAlignment(Alignment.CENTRE);
        centre.setVerticalAlignment(VerticalAlignment.CENTRE);
        WritableCellFormat centreGreen = new WritableCellFormat(arial10boldfont);
        centreGreen.setAlignment(Alignment.CENTRE);
        centreGreen.setVerticalAlignment(VerticalAlignment.CENTRE);
        centreGreen.setBackground(Colour.LIGHT_GREEN);
        WritableCellFormat title = new WritableCellFormat(arial10boldfont);
        title.setWrap(true);
        WritableCellFormat float2d = new WritableCellFormat(NumberFormats.FORMAT3);
        int lparNameSize = 0;
        int row = 0;
        int i = 0;
        while (i < this.managedSystem.length) {
            String[] s = this.managedSystem[i].getVarValues("name");
            sheet.mergeCells(0, row, 17, row);
            this.addLabel(sheet, 0, row, s[0], this.formatLabel(BOLD | CENTRE | VCENTRE | GREEN));
            this.addLabel(sheet, 0, ++row, "System cores", this.formatLabel(BOLD | B_ALL_MED));
            gd = this.managedSystem[i].getObjects(PROC);
            if (gd == null || gd[0] == null) {
                this.addLabel(sheet, 1, row, "N/A", this.formatLabel(B_RIGHT_LOW | B_BOTTOM_LOW | B_TOP_LOW));
                row += 2;
            } else {
                Formula f;
                int k;
                this.addNumber(sheet, 1, row, gd[0].getVarValues("configurable_sys_proc_units"), 0, this.formatInt(B_RIGHT_LOW | B_BOTTOM_LOW | B_TOP_LOW));
                int poolsRow = ++row;
                GenericData[] pool = this.managedSystem[i].getObjects(PROC_POOL);
                sheet.mergeCells(0, row, 0, row + 2);
                if (pool == null) {
                    this.addLabel(sheet, 0, row, "Processor Pools\n(Not supported)", this.formatLabel(VCENTRE | BOLD | B_ALL_MED | WRAP));
                } else {
                    this.addLabel(sheet, 0, row, "Processor Pools", this.formatLabel(VCENTRE | BOLD | B_ALL_MED | WRAP));
                }
                this.addLabel(sheet, 1, row, "ID", this.formatLabel(BOLD | B_ALL_MED));
                this.addLabel(sheet, 1, row + 1, "Name", this.formatLabel(BOLD | B_ALL_MED));
                this.addLabel(sheet, 1, row + 2, "Size", this.formatLabel(BOLD | B_ALL_MED));
                int j = 1;
                while (j <= 16) {
                    this.addNumber(sheet, 1 + j, row, j, this.formatInt(B_TOP_LOW | B_BOTTOM_LOW | B_RIGHT_LOW));
                    k = 0;
                    while (pool != null && k < pool.length) {
                        if (pool[k].getVarValues("shared_proc_pool_id")[0].equals(String.valueOf(j))) break;
                        ++k;
                    }
                    if (pool != null && k != pool.length) {
                        this.addLabel(sheet, 1 + j, row + 1, pool[k].getVarValues("name"), 0, this.formatLabel(B_RIGHT_LOW | B_BOTTOM_LOW));
                        this.addNumber(sheet, 1 + j, row + 2, pool[k].getVarValues("max_pool_proc_units"), 0, this.formatInt(B_RIGHT_LOW | B_BOTTOM_LOW));
                    }
                    ++j;
                }
                sheet.mergeCells(0, row += 4, 0, row + 1);
                this.addLabel(sheet, 0, row, "LPAR Name", this.formatLabel(BOLD | CENTRE | VCENTRE | B_ALL_MED));
                sheet.mergeCells(1, row, 1, row + 1);
                this.addLabel(sheet, 1, row, "Select", this.formatLabel(BOLD | CENTRE | VCENTRE | B_ALL_MED));
                sheet.mergeCells(2, row, 2, row + 1);
                this.addLabel(sheet, 2, row, "Curr VPs", this.formatLabel(BOLD | WRAP | CENTRE | VCENTRE | B_ALL_MED));
                sheet.mergeCells(3, row, 3, row + 1);
                this.addLabel(sheet, 3, row, "Curr Ent", this.formatLabel(BOLD | WRAP | CENTRE | VCENTRE | B_ALL_MED));
                sheet.mergeCells(4, row, 4, row + 1);
                this.addLabel(sheet, 4, row, "cap vs uncap", this.formatLabel(BOLD | WRAP | CENTRE | VCENTRE | B_ALL_MED));
                sheet.mergeCells(5, row, 6, row);
                this.addLabel(sheet, 5, row, "Shared Pool", this.formatLabel(BOLD | CENTRE | B_ALL_MED));
                this.addLabel(sheet, 5, row + 1, "ID", this.formatLabel(BOLD | CENTRE | B_ALL_MED));
                this.addLabel(sheet, 6, row + 1, "Name", this.formatLabel(BOLD | B_ALL_MED));
                sheet.mergeCells(7, row, 7, row + 1);
                this.addLabel(sheet, 7, row, "Max core usage", this.formatLabel(BOLD | CENTRE | WRAP | B_ALL_MED));
                sheet.mergeCells(8, row, 25, row);
                this.addLabel(sheet, 8, row, "Max core usage assigned to pools", this.formatLabel(BOLD | B_ALL_MED));
                this.addLabel(sheet, 8, row + 1, "DedLPAR", this.formatLabel(BOLD | B_ALL_MED));
                this.addLabel(sheet, 9, row + 1, "Def Pool", this.formatLabel(BOLD | B_ALL_MED));
                j = 1;
                while (j <= 16) {
                    f = new Formula(9 + j, row + 1, "IF(ISBLANK(" + this.getColName(1 + j) + (poolsRow + 2) + "),\"\"," + this.getColName(1 + j) + (poolsRow + 2) + ")", (CellFormat)this.formatLabel(BOLD | B_ALL_MED));
                    sheet.addCell((WritableCell)f);
                    ++j;
                }
                row += 2;
                GenericData[] lpar = this.managedSystem[i].getObjects(PROC_LPAR);
                if (lpar == null) {
                    row += 2;
                } else {
                    int lparRow = row;
                    j = 0;
                    while (j < lpar.length) {
                        s = lpar[j].getVarValues("lpar_name");
                        this.addLabel(sheet, 0, row, s, 0, this.formatLabel(B_RIGHT_LOW | B_BOTTOM_LOW | B_LEFT_LOW));
                        if (s[0].length() > lparNameSize) {
                            lparNameSize = s[0].length();
                        }
                        boolean dedicated = lpar[j].getVarValues("curr_proc_mode")[0].equals("ded");
                        this.addNumber(sheet, 2, row, lpar[j].getVarValues("run_procs"), 0, this.formatInt(B_RIGHT_LOW | B_BOTTOM_LOW));
                        this.addNumber(sheet, 3, row, lpar[j].getVarValues("run_proc_units"), 0, this.formatFloat(B_RIGHT_LOW | B_BOTTOM_LOW));
                        if (!dedicated) {
                            this.addLabel(sheet, 4, row, lpar[j].getVarValues("curr_sharing_mode"), 0, this.formatLabel(B_RIGHT_LOW | B_BOTTOM_LOW | B_LEFT_LOW));
                        }
                        if (dedicated) {
                            this.addNumber(sheet, 5, row, -1.0, this.formatInt(B_RIGHT_LOW | B_BOTTOM_LOW));
                        } else {
                            s = lpar[j].getVarValues("curr_shared_proc_pool_id");
                            if (s == null) {
                                this.addNumber(sheet, 5, row, 0.0, this.formatInt(B_RIGHT_LOW | B_BOTTOM_LOW));
                            } else {
                                this.addNumber(sheet, 5, row, s, 0, this.formatInt(B_RIGHT_LOW | B_BOTTOM_LOW));
                            }
                        }
                        f = new Formula(6, row, "IF(F" + (row + 1) + "=0,\"DefaultPool\",IF(F" + (row + 1) + "<0,\"DedLPAR\",HLOOKUP(F" + (row + 1) + ",$C$" + (poolsRow + 1) + ":$R$" + (poolsRow + 2) + ",2)))", (CellFormat)this.formatFloat(B_RIGHT_LOW | B_BOTTOM_LOW));
                        sheet.addCell((WritableCell)f);
                        f = new Formula(7, row, "IF(ISBLANK(B" + (row + 1) + "),0,IF(OR(F" + (row + 1) + "<0,E" + (row + 1) + "=\"uncap\"),C" + (row + 1) + ",D" + (row + 1) + "))", (CellFormat)this.formatFloat(B_RIGHT_LOW | B_BOTTOM_LOW));
                        sheet.addCell((WritableCell)f);
                        f = new Formula(8, row, "IF(F" + (row + 1) + "<0,H" + (row + 1) + ",0)", (CellFormat)this.formatFloat(B_RIGHT_LOW | B_BOTTOM_LOW));
                        sheet.addCell((WritableCell)f);
                        f = new Formula(9, row, "IF(F" + (row + 1) + "=0,H" + (row + 1) + ",0)", (CellFormat)this.formatFloat(B_RIGHT_LOW | B_BOTTOM_LOW));
                        sheet.addCell((WritableCell)f);
                        k = 1;
                        while (k <= 16) {
                            f = new Formula(9 + k, row, "IF($F" + (row + 1) + "=" + this.getColName(1 + k) + "$" + (poolsRow + 1) + ",$H" + (row + 1) + ",0)", (CellFormat)this.formatFloat(B_RIGHT_LOW | B_BOTTOM_LOW));
                            sheet.addCell((WritableCell)f);
                            ++k;
                        }
                        ++row;
                        ++j;
                    }
                    f = new Formula(8, row, "SUM(I" + (lparRow + 1) + ":I" + (row - 1 + 1), (CellFormat)this.formatFloat(B_RIGHT_LOW | B_BOTTOM_LOW | B_LEFT_LOW));
                    sheet.addCell((WritableCell)f);
                    f = new Formula(9, row, "MIN(C" + (row + 2) + ",SUM(J" + (lparRow + 1) + ":J" + (row - 1 + 1), (CellFormat)this.formatFloat(B_RIGHT_LOW | B_BOTTOM_LOW | B_LEFT_LOW));
                    sheet.addCell((WritableCell)f);
                    j = 10;
                    while (j < 26) {
                        f = new Formula(j, row, "MIN(" + this.getColName(2 + j - 10) + (poolsRow + 3) + ",SUM(" + this.getColName(j) + (lparRow + 1) + ":" + this.getColName(j) + (row - 1 + 1), (CellFormat)this.formatFloat(B_RIGHT_LOW | B_BOTTOM_LOW | B_LEFT_LOW));
                        sheet.addCell((WritableCell)f);
                        ++j;
                    }
                    Label label = new Label(0, ++row, "System pool size", (CellFormat)this.formatLabel(BOLD | B_ALL_MED));
                    sheet.addCell((WritableCell)label);
                    f = new Formula(2, row, "B" + (poolsRow - 1 + 1) + "-I" + row);
                    f.setCellFormat((CellFormat)float2d);
                    sheet.addCell((WritableCell)f);
                    label = new Label(0, ++row, "Max dedicated cores", (CellFormat)this.formatLabel(BOLD | B_ALL_MED));
                    sheet.addCell((WritableCell)label);
                    f = new Formula(2, row, "I" + (row - 2 + 1));
                    f.setCellFormat((CellFormat)float2d);
                    sheet.addCell((WritableCell)f);
                    label = new Label(0, ++row, "Max pool cores", (CellFormat)this.formatLabel(BOLD | B_ALL_MED));
                    sheet.addCell((WritableCell)label);
                    f = new Formula(2, row, "MIN(C" + (row - 2 + 1) + ",SUM(J" + (row - 3 + 1) + ":Z" + (row - 3 + 1));
                    f.setCellFormat((CellFormat)float2d);
                    sheet.addCell((WritableCell)f);
                    label = new Label(0, ++row, "Max used cores", (CellFormat)this.formatLabel(BOLD | B_ALL_MED));
                    sheet.addCell((WritableCell)label);
                    f = new Formula(2, row, "C" + (row - 2 + 1) + "+C" + (row - 1 + 1));
                    f.setCellFormat((CellFormat)float2d);
                    sheet.addCell((WritableCell)f);
                    label = new Label(3, row, "<<<=== Useful when checking number of required SW licenses", (CellFormat)arial10format);
                    sheet.addCell((WritableCell)label);
                    ++row;
                    row += 2;
                }
            }
            ++i;
        }
        if (lparNameSize <= 18) {
            lparNameSize = 20;
        }
        sheet.setColumnView(0, lparNameSize + 2);
    }

    private int addLabel(WritableSheet sheet, int col, int row, String s, WritableCellFormat format) throws RowsExceededException, WriteException {
        if (s == null) {
            sheet.addCell((WritableCell)new Label(col, row, null, (CellFormat)format));
            return 0;
        }
        sheet.addCell((WritableCell)new Label(col, row, s, (CellFormat)format));
        return s.length();
    }

    private int addLabel(WritableSheet sheet, int col, int row, String[] s, int index, WritableCellFormat format) throws RowsExceededException, WriteException {
        if (s == null || index >= s.length) {
            sheet.addCell((WritableCell)new Label(col, row, null, (CellFormat)format));
            return 0;
        }
        sheet.addCell((WritableCell)new Label(col, row, s[index], (CellFormat)format));
        if (s[index] == null) {
            return 0;
        }
        return s[index].length();
    }

    private void addNumber(WritableSheet sheet, int col, int row, String[] s, int index, WritableCellFormat format) throws RowsExceededException, WriteException {
        if (sheet == null || s == null) {
            return;
        }
        if (index >= s.length) {
            return;
        }
        try {
            double d = Double.parseDouble(s[index]);
            d = (double)Math.round(d * 100.0) / 100.0;
            sheet.addCell((WritableCell)new Number(col, row, d, (CellFormat)format));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void addNumber(WritableSheet sheet, int col, int row, double d, WritableCellFormat format) throws RowsExceededException, WriteException {
        sheet.addCell((WritableCell)new Number(col, row, d, (CellFormat)format));
    }

    private void createHeaderExcel(WritableSheet sheet) {
        DataSheet ds = this.createHeader();
        if (ds != null) {
            ds.createExcelSheet(sheet);
        }
    }

    private void createHeaderHTML(String fileName) {
        DataSheet ds = this.createHeader();
        if (ds != null) {
            ds.createHTMLSheet(fileName);
            this.addButton("Header", new File(fileName).getName());
        }
    }

    private void createHeaderCSV(String fileName) {
        DataSheet ds = this.createHeader();
        if (ds != null) {
            ds.setSeparator(this.csvSeparator);
            ds.createCSVSheet(fileName);
        }
    }

    private DataSheet createHeader() {
        DataSheet ds = new DataSheet();
        int row = 0;
        ds.addLabel(0, row, "Manager Name", BOLD | B_ALL_MED);
        ds.addLabel(1, row, this.scannerParams.getVarValues("HMC")[0], B_ALL_LOW);
        ds.addLabel(0, ++row, "Manager Type", BOLD | B_ALL_MED);
        switch (this.managerType) {
            case 2: {
                ds.addLabel(1, row, "FSM", B_ALL_LOW);
                break;
            }
            case 0: {
                ds.addLabel(1, row, "HMC", B_ALL_LOW);
                break;
            }
            case 1: {
                ds.addLabel(1, row, "SDMC", B_ALL_LOW);
                break;
            }
            case 3: {
                ds.addLabel(1, row, "IVM", B_ALL_LOW);
                break;
            }
        }
        ds.addLabel(0, ++row, "User", BOLD | B_ALL_MED);
        ds.addLabel(1, row, this.scannerParams.getVarValues("user")[0], B_ALL_LOW);
        ds.addLabel(0, ++row, "Generation Date", BOLD | B_ALL_MED);
        ds.addLabel(1, row, this.scannerParams.getVarValues("date")[0], B_ALL_LOW);
        ds.addLabel(0, ++row, "Generation Time", BOLD | B_ALL_MED);
        ds.addLabel(1, row, this.scannerParams.getVarValues("time")[0], B_ALL_LOW);
        ds.addLabel(0, ++row, "Manager Date", BOLD | B_ALL_MED);
        ds.addLabel(1, row, this.scannerParams.getVarValues("HMCdate")[0], B_ALL_LOW);
        ds.addLabel(0, ++row, "Manager Time", BOLD | B_ALL_MED);
        ds.addLabel(1, row, this.scannerParams.getVarValues("HMCtime")[0], B_ALL_LOW);
        ds.addLabel(0, ++row, "HMC Scanner Version", BOLD | B_ALL_MED);
        ds.addLabel(1, row, version, B_ALL_LOW);
        ++row;
        ds.addLabel(0, ++row, "Latest HMC Scanner is available at https://www.ibm.com/support/pages/hmc-scanner-power-server-config-and-performance-stats", NONE);
        ds.addLabel(0, ++row, "For issues send a mail to vagnini@it.ibm.com", NONE);
        ds.addLabel(0, ++row, "Include generated log file(s) and files in directroy created by the scanner.", NONE);
        ds.addPicture(3, ++row, 5, 15, String.valueOf(System.getProperty("user.dir")) + File.separatorChar + hmcScannerPic);
        ds.setColSize(0, 21);
        ds.setColSize(1, 36);
        return ds;
    }

    private void createSysRAMUsageSheetExcel(WritableSheet sheet) {
        DataSheet ds = this.createSysRAMUsageSheet();
        if (ds != null) {
            ds.createExcelSheet(sheet);
        }
    }

    private void createSysRAMUsageSheetHTML(String fileName) {
        DataSheet ds = this.createSysRAMUsageSheet();
        if (ds != null) {
            ds.createHTMLSheet(fileName);
            this.addButton("System RAM Usage", new File(fileName).getName());
        }
    }

    private void createSysRAMUsageSheetCSV(String fileName) {
        DataSheet ds = this.createSysRAMUsageSheet();
        if (ds != null) {
            ds.setSeparator(this.csvSeparator);
            ds.createCSVSheet(fileName);
        }
    }

    private DataSheet createSysRAMUsageSheet() {
        float f;
        int j;
        String s;
        DataSheet ds = new DataSheet();
        int size = 0;
        String[] timeLabels = this.msMemConfig[0].getMonthlyLabels();
        int row = 0;
        ds.mergeCells(0, row, 13, row);
        ds.addLabel(0, row, "Average Free Memory GB", BOLD | CENTRE | VCENTRE | GREEN);
        ds.mergeCells(15, row, 28, row);
        ds.addLabel(15, row, "Average Percentage Free Memory", BOLD | CENTRE | VCENTRE | GREEN);
        ++row;
        int i = 0;
        while (i < timeLabels.length) {
            s = timeLabels[i];
            ds.addLabel(1 + i, row, s, BOLD | B_ALL_MED);
            ds.addLabel(16 + i, row, s, BOLD | B_ALL_MED);
            ++i;
        }
        ++row;
        i = 0;
        while (i < this.managedSystem.length) {
            s = this.managedSystem[i].getVarValues("name")[0];
            if (s.length() > size) {
                size = s.length();
            }
            ds.addLabel(0, row + i, s, BOLD | VCENTRE | CENTRE | B_ALL_MED);
            ds.addLabel(15, row + i, s, BOLD | VCENTRE | CENTRE | B_ALL_MED);
            j = 0;
            while (j < timeLabels.length) {
                f = this.msMemAvail[i].getMonthData(j);
                float f2 = this.msMemConfig[i].getMonthData(j);
                if (f >= 0.0f) {
                    ds.addFloat(1 + j, row + i, f, B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW);
                }
                if (f >= 0.0f && f2 > 0.0f) {
                    ds.addFloat(16 + j, row + i, f / f2 * 100.0f, B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW);
                }
                ++j;
            }
            ++i;
        }
        row += i;
        ds.mergeCells(0, ++row, 13, row);
        ds.addLabel(0, row, "Average Configured Memory GB", BOLD | CENTRE | VCENTRE | GREEN);
        ++row;
        i = 0;
        while (i < timeLabels.length) {
            s = timeLabels[i];
            ds.addLabel(1 + i, row, s, BOLD | B_ALL_MED);
            ++i;
        }
        ++row;
        i = 0;
        while (i < this.managedSystem.length) {
            s = this.managedSystem[i].getVarValues("name")[0];
            if (s.length() > size) {
                size = s.length();
            }
            ds.addLabel(0, row + i, s, BOLD | VCENTRE | CENTRE | B_ALL_MED);
            j = 0;
            while (j < timeLabels.length) {
                f = this.msMemConfig[i].getMonthData(j);
                if (f >= 0.0f) {
                    ds.addFloat(1 + j, row + i, f, B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW);
                }
                ++j;
            }
            ++i;
        }
        row += i;
        ++row;
        ds.setColSize(0, size + 6);
        ds.setColSize(15, size + 6);
        return ds;
    }

    private void createLparDailyUsageSheetExcel(WritableSheet sheet, int from, int to) {
        DataSheet ds = this.createLparDailyUsageSheet(from, to);
        if (ds != null) {
            ds.createExcelSheet(sheet);
        }
    }

    private void createLparDailyUsageSheetHTML(String fileName, int from, int to, int count) {
        DataSheet ds = this.createLparDailyUsageSheet(from, to);
        if (ds != null) {
            ds.createHTMLSheet(fileName);
            this.addButton("LPAR Daily N" + count, new File(fileName).getName());
        }
    }

    private void createLparDailyUsageSheetCSV(String fileName, int from, int to, int count) {
        DataSheet ds = this.createLparDailyUsageSheet(from, to);
        if (ds != null) {
            ds.setSeparator(this.csvSeparator);
            ds.createCSVSheet(fileName);
        }
    }

    private DataSheet createLparDailyUsageSheet(int from, int to) {
        int j;
        String s;
        DataSheet ds = new DataSheet();
        int size = 0;
        int map = 0;
        String[] timeLabels = this.lparPC[from].getDailyLabels();
        if (to > this.lparNames.length - 1) {
            to = this.lparNames.length - 1;
        }
        int row = 0;
        ds.addLabel(0, row, "Red", BOLD | CENTRE | VCENTRE | RED);
        ds.mergeCells(1, row, 10, row);
        ds.addLabel(1, row, "Usage >= " + this.R_LEVEL + "% of max allowed size", BOLD);
        ds.addLabel(0, ++row, "Yellow", BOLD | CENTRE | VCENTRE | YELLOW);
        ds.mergeCells(1, row, 10, row);
        ds.addLabel(1, row, "Usage >= " + this.Y_LEVEL + "% of max allowed size", BOLD);
        ds.addLabel(0, ++row, "Bold", BOLD | CENTRE | VCENTRE);
        ds.mergeCells(1, row, 10, row);
        ds.addLabel(1, row, "Usage > entitled capacity", BOLD);
        ds.addLabel(0, ++row, "LPAR color", BOLD | CENTRE | VCENTRE);
        ds.mergeCells(1, row, 10, row);
        ds.addLabel(1, row, "Colored cells >= " + this.COLOR_LEVEL * 100.0 + "% of total (yellows include reds)", BOLD);
        ++row;
        ds.mergeCells(0, ++row, to - from + 2, row);
        ds.addLabel(0, row, "Average LPAR Usage", BOLD | LEFT | VCENTRE | GREEN);
        ++row;
        ds.addLabel(0, ++row, "Days", BOLD | VCENTRE | CENTRE | B_ALL_MED);
        ds.addLabel(0, ++row, "Reds %", BOLD | VCENTRE | CENTRE | B_ALL_MED);
        ds.addLabel(0, ++row, "Yellows %", BOLD | VCENTRE | CENTRE | B_ALL_MED);
        ds.addLabel(0, ++row, "Over Cap %", BOLD | VCENTRE | CENTRE | B_ALL_MED);
        ds.addLabel(0, ++row, "Max", BOLD | VCENTRE | CENTRE | B_ALL_MED);
        ds.addLabel(0, ++row, "Avg", BOLD | VCENTRE | CENTRE | B_ALL_MED);
        ds.addLabel(0, ++row, "90% <=", BOLD | VCENTRE | CENTRE | B_ALL_MED);
        ds.addLabel(0, ++row, "95% <=", BOLD | VCENTRE | CENTRE | B_ALL_MED);
        ds.addLabel(0, ++row, "Last Ent", BOLD | VCENTRE | CENTRE | B_ALL_MED);
        ++row;
        ds.addLabel(0, ++row, "Date", BOLD | VCENTRE | CENTRE | B_ALL_MED);
        ++row;
        int i = 0;
        while (i < timeLabels.length) {
            s = timeLabels[i];
            ds.addLabel(0, row + i, s, BOLD | B_ALL_MED);
            ++i;
        }
        int[] red = new int[to - from + 1];
        int[] yellow = new int[red.length];
        int[] num = new int[red.length];
        int[] uncap = new int[red.length];
        i = from;
        while (i <= to) {
            j = 0;
            while (j < 365) {
                float f = this.lparPC[i].getDayData(j);
                float ent = this.lparEnt[i].getDayData(j);
                boolean cap = this.lparStatus[i].getDayCap(j);
                String ms = this.lparStatus[i].getDayMS(j);
                String pool = this.lparStatus[i].getDayPool(j);
                float vp = this.lparVP[i].getDayData(j);
                if (!(f < 0.0f)) {
                    float max;
                    float free;
                    if (pool.equals("DefaultPool")) {
                        free = this.msCoreConfig[this.getMSid(ms)].getDayData(j) - this.msCoreUsed[this.getMSid(ms)].getDayData(j);
                    } else {
                        int poolID = this.getProcPoolId(ms, pool);
                        free = this.procPoolConfig[poolID].getDayData(j) - this.procPoolUsed[poolID].getDayData(j);
                    }
                    if (cap) {
                        max = ent;
                    } else {
                        max = f + free >= vp ? vp : f + free;
                        if (max < ent) {
                            max = ent;
                        }
                    }
                    map = B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW;
                    if (f / max * 100.0f >= (float)this.R_LEVEL) {
                        map |= RED;
                        int n = i - from;
                        red[n] = red[n] + 1;
                        int n2 = i - from;
                        yellow[n2] = yellow[n2] + 1;
                    } else if (f / max * 100.0f >= (float)this.Y_LEVEL) {
                        map |= YELLOW;
                        int n = i - from;
                        yellow[n] = yellow[n] + 1;
                    }
                    int n = i - from;
                    num[n] = num[n] + 1;
                    if (f > ent) {
                        map |= BOLD;
                        int n3 = i - from;
                        uncap[n3] = uncap[n3] + 1;
                    }
                    ds.addFloat(1 + i - from, row + j, f, map);
                }
                ++j;
            }
            ++i;
        }
        i = from;
        while (i <= to) {
            s = this.lparNames[i];
            if (s.length() > size) {
                size = s.length();
            }
            map = BOLD | DIAG45 | B_ALL_MED;
            if (1.0 * (double)red[i - from] / (double)num[i - from] > this.COLOR_LEVEL) {
                map |= RED;
            } else if (1.0 * (double)yellow[i - from] / (double)num[i - from] > this.COLOR_LEVEL) {
                map |= YELLOW;
            }
            ds.addLabel(1 + i - from, row - 12, s, map);
            map = B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW;
            ds.addInteger(1 + i - from, row - 11, num[i - from], map);
            if (num[i - from] == 0) {
                map = B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW;
                ds.addFloat(1 + i - from, row - 10, 0.0, map);
                ds.addFloat(1 + i - from, row - 9, 0.0, map);
                ds.addFloat(1 + i - from, row - 8, 0.0, map);
                ds.addFloat(1 + i - from, row - 7, 0.0, map);
                ds.addFloat(1 + i - from, row - 6, 0.0, map);
                ds.addFloat(1 + i - from, row - 5, 0.0, map);
                ds.addFloat(1 + i - from, row - 4, 0.0, map);
                ds.addFloat(1 + i - from, row - 3, 0.0, map);
            } else {
                if (1.0 * (double)red[i - from] / (double)num[i - from] > this.COLOR_LEVEL) {
                    map |= RED;
                }
                ds.addFloat(1 + i - from, row - 10, 100.0 * (double)red[i - from] / (double)num[i - from], map);
                map = B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW;
                if (1.0 * (double)yellow[i - from] / (double)num[i - from] > this.COLOR_LEVEL) {
                    map |= YELLOW;
                }
                ds.addFloat(1 + i - from, row - 9, 100.0 * (double)yellow[i - from] / (double)num[i - from], map);
                map = B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW;
                ds.addFloat(1 + i - from, row - 8, 100.0 * (double)uncap[i - from] / (double)num[i - from], map);
                ds.addFloat(1 + i - from, row - 7, this.lparPC[i].getDailyMax(), B_RIGHT_LOW | B_BOTTOM_LOW | B_LEFT_LOW);
                ds.addFloat(1 + i - from, row - 6, this.lparPC[i].getDailyAvg(), B_RIGHT_LOW | B_BOTTOM_LOW | B_LEFT_LOW);
                ds.addFloat(1 + i - from, row - 5, this.lparPC[i].getDaily90p(), B_RIGHT_LOW | B_BOTTOM_LOW | B_LEFT_LOW);
                ds.addFloat(1 + i - from, row - 4, this.lparPC[i].getDaily95p(), B_RIGHT_LOW | B_BOTTOM_LOW | B_LEFT_LOW);
                j = 364;
                while (j >= 0) {
                    if (this.lparEnt[i].getDayData(j) > 0.0f) break;
                    --j;
                }
                if (j >= 0) {
                    ds.addFloat(1 + i - from, row - 3, this.lparEnt[i].getDayData(j), B_RIGHT_LOW | B_BOTTOM_LOW | B_LEFT_LOW);
                }
            }
            ++i;
        }
        ++row;
        row += 365;
        ++row;
        ds.setColSize(0, 12);
        i = 1;
        while (i <= to - from + 1) {
            ds.setColSize(i, 7);
            ++i;
        }
        return ds;
    }

    private void createLparHourlyUsageSheetExcel(WritableSheet sheet, int from, int to) {
        DataSheet ds = this.createLparHourlyUsageSheet(from, to);
        if (ds != null) {
            ds.createExcelSheet(sheet);
        }
    }

    private void createLparHourlyUsageSheetHTML(String fileName, int from, int to, int count) {
        DataSheet ds = this.createLparHourlyUsageSheet(from, to);
        if (ds != null) {
            ds.createHTMLSheet(fileName);
            this.addButton("LPAR Hourly N" + count, new File(fileName).getName());
        }
    }

    private void createLparHourlyUsageSheetCSV(String fileName, int from, int to, int count) {
        DataSheet ds = this.createLparHourlyUsageSheet(from, to);
        if (ds != null) {
            ds.setSeparator(this.csvSeparator);
            ds.createCSVSheet(fileName);
        }
    }

    private DataSheet createLparHourlyUsageSheet(int from, int to) {
        int j;
        String s;
        DataSheet ds = new DataSheet();
        int size = 0;
        int map = 0;
        String[] timeLabels = this.lparPC[from].getHourlyLabels();
        if (to > this.lparNames.length - 1) {
            to = this.lparNames.length - 1;
        }
        int row = 0;
        ds.addLabel(0, row, "Red", BOLD | CENTRE | VCENTRE | RED);
        ds.mergeCells(1, row, 10, row);
        ds.addLabel(1, row, "Usage >= " + this.R_LEVEL + "% of max allowed size", BOLD);
        ds.addLabel(0, ++row, "Yellow", BOLD | CENTRE | VCENTRE | YELLOW);
        ds.mergeCells(1, row, 10, row);
        ds.addLabel(1, row, "Usage >= " + this.Y_LEVEL + "% of max allowed size", BOLD);
        ds.addLabel(0, ++row, "Bold", BOLD | CENTRE | VCENTRE);
        ds.mergeCells(1, row, 10, row);
        ds.addLabel(1, row, "Usage > entitled capacity", BOLD);
        ds.addLabel(0, ++row, "LPAR color", BOLD | CENTRE | VCENTRE);
        ds.mergeCells(1, row, 10, row);
        ds.addLabel(1, row, "Colored cells >= " + this.COLOR_LEVEL * 100.0 + "% of total (yellows include reds)", BOLD);
        ++row;
        ds.mergeCells(0, ++row, to - from + 2, row);
        ds.addLabel(0, row, "Average LPAR Usage", BOLD | LEFT | VCENTRE | GREEN);
        ++row;
        ds.addLabel(0, ++row, "Hours", BOLD | VCENTRE | CENTRE | B_ALL_MED);
        ds.addLabel(0, ++row, "Reds %", BOLD | VCENTRE | CENTRE | B_ALL_MED);
        ds.addLabel(0, ++row, "Yellows %", BOLD | VCENTRE | CENTRE | B_ALL_MED);
        ds.addLabel(0, ++row, "Over Cap %", BOLD | VCENTRE | CENTRE | B_ALL_MED);
        ds.addLabel(0, ++row, "Max", BOLD | VCENTRE | CENTRE | B_ALL_MED);
        ds.addLabel(0, ++row, "Avg", BOLD | VCENTRE | CENTRE | B_ALL_MED);
        ds.addLabel(0, ++row, "90% <=", BOLD | VCENTRE | CENTRE | B_ALL_MED);
        ds.addLabel(0, ++row, "95% <=", BOLD | VCENTRE | CENTRE | B_ALL_MED);
        ds.addLabel(0, ++row, "Last Ent", BOLD | VCENTRE | CENTRE | B_ALL_MED);
        ++row;
        ds.addLabel(0, ++row, "Date", BOLD | VCENTRE | CENTRE | B_ALL_MED);
        ++row;
        int i = 0;
        while (i < timeLabels.length) {
            s = timeLabels[i];
            ds.addLabel(0, row + i, s, BOLD | B_ALL_MED);
            ++i;
        }
        int[] red = new int[to - from + 1];
        int[] yellow = new int[red.length];
        int[] num = new int[red.length];
        int[] uncap = new int[red.length];
        i = from;
        while (i <= to) {
            j = 0;
            while (j < 1440) {
                float f = this.lparPC[i].getHourData(j);
                float ent = this.lparEnt[i].getHourData(j);
                boolean cap = this.lparStatus[i].getHourCap(j);
                String ms = this.lparStatus[i].getHourMS(j);
                String pool = this.lparStatus[i].getHourPool(j);
                float vp = this.lparVP[i].getHourData(j);
                if (!(f < 0.0f) && !(ent <= 0.0f) && ms != null) {
                    float free;
                    if (pool.equals("DefaultPool")) {
                        free = this.msCoreConfig[this.getMSid(ms)].getHourData(j) - this.msCoreUsed[this.getMSid(ms)].getHourData(j);
                    } else {
                        int poolID = this.getProcPoolId(ms, pool);
                        free = this.procPoolConfig[poolID].getHourData(j) - this.procPoolUsed[poolID].getHourData(j);
                    }
                    float max = cap ? ent : (f + free >= vp ? vp : f + free);
                    map = B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW;
                    if (f / max * 100.0f >= (float)this.R_LEVEL) {
                        map |= RED;
                        int n = i - from;
                        red[n] = red[n] + 1;
                        int n2 = i - from;
                        yellow[n2] = yellow[n2] + 1;
                    } else if (f / max * 100.0f >= (float)this.Y_LEVEL) {
                        map |= YELLOW;
                        int n = i - from;
                        yellow[n] = yellow[n] + 1;
                    }
                    int n = i - from;
                    num[n] = num[n] + 1;
                    if (f > ent) {
                        map |= BOLD;
                        int n3 = i - from;
                        uncap[n3] = uncap[n3] + 1;
                    }
                    ds.addFloat(1 + i - from, row + j, f, map);
                }
                ++j;
            }
            ++i;
        }
        i = from;
        while (i <= to) {
            s = this.lparNames[i];
            if (s.length() > size) {
                size = s.length();
            }
            map = BOLD | DIAG45 | B_ALL_MED;
            if (1.0 * (double)red[i - from] / (double)num[i - from] > this.COLOR_LEVEL) {
                map |= RED;
            } else if (1.0 * (double)yellow[i - from] / (double)num[i - from] > this.COLOR_LEVEL) {
                map |= YELLOW;
            }
            ds.addLabel(1 + i - from, row - 12, s, map);
            map = B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW;
            ds.addInteger(1 + i - from, row - 11, num[i - from], map);
            if (num[i - from] == 0) {
                map = B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW;
                ds.addFloat(1 + i - from, row - 10, 0.0, map);
                ds.addFloat(1 + i - from, row - 9, 0.0, map);
                ds.addFloat(1 + i - from, row - 8, 0.0, map);
                ds.addFloat(1 + i - from, row - 7, 0.0, map);
                ds.addFloat(1 + i - from, row - 6, 0.0, map);
                ds.addFloat(1 + i - from, row - 5, 0.0, map);
                ds.addFloat(1 + i - from, row - 4, 0.0, map);
                ds.addFloat(1 + i - from, row - 3, 0.0, map);
            } else {
                if (1.0 * (double)red[i - from] / (double)num[i - from] > this.COLOR_LEVEL) {
                    map |= RED;
                }
                ds.addFloat(1 + i - from, row - 10, 100.0 * (double)red[i - from] / (double)num[i - from], map);
                map = B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW;
                if (1.0 * (double)yellow[i - from] / (double)num[i - from] > this.COLOR_LEVEL) {
                    map |= YELLOW;
                }
                ds.addFloat(1 + i - from, row - 9, 100.0 * (double)yellow[i - from] / (double)num[i - from], map);
                map = B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW;
                ds.addFloat(1 + i - from, row - 8, 100.0 * (double)uncap[i - from] / (double)num[i - from], map);
                ds.addFloat(1 + i - from, row - 7, this.lparPC[i].getHourlyMax(), B_RIGHT_LOW | B_BOTTOM_LOW | B_LEFT_LOW);
                ds.addFloat(1 + i - from, row - 6, this.lparPC[i].getHourlyAvg(), B_RIGHT_LOW | B_BOTTOM_LOW | B_LEFT_LOW);
                ds.addFloat(1 + i - from, row - 5, this.lparPC[i].getHourly90p(), B_RIGHT_LOW | B_BOTTOM_LOW | B_LEFT_LOW);
                ds.addFloat(1 + i - from, row - 4, this.lparPC[i].getHourly95p(), B_RIGHT_LOW | B_BOTTOM_LOW | B_LEFT_LOW);
                j = 1439;
                while (j >= 0) {
                    if (this.lparEnt[i].getHourData(j) > 0.0f) break;
                    --j;
                }
                ds.addFloat(1 + i - from, row - 3, this.lparEnt[i].getHourData(j), B_RIGHT_LOW | B_BOTTOM_LOW | B_LEFT_LOW);
            }
            ++i;
        }
        ++row;
        row += 1440;
        ++row;
        ds.setColSize(0, 15);
        i = 1;
        while (i <= to - from + 1) {
            ds.setColSize(i, 7);
            ++i;
        }
        return ds;
    }

    private void createSysPoolHourlyUsageSheetExcel(WritableSheet sheet) {
        DataSheet ds = this.createSysPoolHourlyUsageSheet();
        if (ds == null) {
            return;
        }
        ds.createExcelSheet(sheet);
    }

    private void createSysPoolHourlyUsageSheetHTML(String fileName) {
        DataSheet ds = this.createSysPoolHourlyUsageSheet();
        if (ds == null) {
            return;
        }
        ds.createHTMLSheet(fileName);
        this.addButton("CPU Pool Hourly", new File(fileName).getName());
    }

    private void createSysPoolHourlyUsageSheetCSV(String fileName) {
        DataSheet ds = this.createSysPoolHourlyUsageSheet();
        if (ds == null) {
            return;
        }
        ds.setSeparator(this.csvSeparator);
        ds.createCSVSheet(fileName);
    }

    private DataSheet createSysPoolHourlyUsageSheet() {
        int map;
        float f2;
        float f;
        int j;
        String s;
        int[] num;
        int[] yellow;
        int[] red;
        DataSheet ds = new DataSheet();
        String[] timeLabels = this.msCoreUsed[0].getHourlyLabels();
        int row = 0;
        ds.addLabel(0, row, "Red", BOLD | CENTRE | VCENTRE | RED);
        ds.mergeCells(1, row, 10, row);
        ds.addLabel(1, row, "Usage >= " + this.R_LEVEL + "% of max allowed size", BOLD);
        ds.addLabel(0, ++row, "Yellow", BOLD | CENTRE | VCENTRE | YELLOW);
        ds.mergeCells(1, row, 10, row);
        ds.addLabel(1, row, "Usage >= " + this.Y_LEVEL + "% of max allowed size", BOLD);
        ds.addLabel(0, ++row, "Pool color", BOLD | CENTRE | VCENTRE);
        ds.mergeCells(1, row, 10, row);
        ds.addLabel(1, row, "Colored cells >= " + this.COLOR_LEVEL * 100.0 + "% of total (yellows include reds)", BOLD);
        ++row;
        int cells = this.procPoolName != null ? this.managedSystem.length + 1 + this.procPoolName.length : this.managedSystem.length + 1;
        ds.mergeCells(0, ++row, cells, row);
        ds.addLabel(0, row, "Average Pool Usage", BOLD | CENTRE | VCENTRE | GREEN);
        ++row;
        if (this.procPoolName != null) {
            red = new int[this.managedSystem.length + this.procPoolName.length];
            yellow = new int[red.length];
            num = new int[red.length];
        } else {
            red = new int[this.managedSystem.length];
            yellow = new int[red.length];
            num = new int[red.length];
        }
        ds.addLabel(0, ++row, "Hours", BOLD | VCENTRE | CENTRE | B_ALL_MED);
        ds.addLabel(0, ++row, "Reds %", BOLD | VCENTRE | CENTRE | B_ALL_MED);
        ds.addLabel(0, ++row, "Yellows %", BOLD | VCENTRE | CENTRE | B_ALL_MED);
        ds.addLabel(0, ++row, "Max", BOLD | VCENTRE | CENTRE | B_ALL_MED);
        ds.addLabel(0, ++row, "Avg", BOLD | VCENTRE | CENTRE | B_ALL_MED);
        ds.addLabel(0, ++row, "90% <=", BOLD | VCENTRE | CENTRE | B_ALL_MED);
        ds.addLabel(0, ++row, "95% <=", BOLD | VCENTRE | CENTRE | B_ALL_MED);
        ds.addLabel(0, ++row, "Last size", BOLD | VCENTRE | CENTRE | B_ALL_MED);
        ++row;
        ds.addLabel(0, ++row, "Date", BOLD | VCENTRE | CENTRE | B_ALL_MED);
        ++row;
        int i = 0;
        while (i < timeLabels.length) {
            s = timeLabels[i];
            ds.addLabel(0, row + i, s, BOLD | B_ALL_MED);
            ++i;
        }
        i = 0;
        while (i < this.managedSystem.length) {
            num[i] = 0;
            yellow[i] = 0;
            red[i] = 0;
            j = 0;
            while (j < 1440) {
                f = this.msCoreUsed[i].getHourData(j);
                f2 = this.msCoreConfig[i].getHourData(j);
                if (!(f < 0.0f) && !(f2 <= 0.0f)) {
                    f2 = f / f2 * 100.0f;
                    int n = i;
                    num[n] = num[n] + 1;
                    map = B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW;
                    if (f2 >= (float)this.R_LEVEL) {
                        map |= RED;
                        int n2 = i;
                        yellow[n2] = yellow[n2] + 1;
                        int n3 = i;
                        red[n3] = red[n3] + 1;
                    } else if (f2 >= (float)this.Y_LEVEL) {
                        map |= YELLOW;
                        int n4 = i;
                        yellow[n4] = yellow[n4] + 1;
                    }
                    ds.addFloat(1 + i, row + j, f, map);
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (this.procPoolName != null && i < this.procPoolName.length) {
            num[this.managedSystem.length + i] = 0;
            yellow[this.managedSystem.length + i] = 0;
            red[this.managedSystem.length + i] = 0;
            j = 0;
            while (j < 1440) {
                f = this.procPoolUsed[i].getHourData(j);
                f2 = this.procPoolConfig[i].getHourData(j);
                if (!(f < 0.0f) && !(f2 <= 0.0f)) {
                    f2 = f / f2 * 100.0f;
                    int n = this.managedSystem.length + i;
                    num[n] = num[n] + 1;
                    map = B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW;
                    if (f2 >= (float)this.R_LEVEL) {
                        map |= RED;
                        int n5 = this.managedSystem.length + i;
                        yellow[n5] = yellow[n5] + 1;
                        int n6 = this.managedSystem.length + i;
                        red[n6] = red[n6] + 1;
                    } else if (f2 >= (float)this.Y_LEVEL) {
                        map |= YELLOW;
                        int n7 = this.managedSystem.length + i;
                        yellow[n7] = yellow[n7] + 1;
                    }
                    ds.addFloat(this.managedSystem.length + 2 + i, row + j, f, map);
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.managedSystem.length) {
            s = this.managedSystem[i].getVarValues("name")[0];
            map = BOLD | DIAG45 | B_ALL_MED;
            if (1.0 * (double)red[i] / (double)num[i] > this.COLOR_LEVEL) {
                map |= RED;
            } else if (1.0 * (double)yellow[i] / (double)num[i] > this.COLOR_LEVEL) {
                map |= YELLOW;
            }
            ds.addLabel(1 + i, row - 11, s, map);
            ++i;
        }
        i = 0;
        while (this.procPoolName != null && i < this.procPoolName.length) {
            s = this.procPoolName[i];
            map = BOLD | DIAG45 | B_ALL_MED | WRAP;
            if (1.0 * (double)red[this.managedSystem.length + i] / (double)num[this.managedSystem.length + i] > this.COLOR_LEVEL) {
                map |= RED;
            } else if (1.0 * (double)yellow[this.managedSystem.length + i] / (double)num[this.managedSystem.length + i] > this.COLOR_LEVEL) {
                map |= YELLOW;
            }
            ds.addLabel(this.managedSystem.length + 2 + i, row - 11, s, map);
            ++i;
        }
        i = 0;
        while (i < this.managedSystem.length) {
            map = B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW;
            ds.addInteger(1 + i, row - 10, num[i], map);
            if (num[i] == 0) {
                ds.addInteger(1 + i, row - 9, 0.0, map);
                ds.addInteger(1 + i, row - 8, 0.0, map);
                ds.addInteger(1 + i, row - 7, 0.0, map);
                ds.addInteger(1 + i, row - 6, 0.0, map);
                ds.addInteger(1 + i, row - 5, 0.0, map);
                ds.addInteger(1 + i, row - 4, 0.0, map);
                ds.addInteger(1 + i, row - 3, 0.0, map);
            } else {
                if (1.0 * (double)red[i] / (double)num[i] > this.COLOR_LEVEL) {
                    map |= RED;
                }
                ds.addFloat(1 + i, row - 9, 100.0 * (double)red[i] / (double)num[i], map);
                map = B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW;
                if (1.0 * (double)yellow[i] / (double)num[i] > this.COLOR_LEVEL) {
                    map |= YELLOW;
                }
                ds.addFloat(1 + i, row - 8, 100.0 * (double)yellow[i] / (double)num[i], map);
                ds.addFloat(1 + i, row - 7, this.msCoreUsed[i].getHourlyMax(), B_RIGHT_LOW | B_BOTTOM_LOW | B_LEFT_LOW);
                ds.addFloat(1 + i, row - 6, this.msCoreUsed[i].getHourlyAvg(), B_RIGHT_LOW | B_BOTTOM_LOW | B_LEFT_LOW);
                ds.addFloat(1 + i, row - 5, this.msCoreUsed[i].getHourly90p(), B_RIGHT_LOW | B_BOTTOM_LOW | B_LEFT_LOW);
                ds.addFloat(1 + i, row - 4, this.msCoreUsed[i].getHourly95p(), B_RIGHT_LOW | B_BOTTOM_LOW | B_LEFT_LOW);
                j = 1439;
                while (j >= 0) {
                    if (this.msCoreConfig[i].getHourData(j) > 0.0f) break;
                    --j;
                }
                ds.addInteger(1 + i, row - 3, this.msCoreConfig[i].getHourData(j), B_RIGHT_LOW | B_BOTTOM_LOW | B_LEFT_LOW);
            }
            ++i;
        }
        i = 0;
        while (this.procPoolName != null && i < this.procPoolName.length) {
            map = B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW;
            ds.addInteger(this.managedSystem.length + 2 + i, row - 10, num[this.managedSystem.length + i], map);
            if (num[this.managedSystem.length + i] == 0) {
                ds.addInteger(this.managedSystem.length + 2 + i, row - 9, 0.0, map);
                ds.addInteger(this.managedSystem.length + 2 + i, row - 8, 0.0, map);
                ds.addInteger(this.managedSystem.length + 2 + i, row - 7, 0.0, map);
                ds.addInteger(this.managedSystem.length + 2 + i, row - 6, 0.0, map);
                ds.addInteger(this.managedSystem.length + 2 + i, row - 5, 0.0, map);
                ds.addInteger(this.managedSystem.length + 2 + i, row - 4, 0.0, map);
                ds.addInteger(this.managedSystem.length + 2 + i, row - 3, 0.0, map);
            } else {
                if (1.0 * (double)red[this.managedSystem.length + i] / (double)num[this.managedSystem.length + i] > this.COLOR_LEVEL) {
                    map |= RED;
                }
                ds.addFloat(this.managedSystem.length + 2 + i, row - 9, 100.0 * (double)red[this.managedSystem.length + i] / (double)num[this.managedSystem.length + i], map);
                map = B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW;
                if (1.0 * (double)yellow[this.managedSystem.length + i] / (double)num[this.managedSystem.length + i] > this.COLOR_LEVEL) {
                    map |= YELLOW;
                }
                ds.addFloat(this.managedSystem.length + 2 + i, row - 8, 100.0 * (double)yellow[this.managedSystem.length + i] / (double)num[this.managedSystem.length + i], map);
                ds.addFloat(this.managedSystem.length + 2 + i, row - 7, this.procPoolUsed[i].getHourlyMax(), B_RIGHT_LOW | B_BOTTOM_LOW | B_LEFT_LOW);
                ds.addFloat(this.managedSystem.length + 2 + i, row - 6, this.procPoolUsed[i].getHourlyAvg(), B_RIGHT_LOW | B_BOTTOM_LOW | B_LEFT_LOW);
                ds.addFloat(this.managedSystem.length + 2 + i, row - 5, this.procPoolUsed[i].getHourly90p(), B_RIGHT_LOW | B_BOTTOM_LOW | B_LEFT_LOW);
                ds.addFloat(this.managedSystem.length + 2 + i, row - 4, this.procPoolUsed[i].getHourly95p(), B_RIGHT_LOW | B_BOTTOM_LOW | B_LEFT_LOW);
                j = 1439;
                while (j >= 0) {
                    if (this.procPoolConfig[i].getHourData(j) > 0.0f) break;
                    --j;
                }
                ds.addInteger(this.managedSystem.length + 2 + i, row - 3, this.procPoolConfig[i].getHourData(j), B_RIGHT_LOW | B_BOTTOM_LOW | B_LEFT_LOW);
            }
            ++i;
        }
        ++row;
        row += 1440;
        ++row;
        ds.setColSize(0, 15);
        i = 1;
        while (i <= this.managedSystem.length) {
            ds.setColSize(i, 8);
            ++i;
        }
        return ds;
    }

    private void createSysPoolDailyUsageSheetExcel(WritableSheet sheet) {
        DataSheet ds = this.createSysPoolDailyUsageSheet();
        if (ds != null) {
            ds.createExcelSheet(sheet);
        }
    }

    private void createSysPoolDailyUsageSheetHTML(String fileName) {
        DataSheet ds = this.createSysPoolDailyUsageSheet();
        if (ds != null) {
            ds.createHTMLSheet(fileName);
            this.addButton("CPU Pool Daily", new File(fileName).getName());
        }
    }

    private void createSysPoolDailyUsageSheetCSV(String fileName) {
        DataSheet ds = this.createSysPoolDailyUsageSheet();
        if (ds != null) {
            ds.setSeparator(this.csvSeparator);
            ds.createCSVSheet(fileName);
        }
    }

    private DataSheet createSysPoolDailyUsageSheet() {
        int map;
        float f2;
        float f;
        int j;
        String s;
        int[] num;
        int[] yellow;
        int[] red;
        DataSheet ds = new DataSheet();
        String[] timeLabels = this.msCoreUsed[0].getDailyLabels();
        int row = 0;
        ds.addLabel(0, row, "Red", BOLD | CENTRE | VCENTRE | RED);
        ds.mergeCells(1, row, 10, row);
        ds.addLabel(1, row, "Usage >= " + this.R_LEVEL + "% of max allowed size", BOLD);
        ds.addLabel(0, ++row, "Yellow", BOLD | CENTRE | VCENTRE | YELLOW);
        ds.mergeCells(1, row, 10, row);
        ds.addLabel(1, row, "Usage >= " + this.Y_LEVEL + "% of max allowed size", BOLD);
        ds.addLabel(0, ++row, "Pool color", BOLD | CENTRE | VCENTRE);
        ds.mergeCells(1, row, 10, row);
        ds.addLabel(1, row, "Colored cells >= " + this.COLOR_LEVEL * 100.0 + "% of total (yellows include reds)", BOLD);
        ++row;
        int cells = this.procPoolName != null ? this.managedSystem.length + 1 + this.procPoolName.length : this.managedSystem.length + 1;
        ds.mergeCells(0, ++row, cells, row);
        ds.addLabel(0, row, "Average Pool Usage", BOLD | CENTRE | VCENTRE | GREEN);
        ++row;
        if (this.procPoolName != null) {
            red = new int[this.managedSystem.length + this.procPoolName.length];
            yellow = new int[red.length];
            num = new int[red.length];
        } else {
            red = new int[this.managedSystem.length];
            yellow = new int[red.length];
            num = new int[red.length];
        }
        ds.addLabel(0, ++row, "Days", BOLD | VCENTRE | CENTRE | B_ALL_MED);
        ds.addLabel(0, ++row, "Reds %", BOLD | VCENTRE | CENTRE | B_ALL_MED);
        ds.addLabel(0, ++row, "Yellows %", BOLD | VCENTRE | CENTRE | B_ALL_MED);
        ds.addLabel(0, ++row, "Max", BOLD | VCENTRE | CENTRE | B_ALL_MED);
        ds.addLabel(0, ++row, "Avg", BOLD | VCENTRE | CENTRE | B_ALL_MED);
        ds.addLabel(0, ++row, "90% <=", BOLD | VCENTRE | CENTRE | B_ALL_MED);
        ds.addLabel(0, ++row, "95% <=", BOLD | VCENTRE | CENTRE | B_ALL_MED);
        ds.addLabel(0, ++row, "Last size", BOLD | VCENTRE | CENTRE | B_ALL_MED);
        ++row;
        ds.addLabel(0, ++row, "Date", BOLD | VCENTRE | CENTRE | B_ALL_MED);
        ++row;
        int i = 0;
        while (i < timeLabels.length) {
            s = timeLabels[i];
            ds.addLabel(0, row + i, s, BOLD | B_ALL_MED);
            ++i;
        }
        i = 0;
        while (i < this.managedSystem.length) {
            num[i] = 0;
            yellow[i] = 0;
            red[i] = 0;
            j = 0;
            while (j < 365) {
                f = this.msCoreUsed[i].getDayData(j);
                f2 = this.msCoreConfig[i].getDayData(j);
                if (!(f < 0.0f) && !(f2 <= 0.0f)) {
                    f2 = f / f2 * 100.0f;
                    int n = i;
                    num[n] = num[n] + 1;
                    map = B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW;
                    if (f2 >= (float)this.R_LEVEL) {
                        map |= RED;
                        int n2 = i;
                        yellow[n2] = yellow[n2] + 1;
                        int n3 = i;
                        red[n3] = red[n3] + 1;
                    } else if (f2 >= (float)this.Y_LEVEL) {
                        map |= YELLOW;
                        int n4 = i;
                        yellow[n4] = yellow[n4] + 1;
                    }
                    ds.addFloat(1 + i, row + j, f, map);
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (this.procPoolName != null && i < this.procPoolName.length) {
            num[this.managedSystem.length + i] = 0;
            yellow[this.managedSystem.length + i] = 0;
            red[this.managedSystem.length + i] = 0;
            j = 0;
            while (j < 365) {
                f = this.procPoolUsed[i].getDayData(j);
                f2 = this.procPoolConfig[i].getDayData(j);
                if (!(f < 0.0f) && !(f2 <= 0.0f)) {
                    f2 = f / f2 * 100.0f;
                    int n = this.managedSystem.length + i;
                    num[n] = num[n] + 1;
                    map = B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW;
                    if (f2 >= (float)this.R_LEVEL) {
                        map |= RED;
                        int n5 = this.managedSystem.length + i;
                        yellow[n5] = yellow[n5] + 1;
                        int n6 = this.managedSystem.length + i;
                        red[n6] = red[n6] + 1;
                    } else if (f2 >= (float)this.Y_LEVEL) {
                        map |= YELLOW;
                        int n7 = this.managedSystem.length + i;
                        yellow[n7] = yellow[n7] + 1;
                    }
                    ds.addFloat(this.managedSystem.length + 2 + i, row + j, f, map);
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.managedSystem.length) {
            s = this.managedSystem[i].getVarValues("name")[0];
            map = BOLD | DIAG45 | B_ALL_MED;
            if (1.0 * (double)red[i] / (double)num[i] > this.COLOR_LEVEL) {
                map |= RED;
            } else if (1.0 * (double)yellow[i] / (double)num[i] > this.COLOR_LEVEL) {
                map |= YELLOW;
            }
            ds.addLabel(1 + i, row - 11, s, map);
            ++i;
        }
        i = 0;
        while (this.procPoolName != null && i < this.procPoolName.length) {
            s = this.procPoolName[i];
            map = BOLD | DIAG45 | B_ALL_MED | WRAP;
            if (1.0 * (double)red[this.managedSystem.length + i] / (double)num[this.managedSystem.length + i] > this.COLOR_LEVEL) {
                map |= RED;
            } else if (1.0 * (double)yellow[this.managedSystem.length + i] / (double)num[this.managedSystem.length + i] > this.COLOR_LEVEL) {
                map |= YELLOW;
            }
            ds.addLabel(this.managedSystem.length + 2 + i, row - 11, s, map);
            ++i;
        }
        i = 0;
        while (i < this.managedSystem.length) {
            map = B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW;
            ds.addInteger(1 + i, row - 10, num[i], map);
            if (num[i] == 0) {
                ds.addInteger(1 + i, row - 9, 0.0, map);
                ds.addInteger(1 + i, row - 8, 0.0, map);
                ds.addInteger(1 + i, row - 7, 0.0, map);
                ds.addInteger(1 + i, row - 6, 0.0, map);
                ds.addInteger(1 + i, row - 5, 0.0, map);
                ds.addInteger(1 + i, row - 4, 0.0, map);
                ds.addInteger(1 + i, row - 3, 0.0, map);
            } else {
                if (1.0 * (double)red[i] / (double)num[i] > this.COLOR_LEVEL) {
                    map |= RED;
                }
                ds.addFloat(1 + i, row - 9, 100.0 * (double)red[i] / (double)num[i], map);
                map = B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW;
                if (1.0 * (double)yellow[i] / (double)num[i] > this.COLOR_LEVEL) {
                    map |= YELLOW;
                }
                ds.addFloat(1 + i, row - 8, 100.0 * (double)yellow[i] / (double)num[i], map);
                ds.addFloat(1 + i, row - 7, this.msCoreUsed[i].getDailyMax(), B_RIGHT_LOW | B_BOTTOM_LOW | B_LEFT_LOW);
                ds.addFloat(1 + i, row - 6, this.msCoreUsed[i].getDailyAvg(), B_RIGHT_LOW | B_BOTTOM_LOW | B_LEFT_LOW);
                ds.addFloat(1 + i, row - 5, this.msCoreUsed[i].getDaily90p(), B_RIGHT_LOW | B_BOTTOM_LOW | B_LEFT_LOW);
                ds.addFloat(1 + i, row - 4, this.msCoreUsed[i].getDaily95p(), B_RIGHT_LOW | B_BOTTOM_LOW | B_LEFT_LOW);
                j = 364;
                while (j >= 0) {
                    if (this.msCoreConfig[i].getDayData(j) > 0.0f) break;
                    --j;
                }
                ds.addInteger(1 + i, row - 3, this.msCoreConfig[i].getDayData(j), B_RIGHT_LOW | B_BOTTOM_LOW | B_LEFT_LOW);
            }
            ++i;
        }
        i = 0;
        while (this.procPoolName != null && i < this.procPoolName.length) {
            map = B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW;
            ds.addInteger(this.managedSystem.length + 2 + i, row - 10, num[this.managedSystem.length + i], map);
            if (num[this.managedSystem.length + i] == 0) {
                ds.addInteger(this.managedSystem.length + 2 + i, row - 9, 0.0, map);
                ds.addInteger(this.managedSystem.length + 2 + i, row - 8, 0.0, map);
                ds.addInteger(this.managedSystem.length + 2 + i, row - 7, 0.0, map);
                ds.addInteger(this.managedSystem.length + 2 + i, row - 6, 0.0, map);
                ds.addInteger(this.managedSystem.length + 2 + i, row - 5, 0.0, map);
                ds.addInteger(this.managedSystem.length + 2 + i, row - 4, 0.0, map);
                ds.addInteger(this.managedSystem.length + 2 + i, row - 3, 0.0, map);
            } else {
                if (1.0 * (double)red[this.managedSystem.length + i] / (double)num[this.managedSystem.length + i] > this.COLOR_LEVEL) {
                    map |= RED;
                }
                ds.addFloat(this.managedSystem.length + 2 + i, row - 9, 100.0 * (double)red[this.managedSystem.length + i] / (double)num[this.managedSystem.length + i], map);
                map = B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW;
                if (1.0 * (double)yellow[this.managedSystem.length + i] / (double)num[this.managedSystem.length + i] > this.COLOR_LEVEL) {
                    map |= YELLOW;
                }
                ds.addFloat(this.managedSystem.length + 2 + i, row - 8, 100.0 * (double)yellow[this.managedSystem.length + i] / (double)num[this.managedSystem.length + i], map);
                ds.addFloat(this.managedSystem.length + 2 + i, row - 7, this.procPoolUsed[i].getDailyMax(), B_RIGHT_LOW | B_BOTTOM_LOW | B_LEFT_LOW);
                ds.addFloat(this.managedSystem.length + 2 + i, row - 6, this.procPoolUsed[i].getDailyAvg(), B_RIGHT_LOW | B_BOTTOM_LOW | B_LEFT_LOW);
                ds.addFloat(this.managedSystem.length + 2 + i, row - 5, this.procPoolUsed[i].getDaily90p(), B_RIGHT_LOW | B_BOTTOM_LOW | B_LEFT_LOW);
                ds.addFloat(this.managedSystem.length + 2 + i, row - 4, this.procPoolUsed[i].getDaily95p(), B_RIGHT_LOW | B_BOTTOM_LOW | B_LEFT_LOW);
                j = 364;
                while (j >= 0) {
                    if (this.procPoolConfig[i].getDayData(j) > 0.0f) break;
                    --j;
                }
                ds.addInteger(this.managedSystem.length + 2 + i, row - 3, this.procPoolConfig[i].getDayData(j), B_RIGHT_LOW | B_BOTTOM_LOW | B_LEFT_LOW);
            }
            ++i;
        }
        row += 365;
        ++row;
        ds.setColSize(0, 12);
        i = 1;
        while (i <= this.managedSystem.length) {
            ds.setColSize(i, 8);
            ++i;
        }
        return ds;
    }

    private void createSysPoolUsageSheetExcel(WritableSheet sheet) {
        DataSheet ds = this.createSysPoolUsageSheet();
        if (ds != null) {
            ds.createExcelSheet(sheet);
        }
    }

    private void createSysPoolUsageSheetHTML(String fileName) {
        DataSheet ds = this.createSysPoolUsageSheet();
        if (ds != null) {
            ds.createHTMLSheet(fileName);
            this.addButton("CPU Pool Usage", new File(fileName).getName());
        }
    }

    private void createSysPoolUsageSheetCSV(String fileName) {
        DataSheet ds = this.createSysPoolUsageSheet();
        if (ds != null) {
            ds.setSeparator(this.csvSeparator);
            ds.createCSVSheet(fileName);
        }
    }

    private DataSheet createSysPoolUsageSheet() {
        double f2;
        double f;
        int j;
        int red;
        int yellow;
        int num;
        String s;
        DataSheet ds = new DataSheet();
        int size = 0;
        int map = 0;
        String[] timeLabels = this.msCoreUsed[0].getMonthlyLabels();
        int row = 0;
        ds.addLabel(0, row, "Red", BOLD | CENTRE | VCENTRE | RED);
        ds.mergeCells(1, row, 10, row);
        ds.addLabel(1, row, "Usage >= " + this.R_LEVEL + "% of max allowed size", BOLD);
        ds.addLabel(0, ++row, "Yellow", BOLD | CENTRE | VCENTRE | YELLOW);
        ds.mergeCells(1, row, 10, row);
        ds.addLabel(1, row, "Usage >= " + this.Y_LEVEL + "% of max allowed size", BOLD);
        ds.addLabel(0, ++row, "Pool color", BOLD | CENTRE | VCENTRE);
        ds.mergeCells(1, row, 10, row);
        ds.addLabel(1, row, "Colored cells >= " + this.COLOR_LEVEL * 100.0 + "% of total (yellows include reds)", BOLD);
        ++row;
        ds.mergeCells(0, ++row, 13, row);
        ds.addLabel(0, row, "Average Pool Usage", BOLD | CENTRE | VCENTRE | GREEN);
        ds.mergeCells(15, row, 28, row);
        ds.addLabel(15, row, "Average Percentage Pool Usage", BOLD | CENTRE | VCENTRE | GREEN);
        ++row;
        int i = 0;
        while (i < timeLabels.length) {
            s = timeLabels[i];
            ds.addLabel(1 + i, row, s, BOLD | B_ALL_MED);
            ds.addLabel(16 + i, row, s, BOLD | B_ALL_MED);
            ++i;
        }
        ++row;
        i = 0;
        while (i < this.managedSystem.length) {
            s = this.managedSystem[i].getVarValues("name")[0];
            if (s.length() > size) {
                size = s.length();
            }
            num = 0;
            yellow = 0;
            red = 0;
            j = 0;
            while (j < timeLabels.length) {
                f = this.msCoreUsed[i].getMonthData(j);
                f2 = this.msCoreConfig[i].getMonthData(j);
                if (!(f < 0.0) && !(f2 <= 0.0)) {
                    f2 = f / f2 * 100.0;
                    ++num;
                    map = B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW;
                    if (f2 >= (double)this.R_LEVEL) {
                        map |= RED;
                        ++yellow;
                        ++red;
                    } else if (f2 >= (double)this.Y_LEVEL) {
                        map |= YELLOW;
                        ++yellow;
                    }
                    ds.addFloat(1 + j, row + i, f, map);
                    ds.addFloat(16 + j, row + i, f2, map);
                }
                ++j;
            }
            map = BOLD | VCENTRE | CENTRE | B_ALL_MED;
            if (1.0 * (double)red / (double)num > this.COLOR_LEVEL) {
                map |= RED;
            } else if (1.0 * (double)yellow / (double)num > this.COLOR_LEVEL) {
                map |= YELLOW;
            }
            ds.addLabel(0, row + i, s, map);
            ds.addLabel(15, row + i, s, map);
            ++i;
        }
        row += i;
        ds.mergeCells(0, ++row, 13, row);
        ds.addLabel(0, row, "Peak Pool Usage", BOLD | CENTRE | VCENTRE | GREEN);
        ds.mergeCells(15, row, 28, row);
        ds.addLabel(15, row, "Peak Percentage Pool Usage", BOLD | CENTRE | VCENTRE | GREEN);
        ++row;
        i = 0;
        while (i < timeLabels.length) {
            s = timeLabels[i];
            ds.addLabel(1 + i, row, s, BOLD | B_ALL_MED);
            ds.addLabel(16 + i, row, s, BOLD | B_ALL_MED);
            ++i;
        }
        ++row;
        i = 0;
        while (i < this.managedSystem.length) {
            s = this.managedSystem[i].getVarValues("name")[0];
            if (s.length() > size) {
                size = s.length();
            }
            num = 0;
            yellow = 0;
            red = 0;
            j = 0;
            while (j < timeLabels.length) {
                f = this.msCoreUsed[i].getMonthlyMax(j);
                f2 = this.msCoreConfig[i].getMonthlyMax(j);
                if (!(f < 0.0) && !(f2 <= 0.0)) {
                    f2 = f / f2 * 100.0;
                    ++num;
                    map = B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW;
                    if (f2 >= (double)this.R_LEVEL) {
                        map |= RED;
                        ++yellow;
                        ++red;
                    } else if (f2 >= (double)this.Y_LEVEL) {
                        map |= YELLOW;
                        ++yellow;
                    }
                    ds.addFloat(1 + j, row + i, f, map);
                    ds.addFloat(16 + j, row + i, f2, map);
                }
                ++j;
            }
            map = BOLD | VCENTRE | CENTRE | B_ALL_MED;
            if (1.0 * (double)red / (double)num > this.COLOR_LEVEL) {
                map |= RED;
            } else if (1.0 * (double)yellow / (double)num > this.COLOR_LEVEL) {
                map |= YELLOW;
            }
            ds.addLabel(0, row + i, s, map);
            ds.addLabel(15, row + i, s, map);
            ++i;
        }
        row += i;
        ds.mergeCells(0, ++row, 13, row);
        ds.addLabel(0, row, "Average Pool Size", BOLD | CENTRE | VCENTRE | GREEN);
        ++row;
        i = 0;
        while (i < timeLabels.length) {
            s = timeLabels[i];
            ds.addLabel(1 + i, row, s, BOLD | B_ALL_MED);
            ++i;
        }
        ++row;
        i = 0;
        while (i < this.managedSystem.length) {
            s = this.managedSystem[i].getVarValues("name")[0];
            if (s.length() > size) {
                size = s.length();
            }
            ds.addLabel(0, row + i, s, BOLD | VCENTRE | CENTRE | B_ALL_MED);
            j = 0;
            while (j < timeLabels.length) {
                f = this.msCoreConfig[i].getMonthlyAvg(j);
                if (f >= 0.0) {
                    ds.addFloat(1 + j, row + i, f, B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW);
                }
                ++j;
            }
            ++i;
        }
        row += i;
        ds.mergeCells(0, ++row, 13, row);
        ds.addLabel(0, row, "Average Pool Unassigned", BOLD | CENTRE | VCENTRE | GREEN);
        ++row;
        i = 0;
        while (i < timeLabels.length) {
            s = timeLabels[i];
            ds.addLabel(1 + i, row, s, BOLD | B_ALL_MED);
            ++i;
        }
        ++row;
        i = 0;
        while (i < this.managedSystem.length) {
            s = this.managedSystem[i].getVarValues("name")[0];
            if (s.length() > size) {
                size = s.length();
            }
            ds.addLabel(0, row + i, s, BOLD | VCENTRE | CENTRE | B_ALL_MED);
            j = 0;
            while (j < timeLabels.length) {
                f = this.msCoreAvail[i].getMonthlyAvg(j);
                if (f >= 0.0) {
                    ds.addFloat(1 + j, row + i, f, B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW);
                }
                ++j;
            }
            ++i;
        }
        row += i;
        ds.mergeCells(0, ++row, 13, row);
        ds.addLabel(0, row, "Average Virtual Pool Usage", BOLD | CENTRE | VCENTRE | GREEN);
        ds.mergeCells(15, row, 28, row);
        ds.addLabel(15, row, "Average Percentage Virtual Pool Usage", BOLD | CENTRE | VCENTRE | GREEN);
        ++row;
        i = 0;
        while (i < timeLabels.length) {
            s = timeLabels[i];
            ds.addLabel(1 + i, row, s, BOLD | B_ALL_MED);
            ds.addLabel(16 + i, row, s, BOLD | B_ALL_MED);
            ++i;
        }
        ++row;
        i = 0;
        while (this.procPoolName != null && i < this.procPoolName.length) {
            s = this.procPoolName[i];
            num = 0;
            yellow = 0;
            red = 0;
            j = 0;
            while (j < timeLabels.length) {
                f = this.procPoolUsed[i].getMonthlyAvg(j);
                f2 = this.procPoolConfig[i].getMonthlyAvg(j);
                if (!(f < 0.0) && !(f2 <= 0.0)) {
                    f2 = f / f2 * 100.0;
                    ++num;
                    map = B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW;
                    if (f2 >= (double)this.R_LEVEL) {
                        map |= RED;
                        ++yellow;
                        ++red;
                    } else if (f2 >= (double)this.Y_LEVEL) {
                        map |= YELLOW;
                        ++yellow;
                    }
                    ds.addFloat(1 + j, row + i, f, map);
                    ds.addFloat(16 + j, row + i, f2, map);
                }
                ++j;
            }
            map = BOLD | VCENTRE | CENTRE | B_ALL_MED | WRAP;
            if (1.0 * (double)red / (double)num > this.COLOR_LEVEL) {
                map |= RED;
            } else if (1.0 * (double)yellow / (double)num > this.COLOR_LEVEL) {
                map |= YELLOW;
            }
            ds.addLabel(0, row + i, s, map);
            ds.addLabel(15, row + i, s, map);
            ++i;
        }
        row += i;
        ds.mergeCells(0, ++row, 13, row);
        ds.addLabel(0, row, "Peak Virtual Pool Usage", BOLD | CENTRE | VCENTRE | GREEN);
        ds.mergeCells(15, row, 28, row);
        ds.addLabel(15, row, "Peak Percentage Virtual Pool Usage", BOLD | CENTRE | VCENTRE | GREEN);
        ++row;
        i = 0;
        while (i < timeLabels.length) {
            s = timeLabels[i];
            ds.addLabel(1 + i, row, s, BOLD | B_ALL_MED);
            ds.addLabel(16 + i, row, s, BOLD | B_ALL_MED);
            ++i;
        }
        ++row;
        i = 0;
        while (this.procPoolName != null && i < this.procPoolName.length) {
            s = this.procPoolName[i];
            num = 0;
            yellow = 0;
            red = 0;
            j = 0;
            while (j < timeLabels.length) {
                f = this.procPoolUsed[i].getMonthlyMax(j);
                f2 = this.procPoolConfig[i].getMonthlyMax(j);
                if (!(f < 0.0) && !(f2 <= 0.0)) {
                    f2 = f / f2 * 100.0;
                    ++num;
                    map = B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW;
                    if (f2 >= (double)this.R_LEVEL) {
                        map |= RED;
                        ++yellow;
                        ++red;
                    } else if (f2 >= (double)this.Y_LEVEL) {
                        map |= YELLOW;
                        ++yellow;
                    }
                    ds.addFloat(1 + j, row + i, f, map);
                    ds.addFloat(16 + j, row + i, f2, map);
                }
                ++j;
            }
            map = BOLD | VCENTRE | CENTRE | B_ALL_MED | WRAP;
            if (1.0 * (double)red / (double)num > this.COLOR_LEVEL) {
                map |= RED;
            } else if (1.0 * (double)yellow / (double)num > this.COLOR_LEVEL) {
                map |= YELLOW;
            }
            ds.addLabel(0, row + i, s, map);
            ds.addLabel(15, row + i, s, map);
            ++i;
        }
        row += i;
        ds.mergeCells(0, ++row, 13, row);
        ds.addLabel(0, row, "Average Virtual Pool Size", BOLD | CENTRE | VCENTRE | GREEN);
        ++row;
        i = 0;
        while (i < timeLabels.length) {
            s = timeLabels[i];
            ds.addLabel(1 + i, row, s, BOLD | B_ALL_MED);
            ++i;
        }
        ++row;
        i = 0;
        while (this.procPoolName != null && i < this.procPoolName.length) {
            s = this.procPoolName[i];
            ds.addLabel(0, row + i, s, BOLD | VCENTRE | CENTRE | B_ALL_MED | WRAP);
            j = 0;
            while (j < timeLabels.length) {
                f = this.procPoolConfig[i].getMonthlyMax(j);
                if (f >= 0.0) {
                    ds.addFloat(1 + j, row + i, f, B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW);
                }
                ++j;
            }
            ++i;
        }
        row += i;
        ++row;
        ds.setColSize(0, size + 6);
        ds.setColSize(15, size + 6);
        return ds;
    }

    private int getMSid(String ms) {
        int i = 0;
        while (i < this.managedSystem.length) {
            String name = this.managedSystem[i].getVarValues("name")[0];
            if (ms.equals(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void createLparCoreUsageSheetExcel(WritableSheet sheet) {
        DataSheet ds = this.createLparCoreUsageSheet();
        if (ds != null) {
            ds.createExcelSheet(sheet);
        }
    }

    private void createLparCoreUsageSheetHTML(String fileName) {
        DataSheet ds = this.createLparCoreUsageSheet();
        if (ds != null) {
            ds.createHTMLSheet(fileName);
            this.addButton("LPAR CPU Usage", new File(fileName).getName());
        }
    }

    private void createLparCoreUsageSheetCSV(String fileName) {
        DataSheet ds = this.createLparCoreUsageSheet();
        if (ds != null) {
            ds.setSeparator(this.csvSeparator);
            ds.createCSVSheet(fileName);
        }
    }

    private DataSheet createLparCoreUsageSheet() {
        double f2;
        double f;
        int j;
        String s;
        DataSheet ds = new DataSheet();
        int size = 0;
        int map = 0;
        String[] timeLabels = this.msCoreUsed[0].getMonthlyLabels();
        int i = 0;
        while (i < this.lparNames.length) {
            if (this.lparNames[i].length() > size) {
                size = this.lparNames[i].length();
            }
            ++i;
        }
        int row = 0;
        ds.addLabel(0, row, "Red", BOLD | CENTRE | VCENTRE | RED);
        ds.mergeCells(1, row, 10, row);
        ds.addLabel(1, row, "Usage >= " + this.R_LEVEL + "% of max allowed size", BOLD);
        ds.addLabel(0, ++row, "Yellow", BOLD | CENTRE | VCENTRE | YELLOW);
        ds.mergeCells(1, row, 10, row);
        ds.addLabel(1, row, "Usage >= " + this.Y_LEVEL + "% of max allowed size", BOLD);
        ds.addLabel(0, ++row, "Bold", BOLD | CENTRE | VCENTRE);
        ds.mergeCells(1, row, 10, row);
        ds.addLabel(1, row, "Usage > entitled capacity", BOLD);
        ds.addLabel(0, ++row, "LPAR color", BOLD | CENTRE | VCENTRE);
        ds.mergeCells(1, row, 10, row);
        ds.addLabel(1, row, "Colored cells >= " + this.COLOR_LEVEL * 100.0 + "% of total (yellows include reds)", BOLD);
        ++row;
        ds.mergeCells(0, ++row, 13, row);
        ds.addLabel(0, row, "Average Processor Usage", BOLD | CENTRE | VCENTRE | GREEN);
        ds.mergeCells(15, row, 28, row);
        ds.addLabel(15, row, "Average Entitlement Percentage Usage", BOLD | CENTRE | VCENTRE | GREEN);
        ++row;
        i = 0;
        while (i < timeLabels.length) {
            s = timeLabels[i];
            ds.addLabel(1 + i, row, s, BOLD | B_ALL_MED);
            ds.addLabel(16 + i, row, s, BOLD | B_ALL_MED);
            ++i;
        }
        ++row;
        i = 0;
        while (i < this.lparNames.length) {
            int num = 0;
            int yellow = 0;
            int red = 0;
            j = 0;
            while (j < timeLabels.length) {
                f = this.lparPC[i].getMonthlyAvg(j);
                f2 = this.lparEnt[i].getMonthlyAvg(j);
                boolean cap = this.lparStatus[i].getMonthCap(j);
                String ms = this.lparStatus[i].getMonthMS(j);
                String pool = this.lparStatus[i].getMonthPool(j);
                double vp = this.lparVP[i].getMonthlyAvg(j);
                if (!(f < 0.0 || f2 <= 0.0 || pool == null || ms == null || vp < 0.0)) {
                    double free;
                    if (pool.equals("DefaultPool")) {
                        free = this.msCoreConfig[this.getMSid(ms)].getMonthlyAvg(j) - this.msCoreUsed[this.getMSid(ms)].getMonthlyAvg(j);
                    } else {
                        int poolID = this.getProcPoolId(ms, pool);
                        free = this.procPoolConfig[poolID].getMonthlyAvg(j) - this.procPoolUsed[poolID].getMonthlyAvg(j);
                    }
                    double max = cap ? f2 : (f + free >= vp ? vp : f + free);
                    map = B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW;
                    if (f / max * 100.0 >= (double)this.R_LEVEL) {
                        map |= RED;
                        ++yellow;
                        ++red;
                    } else if (f / max * 100.0 >= (double)this.Y_LEVEL) {
                        map |= YELLOW;
                        ++yellow;
                    }
                    if (f > f2) {
                        map |= BOLD;
                    }
                    ds.addFloat(1 + j, row + i, f, map);
                    ds.addFloat(16 + j, row + i, f / f2 * 100.0, map);
                    ++num;
                }
                ++j;
            }
            map = BOLD | VCENTRE | CENTRE | B_ALL_MED;
            if (1.0 * (double)red / (double)num > this.COLOR_LEVEL) {
                map |= RED;
            } else if (1.0 * (double)yellow / (double)num > this.COLOR_LEVEL) {
                map |= YELLOW;
            }
            ds.addLabel(0, row + i, this.lparNames[i], map);
            ds.addLabel(15, row + i, this.lparNames[i], map);
            ++i;
        }
        row += i;
        ds.mergeCells(0, ++row, 13, row);
        ds.addLabel(0, row, "Peak Processor Usage", BOLD | CENTRE | VCENTRE | GREEN);
        ds.mergeCells(15, row, 28, row);
        ds.addLabel(15, row, "Peak Entitlement Percentage Usage", BOLD | CENTRE | VCENTRE | GREEN);
        ++row;
        i = 0;
        while (i < timeLabels.length) {
            s = timeLabels[i];
            ds.addLabel(1 + i, row, s, BOLD | B_ALL_MED);
            ds.addLabel(16 + i, row, s, BOLD | B_ALL_MED);
            ++i;
        }
        ++row;
        i = 0;
        while (i < this.lparNames.length) {
            ds.addLabel(0, row + i, this.lparNames[i], BOLD | VCENTRE | CENTRE | B_ALL_MED);
            ds.addLabel(15, row + i, this.lparNames[i], BOLD | VCENTRE | CENTRE | B_ALL_MED);
            j = 0;
            while (j < timeLabels.length) {
                f = this.lparPC[i].getMonthlyMax(j);
                f2 = this.lparEnt[i].getMonthlyMax(j);
                if (f >= 0.0) {
                    ds.addFloat(1 + j, row + i, f, B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW);
                }
                if (f >= 0.0 && f2 > 0.0) {
                    ds.addFloat(16 + j, row + i, f / f2 * 100.0, B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW);
                }
                ++j;
            }
            ++i;
        }
        row += i;
        ds.mergeCells(0, ++row, 13, row);
        ds.addLabel(0, row, "Average Entitlement", BOLD | CENTRE | VCENTRE | GREEN);
        ds.mergeCells(15, row, 28, row);
        ds.addLabel(15, row, "Average VPs", BOLD | CENTRE | VCENTRE | GREEN);
        ++row;
        i = 0;
        while (i < timeLabels.length) {
            s = timeLabels[i];
            ds.addLabel(1 + i, row, s, BOLD | B_ALL_MED);
            ds.addLabel(16 + i, row, s, BOLD | B_ALL_MED);
            ++i;
        }
        ++row;
        i = 0;
        while (i < this.lparNames.length) {
            ds.addLabel(0, row + i, this.lparNames[i], BOLD | VCENTRE | CENTRE | B_ALL_MED);
            j = 0;
            while (j < timeLabels.length) {
                f = this.lparEnt[i].getMonthlyAvg(j);
                if (f >= 0.0) {
                    ds.addFloat(1 + j, row + i, f, B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW);
                }
                if ((f = this.lparVP[i].getMonthlyAvg(j)) >= 0.0) {
                    ds.addFloat(16 + j, row + i, f, B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW);
                }
                ++j;
            }
            ++i;
        }
        row += i;
        ++row;
        ds.setColSize(0, size + 6);
        ds.setColSize(15, size + 6);
        return ds;
    }

    private void createSystemsSheetExcel(WritableSheet sheet) {
        DataSheet ds = this.createSystemsSheetRowBased();
        if (ds != null) {
            ds.createExcelSheet(sheet);
        }
    }

    private void createSystemsSheetHTML(String fileName) {
        DataSheet ds = this.createSystemsSheetRowBased();
        if (ds != null) {
            ds.createHTMLSheet(fileName);
            this.addButton("Systems", new File(fileName).getName());
        }
    }

    private void createSystemsSheetCSV(String fileName) {
        DataSheet ds = this.createSystemsSheetRowBased();
        if (ds != null) {
            ds.setSeparator(this.csvSeparator);
            ds.createCSVSheet(fileName);
        }
    }

    private DataSheet createSystemsSheetRowBased() {
        int nameSize = 0;
        int vp = 0;
        int ded = 0;
        int numLpar = 0;
        DataSheet ds = new DataSheet();
        int row = 0;
        ds.addLabel(0, 0, "Managed System", BOLD | VCENTRE | B_ALL_MED | GREEN);
        ds.addLabel(1, 0, "Status", BOLD | VCENTRE | B_ALL_MED | GREEN);
        ds.addLabel(2, 0, "Type Model", BOLD | B_ALL_MED | WRAP | GREEN);
        ds.addLabel(3, 0, "Serial", BOLD | B_ALL_MED | GREEN);
        ds.addLabel(4, 0, "GHz", BOLD | B_ALL_MED | GREEN);
        ds.addLabel(5, 0, "CPU Type", BOLD | B_ALL_MED | GREEN);
        ds.addLabel(6, 0, "Tot Cores", BOLD | B_BOTTOM_MED | B_TOP_MED | B_RIGHT_LOW | WRAP | GREEN);
        ds.addLabel(7, 0, "Act Cores", BOLD | B_BOTTOM_MED | B_TOP_MED | B_RIGHT_LOW | WRAP | GREEN);
        ds.addLabel(8, 0, "Deconf Cores", BOLD | B_BOTTOM_MED | B_TOP_MED | B_RIGHT_LOW | WRAP | GREEN);
        ds.addLabel(9, 0, "Curr Avail Cores", BOLD | B_BOTTOM_MED | B_TOP_MED | B_RIGHT_LOW | WRAP | GREEN);
        ds.addLabel(10, 0, "Pend Avail Cores", BOLD | B_BOTTOM_MED | B_TOP_MED | B_RIGHT_MED | WRAP | GREEN);
        ds.addLabel(11, 0, "Ded Cores", BOLD | B_BOTTOM_MED | B_TOP_MED | B_RIGHT_LOW | WRAP | GREEN);
        ds.addLabel(12, 0, "Pool Size", BOLD | B_BOTTOM_MED | B_TOP_MED | B_RIGHT_LOW | WRAP | GREEN);
        ds.addLabel(13, 0, "Virt Procs", BOLD | B_BOTTOM_MED | B_TOP_MED | B_RIGHT_MED | WRAP | GREEN);
        ds.addLabel(14, 0, "#LPAR", BOLD | B_BOTTOM_MED | B_TOP_MED | B_RIGHT_MED | WRAP | GREEN);
        ds.addLabel(15, 0, "Tot GB", BOLD | B_BOTTOM_MED | B_TOP_MED | B_RIGHT_LOW | WRAP | GREEN);
        ds.addLabel(16, 0, "Act GB", BOLD | B_BOTTOM_MED | B_TOP_MED | B_RIGHT_LOW | WRAP | GREEN);
        ds.addLabel(17, 0, "Deconf GB", BOLD | B_BOTTOM_MED | B_TOP_MED | B_RIGHT_LOW | WRAP | GREEN);
        ds.addLabel(18, 0, "Firm GB", BOLD | B_BOTTOM_MED | B_TOP_MED | B_RIGHT_LOW | WRAP | GREEN);
        ds.addLabel(19, 0, "Curr Avail GB", BOLD | B_BOTTOM_MED | B_TOP_MED | B_RIGHT_LOW | WRAP | GREEN);
        ds.addLabel(20, 0, "Pend Avail GB", BOLD | B_BOTTOM_MED | B_TOP_MED | B_RIGHT_MED | WRAP | GREEN);
        ds.addLabel(21, 0, "Perf Sample Rate", BOLD | B_ALL_MED | WRAP | GREEN);
        ds.addLabel(22, 0, "Mgr #1", BOLD | B_BOTTOM_MED | B_TOP_MED | B_RIGHT_LOW | GREEN);
        ds.addLabel(23, 0, "Mgr #2", BOLD | B_BOTTOM_MED | B_TOP_MED | B_RIGHT_MED | GREEN);
        ds.addLabel(24, 0, "Prim SP", BOLD | B_BOTTOM_MED | B_TOP_MED | B_RIGHT_LOW | WRAP | GREEN);
        ds.addLabel(25, 0, "Sec SP", BOLD | B_BOTTOM_MED | B_TOP_MED | B_RIGHT_MED | WRAP | GREEN);
        ds.addLabel(26, 0, "EC Number", BOLD | B_BOTTOM_MED | B_TOP_MED | B_RIGHT_LOW | WRAP | GREEN);
        ds.addLabel(27, 0, "IPL Level", BOLD | B_BOTTOM_MED | B_TOP_MED | B_RIGHT_LOW | WRAP | GREEN);
        ds.addLabel(28, 0, "Activated Level", BOLD | B_BOTTOM_MED | B_TOP_MED | B_RIGHT_LOW | WRAP | GREEN);
        ds.addLabel(29, 0, "Deferred Level", BOLD | B_BOTTOM_MED | B_TOP_MED | B_RIGHT_MED | WRAP | GREEN);
        row = 1;
        int i = 0;
        while (i < this.managedSystem.length) {
            String s = this.managedSystem[i].getVarValues("name")[0];
            if (s.length() > nameSize) {
                nameSize = s.length();
            }
            numLpar = 0;
            ded = 0;
            vp = 0;
            GenericData[] lpar = this.managedSystem[i].getObjects(PROC_LPAR);
            int j = 0;
            while (lpar != null && j < lpar.length) {
                ++numLpar;
                if (lpar[j].getVarValues("curr_proc_mode")[0].equals("shared")) {
                    vp += this.textToInt(lpar[j].getVarValues("run_procs")[0]);
                } else {
                    ded += this.textToInt(lpar[j].getVarValues("run_procs")[0]);
                }
                ++j;
            }
            int col = 0;
            ds.addLabel(col++, row, s, BOLD);
            if (this.managerType == 1 || this.managerType == 2) {
                ds.addLabel(col++, row, this.managedSystem[i].getVarValues("primary_state")[0], B_ALL_LOW);
            } else {
                ds.addLabel(col++, row, this.managedSystem[i].getVarValues("state")[0], B_ALL_LOW | RIGHT);
            }
            ds.addLabel(col++, row, this.managedSystem[i].getVarValues("type_model")[0], B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW | RIGHT);
            ds.addLabel(col++, row, this.managedSystem[i].getVarValues("serial_num")[0], B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW | RIGHT);
            if (this.managedSystem[i].getVarValues("frequency") != null) {
                ds.addFloat(col++, row, this.managedSystem[i].getVarValues("frequency"), 0, B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW | RIGHT);
            } else {
                ++col;
            }
            if (this.managedSystem[i].getVarValues("cpu_type") != null) {
                ds.addLabel(col++, row, this.managedSystem[i].getVarValues("cpu_type"), 0, B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW | RIGHT);
            } else {
                ++col;
            }
            GenericData[] gd = this.managedSystem[i].getObjects(PROC);
            if (gd != null && gd[0] != null) {
                ds.addInteger(col++, row, gd[0].getVarValues("installed_sys_proc_units"), 0, B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW);
                ds.addInteger(col++, row, gd[0].getVarValues("configurable_sys_proc_units"), 0, B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW);
                ds.addInteger(col++, row, gd[0].getVarValues("deconfig_sys_proc_units"), 0, B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW);
                ds.addFloat(col++, row, gd[0].getVarValues("curr_avail_sys_proc_units"), 0, B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW);
                ds.addFloat(col++, row, gd[0].getVarValues("pend_avail_sys_proc_units"), 0, B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW);
                ds.addInteger(col++, row, ded, B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW);
                try {
                    float pool = Float.parseFloat(gd[0].getVarValues("configurable_sys_proc_units")[0]) - Float.parseFloat(gd[0].getVarValues("deconfig_sys_proc_units")[0]) - (float)ded;
                    ds.addInteger(col++, row, pool, B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW);
                }
                catch (NumberFormatException nfe) {
                    ds.addLabel(col++, row, "NaN", B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW | RIGHT);
                }
            } else {
                col += 5;
                ds.addInteger(col++, row, ded, B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW);
            }
            int n = ++col;
            ds.addInteger(n, row, vp, B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW);
            int n2 = ++col;
            ++col;
            ds.addInteger(n2, row, numLpar, B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW);
            gd = this.managedSystem[i].getObjects(MEM);
            if (gd != null && gd[0] != null) {
                ds.addFloatDiv1024(col++, row, gd[0].getVarValues("installed_sys_mem"), 0, B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW);
                ds.addFloatDiv1024(col++, row, gd[0].getVarValues("configurable_sys_mem"), 0, B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW);
                ds.addFloatDiv1024(col++, row, gd[0].getVarValues("deconfig_sys_mem"), 0, B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW);
                ds.addFloatDiv1024(col++, row, gd[0].getVarValues("sys_firmware_mem"), 0, B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW);
                ds.addFloatDiv1024(col++, row, gd[0].getVarValues("curr_avail_sys_mem"), 0, B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW);
                ds.addFloatDiv1024(col++, row, gd[0].getVarValues("pend_avail_sys_mem"), 0, B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW);
            } else {
                col += 6;
            }
            ds.addInteger(col++, row, this.managedSystem[i].getVarValues("sample_rate"), 0, B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW);
            ds.addLabel(col++, row, this.managedSystem[i].getVarValues("HMC1_name"), 0, B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW | RIGHT);
            ds.addLabel(col++, row, this.managedSystem[i].getVarValues("HMC2_name"), 0, B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW | RIGHT);
            ds.addLabel(col++, row, this.managedSystem[i].getVarValues("ipaddr"), 0, B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW | RIGHT);
            ds.addLabel(col++, row, this.managedSystem[i].getVarValues("ipaddr_secondary"), 0, B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW | RIGHT);
            gd = this.managedSystem[i].getObjects(SYSPOWERLIC);
            if (gd != null && gd[0] != null) {
                ds.addLabel(col++, row, gd[0].getVarValues("ecnumber"), 0, B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW | RIGHT);
                ds.addInteger(col++, row, gd[0].getVarValues("platform_ipl_level"), 0, B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW);
                ds.addInteger(col++, row, gd[0].getVarValues("activated_level"), 0, B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW);
                if (gd[0].getVarValues("deferred_level") != null) {
                    if (gd[0].getVarValues("deferred_level")[0].equalsIgnoreCase("None")) {
                        ds.addLabel(col++, row, gd[0].getVarValues("deferred_level"), 0, B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW | RIGHT);
                    } else {
                        ds.addInteger(col++, row, gd[0].getVarValues("deferred_level"), 0, B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW);
                    }
                } else {
                    ++col;
                }
            } else {
                col += 4;
            }
            ++row;
            ++i;
        }
        ds.setColSize(0, nameSize + 6);
        ds.setColSize(1, 9);
        ds.setColSize(2, 9);
        ds.setColSize(3, 9);
        ds.setColSize(4, 9);
        ds.setColSize(5, 20);
        ds.setColSize(6, 6);
        ds.setColSize(7, 6);
        ds.setColSize(8, 6);
        ds.setColSize(9, 9);
        ds.setColSize(10, 9);
        ds.setColSize(11, 7);
        ds.setColSize(12, 7);
        ds.setColSize(13, 7);
        ds.setColSize(14, 7);
        ds.setColSize(15, 9);
        ds.setColSize(16, 9);
        ds.setColSize(17, 9);
        ds.setColSize(18, 9);
        ds.setColSize(19, 9);
        ds.setColSize(20, 9);
        ds.setColSize(21, 9);
        ds.setColSize(22, 15);
        ds.setColSize(23, 15);
        ds.setColSize(24, 15);
        ds.setColSize(25, 15);
        ds.setColSize(26, 9);
        ds.setColSize(27, 9);
        ds.setColSize(28, 9);
        ds.setColSize(29, 9);
        return ds;
    }

    private void createSystemsSheet(WritableSheet sheet) throws RowsExceededException, WriteException {
        int nameSize = 0;
        int col = 0;
        sheet.mergeCells(0, 1, 1, 1);
        this.addLabel(sheet, 0, 1, "Status", this.formatLabel(BOLD | VCENTRE | B_ALL_MED));
        sheet.mergeCells(0, 2, 0, 3);
        this.addLabel(sheet, 0, 2, "Identification", this.formatLabel(BOLD | VCENTRE | B_ALL_MED));
        this.addLabel(sheet, 1, 2, "Type-Model", this.formatLabel(BOLD | B_ALL_MED));
        this.addLabel(sheet, 1, 3, "Serial", this.formatLabel(BOLD | B_ALL_MED));
        sheet.mergeCells(0, 4, 0, 8);
        this.addLabel(sheet, 0, 4, "Cores", this.formatLabel(BOLD | VCENTRE | B_ALL_MED));
        this.addLabel(sheet, 1, 4, "Installed", this.formatLabel(BOLD | B_ALL_MED));
        this.addLabel(sheet, 1, 5, "Active", this.formatLabel(BOLD | B_ALL_MED));
        this.addLabel(sheet, 1, 6, "Deconfig", this.formatLabel(BOLD | B_ALL_MED));
        this.addLabel(sheet, 1, 7, "Curr Avail", this.formatLabel(BOLD | B_ALL_MED));
        this.addLabel(sheet, 1, 8, "Pend Avail", this.formatLabel(BOLD | B_ALL_MED));
        sheet.mergeCells(0, 9, 0, 14);
        this.addLabel(sheet, 0, 9, "Memory (MB)", this.formatLabel(BOLD | VCENTRE | B_ALL_MED));
        this.addLabel(sheet, 1, 9, "Installed", this.formatLabel(BOLD | B_ALL_MED));
        this.addLabel(sheet, 1, 10, "Active", this.formatLabel(BOLD | B_ALL_MED));
        this.addLabel(sheet, 1, 11, "Deconfig", this.formatLabel(BOLD | B_ALL_MED));
        this.addLabel(sheet, 1, 12, "Firmware", this.formatLabel(BOLD | B_ALL_MED));
        this.addLabel(sheet, 1, 13, "Curr Avail", this.formatLabel(BOLD | B_ALL_MED));
        this.addLabel(sheet, 1, 14, "Pend Avail", this.formatLabel(BOLD | B_ALL_MED));
        sheet.mergeCells(0, 15, 1, 15);
        this.addLabel(sheet, 0, 15, "Perf Sample Rate", this.formatLabel(BOLD | B_ALL_MED));
        sheet.mergeCells(0, 16, 0, 17);
        this.addLabel(sheet, 0, 16, "Manager", this.formatLabel(BOLD | VCENTRE | B_ALL_MED));
        this.addLabel(sheet, 1, 16, "#1", this.formatLabel(BOLD | B_ALL_MED));
        this.addLabel(sheet, 1, 17, "#2", this.formatLabel(BOLD | B_ALL_MED));
        sheet.mergeCells(0, 18, 0, 19);
        this.addLabel(sheet, 0, 18, "Service Processor IP", this.formatLabel(BOLD | VCENTRE | B_ALL_MED | WRAP));
        this.addLabel(sheet, 1, 18, "Primary", this.formatLabel(BOLD | B_RIGHT_MED | B_TOP_MED | B_LEFT_MED));
        this.addLabel(sheet, 1, 19, "Secondary", this.formatLabel(BOLD | B_RIGHT_MED | B_BOTTOM_MED | B_LEFT_MED));
        sheet.mergeCells(0, 20, 0, 23);
        this.addLabel(sheet, 0, 20, "Code Levels", this.formatLabel(BOLD | VCENTRE | B_ALL_MED | WRAP));
        this.addLabel(sheet, 1, 20, "EC Number", this.formatLabel(BOLD | B_RIGHT_MED | B_TOP_MED | B_LEFT_MED));
        this.addLabel(sheet, 1, 21, "IPL Level", this.formatLabel(BOLD | B_RIGHT_MED | B_LEFT_MED));
        this.addLabel(sheet, 1, 22, "Activated Level", this.formatLabel(BOLD | B_RIGHT_MED | B_LEFT_MED));
        this.addLabel(sheet, 1, 23, "Deferred Level", this.formatLabel(BOLD | B_RIGHT_MED | B_BOTTOM_MED | B_LEFT_MED));
        col = 2;
        int i = 0;
        while (i < this.managedSystem.length) {
            String s = this.managedSystem[i].getVarValues("name")[0];
            if (s.length() > nameSize) {
                nameSize = s.length();
            }
            this.addLabel(sheet, col, 0, s, this.formatLabel(BOLD | DIAG45));
            if (this.managerType == 1 || this.managerType == 2) {
                this.addLabel(sheet, col, 1, this.managedSystem[i].getVarValues("primary_state")[0], this.formatLabel(B_ALL_LOW));
            } else {
                this.addLabel(sheet, col, 1, this.managedSystem[i].getVarValues("state")[0], this.formatLabel(B_ALL_LOW | RIGHT));
            }
            this.addLabel(sheet, col, 2, this.managedSystem[i].getVarValues("type_model")[0], this.formatLabel(B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW | RIGHT));
            this.addLabel(sheet, col, 3, this.managedSystem[i].getVarValues("serial_num")[0], this.formatLabel(B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW | RIGHT));
            GenericData[] gd = this.managedSystem[i].getObjects(PROC);
            if (gd != null && gd[0] != null) {
                this.addNumber(sheet, col, 4, gd[0].getVarValues("installed_sys_proc_units"), 0, this.formatInt(B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW));
                this.addNumber(sheet, col, 5, gd[0].getVarValues("configurable_sys_proc_units"), 0, this.formatInt(B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW));
                this.addNumber(sheet, col, 6, gd[0].getVarValues("deconfig_sys_proc_units"), 0, this.formatInt(B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW));
                this.addNumber(sheet, col, 7, gd[0].getVarValues("curr_avail_sys_proc_units"), 0, this.formatFloat(B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW));
                this.addNumber(sheet, col, 8, gd[0].getVarValues("pend_avail_sys_proc_units"), 0, this.formatFloat(B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW));
            }
            if ((gd = this.managedSystem[i].getObjects(MEM)) != null && gd[0] != null) {
                this.addNumber(sheet, col, 9, gd[0].getVarValues("installed_sys_mem"), 0, this.formatInt(B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW));
                this.addNumber(sheet, col, 10, gd[0].getVarValues("configurable_sys_mem"), 0, this.formatInt(B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW));
                this.addNumber(sheet, col, 11, gd[0].getVarValues("deconfig_sys_mem"), 0, this.formatInt(B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW));
                this.addNumber(sheet, col, 12, gd[0].getVarValues("sys_firmware_mem"), 0, this.formatInt(B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW));
                this.addNumber(sheet, col, 13, gd[0].getVarValues("curr_avail_sys_mem"), 0, this.formatInt(B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW));
                this.addNumber(sheet, col, 14, gd[0].getVarValues("pend_avail_sys_mem"), 0, this.formatInt(B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW));
            }
            this.addNumber(sheet, col, 15, this.managedSystem[i].getVarValues("sample_rate"), 0, this.formatInt(B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW));
            this.addLabel(sheet, col, 16, this.managedSystem[i].getVarValues("HMC1_name"), 0, this.formatInt(B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW | RIGHT));
            this.addLabel(sheet, col, 17, this.managedSystem[i].getVarValues("HMC2_name"), 0, this.formatInt(B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW | RIGHT));
            this.addLabel(sheet, col, 18, this.managedSystem[i].getVarValues("ipaddr"), 0, this.formatInt(B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW | RIGHT));
            this.addLabel(sheet, col, 19, this.managedSystem[i].getVarValues("ipaddr_secondary"), 0, this.formatInt(B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW | RIGHT));
            gd = this.managedSystem[i].getObjects(SYSPOWERLIC);
            if (gd != null && gd[0] != null) {
                this.addLabel(sheet, col, 20, gd[0].getVarValues("ecnumber"), 0, this.formatLabel(B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW | RIGHT));
                this.addNumber(sheet, col, 21, gd[0].getVarValues("platform_ipl_level"), 0, this.formatInt(B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW));
                this.addNumber(sheet, col, 22, gd[0].getVarValues("activated_level"), 0, this.formatInt(B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW));
                if (gd[0].getVarValues("deferred_level")[0].equalsIgnoreCase("None")) {
                    this.addLabel(sheet, col, 23, gd[0].getVarValues("deferred_level"), 0, this.formatLabel(B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW | RIGHT));
                } else {
                    this.addNumber(sheet, col, 23, gd[0].getVarValues("deferred_level"), 0, this.formatInt(B_RIGHT_LOW | B_LEFT_LOW | B_BOTTOM_LOW));
                }
            }
            ++col;
            ++i;
        }
        i = 0;
        while (i <= 50) {
            sheet.setColumnView(i, 15);
            ++i;
        }
    }

    private void identifyManagerType(String baseDir) {
        String line;
        BufferedReader br;
        File f = new File(String.valueOf(baseDir) + lshmcV);
        if (f.exists()) {
            try {
                br = new BufferedReader(new FileReader(String.valueOf(baseDir) + lshmcV), 0x100000);
                while ((line = br.readLine()) != null) {
                    if (line.startsWith("HMC")) {
                        this.managerType = 0;
                        br.close();
                        return;
                    }
                    if (line.startsWith("SDMC")) {
                        this.managerType = 1;
                        br.close();
                        return;
                    }
                    if (!line.startsWith("FSM")) continue;
                    this.managerType = (byte)2;
                    br.close();
                    return;
                }
                br.close();
            }
            catch (IOException ioe) {
                System.out.println("Loader.identifyManagerType: IOException");
                System.out.println(ioe);
            }
        }
        if ((f = new File(String.valueOf(baseDir) + ivmversion)).exists()) {
            try {
                br = new BufferedReader(new FileReader(String.valueOf(baseDir) + ivmversion), 0x100000);
                line = br.readLine();
                if (line != null) {
                    this.managerType = (byte)3;
                    return;
                }
            }
            catch (IOException ioe) {
                System.out.println("Loader.identifyManagerType: IOException");
                System.out.println(ioe);
            }
        }
    }

    private void setScannerDate(String s) {
        int s1 = s.indexOf(45);
        int s2 = s.indexOf(45, s1 + 1);
        int year = Integer.parseInt(s.substring(0, s1));
        int month = Integer.parseInt(s.substring(s1 + 1, s2));
        int day = Integer.parseInt(s.substring(s2 + 1));
        this.scannerDate = new GregorianCalendar(year, month - 1, day);
    }

    private void loadScannerParams(String baseDir) {
        String[] names = null;
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(String.valueOf(baseDir) + scannerInfo), 0x100000);
            names = null;
            while ((line = br.readLine()) != null) {
                DataParser dp = new DataParser(line);
                names = dp.getNames();
                this.scannerParams = new GenericData();
                int j = 0;
                while (j < names.length) {
                    this.scannerParams.add(names[j], dp.getStringValue(names[j]));
                    ++j;
                }
                String[] data = this.scannerParams.getVarValues("HMCdate");
                if (data == null) continue;
                this.setScannerDate(data[0]);
                break;
            }
        }
        catch (IOException ioe) {
            System.out.println("Loader.loadSysConfigData.loadscannerParams: IOException");
            System.out.println(ioe);
        }
    }

    private void addManagedSystem(GenericData ms, String hmcName) {
        String[] nameS = new String[]{hmcName};
        ms.add("HMC1_name", nameS);
        if (this.managedSystem == null) {
            this.managedSystem = new GenericData[1];
            this.managedSystem[0] = ms;
            return;
        }
        String name = ms.getVarValues("name")[0];
        int compare = 0;
        int curr = 0;
        while (curr < this.managedSystem.length && (compare = this.managedSystem[curr].getVarValues("name")[0].compareTo(name)) < 0) {
            ++curr;
        }
        if (compare == 0) {
            this.managedSystem[curr].add("HMC2_name", nameS);
            String[] a = ms.getVarValues("ipaddr");
            String[] b = this.managedSystem[curr].getVarValues("ipaddr");
            if (!a[0].equals(b[0])) {
                this.managedSystem[curr].add("ipaddr2", ms.getVarValues("ipaddr"));
                this.managedSystem[curr].add("ipaddr2_secondary", ms.getVarValues("ipaddr_secondary"));
            }
            return;
        }
        GenericData[] newManagedSystem = new GenericData[this.managedSystem.length + 1];
        int i = 0;
        while (i < curr) {
            newManagedSystem[i] = this.managedSystem[i];
            ++i;
        }
        newManagedSystem[curr] = ms;
        i = curr;
        while (i < this.managedSystem.length) {
            newManagedSystem[i + 1] = this.managedSystem[i];
            ++i;
        }
        this.managedSystem = newManagedSystem;
    }

    private void loadSysConfigData(String hmcName, String baseDir) {
        int j;
        DataParser dp;
        String line;
        BufferedReader br;
        String[] names = null;
        GenericData ms = null;
        try {
            br = new BufferedReader(new FileReader(String.valueOf(baseDir) + systemData), 0x100000);
            names = null;
            while ((line = br.readLine()) != null) {
                if (line.startsWith("HSC") || line.startsWith("No results were found")) continue;
                dp = new DataParser(line);
                names = dp.getNames();
                ms = new GenericData();
                j = 0;
                while (j < names.length) {
                    ms.add(names[j], dp.getStringValue(names[j]));
                    ++j;
                }
                String[] tm = ms.getVarValues("type_model");
                String[] sn = ms.getVarValues("serial_num");
                if (tm == null || tm[0] == null || sn == null || sn[0] == null) {
                    System.out.println("Skipping system to to bad type-model or serial");
                    System.out.println("  skipped line is >" + line + "<");
                    continue;
                }
                names = new String[]{String.valueOf(tm[0]) + "_" + sn[0]};
                ms.add("_file_", names);
                this.addManagedSystem(ms, hmcName);
            }
        }
        catch (IOException ioe) {
            System.out.println("Loader.loadSysConfigData.systemData: IOException");
            System.out.println(ioe);
        }
        if (this.managedSystem == null) {
            return;
        }
        Vector<String> system = new Vector<String>();
        Vector<String> sample = new Vector<String>();
        try {
            br = new BufferedReader(new FileReader(String.valueOf(baseDir) + utilDataConfig), 0x100000);
            names = null;
            while ((line = br.readLine()) != null) {
                if (line == null || line.startsWith("HSC") || !line.contains("type_model_serial_num")) continue;
                dp = new DataParser(line);
                system.add(dp.getStringValue("type_model_serial_num")[0]);
                sample.add(dp.getStringValue("sample_rate")[0]);
            }
        }
        catch (IOException ioe) {
            System.out.println("Loader.loadSysConfigData: IOException.utilDataConfig");
            System.out.println(ioe);
        }
        int i = 0;
        while (i < this.managedSystem.length) {
            String model = this.managedSystem[i].getVarValues("type_model")[0];
            String serial = this.managedSystem[i].getVarValues("serial_num")[0];
            j = 0;
            while (j < system.size()) {
                if (((String)system.get(j)).equals(String.valueOf(model) + "*" + serial)) {
                    String[] result = new String[]{(String)sample.get(j)};
                    this.managedSystem[i].add("sample_rate", result);
                    break;
                }
                ++j;
            }
            ++i;
        }
    }

    private String getColName(int col) {
        int C1 = col / 26;
        int C2 = col % 26;
        String result = "";
        if (C1 > 0) {
            result = String.valueOf((char)(65 + C1));
        }
        result = String.valueOf(result) + String.valueOf((char)(65 + C2));
        return result;
    }

    private void sortManagedData() {
        int i = 0;
        while (i < this.managedSystem.length) {
            String curr = this.managedSystem[i].getVarValues("name")[0];
            int id = -1;
            int j = i + 1;
            while (j < this.managedSystem.length) {
                if (this.managedSystem[j].getVarValues("name")[0].compareTo(curr) < 0) {
                    id = j;
                    curr = this.managedSystem[j].getVarValues("name")[0];
                }
                ++j;
            }
            if (id >= 0) {
                GenericData gd = this.managedSystem[i];
                this.managedSystem[i] = this.managedSystem[id];
                this.managedSystem[id] = gd;
                float[][] faa = this.managedSystemData[i];
                this.managedSystemData[i] = this.managedSystemData[id];
                this.managedSystemData[id] = faa;
                boolean[] ba = this.goodSystemData[i];
                this.goodSystemData[i] = this.goodSystemData[id];
                this.goodSystemData[id] = ba;
                this.swapDataManagerObject(this.msCoreConfig, i, id);
                this.swapDataManagerObject(this.msCoreAvail, i, id);
                this.swapDataManagerObject(this.msCoreUsed, i, id);
                this.swapDataManagerObject(this.msMemConfig, i, id);
                this.swapDataManagerObject(this.msMemAvail, i, id);
            }
            ++i;
        }
    }

    private void swapDataManagerObject(DataManager[] array, int a, int b) {
        if (array == null || a < 0 || a > array.length || b < 0 || b > array.length) {
            return;
        }
        DataManager dm = array[a];
        array[a] = array[b];
        array[b] = dm;
    }

    private void swapLparStatusObject(NewLparStatus[] array, int a, int b) {
        if (array == null || a < 0 || a > array.length || b < 0 || b > array.length) {
            return;
        }
        NewLparStatus dm = array[a];
        array[a] = array[b];
        array[b] = dm;
    }

    private void sortLparData() {
        int i = 0;
        while (i < this.lparNames.length) {
            String curr = this.lparNames[i];
            int id = -1;
            int j = i + 1;
            while (j < this.lparNames.length) {
                if (this.lparNames[j].compareTo(curr) < 0) {
                    id = j;
                    curr = this.lparNames[j];
                }
                ++j;
            }
            if (id >= 0) {
                String s = this.lparNames[i];
                this.lparNames[i] = this.lparNames[id];
                this.lparNames[id] = s;
                this.swapDataManagerObject(this.lparEnt, i, id);
                this.swapDataManagerObject(this.lparVP, i, id);
                this.swapDataManagerObject(this.lparPC, i, id);
                this.swapLparStatusObject(this.lparStatus, i, id);
            }
            ++i;
        }
    }

    private void sanitizeData() {
        StringChanger msChange = new StringChanger("System#");
        StringChanger ipChange = new StringChanger("IP#");
        StringChanger lparChange = new StringChanger("LPAR");
        StringChanger macChange = new StringChanger("MAC#");
        StringChanger vswitchChange = new StringChanger("VS#");
        StringChanger wwpnChange = new StringChanger("WWPN#");
        StringChanger vtdChange = new StringChanger("VTD#");
        StringChanger profileChange = new StringChanger("PROFILE#");
        StringChanger _poolChange = new StringChanger("VP#", "DefaultPool");
        StringChanger[] sc = new StringChanger[]{_poolChange, msChange};
        StringChanger vpoolChange = new StringChanger("\n", sc);
        this.sanitizeString(this.scannerParams, "HMC", ipChange);
        this.sanitizeString(this.hmc, "hostname", ipChange);
        this.sanitizeString(this.hmc, "gateway", ipChange);
        this.hmc.cleanData("domain");
        this.hmc.cleanData("domainsuffix");
        int i = 0;
        while (i < 6) {
            this.sanitizeString(this.hmc, "ipv4addr_eth" + (i - 1), ipChange);
            this.sanitizeString(this.hmc, "ipv6addr_eth" + (i - 1), ipChange);
            ++i;
        }
        GenericData[] gd = this.service_agent.getObjects((byte)0);
        if (gd != null) {
            gd[0].cleanData("email_addresses");
        }
        gd = this.service_agent.getObjects((byte)1);
        StringChanger[] stringChangerArray = new StringChanger[3];
        stringChangerArray[0] = msChange;
        sc = stringChangerArray;
        StringChanger tmpChanger = new StringChanger("/", sc);
        if (gd != null) {
            this.sanitizeString(gd[0], "systems", tmpChanger);
        }
        gd = this.service_agent.getObjects((byte)2);
        StringChanger[] stringChangerArray2 = new StringChanger[3];
        stringChangerArray2[0] = ipChange;
        sc = stringChangerArray2;
        tmpChanger = new StringChanger("/", sc);
        if (gd != null) {
            this.sanitizeString(gd[0], "servers", tmpChanger);
            gd[0].cleanData("host");
            gd[0].cleanData("user");
        }
        if ((gd = this.service_agent.getObjects((byte)3)) != null) {
            i = 0;
            while (i < gd.length) {
                this.sanitizeString(gd[i], "name", msChange);
                ++i;
            }
        }
        if ((gd = this.service_agent.getObjects((byte)5)) != null) {
            String[] names = gd[0].getVarNames();
            i = 0;
            while (i < names.length) {
                gd[0].cleanData(names[i]);
                ++i;
            }
        }
        if ((gd = this.service_agent.getObjects((byte)6)) != null) {
            this.sanitizeString(gd[0], "smtp_server", ipChange);
            gd[0].cleanData("email_addresses");
        }
        i = 0;
        while (i < this.managedSystem.length) {
            int k;
            String[] s;
            GenericData ms = this.managedSystem[i];
            this.sanitizeString(ms, "name", msChange);
            this.sanitizeString(ms, "HMC1_name", ipChange);
            this.sanitizeString(ms, "HMC2_name", ipChange);
            this.sanitizeString(ms, "ipaddr", ipChange);
            this.sanitizeString(ms, "ipaddr_secondary", ipChange);
            gd = ms.getObjects(CONFIG_LPAR);
            int j = 0;
            while (gd != null && j < gd.length) {
                this.sanitizeString(gd[j], "name", lparChange);
                this.sanitizeString(gd[j], "rmc_ipaddr", ipChange);
                this.sanitizeString(gd[j], "curr_profile", profileChange);
                this.sanitizeString(gd[j], "default_profile", profileChange);
                ++j;
            }
            gd = ms.getObjects(PROC_LPAR);
            j = 0;
            while (gd != null && j < gd.length) {
                this.sanitizeString(gd[j], "lpar_name", lparChange);
                this.sanitizeString(gd[j], "curr_shared_proc_pool_name", _poolChange);
                ++j;
            }
            gd = ms.getObjects(MEM_LPAR);
            j = 0;
            while (gd != null && j < gd.length) {
                this.sanitizeString(gd[j], "lpar_name", lparChange);
                this.sanitizeString(gd[j], "primary_paging_vios_name", lparChange);
                this.sanitizeString(gd[j], "secondary_paging_vios_name", lparChange);
                this.sanitizeString(gd[j], "curr_paging_vios_name", lparChange);
                ++j;
            }
            gd = ms.getObjects(PROFILES);
            j = 0;
            while (gd != null && j < gd.length) {
                this.sanitizeString(gd[j], "lpar_name", lparChange);
                this.sanitizeString(gd[j], "name", profileChange);
                this.sanitizeString(gd[j], "shared_proc_pool_name", _poolChange);
                ++j;
            }
            gd = ms.getObjects(PROC_POOL);
            j = 0;
            while (gd != null && j < gd.length) {
                this.sanitizeString(gd[j], "name", _poolChange);
                this.sanitizeString(gd[j], "lpar_names", lparChange);
                ++j;
            }
            gd = ms.getObjects(SLOT);
            j = 0;
            while (gd != null && j < gd.length) {
                this.sanitizeString(gd[j], "lpar_name", lparChange);
                ++j;
            }
            gd = ms.getObjects(VETH);
            j = 0;
            while (gd != null && j < gd.length) {
                this.sanitizeString(gd[j], "lpar_name", lparChange);
                this.sanitizeString(gd[j], "mac_addr", macChange);
                this.sanitizeString(gd[j], "vswitch", vswitchChange);
                ++j;
            }
            gd = ms.getObjects(VSWITCH);
            j = 0;
            while (gd != null && j < gd.length) {
                if (gd[j] != null) {
                    s = gd[j].getVarValues("vswitch");
                    if (s[0].endsWith("(Default)")) {
                        s[0] = s[0].substring(0, s[0].length() - 9);
                        s[0] = vswitchChange.translate(s[0]);
                        s[0] = String.valueOf(s[0]) + "(Default)";
                        gd[j].add("vswitch", s);
                    } else {
                        this.sanitizeString(gd[j], "vswitch", vswitchChange);
                    }
                }
                ++j;
            }
            gd = ms.getObjects(VSCSI);
            j = 0;
            while (gd != null && j < gd.length) {
                this.sanitizeString(gd[j], "lpar_name", lparChange);
                this.sanitizeString(gd[j], "remote_lpar_name", lparChange);
                ++j;
            }
            gd = ms.getObjects(VSCSIMAP);
            j = 0;
            while (gd != null && j < gd.length) {
                this.sanitizeString(gd[j], "VIOS", lparChange);
                this.sanitizeString(gd[j], "remote_lpar_name", lparChange);
                s = gd[j].getVarValues("VTD");
                if (s != null) {
                    k = 0;
                    while (k < s.length) {
                        if (s[k] != null) {
                            s[k] = vtdChange.translate(s[k]);
                        }
                        ++k;
                    }
                    gd[j].add("VTD", s);
                }
                ++j;
            }
            gd = ms.getObjects(HDISK);
            j = 0;
            while (gd != null && j < gd.length) {
                this.sanitizeString(gd[j], "VIOS", lparChange);
                ++j;
            }
            gd = ms.getObjects(VFC);
            j = 0;
            while (gd != null && j < gd.length) {
                this.sanitizeString(gd[j], "lpar_name", lparChange);
                this.sanitizeString(gd[j], "remote_lpar_name", lparChange);
                s = gd[j].getVarValues("wwpns");
                if (s != null) {
                    s[0] = wwpnChange.translate(s[0]);
                    s[1] = wwpnChange.translate(s[0]);
                    gd[j].add("wwpns", s);
                }
                ++j;
            }
            gd = ms.getObjects(VFCMAP);
            j = 0;
            while (gd != null && j < gd.length) {
                s = gd[j].getVarNames();
                k = 0;
                while (s != null && k < s.length) {
                    String name = String.valueOf(lparChange.translate(s[k].substring(0, s[k].indexOf(64)))) + s[k].substring(s[k].indexOf(64));
                    String[] s2 = gd[j].getVarValues(s[k]);
                    String[] s3 = new String[1];
                    int n = s2[0].indexOf(45);
                    if (n >= 0) {
                        s3[0] = String.valueOf(s2[0].substring(0, n)) + s2[0].substring(n);
                        gd[j].add(name, s3);
                    }
                    ++k;
                }
                ++j;
            }
            gd = ms.getObjects(SEA);
            j = 0;
            while (gd != null && j < gd.length) {
                this.sanitizeString(gd[j], "VIOS", lparChange);
                ++j;
            }
            gd = ms.getObjects(ETH);
            j = 0;
            while (gd != null && j < gd.length) {
                this.sanitizeString(gd[j], "VIOS", lparChange);
                ++j;
            }
            gd = ms.getObjects(ETHERCHANNEL);
            j = 0;
            while (gd != null && j < gd.length) {
                this.sanitizeString(gd[j], "VIOS", lparChange);
                ++j;
            }
            gd = ms.getObjects(ENTSTATSEA);
            j = 0;
            while (gd != null && j < gd.length) {
                this.sanitizeString(gd[j], "VIOS", lparChange);
                ++j;
            }
            gd = ms.getObjects(FC);
            j = 0;
            while (gd != null && j < gd.length) {
                this.sanitizeString(gd[j], "VIOS", lparChange);
                ++j;
            }
            gd = ms.getObjects(SRIOV_LOGP_ETH);
            j = 0;
            while (gd != null && j < gd.length) {
                this.sanitizeString(gd[j], "lpar_name", lparChange);
                this.sanitizeString(gd[j], "mac_addr", macChange);
                this.sanitizeString(gd[j], "curr_mac_addr", macChange);
                this.sanitizeString(gd[j], "allowed_os_mac_addrs", macChange);
                this.sanitizeString(gd[j], "client_lpar_names", lparChange);
                ++j;
            }
            gd = ms.getObjects(SRIOV_LOGP_ROCE);
            j = 0;
            while (gd != null && j < gd.length) {
                this.sanitizeString(gd[j], "lpar_name", lparChange);
                this.sanitizeString(gd[j], "mac_addr", macChange);
                this.sanitizeString(gd[j], "curr_mac_addr", macChange);
                this.sanitizeString(gd[j], "allowed_os_mac_addrs", macChange);
                this.sanitizeString(gd[j], "client_lpar_names", lparChange);
                ++j;
            }
            gd = ms.getObjects(VNIC);
            j = 0;
            while (gd != null && j < gd.length) {
                this.sanitizeString(gd[j], "lpar_name", lparChange);
                this.sanitizeString(gd[j], "mac_addr", macChange);
                this.sanitizeString(gd[j], "allowed_os_mac_addrs", macChange);
                ++j;
            }
            ++i;
        }
        if (this.lparNames != null) {
            i = 0;
            while (i < this.lparNames.length) {
                this.lparNames[i] = lparChange.translate(this.lparNames[i]);
                ++i;
            }
        }
        if (this.procPoolName != null) {
            i = 0;
            while (i < this.procPoolName.length) {
                this.procPoolName[i] = vpoolChange.translate(this.procPoolName[i]);
                ++i;
            }
        }
        if (this.lparStatus != null) {
            i = 0;
            while (i < this.lparStatus.length) {
                this.lparStatus[i].sanitize(msChange, vpoolChange);
                ++i;
            }
        }
    }

    private void sanitizeString(GenericData gd, String name, StringChanger sc) {
        if (gd == null) {
            return;
        }
        String[] s = gd.getVarValues(name);
        if (s == null) {
            return;
        }
        int i = 0;
        while (i < s.length) {
            s[i] = sc.translate(s[i]);
            ++i;
        }
        gd.add(name, s);
    }

    private int textToInt(String s) {
        if (s.equals("null")) {
            return 0;
        }
        return Integer.parseInt(s);
    }

    public String getHMCdate() {
        if (this.scannerParams == null) {
            return "";
        }
        String[] s = this.scannerParams.getVarValues("HMCdate");
        if (s == null || s.length < 1) {
            return "";
        }
        String result = s[0].replace("-", "");
        s = this.scannerParams.getVarValues("HMCtime");
        if (s == null || s.length < 1) {
            return "";
        }
        result = String.valueOf(result) + "_" + s[0].replace(":", "");
        return result;
    }

    private void createIndexHtml(String dirName) {
        PrintWriter index;
        try {
            index = new PrintWriter(new FileOutputStream(String.valueOf(dirName) + File.separatorChar + index_html));
        }
        catch (IOException e) {
            System.out.println("\nError creating file " + dirName + File.separatorChar + index_html);
            System.out.println("Skipping HTML creation");
            return;
        }
        index.println("<HTML>\n<HEAD>\n<TITLE>hmcScanner HTML</TITLE>");
        index.println("<style type=\"text/css\">");
        index.println("<!--\niframe {\nfloat:left;\nmargin:0px;\n}\n-->");
        index.println("</style>\n</head>");
        index.println("<BODY BCOLOR=#e6e6e6>");
        index.println("<iframe width=\"15%\" height=\"100%\" src=\"" + menu_html + "\" frameborder=\"0\" name=\"menu\"></iframe>");
        index.println("<iframe width=\"85%\" height=\"100%\" src=\"" + header_html + "\" frameborder=\"0\" name=\"data\"></iframe>");
        index.println("</BODY>");
        index.println("</HTML>");
        index.close();
    }

    private void createSystemPerfIndexHtml(String dirName) {
        PrintWriter index;
        try {
            index = new PrintWriter(new FileOutputStream(String.valueOf(dirName) + File.separatorChar + sysperfindex_html));
        }
        catch (IOException e) {
            System.out.println("\nError creating file " + dirName + File.separatorChar + sysperfindex_html);
            System.out.println("Skipping HTML creation");
            return;
        }
        index.println("<HTML>\n<HEAD>\n");
        index.println("<style type=\"text/css\">");
        index.println("<!--\niframe {\nfloat:left;\nmargin:0px;\n}\n-->");
        index.println("</style>\n</head>");
        index.println("<BODY BCOLOR=#e6e6e6>");
        index.println("<iframe width=\"15%\" height=\"100%\" src=\"" + sysperfmenu_html + "\" frameborder=\"0\" name=\"sysperfmenu\"></iframe>");
        index.println("<iframe width=\"85%\" height=\"100%\" frameborder=\"0\" name=\"sysperfdata\"</iframe>");
        index.println("</BODY>");
        index.println("</HTML>");
        index.close();
    }

    private void createPoolPerfIndexHtml(String dirName) {
        PrintWriter index;
        try {
            index = new PrintWriter(new FileOutputStream(String.valueOf(dirName) + File.separatorChar + poolperfindex_html));
        }
        catch (IOException e) {
            System.out.println("\nError creating file " + dirName + File.separatorChar + poolperfindex_html);
            System.out.println("Skipping HTML creation");
            return;
        }
        index.println("<HTML>\n<HEAD>\n");
        index.println("<style type=\"text/css\">");
        index.println("<!--\niframe {\nfloat:left;\nmargin:0px;\n}\n-->");
        index.println("</style>\n</head>");
        index.println("<BODY BCOLOR=#e6e6e6>");
        index.println("<iframe width=\"15%\" height=\"100%\" src=\"" + poolperfmenu_html + "\" frameborder=\"0\" name=\"sysperfmenu\"></iframe>");
        index.println("<iframe width=\"85%\" height=\"100%\" frameborder=\"0\" name=\"poolperfdata\"</iframe>");
        index.println("</BODY>");
        index.println("</HTML>");
        index.close();
    }

    private void createLPARPerfIndexHtml(String dirName) {
        PrintWriter index;
        try {
            index = new PrintWriter(new FileOutputStream(String.valueOf(dirName) + File.separatorChar + lparperfindex_html));
        }
        catch (IOException e) {
            System.out.println("\nError creating file " + dirName + File.separatorChar + lparperfindex_html);
            System.out.println("Skipping HTML creation");
            return;
        }
        index.println("<HTML>\n<HEAD>\n");
        index.println("<style type=\"text/css\">");
        index.println("<!--\niframe {\nfloat:left;\nmargin:0px;\n}\n-->");
        index.println("</style>\n</head>");
        index.println("<BODY BCOLOR=#e6e6e6>");
        index.println("<iframe width=\"15%\" height=\"100%\" src=\"" + lparperfmenu_html + "\" frameborder=\"0\" name=\"sysperfmenu\"></iframe>");
        index.println("<iframe width=\"85%\" height=\"100%\" frameborder=\"0\" name=\"lparperfdata\"</iframe>");
        index.println("</BODY>");
        index.println("</HTML>");
        index.close();
    }

    private void addButton(String button, String html) {
        if (this.buttonName == null) {
            this.buttonName = new Vector();
            this.htmlName = new Vector();
        }
        this.buttonName.add(button);
        this.htmlName.add(html);
    }

    private void addButtonSystem(String button, String html) {
        if (this.sysButtonName == null) {
            this.sysButtonName = new Vector();
            this.sysHtmlName = new Vector();
        }
        this.sysButtonName.add(button);
        this.sysHtmlName.add(html);
    }

    private void addButtonLPAR(String button, String html) {
        if (this.lparButtonName == null) {
            this.lparButtonName = new Vector();
            this.lparHtmlName = new Vector();
        }
        this.lparButtonName.add(button);
        this.lparHtmlName.add(html);
    }

    private void addButtonPool(String button, String html) {
        if (this.poolButtonName == null) {
            this.poolButtonName = new Vector();
            this.poolHtmlName = new Vector();
        }
        this.poolButtonName.add(button);
        this.poolHtmlName.add(html);
    }

    private void createSystemHtmlStructure(String dirName) {
        this.createSystemPerfIndexHtml(dirName);
        int i = 0;
        while (i < this.managedSystem.length) {
            PrintWriter target;
            String name = this.managedSystem[i].getVarValues("name")[0];
            try {
                target = new PrintWriter(new FileOutputStream(new File(String.valueOf(dirName) + File.separatorChar + name + ".html")));
            }
            catch (IOException e) {
                System.out.println("\nError creating file " + dirName + File.separatorChar + name + ".html");
                System.out.println("Skipping HTML creation");
                return;
            }
            target.println("<HTML><HEAD></HEAD>");
            target.println("<BODY BGCOLOR=#e6e6e6 TEXT=#000000 LINK=#0000FF VLINK=#0000FF ALINK=#FF0000><H1>" + name + "</H1>");
            target.println("<IMG SRC=" + name + "_daily.png><BR>");
            target.println("<BR><BR>");
            target.println("<IMG SRC=" + name + "_hourly.png><BR>");
            target.println("</BODY></HTML");
            target.close();
            File f = new File(String.valueOf(dirName) + File.separatorChar + name + "_daily.png");
            this.createSysPoolDailyImage(i, f);
            f = new File(String.valueOf(dirName) + File.separatorChar + name + "_hourly.png");
            this.createSysPoolHourlyImage(i, f);
            this.addButtonSystem(name, String.valueOf(name) + ".html");
            ++i;
        }
        this.createSystemMenuHtml(dirName);
    }

    private void createLPARHtmlStructure(String dirName) {
        this.createLPARPerfIndexHtml(dirName);
        int i = 0;
        while (i < this.lparNames.length) {
            PrintWriter target;
            String name = this.lparNames[i];
            try {
                target = new PrintWriter(new FileOutputStream(new File(String.valueOf(dirName) + File.separatorChar + name + ".html")));
            }
            catch (IOException e) {
                System.out.println("\nError creating file " + dirName + File.separatorChar + name + ".html");
                System.out.println("Skipping HTML creation");
                return;
            }
            target.println("<HTML><HEAD></HEAD>");
            target.println("<BODY BGCOLOR=#e6e6e6 TEXT=#000000 LINK=#0000FF VLINK=#0000FF ALINK=#FF0000><H1>" + name + "</H1>");
            target.println("<IMG SRC=" + name + "_daily.png><BR>");
            target.println("<BR><BR>");
            target.println("<IMG SRC=" + name + "_hourly.png><BR>");
            target.println("</BODY></HTML");
            target.close();
            File f = new File(String.valueOf(dirName) + File.separatorChar + name + "_daily.png");
            this.createLparDailyImage(i, f);
            f = new File(String.valueOf(dirName) + File.separatorChar + name + "_hourly.png");
            this.createLparHourlyImage(i, f);
            this.addButtonLPAR(name, String.valueOf(name) + ".html");
            ++i;
        }
        this.createLPARMenuHtml(dirName);
    }

    private void createPoolHtmlStructure(String dirName) {
        this.createPoolPerfIndexHtml(dirName);
        int i = 0;
        while (this.procPoolName != null && i < this.procPoolName.length) {
            PrintWriter target;
            String name = this.procPoolName[i].replace('\n', '@');
            try {
                target = new PrintWriter(new FileOutputStream(new File(String.valueOf(dirName) + File.separatorChar + name + ".html")));
            }
            catch (IOException e) {
                System.out.println("\nError creating file " + dirName + File.separatorChar + name + ".html");
                System.out.println("Skipping HTML creation");
                return;
            }
            target.println("<HTML><HEAD></HEAD>");
            target.println("<BODY BGCOLOR=#e6e6e6 TEXT=#000000 LINK=#0000FF VLINK=#0000FF ALINK=#FF0000><H1>" + name + "</H1>");
            target.println("<IMG SRC=" + name + "_daily.png><BR>");
            target.println("<BR><BR>");
            target.println("<IMG SRC=" + name + "_hourly.png><BR>");
            target.println("</BODY></HTML");
            target.close();
            File f = new File(String.valueOf(dirName) + File.separatorChar + name + "_daily.png");
            this.createVirtPoolDailyImage(i, f);
            f = new File(String.valueOf(dirName) + File.separatorChar + name + "_hourly.png");
            this.createVirtPoolHourlyImage(i, f);
            this.addButtonPool(name, String.valueOf(name) + ".html");
            ++i;
        }
        this.createPoolMenuHtml(dirName);
    }

    private void createPoolMenuHtml(String dirName) {
        FileOutputStream fos;
        try {
            fos = new FileOutputStream(String.valueOf(dirName) + File.separatorChar + poolperfmenu_html);
        }
        catch (IOException e) {
            System.out.println("\nError creating file " + dirName + File.separatorChar + poolperfmenu_html);
            System.out.println("Skipping HTML creation");
            return;
        }
        PrintWriter index = new PrintWriter(fos);
        index.println("<HTML>\n<HEAD>");
        index.println("<STYLE>\n\tbutton{width:100%;font-family:calibri;font-size:12px;}\n</STYLE>");
        index.println("</HEAD>");
        index.println("<BODY BGCOLOR=#e6e6e6 TEXT=#000000 LINK=#0000FF VLINK=#0000FF ALINK=#FF0000>");
        int i = 0;
        while (this.poolButtonName != null && i < this.poolButtonName.size()) {
            index.println("<a href=\"" + this.poolHtmlName.elementAt(i) + "\" target=\"poolperfdata\">" + "<button type=\"button\">" + this.poolButtonName.elementAt(i) + "</button>" + "</a>");
            index.println("<BR>");
            ++i;
        }
        index.println("</BODY>");
        index.println("</HTML>");
        index.close();
    }

    private void createSystemMenuHtml(String dirName) {
        PrintWriter index;
        try {
            index = new PrintWriter(new FileOutputStream(String.valueOf(dirName) + File.separatorChar + sysperfmenu_html));
        }
        catch (IOException e) {
            System.out.println("\nError creating file " + dirName + File.separatorChar + sysperfmenu_html);
            System.out.println("Skipping HTML creation");
            return;
        }
        index.println("<HTML>\n<HEAD>");
        index.println("<STYLE>\n\tbutton{width:100%;font-family:calibri;font-size:12px;}\n</STYLE>");
        index.println("</HEAD>");
        index.println("<BODY BGCOLOR=#e6e6e6 TEXT=#000000 LINK=#0000FF VLINK=#0000FF ALINK=#FF0000>");
        int i = 0;
        while (i < this.sysButtonName.size()) {
            index.println("<a href=\"" + this.sysHtmlName.elementAt(i) + "\" target=\"sysperfdata\">" + "<button type=\"button\">" + this.sysButtonName.elementAt(i) + "</button>" + "</a>");
            index.println("<BR>");
            ++i;
        }
        index.println("</BODY>");
        index.println("</HTML>");
        index.close();
    }

    private void createLPARMenuHtml(String dirName) {
        PrintWriter index;
        try {
            index = new PrintWriter(new FileOutputStream(String.valueOf(dirName) + File.separatorChar + lparperfmenu_html));
        }
        catch (IOException e) {
            System.out.println("\nError creating file " + dirName + File.separatorChar + lparperfmenu_html);
            System.out.println("Skipping HTML creation");
            return;
        }
        index.println("<HTML>\n<HEAD>");
        index.println("<STYLE>\n\tbutton{width:100%;font-family:calibri;font-size:12px;}\n</STYLE>");
        index.println("</HEAD>");
        index.println("<BODY BGCOLOR=#e6e6e6 TEXT=#000000 LINK=#0000FF VLINK=#0000FF ALINK=#FF0000>");
        int i = 0;
        while (i < this.lparButtonName.size()) {
            index.println("<a href=\"" + this.lparHtmlName.elementAt(i) + "\" target=\"lparperfdata\">" + "<button type=\"button\">" + this.lparButtonName.elementAt(i) + "</button>" + "</a>");
            index.println("<BR>");
            ++i;
        }
        index.println("</BODY>");
        index.println("</HTML>");
        index.close();
    }

    private void createMenuHtml(String dirName) {
        PrintWriter index;
        try {
            index = new PrintWriter(new FileOutputStream(String.valueOf(dirName) + File.separatorChar + menu_html));
        }
        catch (IOException e) {
            System.out.println("\nError creating file " + dirName + File.separatorChar + menu_html);
            System.out.println("Skipping HTML creation");
            return;
        }
        index.println("<HTML>\n<HEAD>");
        index.println("<STYLE>\n\tbutton{width:100%;font-family:calibri;font-size:12px;}\n</STYLE>");
        index.println("</HEAD>");
        index.println("<BODY BGCOLOR=#e6e6e6 TEXT=#000000 LINK=#0000FF VLINK=#0000FF ALINK=#FF0000>");
        int i = 0;
        while (i < this.buttonName.size()) {
            index.println("<a href=\"" + this.htmlName.elementAt(i) + "\" target=\"data\">" + "<button type=\"button\">" + this.buttonName.elementAt(i) + "</button>" + "</a>");
            index.println("<BR>");
            ++i;
        }
        index.println("</BODY>");
        index.println("</HTML>");
        index.close();
    }

    private void createLparHourlyImage(int id, File file) {
        float[] pc = new float[1440];
        float[] ent = new float[1440];
        float[] vp = new float[1440];
        float[] max = new float[1440];
        int STEP = 120;
        String[] label = new String[12];
        LparGraph lg = null;
        int i = 0;
        while (i < pc.length) {
            pc[i] = this.lparPC[id].getHourData(i);
            ent[i] = this.lparEnt[id].getHourData(i);
            vp[i] = this.lparVP[id].getHourData(i);
            boolean cap = this.lparStatus[id].getHourCap(i);
            String ms = this.lparStatus[id].getHourMS(i);
            String pool = this.lparStatus[id].getHourPool(i);
            if (pc[i] < 0.0f || ent[i] <= 0.0f) {
                max[i] = -1.0f;
            } else {
                float free;
                if (pool.equals("DefaultPool")) {
                    free = this.msCoreConfig[this.getMSid(ms)].getHourData(i) - this.msCoreUsed[this.getMSid(ms)].getHourData(i);
                } else {
                    int poolID = this.getProcPoolId(ms, pool);
                    free = this.procPoolConfig[poolID].getHourData(i) - this.procPoolUsed[poolID].getHourData(i);
                }
                if (cap) {
                    max[i] = ent[i];
                } else {
                    max[i] = pc[i] + free >= vp[i] ? vp[i] : pc[i] + free;
                    if (max[i] < ent[i]) {
                        max[i] = ent[i];
                    }
                }
            }
            ++i;
        }
        i = 120;
        int j = 0;
        while (i < 1440) {
            label[j++] = this.lparPC[id].getHourLabel(i);
            i += 120;
        }
        lg = new LparGraph(String.valueOf(this.lparNames[id]) + " - 2 Months Hourly", pc, ent, vp, max, label, 120);
        lg.setSize(this.XSIZE, this.YSIZE);
        lg.repaint();
        try {
            BufferedImage bi = new BufferedImage(lg.getWidth(), lg.getHeight(), 1);
            Graphics2D g2d = bi.createGraphics();
            lg.paint(g2d);
            try {
                ImageIO.write((RenderedImage)bi, "png", file);
            }
            catch (IOException iOException) {}
        }
        catch (OutOfMemoryError oome) {
            System.out.println(" Insufficient memory to create PNG output!");
            System.out.println(" Provide more memory to Java using the -Xmx flag.");
        }
    }

    private void createVirtPoolDailyImage(int id, File file) {
        float[] pc = new float[365];
        float[] size = new float[365];
        float[] max = new float[365];
        int STEP = 40;
        String[] label = new String[9];
        PoolGraph pg = null;
        String poolName = this.procPoolName[id];
        String[] split = poolName.split("\n");
        String msName = split[1];
        int msID = 0;
        while (msID < this.msCoreUsed.length) {
            if (this.managedSystem[msID].getVarValues("name")[0].equals(msName)) break;
            ++msID;
        }
        int i = 0;
        while (i < pc.length) {
            pc[i] = this.procPoolUsed[id].getDayData(i);
            size[i] = this.procPoolConfig[id].getDayData(i);
            max[i] = size[i] <= this.msCoreConfig[msID].getDayData(i) - this.msCoreUsed[msID].getDayData(i) ? size[i] : this.msCoreConfig[msID].getDayData(i) - this.msCoreUsed[msID].getDayData(i);
            ++i;
        }
        i = 40;
        int j = 0;
        while (i < 365) {
            label[j++] = this.procPoolUsed[id].getDayLabel(i);
            i += 40;
        }
        pg = new PoolGraph(String.valueOf(split[0]) + "@" + split[1] + " - 1 Year Daily", pc, size, max, label, 40);
        pg.setSize(this.XSIZE, this.YSIZE);
        pg.repaint();
        try {
            BufferedImage bi = new BufferedImage(pg.getWidth(), pg.getHeight(), 1);
            Graphics2D g2d = bi.createGraphics();
            pg.paint(g2d);
            try {
                ImageIO.write((RenderedImage)bi, "png", file);
            }
            catch (IOException iOException) {}
        }
        catch (OutOfMemoryError oome) {
            System.out.println(" Insufficient memory to create PNG output!");
            System.out.println(" Provide more memory to Java using the -Xmx flag.");
        }
    }

    private void createVirtPoolHourlyImage(int id, File file) {
        float[] pc = new float[1440];
        float[] size = new float[1440];
        float[] max = new float[1440];
        int STEP = 120;
        String[] label = new String[12];
        PoolGraph pg = null;
        String poolName = this.procPoolName[id];
        String[] split = poolName.split("\n");
        String msName = split[1];
        int msID = 0;
        while (msID < this.msCoreUsed.length) {
            if (this.managedSystem[msID].getVarValues("name")[0].equals(msName)) break;
            ++msID;
        }
        int i = 0;
        while (i < pc.length) {
            pc[i] = this.procPoolUsed[id].getHourData(i);
            size[i] = this.procPoolConfig[id].getHourData(i);
            max[i] = size[i] <= this.msCoreConfig[msID].getHourData(i) - this.msCoreUsed[msID].getHourData(i) ? size[i] : this.msCoreConfig[msID].getHourData(i) - this.msCoreUsed[msID].getHourData(i);
            ++i;
        }
        i = 120;
        int j = 0;
        while (i < 1440) {
            label[j++] = this.procPoolUsed[id].getHourLabel(i);
            i += 120;
        }
        pg = new PoolGraph(String.valueOf(split[0]) + "@" + split[1] + " - 2 Months Hourly", pc, size, max, label, 120);
        pg.setSize(this.XSIZE, this.YSIZE);
        pg.repaint();
        try {
            BufferedImage bi = new BufferedImage(pg.getWidth(), pg.getHeight(), 1);
            Graphics2D g2d = bi.createGraphics();
            pg.paint(g2d);
            try {
                ImageIO.write((RenderedImage)bi, "png", file);
            }
            catch (IOException iOException) {}
        }
        catch (OutOfMemoryError oome) {
            System.out.println(" Insufficient memory to create PNG output!");
            System.out.println(" Provide more memory to Java using the -Xmx flag.");
        }
    }

    private void createSysPoolHourlyImage(int id, File file) {
        float[] pc = new float[1440];
        float[] size = new float[1440];
        int STEP = 120;
        String[] label = new String[12];
        PoolGraph pg = null;
        int i = 0;
        while (i < pc.length) {
            pc[i] = this.msCoreUsed[id].getHourData(i);
            size[i] = this.msCoreConfig[id].getHourData(i);
            ++i;
        }
        i = 120;
        int j = 0;
        while (i < 1440) {
            label[j++] = this.msCoreUsed[id].getHourLabel(i);
            i += 120;
        }
        pg = new PoolGraph(String.valueOf(this.managedSystem[id].getVarValues("name")[0]) + " - 2 Months Hourly", pc, size, label, 120);
        pg.setSize(this.XSIZE, this.YSIZE);
        pg.repaint();
        try {
            BufferedImage bi = new BufferedImage(pg.getWidth(), pg.getHeight(), 1);
            Graphics2D g2d = bi.createGraphics();
            pg.paint(g2d);
            try {
                ImageIO.write((RenderedImage)bi, "png", file);
            }
            catch (IOException iOException) {}
        }
        catch (OutOfMemoryError oome) {
            System.out.println(" Insufficient memory to create PNG output!");
            System.out.println(" Provide more memory to Java using the -Xmx flag.");
        }
    }

    private void createSysPoolDailyImage(int id, File file) {
        float[] pc = new float[365];
        float[] size = new float[365];
        int STEP = 40;
        String[] label = new String[9];
        PoolGraph pg = null;
        int i = 0;
        while (i < pc.length) {
            pc[i] = this.msCoreUsed[id].getDayData(i);
            size[i] = this.msCoreConfig[id].getDayData(i);
            ++i;
        }
        i = 40;
        int j = 0;
        while (i < 365) {
            label[j++] = this.msCoreUsed[id].getDayLabel(i);
            i += 40;
        }
        pg = new PoolGraph(String.valueOf(this.managedSystem[id].getVarValues("name")[0]) + " - 1 Year Daily", pc, size, label, 40);
        pg.setSize(this.XSIZE, this.YSIZE);
        pg.repaint();
        try {
            BufferedImage bi = new BufferedImage(pg.getWidth(), pg.getHeight(), 1);
            Graphics2D g2d = bi.createGraphics();
            pg.paint(g2d);
            try {
                ImageIO.write((RenderedImage)bi, "png", file);
            }
            catch (IOException iOException) {}
        }
        catch (OutOfMemoryError oome) {
            System.out.println(" Insufficient memory to create PNG output!");
            System.out.println(" Provide more memory to Java using the -Xmx flag.");
        }
    }

    private void createLparDailyImage(int id, File file) {
        float[] pc = new float[365];
        float[] ent = new float[365];
        float[] vp = new float[365];
        float[] max = new float[365];
        int STEP = 40;
        String[] label = new String[9];
        LparGraph lg = null;
        int i = 0;
        while (i < pc.length) {
            pc[i] = this.lparPC[id].getDayData(i);
            ent[i] = this.lparEnt[id].getDayData(i);
            vp[i] = this.lparVP[id].getDayData(i);
            boolean cap = this.lparStatus[id].getDayCap(i);
            String ms = this.lparStatus[id].getDayMS(i);
            String pool = this.lparStatus[id].getDayPool(i);
            if (pc[i] < 0.0f || ent[i] <= 0.0f) {
                max[i] = -1.0f;
            } else {
                float free;
                if (pool.equals("DefaultPool")) {
                    free = this.msCoreConfig[this.getMSid(ms)].getDayData(i) - this.msCoreUsed[this.getMSid(ms)].getDayData(i);
                } else {
                    int poolID = this.getProcPoolId(ms, pool);
                    free = this.procPoolConfig[poolID].getDayData(i) - this.procPoolUsed[poolID].getDayData(i);
                }
                if (cap) {
                    max[i] = ent[i];
                } else {
                    max[i] = pc[i] + free >= vp[i] ? vp[i] : pc[i] + free;
                    if (max[i] < ent[i]) {
                        max[i] = ent[i];
                    }
                }
            }
            ++i;
        }
        i = 40;
        int j = 0;
        while (i < 365) {
            label[j++] = this.lparPC[id].getDayLabel(i);
            i += 40;
        }
        lg = new LparGraph(String.valueOf(this.lparNames[id]) + " - 1 Year Daily", pc, ent, vp, max, label, 40);
        lg.setSize(this.XSIZE, this.YSIZE);
        lg.repaint();
        try {
            BufferedImage bi = new BufferedImage(lg.getWidth(), lg.getHeight(), 1);
            Graphics2D g2d = bi.createGraphics();
            lg.paint(g2d);
            try {
                ImageIO.write((RenderedImage)bi, "png", file);
            }
            catch (IOException iOException) {}
        }
        catch (OutOfMemoryError oome) {
            System.out.println(" Insufficient memory to create PNG output!");
            System.out.println(" Provide more memory to Java using the -Xmx flag.");
        }
    }

    private void createIOChildrenSheetExcel(WritableSheet sheet) {
        DataSheet ds = this.createIOChildrenSheet();
        ds.createExcelSheet(sheet);
    }

    private void createIOChildrenSheetHTML(String fileName) {
        DataSheet ds = this.createIOChildrenSheet();
        ds.createHTMLSheet(fileName);
        this.addButton("IO Children", new File(fileName).getName());
    }

    private void createIOChildrenSheetCSV(String fileName) {
        DataSheet ds = this.createIOChildrenSheet();
        ds.setSeparator(this.csvSeparator);
        ds.createCSVSheet(fileName);
    }

    private DataSheet createIOChildrenSheet() {
        DataSheet ds = new DataSheet();
        int[] size = new int[7];
        int row = 0;
        int col = 0;
        int i = 0;
        while (i < size.length) {
            size[i] = 0;
            ++i;
        }
        int n = ds.addLabel(col, row, "Physical Location", BOLD | VCENTRE | B_ALL_MED | GREEN);
        if (n > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Description", BOLD | VCENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Microcode Version", BOLD | VCENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "MAC Address", BOLD | RIGHT | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "WWPN", BOLD | RIGHT | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Managed System Name", BOLD | CENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Managed System Serial", BOLD | CENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        ++col;
        ++row;
        i = 0;
        while (i < this.managedSystem.length) {
            GenericData[] children = this.managedSystem[i].getObjects(IOSLOTCHILDREN);
            if (children != null) {
                int j = 0;
                while (j < children.length) {
                    col = 0;
                    String[] s = children[j].getVarValues("phys_loc");
                    n = ds.addLabel(col, row, s, 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                    if (n > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, s = children[j].getVarValues("description"), 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, s = children[j].getVarValues("microcode_version"), 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, s = children[j].getVarValues("mac_address"), 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, s = children[j].getVarValues("wwpn"), 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, s = this.managedSystem[i].getVarValues("name"), 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, s = this.managedSystem[i].getVarValues("serial_num"), 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    ++col;
                    ++row;
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < size.length) {
            ds.setColSize(i, size[i] + 2);
            ++i;
        }
        return ds;
    }

    private DataSheet createOnOffSheet() {
        DataSheet ds = new DataSheet();
        int[] size = new int[15];
        int row = 0;
        int col = 0;
        int i = 0;
        while (i < size.length) {
            size[i] = 0;
            ++i;
        }
        int n = ds.addLabel(col, row, "Type", BOLD | VCENTRE | B_ALL_MED | GREEN);
        if (n > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "State", BOLD | VCENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Activated", BOLD | VCENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Available", BOLD | RIGHT | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Unreturned", BOLD | RIGHT | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Days left", BOLD | RIGHT | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Hours left", BOLD | RIGHT | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Days available", BOLD | RIGHT | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Report date", BOLD | RIGHT | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Report time", BOLD | RIGHT | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Hist expired days", BOLD | RIGHT | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Hist unreturned days", BOLD | RIGHT | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Tot sys runtime hours", BOLD | RIGHT | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Managed System Name", BOLD | CENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Managed System Serial", BOLD | CENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        ++col;
        ++row;
        i = 0;
        while (i < this.managedSystem.length) {
            String[] s;
            GenericData[] onoff_cap = this.managedSystem[i].getObjects(LSCOD_CAP_PROC_ONOFF);
            if (onoff_cap != null && onoff_cap.length > 0) {
                col = 0;
                n = ds.addLabel(col, row, "CPU", B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                if (n > size[col]) {
                    size[col] = n;
                }
                if ((n = ds.addLabel(++col, row, s = onoff_cap[0].getVarValues("proc_onoff_state"), 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                    size[col] = n;
                }
                s = onoff_cap[0].getVarValues("activated_onoff_procs");
                ds.addInteger(++col, row, s, 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                s = onoff_cap[0].getVarValues("avail_procs_for_onoff");
                ds.addInteger(++col, row, s, 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                s = onoff_cap[0].getVarValues("unreturned_onoff_procs");
                ds.addInteger(++col, row, s, 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                s = onoff_cap[0].getVarValues("onoff_request_proc_days_left");
                ds.addInteger(++col, row, s, 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                s = onoff_cap[0].getVarValues("onoff_proc_day_hours_left");
                ds.addInteger(++col, row, s, 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                s = onoff_cap[0].getVarValues("onoff_proc_days_avail");
                ds.addInteger(++col, row, s, 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                ++col;
                onoff_cap = this.managedSystem[i].getObjects(LSCOD_BILL_PROC);
                if (onoff_cap != null && onoff_cap.length > 0) {
                    s = onoff_cap[0].getVarValues("collection_date");
                    n = ds.addLabel(col, row, s, 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                    if (n > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, s = onoff_cap[0].getVarValues("collection_time"), 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    s = onoff_cap[0].getVarValues("hist_expired_resource_days");
                    ds.addInteger(++col, row, s, 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                    s = onoff_cap[0].getVarValues("hist_unreturned_resource_days");
                    ds.addInteger(++col, row, s, 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                    s = onoff_cap[0].getVarValues("total_sys_run_time_hours");
                    ds.addInteger(++col, row, s, 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                    ++col;
                }
                if ((n = ds.addLabel(col, row, s = this.managedSystem[i].getVarValues("name"), 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                    size[col] = n;
                }
                if ((n = ds.addLabel(++col, row, s = this.managedSystem[i].getVarValues("serial_num"), 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                    size[col] = n;
                }
                ++col;
                ++row;
            }
            if ((onoff_cap = this.managedSystem[i].getObjects(LSCOD_CAP_MEM_ONOFF)) != null && onoff_cap.length > 0) {
                col = 0;
                n = ds.addLabel(col, row, "MEM", B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                if (n > size[col]) {
                    size[col] = n;
                }
                if ((n = ds.addLabel(++col, row, s = onoff_cap[0].getVarValues("mem_onoff_state"), 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                    size[col] = n;
                }
                s = onoff_cap[0].getVarValues("activated_onoff_mem");
                ds.addInteger(++col, row, s, 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                s = onoff_cap[0].getVarValues("avail_mem_for_onoff");
                ds.addInteger(++col, row, s, 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                s = onoff_cap[0].getVarValues("unreturned_onoff_mem");
                ds.addInteger(++col, row, s, 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                s = onoff_cap[0].getVarValues("onoff_request_mem_days_left");
                ds.addInteger(++col, row, s, 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                s = onoff_cap[0].getVarValues("onoff_mem_day_hours_left");
                ds.addInteger(++col, row, s, 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                s = onoff_cap[0].getVarValues("onoff_mem_days_avail");
                ds.addInteger(++col, row, s, 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                ++col;
                onoff_cap = this.managedSystem[i].getObjects(LSCOD_BILL_MEM);
                if (onoff_cap != null && onoff_cap.length > 0) {
                    s = onoff_cap[0].getVarValues("collection_date");
                    n = ds.addLabel(col, row, s, 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                    if (n > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, s = onoff_cap[0].getVarValues("collection_time"), 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    s = onoff_cap[0].getVarValues("hist_expired_resource_days");
                    ds.addInteger(++col, row, s, 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                    s = onoff_cap[0].getVarValues("hist_unreturned_resource_days");
                    ds.addInteger(++col, row, s, 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                    s = onoff_cap[0].getVarValues("total_sys_run_time_hours");
                    ds.addInteger(++col, row, s, 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                    ++col;
                }
                if ((n = ds.addLabel(col, row, s = this.managedSystem[i].getVarValues("name"), 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                    size[col] = n;
                }
                if ((n = ds.addLabel(++col, row, s = this.managedSystem[i].getVarValues("serial_num"), 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                    size[col] = n;
                }
                ++col;
                ++row;
            }
            ++i;
        }
        i = 0;
        while (i < size.length) {
            ds.setColSize(i, size[i] + 2);
            ++i;
        }
        return ds;
    }

    private void createOnOffSheetExcel(WritableSheet sheet) {
        DataSheet ds = this.createOnOffSheet();
        ds.createExcelSheet(sheet);
    }

    private void createOnOffSheetHTML(String fileName) {
        DataSheet ds = this.createOnOffSheet();
        ds.createHTMLSheet(fileName);
        this.addButton("OnOff", new File(fileName).getName());
    }

    private void createOnOffSheetCSV(String fileName) {
        DataSheet ds = this.createOnOffSheet();
        ds.setSeparator(this.csvSeparator);
        ds.createCSVSheet(fileName);
    }

    private DataSheet createCoDLogSheet() {
        DataSheet ds = new DataSheet();
        int[] size = new int[4];
        int row = 0;
        int col = 0;
        int i = 0;
        while (i < size.length) {
            size[i] = 0;
            ++i;
        }
        int n = ds.addLabel(col, row, "Time", BOLD | VCENTRE | B_ALL_MED | GREEN);
        if (n > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Event", BOLD | VCENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Managed System Name", BOLD | CENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Managed System Serial", BOLD | CENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        ++col;
        ++row;
        i = 0;
        while (i < this.managedSystem.length) {
            GenericData[] event = this.managedSystem[i].getObjects(LSCOD_HIST);
            if (event != null) {
                int j = event.length - 1;
                while (j >= 0) {
                    col = 0;
                    String[] s = event[j].getVarValues("time_stamp");
                    String date = String.valueOf(s[0].substring(6, 10)) + "/" + s[0].substring(0, 2) + "/" + s[0].substring(3, 5) + " " + s[0].substring(11);
                    n = ds.addLabel(col, row, date, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                    if (n > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, s = event[j].getVarValues("entry"), 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, s = this.managedSystem[i].getVarValues("name"), 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, s = this.managedSystem[i].getVarValues("serial_num"), 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    ++col;
                    ++row;
                    --j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < size.length) {
            ds.setColSize(i, size[i] + 2);
            ++i;
        }
        return ds;
    }

    private void createCoDLogSheetExcel(WritableSheet sheet) {
        DataSheet ds = this.createCoDLogSheet();
        ds.createExcelSheet(sheet);
    }

    private void createCoDLogSheetHTML(String fileName) {
        DataSheet ds = this.createCoDLogSheet();
        ds.createHTMLSheet(fileName);
        this.addButton("OnOff Log", new File(fileName).getName());
    }

    private void createCoDLogSheetCSV(String fileName) {
        DataSheet ds = this.createCoDLogSheet();
        ds.setSeparator(this.csvSeparator);
        ds.createCSVSheet(fileName);
    }

    private DataSheet createSspSheet() {
        int j;
        String[] s;
        GenericData[] status;
        DataSheet ds = new DataSheet();
        int[] size = new int[12];
        int row = 0;
        int col = 0;
        int i = 0;
        while (i < size.length) {
            size[i] = 0;
            ++i;
        }
        int n = ds.addLabel(col, row, "Cluster Data", BOLD | CENTRE | B_ALL_MED | GREEN);
        if (n > size[col]) {
            size[col] = n;
        }
        ++col;
        col = 0;
        if ((n = ds.addLabel(col, ++row, "Name", BOLD | VCENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "ID", BOLD | VCENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Managed System Read", BOLD | CENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "VIOS name Read", BOLD | CENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "State", BOLD | CENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Repos mode", BOLD | CENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Num nodes", BOLD | CENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Nodes OK", BOLD | CENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Nodes down", BOLD | CENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Pool name", BOLD | CENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Pool id", BOLD | CENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Pool state", BOLD | CENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        ++col;
        ++row;
        i = 0;
        while (i < this.sspcluster.length) {
            col = 0;
            status = this.sspcluster[i].getObjects(CLUSTERSTATUS);
            if (status != null) {
                s = this.sspcluster[i].getVarValues("nameid");
                n = ds.addLabel(col, row, s, 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                if (n > size[col]) {
                    size[col] = n;
                }
                if ((n = ds.addLabel(++col, row, s, 1, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                    size[col] = n;
                }
                if ((n = ds.addLabel(++col, row, s = this.sspcluster[i].getVarValues("ms"), 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                    size[col] = n;
                }
                if ((n = ds.addLabel(++col, row, s = this.sspcluster[i].getVarValues("vios"), 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                    size[col] = n;
                }
                if ((n = ds.addLabel(++col, row, s = status[0].getVarValues("cluster_state"), 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                    size[col] = n;
                }
                if ((n = ds.addLabel(++col, row, s = status[0].getVarValues("repos_mode"), 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                    size[col] = n;
                }
                if ((n = ds.addLabel(++col, row, s = status[0].getVarValues("number_of_nodes"), 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                    size[col] = n;
                }
                if ((n = ds.addLabel(++col, row, s = status[0].getVarValues("nodes_ok"), 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                    size[col] = n;
                }
                if ((n = ds.addLabel(++col, row, s = status[0].getVarValues("nodes_down"), 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                    size[col] = n;
                }
                if ((n = ds.addLabel(++col, row, s = status[0].getVarValues("pool_name"), 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                    size[col] = n;
                }
                if ((n = ds.addLabel(++col, row, s = status[0].getVarValues("pool_id"), 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                    size[col] = n;
                }
                if ((n = ds.addLabel(++col, row, s = status[0].getVarValues("pool_state"), 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                    size[col] = n;
                }
                ++col;
                ++row;
            }
            ++i;
        }
        col = 0;
        n = ds.addLabel(col, row += 2, "Nodes Data", BOLD | CENTRE | B_ALL_MED | GREEN);
        if (n > size[col]) {
            size[col] = n;
        }
        ++col;
        col = 0;
        if ((n = ds.addLabel(col, ++row, "Cluster name", BOLD | VCENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Cluster ID", BOLD | VCENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Name", BOLD | CENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "ID", BOLD | CENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Managed System", BOLD | CENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "LPAR ID", BOLD | CENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "State", BOLD | CENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Repos state", BOLD | CENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Upgrade status", BOLD | CENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Roles", BOLD | CENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        ++col;
        ++row;
        i = 0;
        while (i < this.sspcluster.length) {
            col = 0;
            status = this.sspcluster[i].getObjects(CLUSTERSTATUS);
            if (status != null) {
                j = 0;
                while (j < status.length) {
                    col = 0;
                    s = this.sspcluster[i].getVarValues("nameid");
                    n = ds.addLabel(col, row, s, 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                    if (n > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, s, 1, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, s = status[j].getVarValues("node_name"), 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, s = status[j].getVarValues("node_id"), 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, s = status[j].getVarValues("node_mtm"), 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, s = status[j].getVarValues("node_partition_num"), 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, s = status[j].getVarValues("node_state"), 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, s = status[j].getVarValues("node_repos_state"), 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, s = status[j].getVarValues("node_upgrade_status"), 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, s = status[j].getVarValues("node_roles"), 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    ++col;
                    ++row;
                    ++j;
                }
            }
            ++i;
        }
        col = 0;
        n = ds.addLabel(col, row += 2, "Pool Data", BOLD | CENTRE | B_ALL_MED | GREEN);
        if (n > size[col]) {
            size[col] = n;
        }
        ++col;
        col = 0;
        if ((n = ds.addLabel(col, ++row, "Cluster name", BOLD | VCENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Cluster ID", BOLD | VCENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Name", BOLD | CENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Size", BOLD | CENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Free", BOLD | CENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Total", BOLD | CENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Overcommit", BOLD | CENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "#LU", BOLD | CENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Type", BOLD | CENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "ID", BOLD | CENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        ++col;
        ++row;
        i = 0;
        while (i < this.sspcluster.length) {
            col = 0;
            status = this.sspcluster[i].getObjects(CLUSTERPOOL);
            if (status != null) {
                j = 0;
                while (j < status.length) {
                    col = 0;
                    s = this.sspcluster[i].getVarValues("nameid");
                    n = ds.addLabel(col, row, s, 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                    if (n > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, s, 1, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, s = status[j].getVarValues("pool"), 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, s = status[j].getVarValues("size"), 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, s = status[j].getVarValues("free"), 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, s = status[j].getVarValues("total"), 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, s = status[j].getVarValues("overcommit"), 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, s = status[j].getVarValues("lus"), 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, s = status[j].getVarValues("type"), 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, s = status[j].getVarValues("id"), 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    ++col;
                    ++row;
                    ++j;
                }
            }
            ++i;
        }
        col = 0;
        n = ds.addLabel(col, row += 2, "LU Data", BOLD | CENTRE | B_ALL_MED | GREEN);
        if (n > size[col]) {
            size[col] = n;
        }
        ++col;
        col = 0;
        if ((n = ds.addLabel(col, ++row, "Cluster name", BOLD | VCENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Cluster ID", BOLD | VCENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Name", BOLD | CENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Size", BOLD | CENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Provision type", BOLD | CENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Usage", BOLD | CENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Unused", BOLD | CENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Device ID", BOLD | CENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        ++col;
        ++row;
        i = 0;
        while (i < this.sspcluster.length) {
            col = 0;
            status = this.sspcluster[i].getObjects(CLUSTERLUN);
            if (status != null) {
                j = 0;
                while (j < status.length) {
                    col = 0;
                    s = this.sspcluster[i].getVarValues("nameid");
                    n = ds.addLabel(col, row, s, 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                    if (n > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, s, 1, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, s = status[j].getVarValues("luname"), 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, s = status[j].getVarValues("size"), 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, s = status[j].getVarValues("provisiontype"), 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, s = status[j].getVarValues("usage"), 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, s = status[j].getVarValues("unused"), 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, s = status[j].getVarValues("luudid"), 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    ++col;
                    ++row;
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < size.length) {
            ds.setColSize(i, size[i] + 2);
            ++i;
        }
        return ds;
    }

    private void createSspSheetExcel(WritableSheet sheet) {
        DataSheet ds = this.createSspSheet();
        ds.createExcelSheet(sheet);
    }

    private void createSspSheetHTML(String fileName) {
        DataSheet ds = this.createSspSheet();
        ds.createHTMLSheet(fileName);
        this.addButton("SSP", new File(fileName).getName());
    }

    private void createSspSheetCSV(String fileName) {
        DataSheet ds = this.createSspSheet();
        ds.setSeparator(this.csvSeparator);
        ds.createCSVSheet(fileName);
    }

    private void createProfileSheetExcel(WritableSheet sheet) {
        DataSheet ds = this.createProfileSheet();
        if (ds != null) {
            ds.createExcelSheet(sheet);
        }
    }

    private void createProfileSheetHTML(String fileName) {
        DataSheet ds = this.createProfileSheet();
        if (ds != null) {
            ds.createHTMLSheet(fileName);
            this.addButton("LPAR Profiles", new File(fileName).getName());
        }
    }

    private void createProfileSheetCSV(String fileName) {
        DataSheet ds = this.createProfileSheet();
        if (ds != null) {
            ds.setSeparator(this.csvSeparator);
            ds.createCSVSheet(fileName);
        }
    }

    private DataSheet createProfileSheet() {
        DataSheet ds = new DataSheet();
        int[] size = new int[35];
        int row = 0;
        int col = 0;
        int i = 0;
        while (i < size.length) {
            size[i] = 0;
            ++i;
        }
        int n = ds.addLabel(col, row, "Lpar Name", BOLD | VCENTRE | B_ALL_MED | GREEN);
        if (n > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Profile Name", BOLD | VCENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Active", BOLD | VCENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "ID", BOLD | RIGHT | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Env", BOLD | RIGHT | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "All Res", BOLD | RIGHT | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "MinMem", BOLD | RIGHT | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "DesMem", BOLD | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "MaxMem", BOLD | RIGHT | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "MinHugePages", BOLD | RIGHT | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "DesHugePages", BOLD | RIGHT | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "MaxHugePages", BOLD | RIGHT | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "MemMode", BOLD | RIGHT | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "MemExp", BOLD | RIGHT | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "HPT_ratio", BOLD | RIGHT | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "ProcMode", BOLD | RIGHT | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "MinEnt", BOLD | RIGHT | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "DesEnt", BOLD | RIGHT | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "MaxEnt", BOLD | RIGHT | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "MinProc", BOLD | RIGHT | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "DesProc", BOLD | RIGHT | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Maxproc", BOLD | RIGHT | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "ShMode", BOLD | RIGHT | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Weight", BOLD | RIGHT | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "ProcPoolID", BOLD | RIGHT | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "ProcPoolName", BOLD | RIGHT | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "AffinityGrp", BOLD | RIGHT | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "BootMode", BOLD | RIGHT | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "ConnMonit", BOLD | RIGHT | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "AutoStart", BOLD | RIGHT | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "BSR_arrays", BOLD | RIGHT | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "ProcCompat", BOLD | RIGHT | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "ErrReporting", BOLD | RIGHT | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Managed System Name", BOLD | CENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "Managed System Serial", BOLD | CENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        ++col;
        ++row;
        i = 0;
        while (i < this.managedSystem.length) {
            GenericData[] profile = this.managedSystem[i].getObjects(PROFILES);
            if (profile != null) {
                int j = 0;
                while (j < profile.length) {
                    col = 0;
                    String[] s = profile[j].getVarValues("lpar_name");
                    n = ds.addLabel(col, row, s, 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                    if (n > size[col]) {
                        size[col] = n;
                    }
                    String activeProfile = this.getActiveProfileName(i, s[0]);
                    s = profile[j].getVarValues("name");
                    boolean active = activeProfile != null && s != null && activeProfile.equals(s[0]);
                    if ((n = ds.addLabel(++col, row, s, 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    ++col;
                    n = active ? ds.addLabel(col, row, "true", B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW) : ds.addLabel(col, row, "false", B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                    s = profile[j].getVarValues("lpar_id");
                    ds.addInteger(++col, row, s, 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                    n = 4;
                    if (n > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, s = profile[j].getVarValues("lpar_env"), 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = (s = profile[j].getVarValues("all_resources"))[0].equals("0") ? ds.addLabel(col, row, "false", B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW) : ds.addLabel(++col, row, "true", B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    s = profile[j].getVarValues("min_mem");
                    ds.addFloatDiv1024(++col, row, s, 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                    n = 8;
                    if (n > size[col]) {
                        size[col] = n;
                    }
                    s = profile[j].getVarValues("desired_mem");
                    ds.addFloatDiv1024(++col, row, s, 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                    n = 8;
                    if (n > size[col]) {
                        size[col] = n;
                    }
                    s = profile[j].getVarValues("max_mem");
                    ds.addFloatDiv1024(++col, row, s, 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                    n = 8;
                    if (n > size[col]) {
                        size[col] = n;
                    }
                    s = profile[j].getVarValues("min_num_huge_pages");
                    ds.addInteger(++col, row, s, 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                    n = 8;
                    if (n > size[col]) {
                        size[col] = n;
                    }
                    s = profile[j].getVarValues("desired_num_huge_pages");
                    ds.addInteger(++col, row, s, 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                    n = 8;
                    if (n > size[col]) {
                        size[col] = n;
                    }
                    s = profile[j].getVarValues("max_num_huge_pages");
                    ds.addInteger(++col, row, s, 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                    n = 8;
                    if (n > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, s = profile[j].getVarValues("mem_mode"), 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    s = profile[j].getVarValues("mem_expansion");
                    ds.addFloat(++col, row, s, 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                    n = 8;
                    if (n > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, s = profile[j].getVarValues("hpt_ratio"), 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, s = profile[j].getVarValues("proc_mode"), 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    s = profile[j].getVarValues("min_proc_units");
                    ds.addFloat(++col, row, s, 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                    n = 6;
                    if (n > size[col]) {
                        size[col] = n;
                    }
                    s = profile[j].getVarValues("desired_proc_units");
                    ds.addFloat(++col, row, s, 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                    n = 6;
                    if (n > size[col]) {
                        size[col] = n;
                    }
                    s = profile[j].getVarValues("max_proc_units");
                    ds.addFloat(++col, row, s, 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                    n = 6;
                    if (n > size[col]) {
                        size[col] = n;
                    }
                    s = profile[j].getVarValues("min_procs");
                    ds.addInteger(++col, row, s, 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                    n = 3;
                    if (n > size[col]) {
                        size[col] = n;
                    }
                    s = profile[j].getVarValues("desired_procs");
                    ds.addInteger(++col, row, s, 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                    n = 3;
                    if (n > size[col]) {
                        size[col] = n;
                    }
                    s = profile[j].getVarValues("max_procs");
                    ds.addInteger(++col, row, s, 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                    n = 3;
                    if (n > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, s = profile[j].getVarValues("sharing_mode"), 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    s = profile[j].getVarValues("uncap_weight");
                    ds.addInteger(++col, row, s, 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                    n = 3;
                    if (n > size[col]) {
                        size[col] = n;
                    }
                    s = profile[j].getVarValues("shared_proc_pool_id");
                    ds.addInteger(++col, row, s, 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                    n = 3;
                    if (n > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, s = profile[j].getVarValues("shared_proc_pool_name"), 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, s = profile[j].getVarValues("affinity_group_id"), 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, s = profile[j].getVarValues("boot_mode"), 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, s = profile[j].getVarValues("conn_monitoring"), 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, s = profile[j].getVarValues("auto_start"), 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, s = profile[j].getVarValues("bsr_arrays"), 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, s = profile[j].getVarValues("lpar_proc_compat_mode"), 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, s = profile[j].getVarValues("electronic_err_reporting"), 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, s = this.managedSystem[i].getVarValues("name"), 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    if ((n = ds.addLabel(++col, row, s = this.managedSystem[i].getVarValues("serial_num"), 0, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW)) > size[col]) {
                        size[col] = n;
                    }
                    ++col;
                    ++row;
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < size.length) {
            ds.setColSize(i, size[i] + 2);
            ++i;
        }
        return ds;
    }

    private void createViosDiskSheetExcel(WritableSheet sheet) {
        DataSheet ds = this.createViosDiskSheet();
        if (ds != null) {
            ds.createExcelSheet(sheet);
        }
    }

    private void createViosDiskSheetHTML(String fileName) {
        DataSheet ds = this.createViosDiskSheet();
        if (ds != null) {
            ds.createHTMLSheet(fileName);
            this.addButton("VIOS disks", new File(fileName).getName());
        }
    }

    private void createViosDiskSheetCSV(String fileName) {
        DataSheet ds = this.createViosDiskSheet();
        if (ds != null) {
            ds.setSeparator(this.csvSeparator);
            ds.createCSVSheet(fileName);
        }
    }

    private DataSheet createViosDiskSheet() {
        DataSheet ds = new DataSheet();
        String[] vios = this.diskData.getViosNames();
        int[] size = new int[3 + vios.length];
        int row = 0;
        int col = 0;
        int i = 0;
        while (i < size.length) {
            size[i] = 0;
            ++i;
        }
        int n = ds.addLabel(col, row, "UUID", BOLD | VCENTRE | B_ALL_MED | GREEN);
        if (n > size[col]) {
            size[col] = n;
        }
        if ((n = ds.addLabel(++col, row, "SIZE", BOLD | VCENTRE | B_ALL_MED | GREEN)) > size[col]) {
            size[col] = n;
        }
        ++col;
        i = 0;
        while (i < vios.length) {
            n = ds.addLabel(col, row, vios[i], BOLD | VCENTRE | B_ALL_MED | GREEN);
            if (n > size[col]) {
                size[col] = n;
            }
            ++col;
            ++i;
        }
        ++row;
        int num_uuid = this.diskData.getNumUUID();
        i = 0;
        while (i < num_uuid) {
            col = 0;
            String uuidName = this.diskData.getUUIDname(i);
            int diskSize = this.diskData.getSize(i);
            String[] hdiskName = this.diskData.getHdiskOnViosNames(i);
            boolean[] free = this.diskData.getFreeOnViosNames(i);
            n = ds.addLabel(col, row, uuidName, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
            if (n > size[col]) {
                size[col] = n;
            }
            ++col;
            if (diskSize > 0) {
                ds.addInteger(col, row, diskSize, B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW);
                n = 8;
                if (n > size[col]) {
                    size[col] = n;
                }
                ++col;
            } else {
                ++col;
            }
            int j = 0;
            while (j < hdiskName.length) {
                int map = B_LEFT_LOW | B_BOTTOM_LOW | B_RIGHT_LOW;
                if (free[j]) {
                    map |= GREEN;
                }
                if ((n = ds.addLabel(col, row, hdiskName, j, map)) > size[col]) {
                    size[col] = n;
                }
                ++col;
                ++j;
            }
            ++row;
            ++i;
        }
        i = 0;
        while (i < size.length) {
            ds.setColSize(i, size[i] + 2);
            ++i;
        }
        return ds;
    }

    private String getActiveProfileName(int ms, String lparName) {
        GenericData[] lpar = this.managedSystem[ms].getObjects(CONFIG_LPAR);
        int i = 0;
        while (i < lpar.length) {
            if (lpar[i].getVarValues("name")[0].equals(lparName)) break;
            ++i;
        }
        if (i == lpar.length) {
            return null;
        }
        return lpar[i].getVarValues("curr_profile")[0];
    }

    private GenericData getProfileData(int ms, String lparName, String profile) {
        if (lparName == null || profile == null) {
            return null;
        }
        GenericData[] profiles = this.managedSystem[ms].getObjects(PROFILES);
        if (profiles == null) {
            return null;
        }
        int i = 0;
        while (i < profiles.length) {
            if (profiles[i].getVarValues("lpar_name")[0].equals(lparName) && profiles[i].getVarValues("name")[0].equals(profile)) break;
            ++i;
        }
        if (i < profiles.length) {
            return profiles[i];
        }
        return null;
    }

    private String[][] getProfilesUsingAdapter(int ms, String drcindex) {
        Vector<String> required = new Vector<String>();
        Vector<String> desired = new Vector<String>();
        if (drcindex == null) {
            return null;
        }
        GenericData[] profiles = this.managedSystem[ms].getObjects(PROFILES);
        if (profiles == null) {
            return null;
        }
        int i = 0;
        while (i < profiles.length) {
            String[] slots = profiles[i].getVarValues("io_slots");
            int j = 0;
            while (slots != null && j < slots.length) {
                if (slots[j].startsWith(drcindex)) {
                    String name = String.valueOf(profiles[i].getVarValues("lpar_name")[0]) + "@" + profiles[i].getVarValues("name")[0];
                    if (slots[j].endsWith("1")) {
                        required.add(name);
                    } else {
                        desired.add(name);
                    }
                }
                ++j;
            }
            ++i;
        }
        String[][] result = new String[2][];
        result[1] = new String[required.size()];
        result[0] = new String[desired.size()];
        i = 0;
        while (i < required.size()) {
            result[1][i] = (String)required.elementAt(i);
            ++i;
        }
        i = 0;
        while (i < desired.size()) {
            result[0][i] = (String)desired.elementAt(i);
            ++i;
        }
        return result;
    }

    private void sendCommand(SSHManager2 sshm, String cmd, String fileName, boolean compressed) {
        this.sendCommand(sshm, cmd, fileName, compressed, false);
    }

    private void sendCommand(SSHManager2 sshm, String cmd, String fileName) {
        this.sendCommand(sshm, cmd, fileName, false, false);
    }

    private void sendCommand(SSHManager2 sshm, String cmd, String fileName, boolean compressed, boolean progress) {
        logger.log(Level.INFO, String.valueOf(cmd) + " > " + fileName);
        int i = 0;
        while (i < NUM_RETRY) {
            block8: {
                BufferedReader br;
                sshm.sendCommand(cmd, fileName, compressed, progress);
                try {
                    br = new BufferedReader(new FileReader(fileName), 0x100000);
                }
                catch (FileNotFoundException fnfe) {
                    break;
                }
                try {
                    String line = br.readLine();
                    if (line != null && line.indexOf("Service processor lock failed") >= 0) {
                        System.out.print("X");
                        br.close();
                        try {
                            Thread.sleep(10000L);
                        }
                        catch (InterruptedException fnfe) {}
                        break block8;
                    }
                    br.close();
                }
                catch (IOException ioe) {}
                break;
            }
            ++i;
        }
    }
}

