@echo OFF

rem #############################################################################
rem # ===========================================================================
rem # Licensed Materials - Property of IBM
rem #
rem # 5724-T60 5608-A91
rem # (C) Copyright IBM Corp. 2016.  All Rights Reserved
rem #
rem # US Government Users Restricted Rights - Use, duplication, or
rem # disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
rem #  ===========================================================================
rem # 
rem #############################################################################
SET INSTALL_MODE=UNINSTALL
:: Keep variables local
SETLOCAL

set SCRIPTDIR=%cd%

if [%1]==[] goto usage
if [%2]==[] goto usage
if [%3]==[] goto usage
if [%4]==[] goto usage
if [%5]==[] goto usage

SET IM_INSTALL_LOCATION=%1
SET WAS_INSTALL_LOCATION=%2
SET SKLM_HOME=%3
SET WAS_USER=%4
SET WAS_PASS=%5

if not exist %WAS_INSTALL_LOCATION% (
	@echo Check if the parameter WAS_INSTALL_LOCATION is set to the valid WAS directory
	goto end
)

if not exist %WAS_INSTALL_LOCATION%\bin\stopServer.bat (
	@echo Check if the parameter WAS_INSTALL_LOCATION is set to the valid WAS directory
	goto end
)

if not exist %IM_INSTALL_LOCATION% (
	@echo Check if the parameter IM_INSTALL_LOCATION is set to the valid IM directory
	goto end
)

if not exist %IM_INSTALL_LOCATION%\eclipse\tools\imcl.exe (
	@echo Check if the parameter IM_INSTALL_LOCATION is set to the valid IM directory
	goto end
)

if not exist %IM_INSTALL_LOCATION%\eclipse\IBMIM.exe (
	@echo Check if the parameter IM_INSTALL_LOCATION is set to the valid IM directory
	goto end
)

if not exist %SKLM_HOME%\agent\stopAgent.bat (
	@echo Check if the parameter SKLM_HOME is set to the valid SKLM directory
	goto end
)

echo Stopping SKLM Agent...
echo %SKLM_HOME%\agent\stopAgent.bat %WAS_INSTALL_LOCATION%
call %SKLM_HOME%\agent\stopAgent.bat %WAS_INSTALL_LOCATION%

echo Stopping SKLM Server...
echo %WAS_INSTALL_LOCATION%\bin\stopServer.bat server1 -profileName KLMProfile -username %WAS_USER% -password @@@@@
call %WAS_INSTALL_LOCATION%\bin\stopServer.bat server1 -profileName KLMProfile -username %WAS_USER% -password %WAS_PASS%

echo Deleting profile...
call %WAS_INSTALL_LOCATION%\bin\manageprofiles.bat -delete -profileName KLMProfile

echo Dropping Db2 instance...
call %systemdrive%\sklm41properties\scripts\removeDB2Inst.bat	

%IM_INSTALL_LOCATION%\eclipse\IBMIM.exe -input %SCRIPTDIR%\SKLM_Uninstall_Win_Resp.xml
echo Note: Uninstallation removes WebSphere Application Server and drops the database instance that is used by the product. The Db2 database product is not removed. You must manually uninstall Db2 if required.

exit /b 0


:usage

@echo *************************************************************
@echo Usage: 
@echo        uninstallSKLM.bat IM_INSTALL_LOCATION WAS_INSTALL_LOCATION SKLM_HOME WAS_ADMIN WAS_PASSWORD 
@echo        where
@echo        IM_INSTALL_LOCATION is the directory where Installation Manager for SKLM is installed.
@echo        WAS_INSTALL_LOCATION is the directory where WebSphere Application Server(WAS) for SKLM is installed.
@echo        SKLM_HOME is the directory where SKLM is installed.
@echo        WAS_ADMIN is Username of WebSphere Application Server(WAS) for SKLM.
@echo        WAS_PASSWORD is Password of WebSphere Application Server(WAS) for SKLM.
@echo Example : 
@echo		uninstallSKLM.bat "C:\Program Files\IBM\Installation Manager" 
@echo		"C:\Program Files\IBM\WebSphere\AppServer"
@echo		"C:\Program Files\IBM\SKLMV41"
@echo		wasadmin 
@echo		wasadminpwd 
@echo Note: If value of parameters IM_INSTALL_LOCATION and WAS_INSTALL_LOCATION contains spaces, 
@echo		please enclose it with quotes as shown in example.
@echo		Before uninstalling SKLM, please ensure wsadmin console is not running.	
@echo *************************************************************


