/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.acm.transition.messages.cache;

import com.ibm.acm.transition.messages.Message;
import com.ibm.acm.transition.messages.cache.CacheEvictionHandler;
import com.ibm.acm.transition.messages.cache.CacheException;
import com.ibm.acm.transition.messages.cache.CacheLoader;
import com.ibm.acm.transition.messages.cache.ObjectExistsException;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Vector;

public class ObjectCache<K, V> {
    private Properties cacheProps;
    private static final int defaultCacheSize = 100;
    private LinkedList<CachedObject<K, V>> cache;
    private Hashtable<K, CachedObject<K, V>> cacheIndex;
    private int cacheSize;
    private String cacheName;
    private CacheLoader<K, V> cacheLoader;
    private CacheEvictionHandler<V> evictionHandler;

    public ObjectCache(Properties cacheProperties) {
        this.cacheProps = cacheProperties;
        this.init();
    }

    public ObjectCache() throws IOException {
        URL properties = ObjectCache.class.getResource("cache.properties");
        this.cacheProps = new Properties();
        this.cacheProps.load(properties.openStream());
        this.init();
    }

    public synchronized void put(K name, V obj) throws CacheException {
        if (this.cacheIndex.containsKey(name)) {
            Message msg = new Message("G0028E.CACHED_OBJECT_ALREADY_EXISTS");
            msg.addArgument(name);
            msg.addArgument(this.cacheName);
            throw new ObjectExistsException(msg);
        }
        CachedObject<K, V> cachedObj = new CachedObject<K, V>(name, obj);
        if (this.cache.size() == this.cacheSize) {
            int evictionIndex = this.findEvictionCandidate();
            CachedObject<K, V> oldCachedObj = this.cache.get(evictionIndex);
            K oldCachedObjName = oldCachedObj.getName();
            try {
                if (this.evictionHandler != null) {
                    this.evictionHandler.handle(oldCachedObj.getObject());
                }
            }
            finally {
                this.destroy(oldCachedObjName);
            }
        }
        this.cache.addLast(cachedObj);
        this.cacheIndex.put(name, cachedObj);
    }

    public synchronized void destroy(K name) throws CacheException {
        if (this.cacheIndex.containsKey(name)) {
            this.cache.remove(this.cacheIndex.get(name));
            this.cacheIndex.remove(name);
        }
    }

    public synchronized V get(K name) throws CacheException {
        V obj = null;
        if (name == null) {
            Message msg = new Message("G0029E.CACHED_OBJECT_BAD_NAME");
            msg.addArgument(this.cacheName);
            msg.addArgument("null");
            throw new CacheException(msg);
        }
        if (this.cacheIndex.containsKey(name)) {
            CachedObject<K, V> cachedObj = this.cacheIndex.get(name);
            cachedObj.setFlag(1);
            obj = cachedObj.getObject();
        } else {
            if (this.cacheLoader == null) {
                Message msg = new Message("G0030E.NO_CACHE_LOADER_PROVIDED");
                msg.addArgument(this.cacheName);
                throw new CacheException(msg);
            }
            try {
                obj = this.cacheLoader.load(name);
            }
            catch (Exception e) {
                Message msg = new Message("G0031E.CACHE_OBJECT_LOAD_FAILURE");
                msg.addArgument(name);
                msg.addArgument(this.cacheName);
                throw new CacheException(msg, (Throwable)e);
            }
            if (obj == null) {
                Message msg = new Message("G0031E.CACHE_OBJECT_LOAD_FAILURE");
                msg.addArgument(name);
                msg.addArgument(this.cacheName);
                throw new CacheException(msg);
            }
            this.put(name, obj);
        }
        return obj;
    }

    public synchronized boolean replace(K name, V obj, boolean insertIfNotExists) throws CacheException {
        boolean objectReplaced = false;
        if (name == null) {
            Message msg = new Message("G0029E.CACHED_OBJECT_BAD_NAME");
            msg.addArgument(this.cacheName);
            msg.addArgument("null");
            throw new CacheException(msg);
        }
        if (this.cacheIndex.containsKey(name)) {
            CachedObject<K, V> cachedObj = this.cacheIndex.get(name);
            cachedObj.setObject(obj);
            objectReplaced = true;
        } else if (insertIfNotExists) {
            this.put(name, obj);
            objectReplaced = true;
        }
        return objectReplaced;
    }

    public synchronized Vector<K> getAllNames() {
        Vector<K> keyList = new Vector<K>();
        Enumeration<K> keys = this.cacheIndex.keys();
        while (keys.hasMoreElements()) {
            keyList.add(keys.nextElement());
        }
        return keyList;
    }

    public synchronized boolean contains(K name) {
        return this.cacheIndex.containsKey(name);
    }

    public synchronized void setCacheLoader(CacheLoader<K, V> loader) {
        this.cacheLoader = loader;
    }

    public synchronized void setEvictionHandler(CacheEvictionHandler<V> handler) {
        this.evictionHandler = handler;
    }

    public synchronized void clear() {
        this.cache.clear();
        this.cacheIndex.clear();
    }

    private void init() {
        try {
            this.cacheSize = Integer.parseInt(this.cacheProps.getProperty("cache.size", Integer.toString(100)));
        }
        catch (NumberFormatException e) {
            this.cacheSize = 100;
        }
        this.cacheName = this.cacheProps.getProperty("cache.name", "<Unknown>");
        this.cache = new LinkedList();
        this.cacheIndex = new Hashtable(this.cacheSize);
    }

    private int findEvictionCandidate() {
        int index = 0;
        CachedObject<K, V> obj = this.cache.get(0);
        while (obj.getFlag() == 1) {
            this.cache.remove(index);
            obj.setFlag(0);
            this.cache.addLast(obj);
            index = (index + 1) % this.cacheSize;
            obj = this.cache.get(index);
        }
        return index;
    }

    private static class CachedObject<K, V> {
        private K name;
        private V obj;
        private int flag;

        public CachedObject(K name, V obj) {
            this.name = name;
            this.obj = obj;
            this.flag = 0;
        }

        public K getName() {
            return this.name;
        }

        public V getObject() {
            return this.obj;
        }

        public int getFlag() {
            return this.flag;
        }

        public void setFlag(int flag) {
            this.flag = flag;
        }

        public void setObject(V obj) {
            this.obj = obj;
        }
    }
}

