/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.acm.transition.messages.cache;

import com.ibm.acm.transition.messages.Message;
import java.util.ArrayList;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class ExtendedException
extends Exception {
    private static final long serialVersionUID = -7617243608521150152L;
    private static final String EndLine = System.getProperty("line.separator");
    private static final String DefaultIndentation = "   ";
    private static final Message CAUSES_OF_PROBLEM = new Message("A1741I.nested.exceptions");
    private static final String CAUSES_OF_PROBLEM_FALL_BACK = "Causes of the problem:";
    protected Message message = null;

    public ExtendedException(Message messageIn) {
        super(messageIn == null ? "G0020E.EXTERNAL_ERROR_MESSAGE" : messageIn.getKey());
        this.message = new Message(messageIn);
    }

    public ExtendedException(Message messageIn, Throwable cause) {
        super(messageIn == null ? "G0020E.EXTERNAL_ERROR_MESSAGE" : messageIn.getKey(), cause);
        this.message = new Message(messageIn);
    }

    public ExtendedException(String messageStr) {
        this(new Message("G0020E.EXTERNAL_ERROR_MESSAGE", messageStr));
    }

    public ExtendedException(Throwable cause) {
        this(cause == null ? "" : cause.toString(), cause);
    }

    public ExtendedException(String messageStr, Throwable cause) {
        this(new Message("G0020E.EXTERNAL_ERROR_MESSAGE", messageStr), cause);
    }

    public Message getNonLocalizedMessage() {
        return new Message(this.message);
    }

    public void setNonLocalizedMessage(Message msg) {
        this.message.setMessage(msg);
    }

    @Override
    public String getLocalizedMessage() {
        return this.getLocalizedMessage(Locale.getDefault(), false);
    }

    public String getLocalizedMessage(Locale locale) {
        return this.getLocalizedMessage(locale, false);
    }

    public String getLocalizedMessage(Locale locale, boolean printStackTrace) {
        return this.getLocalizedMessage(locale, printStackTrace, true);
    }

    public String getLocalizedMessage(Locale locale, boolean printStackTrace, boolean withDisplayKey) {
        StringBuilder toAppend = new StringBuilder();
        ExtendedException.appendFormattedText(toAppend, this, locale, printStackTrace, withDisplayKey);
        return toAppend.toString();
    }

    public String getHTMLFormattedText(Locale locale, boolean printStackTrace) {
        StringBuilder toAppend = new StringBuilder();
        ExtendedException.appendFormattedText(toAppend, this, locale, printStackTrace, true, IndentationType.Html);
        return toAppend.toString();
    }

    public boolean isACause(Class<?> causeClass) {
        return this.getCauseOfType(causeClass) != null;
    }

    public Throwable getCauseOfType(Class<?> causeClass) {
        if (causeClass == null) {
            return null;
        }
        Throwable currentCause = this.getCause();
        while (currentCause != null) {
            if (currentCause.getClass().equals(causeClass)) {
                return currentCause;
            }
            currentCause = currentCause.getCause();
        }
        return currentCause;
    }

    public boolean isACause(String msgKey) {
        if (msgKey == null) {
            return false;
        }
        Throwable currentCause = this.getCause();
        while (currentCause != null) {
            ExtendedException ee;
            if (currentCause instanceof ExtendedException && (ee = (ExtendedException)currentCause).getNonLocalizedMessage().getKey().equals(msgKey)) {
                return true;
            }
            currentCause = currentCause.getCause();
        }
        return false;
    }

    public ArrayList<Message> getChainedMessages() {
        ArrayList<Message> messages = new ArrayList<Message>();
        messages.add(this.message);
        Throwable thrown = this.getCause();
        while (thrown != null) {
            ExtendedException ee = null;
            if (!(thrown instanceof ExtendedException)) {
                ee = new ExtendedException(thrown.toString());
                ee.setStackTrace(thrown.getStackTrace());
                ee.initCause(thrown.getCause());
                thrown = ee;
            } else {
                ee = (ExtendedException)thrown;
            }
            messages.add(ee.message);
            thrown = ee.getCause();
        }
        return messages;
    }

    public static void appendFormattedText(StringBuffer toAppend, Throwable thrown, Locale locale, boolean printStackTrace) {
        StringBuilder toAppendBuffer = new StringBuilder();
        ExtendedException.appendFormattedText(toAppendBuffer, thrown, locale, printStackTrace);
        toAppend.append((CharSequence)toAppendBuffer);
    }

    public static void appendFormattedText(StringBuilder toAppend, Throwable thrown, Locale locale, boolean printStackTrace) {
        ExtendedException.appendFormattedText(toAppend, thrown, locale, printStackTrace, true);
    }

    public static void appendFormattedText(StringBuilder toAppend, Throwable thrown, Locale locale, boolean printStackTrace, boolean withDisplayKey) {
        ExtendedException.appendFormattedText(toAppend, thrown, locale, printStackTrace, withDisplayKey, IndentationType.Console);
    }

    private static void appendFormattedText(StringBuilder toAppend, Throwable thrown, Locale locale, boolean printStackTrace, boolean withDisplayKey, IndentationType indenType) {
        boolean printedCausedBy = false;
        while (thrown != null) {
            ExtendedException ee = null;
            if (!(thrown instanceof ExtendedException)) {
                ee = new ExtendedException(thrown.toString());
                ee.setStackTrace(thrown.getStackTrace());
                ee.initCause(thrown.getCause());
            } else {
                ee = (ExtendedException)thrown;
            }
            if (withDisplayKey) {
                toAppend.append(ee.message.getFormattedTextWithDisplayKey(locale));
            } else {
                toAppend.append(ee.message.getFormattedText(locale));
            }
            if (printStackTrace) {
                StackTraceElement[] stes = ee.getStackTrace();
                int i = 0;
                while (i < stes.length) {
                    toAppend.append(indenType.lineSeparator);
                    toAppend.append(indenType.indentUnit);
                    if (printedCausedBy) {
                        toAppend.append(indenType.indentUnit);
                    }
                    toAppend.append(stes[i]);
                    ++i;
                }
            }
            if ((thrown = ee.getCause()) == null) continue;
            if (!printedCausedBy) {
                printedCausedBy = true;
                String causedByText = null;
                causedByText = CAUSES_OF_PROBLEM.getFormattedText(locale);
                if (causedByText == null) {
                    causedByText = CAUSES_OF_PROBLEM_FALL_BACK;
                }
                toAppend.append(indenType.lineSeparator);
                toAppend.append(causedByText);
            }
            toAppend.append(indenType.lineSeparator);
            toAppend.append(indenType.indentUnit);
        }
    }

    public LogRecord toLogRecord() {
        LogRecord logRecord = new LogRecord(Level.SEVERE, this.getMessage());
        logRecord.setThrown(this);
        return logRecord;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + ": " + this.message.getFormattedText();
    }

    static /* synthetic */ String access$0() {
        return EndLine;
    }

    private static enum IndentationType {
        Console(ExtendedException.access$0(), "   "),
        Html("<br>" + ExtendedException.access$0(), "&nbsp;&nbsp;&nbsp;");

        private final String indentUnit;
        private final String lineSeparator;

        private IndentationType(String lineSeparator, String indentUnit) {
            this.lineSeparator = lineSeparator;
            this.indentUnit = indentUnit;
        }

        public String lineSeparator() {
            return this.lineSeparator;
        }

        public String getIndentUnit() {
            return this.indentUnit;
        }
    }
}

