/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.acm.transition.messages;

public class XMLTagger {
    private static final int INITIAL_OUTPUTBUFFER_SIZE = 1000;
    private static final int XML_UNICODE_ENTITY_RADIX = 16;
    private static final String CONSTANT_STRING_OPEN_ANGLE = "<";
    private static final String CONSTANT_STRING_CLOSE_ANGLE = ">";
    private static final String CONSTANT_STRING_AMPERSAND = "&";
    private static final String CONSTANT_STRING_SINGLE_QUOTE = "'";
    private static final String CONSTANT_STRING_DOUBLE_QUOTE = "\"";
    private static final String CONSTANT_STRING_SPACE = " ";
    private static final String CONSTANT_STRING_EQUAL = "=";
    private static final char CONSTANT_CHAR_OPEN_ANGLE = '<';
    private static final char CONSTANT_CHAR_CLOSE_ANGLE = '>';
    private static final char CONSTANT_CHAR_AMPERSAND = '&';
    private static final char CONSTANT_CHAR_SINGLE_QUOTE = '\'';
    private static final char CONSTANT_CHAR_DOUBLE_QUOTE = '\"';
    private static final char CONSTANT_CHAR_SEMICOLON = ';';
    private static final char CONSTANT_CHAR_BACKSLASH = '\\';
    private static final String XML_OPEN_START_ELEMENT_TAG = "<";
    private static final String XML_OPEN_END_ELEMENT_TAG = "</";
    private static final String XML_OPEN_PI_TAG = "<?";
    private static final String XML_CLOSE_TAG = ">";
    private static final String XML_CLOSE_END_ELEMENT_TAG = "/>";
    private static final String XML_CLOSE_PI_TAG = "?>";
    private static final String XML_ESCAPED_OPEN_ANGLE = "&lt;";
    private static final String XML_ESCAPED_CLOSE_ANGLE = "&gt;";
    private static final String XML_ESCAPED_AMPERSAND = "&amp;";
    private static final String XML_ESCAPED_DOUBLE_QUOTE = "&quot;";
    private static final String XML_ESCAPED_SINGLE_QUOTE = "&apos;";
    private static final String XML_ESCAPED_BACKSLASH = "&#x5C;";
    private static final String XML_CDATA_START = "<![CDATA[";
    private static final String XML_CDATA_END = "]]>";
    private static final String XML_ENTITY_REFERENCE_START = "&#x";
    private StringBuffer _output = null;
    private String indentString = null;
    private String lineEnd = null;
    private int indent = 0;
    private boolean lastTagWasBeginElement = false;

    public XMLTagger() {
        this(false, 1000);
    }

    public XMLTagger(boolean addWhitespaceForViewing) {
        this(addWhitespaceForViewing, 1000);
    }

    public XMLTagger(boolean addWhitespaceForViewing, int initialOutputBufferSize) {
        if (addWhitespaceForViewing) {
            this.indentString = "  ";
            this.lineEnd = System.getProperty("line.separator");
        }
        this._output = new StringBuffer(initialOutputBufferSize);
    }

    public XMLTagger(boolean addWhitespaceForViewing, boolean addPIElementForUTF8) {
        this(addWhitespaceForViewing, 1000);
        if (addPIElementForUTF8) {
            this.startPI("xml");
            this.writeAttr("version", "1.0");
            this.writeAttr("encoding", "UTF-8");
            this.endPI();
        }
    }

    public void reset() {
        this._output.setLength(0);
    }

    public String getXML() {
        return this._output.toString();
    }

    public void startPI(String name) {
        this._output.append(XML_OPEN_PI_TAG);
        this._output.append(name);
    }

    public void endPI() {
        this._output.append(XML_CLOSE_PI_TAG);
    }

    public void openStartElement(String name) {
        ++this.indent;
        this.addFormatting();
        this.lastTagWasBeginElement = true;
        this._output.append("<");
        this._output.append(name);
    }

    public void startElement(String name) {
        this.openStartElement(name);
        this.closeTag();
    }

    public void closeTag() {
        this._output.append(">");
    }

    public void closeEndElementTag() {
        --this.indent;
        this.lastTagWasBeginElement = false;
        this._output.append(XML_CLOSE_END_ELEMENT_TAG);
    }

    public void endElement(String name) {
        if (!this.lastTagWasBeginElement) {
            this.addFormatting();
        }
        --this.indent;
        this.lastTagWasBeginElement = false;
        this._output.append(XML_OPEN_END_ELEMENT_TAG);
        this._output.append(name);
        this.closeTag();
    }

    public void writeAttr(String name, long value) {
        this.writeAttr(name, Long.toString(value));
    }

    public void writeAttr(String name, double value) {
        this.writeAttr(name, Double.toString(value));
    }

    public void writeAttr(String name, String value) {
        this._output.append(CONSTANT_STRING_SPACE);
        this._output.append(name);
        this._output.append(CONSTANT_STRING_EQUAL);
        this._output.append(CONSTANT_STRING_DOUBLE_QUOTE);
        if (value == null) {
            value = "";
        }
        this._output.append(XMLTagger.escapeXMLValue(value));
        this._output.append(CONSTANT_STRING_DOUBLE_QUOTE);
    }

    public void writeText(String text) {
        this.writeText(text, true);
    }

    public void writeText(String text, boolean escape) {
        if (text == null) {
            return;
        }
        String textToWrite = text;
        if (escape) {
            textToWrite = XMLTagger.escapeXMLValue(text);
        }
        this._output.append(textToWrite);
    }

    public void writeEndline() {
        this._output.append(this.lineEnd);
    }

    public void writeXMLFragment(String fragment) {
        this._output.append(fragment);
    }

    public void startCDATA() {
        this._output.append(XML_CDATA_START);
    }

    public void endCDATA() {
        this._output.append(XML_CDATA_END);
    }

    public static boolean isValidXMLChar(char c) {
        return c == '\t' || c == '\n' || c == '\r' || c >= ' ' && c <= '\ufffd';
    }

    public static boolean isValidXMLString(String stringToCheck) {
        int i = 0;
        while (i < stringToCheck.length()) {
            if (!XMLTagger.isValidXMLChar(stringToCheck.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isEscapeInvalidChar(String escapedString) {
        return escapedString.matches("^\\[u][0-9]+;");
    }

    public static String escapeInvalidChar(char c) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(XML_ENTITY_REFERENCE_START);
        buffer.append(Integer.toString(c, 16));
        buffer.append(";");
        return buffer.toString();
    }

    public static char unescapeInvalidChar(String escapedString) {
        String numeric = escapedString.substring(3, escapedString.length() - 1);
        int characterValue = Integer.parseInt(numeric, 16);
        return (char)characterValue;
    }

    private void addFormatting() {
        if (this.lineEnd != null) {
            this._output.append(this.lineEnd);
        }
        if (this.indentString != null) {
            int i = 1;
            while (i < this.indent) {
                this._output.append(this.indentString);
                ++i;
            }
        }
    }

    public static String escapeXMLValue(String sourceValue) {
        String escape = sourceValue;
        if (sourceValue != null && sourceValue.length() > 0) {
            StringBuffer buffer = new StringBuffer(sourceValue.length());
            int i = 0;
            while (i < sourceValue.length()) {
                char curChar = sourceValue.charAt(i);
                if (curChar == '\\') {
                    buffer.append(XML_ESCAPED_BACKSLASH);
                } else if (!XMLTagger.isValidXMLChar(curChar)) {
                    buffer.append(XMLTagger.escapeInvalidChar(curChar));
                } else if (curChar == '<') {
                    buffer.append(XML_ESCAPED_OPEN_ANGLE);
                } else if (curChar == '>') {
                    buffer.append(XML_ESCAPED_CLOSE_ANGLE);
                } else if (curChar == '&') {
                    buffer.append(XML_ESCAPED_AMPERSAND);
                } else if (curChar == '\'') {
                    buffer.append(XML_ESCAPED_SINGLE_QUOTE);
                } else if (curChar == '\"') {
                    buffer.append(XML_ESCAPED_DOUBLE_QUOTE);
                } else {
                    buffer.append(curChar);
                }
                ++i;
            }
            escape = buffer.toString();
        }
        return escape;
    }

    public static String unescapeXMLValue(String sourceValue) {
        String escapedOutput = sourceValue;
        if (sourceValue.length() > 0) {
            StringBuffer buffer = new StringBuffer(sourceValue.length());
            int i = 0;
            while (i < sourceValue.length()) {
                char curChar = sourceValue.charAt(i);
                if (curChar != '&') {
                    buffer.append(curChar);
                } else {
                    int nextAmpersandBackslash = i;
                    int nextSemiColon = sourceValue.indexOf(59, nextAmpersandBackslash);
                    if (nextAmpersandBackslash < nextSemiColon) {
                        String escapedString = sourceValue.substring(nextAmpersandBackslash, nextSemiColon + 1);
                        if (escapedString.startsWith(XML_ENTITY_REFERENCE_START)) {
                            buffer.append(XMLTagger.unescapeInvalidChar(escapedString));
                        } else if (escapedString.equals(XML_ESCAPED_BACKSLASH)) {
                            buffer.append('\\');
                        } else if (escapedString.equals(XML_ESCAPED_OPEN_ANGLE)) {
                            buffer.append("<");
                        } else if (escapedString.equals(XML_ESCAPED_CLOSE_ANGLE)) {
                            buffer.append(">");
                        } else if (escapedString.equals(XML_ESCAPED_AMPERSAND)) {
                            buffer.append(CONSTANT_STRING_AMPERSAND);
                        } else if (escapedString.equals(XML_ESCAPED_SINGLE_QUOTE)) {
                            buffer.append(CONSTANT_STRING_SINGLE_QUOTE);
                        } else if (escapedString.equals(XML_ESCAPED_DOUBLE_QUOTE)) {
                            buffer.append(CONSTANT_STRING_DOUBLE_QUOTE);
                        } else {
                            buffer.append(escapedString);
                        }
                    } else {
                        buffer.append('&');
                        nextSemiColon = nextAmpersandBackslash;
                    }
                    i = nextSemiColon;
                }
                ++i;
            }
            escapedOutput = buffer.toString();
        }
        return escapedOutput;
    }
}

