/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.acm.transition.messages;

import com.ibm.acm.transition.messages.cache.CacheEvictionHandler;
import com.ibm.acm.transition.messages.cache.CacheException;
import com.ibm.acm.transition.messages.cache.CacheLoader;
import com.ibm.acm.transition.messages.cache.ObjectCache;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;

public final class ResourceBundleObjectCache {
    private static ObjectCache<LookupKey, ResourceBundle> cache = null;
    public static final int DEFAULT_CACHE_SIZE = 5;

    private ResourceBundleObjectCache() {
    }

    public static synchronized ObjectCache<LookupKey, ResourceBundle> init(Properties properties) {
        if (properties == null) {
            return null;
        }
        Loader loader = new Loader();
        EvictionHandler handler = new EvictionHandler();
        cache = new ObjectCache(properties);
        cache.setCacheLoader(loader);
        cache.setEvictionHandler(handler);
        return cache;
    }

    public static synchronized ObjectCache<LookupKey, ResourceBundle> getObjectCache() {
        if (cache == null) {
            Properties cacheDefaulProperties = new Properties();
            cacheDefaulProperties.put("cache.name", ResourceBundleObjectCache.class.getName());
            cacheDefaulProperties.put("cache.size", (Object)5);
            return ResourceBundleObjectCache.init(cacheDefaulProperties);
        }
        return cache;
    }

    public static final class EvictionHandler
    implements CacheEvictionHandler<ResourceBundle> {
        @Override
        public void handle(ResourceBundle o) {
        }
    }

    public static final class Loader
    implements CacheLoader<LookupKey, ResourceBundle> {
        @Override
        public ResourceBundle load(LookupKey key) throws CacheException {
            if (key == null) {
                return null;
            }
            ResourceBundle bundle = null;
            try {
                bundle = ResourceBundle.getBundle(key.getResourceBundleName(), key.getLocale());
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            return bundle;
        }
    }

    static final class LookupKey {
        private String bundleName = null;
        private Locale locale = null;

        LookupKey(String bundleName, Locale locale) {
            if (bundleName == null) {
                bundleName = "";
            }
            if (locale == null) {
                locale = Locale.getDefault();
            }
            this.bundleName = bundleName;
            this.locale = locale;
        }

        public String getResourceBundleName() {
            return this.bundleName;
        }

        public Locale getLocale() {
            return this.locale;
        }

        public boolean equals(LookupKey key) {
            if (key == null || this.bundleName == null || this.locale == null || key.bundleName == null || key.locale == null) {
                return false;
            }
            return this.locale.equals(key.locale) && this.bundleName.equals(key.bundleName);
        }

        public boolean equals(Object toCompare) {
            boolean retValue = false;
            retValue = toCompare != null && toCompare instanceof LookupKey && this.equals((LookupKey)toCompare);
            return retValue;
        }

        public int hashCode() {
            return (String.valueOf(this.locale.toString()) + this.bundleName).hashCode();
        }
    }
}

