/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.acm.transition.jaxb;

import com.ibm.acm.transition.common.Config;
import com.ibm.acm.transition.common.Utility;
import com.ibm.acm.transition.exception.TransitionException;
import com.ibm.acm.transition.jaxb.ACMNamespacePrefixMapperImpl;
import com.ibm.acm.transition.messages.Message;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

public final class ACMJAXBSingleton {
    private static final String JAXB_PACKAGE_LIST = "com.ibm.acm.transition.jaxb.sdf:com.ibm.acm.transition.jaxb.core:com.ibm.acm.transition.jaxb.caseextensions";
    private static volatile ACMJAXBSingleton jaxbInstance = null;
    private Marshaller marshaller;
    private Unmarshaller unmarshaller;
    private static Logger log = Logger.getLogger(ACMJAXBSingleton.class);

    public static ACMJAXBSingleton getSingleton() {
        if (jaxbInstance == null) {
            jaxbInstance = new ACMJAXBSingleton();
        }
        return jaxbInstance;
    }

    private ACMJAXBSingleton() {
    }

    public Object deserialize(String input) throws JAXBException {
        JAXBElement j = null;
        this.loadMarshallerAndUnmarshaller();
        StringReader rdr = new StringReader(input);
        j = (JAXBElement)this.unmarshaller.unmarshal((Reader)rdr);
        return j.getValue();
    }

    private synchronized void loadMarshallerAndUnmarshaller() throws JAXBException {
        if (this.marshaller == null) {
            JAXBContext jaxbContext = JAXBContext.newInstance((String)JAXB_PACKAGE_LIST);
            this.marshaller = jaxbContext.createMarshaller();
            this.unmarshaller = jaxbContext.createUnmarshaller();
            this.marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            this.marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            this.marshaller.setProperty("com.sun.xml.bind.namespacePrefixMapper", (Object)new ACMNamespacePrefixMapperImpl());
            this.marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        }
    }

    public synchronized void writeOutput(String file, Object o) throws JAXBException, FileNotFoundException, TransitionException {
        InputStream sdfStream;
        FileOutputStream out = null;
        OutputStreamWriter writer = null;
        String fname = file;
        out = new FileOutputStream(fname, false);
        try {
            writer = new OutputStreamWriter((OutputStream)out, "UTF8");
        }
        catch (UnsupportedEncodingException e1) {
            Message message = new Message("B4031E.CONVERSION_EXCEPTION");
        }
        String cmisSchemaPath = Config.getCMISSchemaPath();
        log.info((Object)("CMIS schema path is :: " + cmisSchemaPath));
        String sdfSchemaPath = Config.getSDFSchemaPath();
        log.info((Object)("SDF schema path is ::" + sdfSchemaPath));
        InputStream cmisStream = Utility.getResourceAsStream(cmisSchemaPath);
        if (cmisStream == null) {
            log.info((Object)"CMIS schema file could not be found.");
        }
        if ((sdfStream = Utility.getResourceAsStream(sdfSchemaPath)) == null) {
            log.info((Object)"SDF schema file could not be found.");
        }
        log.info((Object)"Before load Marshaller and Unmarshaller --in jaxbSingleton");
        this.loadMarshallerAndUnmarshaller();
        log.info((Object)"After load marshallerThe schema name is :: ");
        try {
            InputStream[] schemaStreams = new InputStream[]{cmisStream, sdfStream};
            SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Source[] sources = new Source[schemaStreams.length];
            int i = 0;
            while (i < schemaStreams.length) {
                sources[i] = new StreamSource(schemaStreams[i]);
                ++i;
            }
            Schema schema = sf.newSchema(sources);
            log.info((Object)"before setting the schema to the marshaller");
            this.marshaller.setSchema(schema);
            log.info((Object)"writing the sdf in validation with the schema ");
            this.marshaller.marshal(o, (Writer)writer);
            ((Writer)writer).flush();
            ((Writer)writer).close();
        }
        catch (SAXException e) {
            e.printStackTrace();
            Message message = new Message("B4030E.SOLUTION_CORRUPTED");
        }
        catch (Exception e) {
            e.printStackTrace();
            Message message = new Message("B4030E.SOLUTION_CORRUPTED", e.getLocalizedMessage());
        }
        try {
            cmisStream.close();
            sdfStream.close();
        }
        catch (Exception e) {
            log.info((Object)("error in closing sdf/cmis streams :: " + e.getLocalizedMessage()));
            throw new TransitionException(e);
        }
    }
}

