/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.acm.transition.converter;

import com.filenet.api.util.Id;
import com.ibm.acm.sold.common.type.Column;
import com.ibm.acm.sold.common.type.Filter;
import com.ibm.acm.sold.common.type.InbasketType;
import com.ibm.acm.sold.common.type.InbasketsType;
import com.ibm.acm.sold.common.type.RoleInbasketsType;
import com.ibm.acm.sold.common.type.RoleType;
import com.ibm.acm.sold.common.type.RolesType;
import com.ibm.acm.sold.common.type.TypeState;
import com.ibm.acm.transition.TransitionManager;
import com.ibm.acm.transition.common.Config;
import com.ibm.acm.transition.converter.Converter;
import com.ibm.acm.transition.entity.CEData;
import com.ibm.acm.transition.entity.CEProperty;
import com.ibm.acm.transition.entity.CommonInbasketFilter;
import com.ibm.acm.transition.entity.SolutionData;
import com.ibm.acm.transition.exception.TransitionException;
import com.ibm.acm.transition.jaxb.ACMNamespacePrefixMapperImpl;
import com.ibm.acm.transition.jaxb.BPFJAXBSingleton;
import com.ibm.acm.transition.jaxb.BPFPickList;
import com.ibm.acm.transition.jaxb.ConfigurationStorageUtil;
import com.ibm.acm.transition.jaxb.bpf.ConfigurationStorage;
import com.ibm.acm.transition.jaxb.ce.ObjectManifest;
import com.ibm.xmlns.prod.ecm.acm.sdf.CaseStructureType;
import com.ibm.xmlns.prod.ecm.acm.sdf.CaseTypeType;
import com.ibm.xmlns.prod.ecm.acm.sdf.CaseTypesType;
import com.ibm.xmlns.prod.ecm.acm.sdf.ChoiceListDefinitionsType;
import com.ibm.xmlns.prod.ecm.acm.sdf.ChoiceListIntegerDefinitionType;
import com.ibm.xmlns.prod.ecm.acm.sdf.ChoiceListStringDefinitionType;
import com.ibm.xmlns.prod.ecm.acm.sdf.ContentType;
import com.ibm.xmlns.prod.ecm.acm.sdf.EnumChoiceListType;
import com.ibm.xmlns.prod.ecm.acm.sdf.EnumHashTimePattern;
import com.ibm.xmlns.prod.ecm.acm.sdf.EnumIconType;
import com.ibm.xmlns.prod.ecm.acm.sdf.EnumIntegrationType;
import com.ibm.xmlns.prod.ecm.acm.sdf.ObjectFactory;
import com.ibm.xmlns.prod.ecm.acm.sdf.PropertyDefinitionsType;
import com.ibm.xmlns.prod.ecm.acm.sdf.RolePageNameType;
import com.ibm.xmlns.prod.ecm.acm.sdf.RolePageNamesType;
import com.ibm.xmlns.prod.ecm.acm.sdf.SolutionType;
import com.ibm.xmlns.prod.ecm.acm.sdf.TasksType;
import com.ibm.xmlns.prod.ecm.acm.sdf.TypeDefinitionsType;
import com.ibm.xmlns.prod.ecm.acm.sdf.ViewType;
import com.ibm.xmlns.prod.ecm.acm.sdf.ViewsType;
import com.ibm.xmlns.prod.ecm.cmis.caseextensions.Hidden;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.oasis_open.docs.ns.cmis.core._200908.CmisChoiceInteger;
import org.oasis_open.docs.ns.cmis.core._200908.CmisChoiceString;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyBooleanDefinitionType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyDateTimeDefinitionType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyDecimalDefinitionType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyDefinitionType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyIntegerDefinitionType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyStringDefinitionType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisTypeDocumentDefinitionType;
import org.oasis_open.docs.ns.cmis.core._200908.EnumBaseObjectTypeIds;
import org.oasis_open.docs.ns.cmis.core._200908.EnumCardinality;
import org.oasis_open.docs.ns.cmis.core._200908.EnumContentStreamAllowed;
import org.oasis_open.docs.ns.cmis.core._200908.EnumPropertyType;
import org.oasis_open.docs.ns.cmis.core._200908.EnumUpdatability;

public class ConverterImpl
implements Converter {
    private Config configuration;
    private ConfigurationStorage bpfData;
    private SolutionType solntype = new SolutionType();
    private SolutionData solnData;
    private RolesType roles;
    private PropertyDefinitionsType props;
    private InbasketsType inbaskets;
    private CEData ceData;
    private ByteArrayOutputStream XMLOutputStream;
    private HashMap<String, CmisPropertyDefinitionType> propertiesMap = new HashMap();
    private HashMap<Integer, CmisPropertyDefinitionType> propertiesMapWithBPFID = new HashMap();
    private HashMap<String, CmisPropertyDefinitionType> propertiesMapWithBPFName = new HashMap();
    private HashMap<Integer, List<CommonInbasketFilter>> filterMapWithBPFID = new HashMap();
    private String bpfXMLPath;
    private String prefix = "BPF";
    private String solutionName = "Case Management";

    public ConverterImpl() {
        this.props = new PropertyDefinitionsType();
        if (this.solnData == null) {
            this.solnData = new SolutionData();
        }
        if (this.solnData.getRoles() == null) {
            this.solnData.setRoles(new RolesType());
        }
        this.roles = this.solnData.getRoles();
        if (this.solnData.getInbaskets() == null) {
            this.solnData.setInbaskets(new InbasketsType());
        }
        this.inbaskets = this.solnData.getInbaskets();
        this.solnData.setConverterData(this);
    }

    @Override
    public void convert() {
        try {
            this.process();
        }
        catch (TransitionException e) {
            e.printStackTrace();
        }
    }

    @Override
    public List<String> getSolutionList() {
        ArrayList<String> result = new ArrayList<String>();
        ConfigurationStorage.CaseTypes cts = this.bpfData.getCaseTypes();
        List<ConfigurationStorage.CaseTypes.CaseType> ctList = cts.getCaseType();
        for (ConfigurationStorage.CaseTypes.CaseType tempCaseType : ctList) {
            String tempCaseTypeName = tempCaseType.getNAME();
            result.add(tempCaseTypeName);
        }
        return result;
    }

    @Override
    public void setConfiguration(Config configuration) {
        this.configuration = configuration;
    }

    @Override
    public void loadBPFMetadata() {
        BPFJAXBSingleton bjs = BPFJAXBSingleton.getSingleton();
        try {
            this.bpfData = bjs.getBPFData(ConfigurationStorage.class, new FileInputStream(this.bpfXMLPath));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
    }

    @Override
    public SolutionType getSolutionType() {
        return this.solntype;
    }

    public String getBpfXMLPath() {
        return this.bpfXMLPath;
    }

    @Override
    public void setBpfXMLPath(String bpfXMLPath) {
        this.bpfXMLPath = bpfXMLPath;
    }

    public CEData getCeData() {
        return this.ceData;
    }

    @Override
    public void setCEData(CEData ceData) {
        this.ceData = ceData;
    }

    @Override
    public SolutionData getSolutionData() {
        return this.solnData;
    }

    @Override
    public void setSolutionData(SolutionData solnData) {
        this.solnData = solnData;
    }

    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getSolutionName() {
        return this.solutionName;
    }

    @Override
    public void setSolutionName(String solutionName) {
        this.solutionName = solutionName;
    }

    @Override
    public InputStream getConverterdXMLStream() {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(this.XMLOutputStream.toByteArray());
        return inputStream;
    }

    @Override
    public void process() throws TransitionException {
        CaseTypesType caseTypes = new CaseTypesType();
        this.solntype.setCaseTypes(caseTypes);
        TypeDefinitionsType types = new TypeDefinitionsType();
        this.solntype.setTypes(types);
        this.solntype.setName(this.solutionName);
        this.solntype.setProperties(this.props);
        this.solntype.setIntegrationType(EnumIntegrationType.P_8);
        this.solntype.setIconType(EnumIconType.BUILTIN);
        this.solntype.setPrefix(this.prefix);
        this.solntype.setProductName(this.configuration.getProductName());
        this.solntype.setProductVersion(this.configuration.getProductVersion());
        this.solntype.setSchemaVersion(this.configuration.getSchemaVersion());
        this.solntype.setVendorName(this.configuration.getVendorName());
        ContentType ct = new ContentType();
        this.solntype.setIcon(ct);
        this.solntype.getIcon().setUri(this.configuration.getIconUri());
        ContentType ct1 = new ContentType();
        this.solntype.setProcessConfiguration(ct1);
        this.solntype.getProcessConfiguration().setContentId("{00000000-0000-0000-0000-000000000000}");
        ContentType ct2 = new ContentType();
        this.solntype.setGlobalProcessCollection(ct2);
        this.solntype.getGlobalProcessCollection().setContentId("{00000000-0000-0000-0000-000000000000}");
        this.processPicklist();
        this.processProperties();
        this.processDocumentClass();
        this.processFilter();
        this.processCaseType();
        this.processRoleType();
    }

    public void processPicklist() throws TransitionException {
        List<BPFPickList> bpfPickLists = ConfigurationStorageUtil.getStaticPickListsByCase(this.bpfData, this.solutionName);
        if (bpfPickLists != null) {
            ChoiceListDefinitionsType chlstdefs = new ChoiceListDefinitionsType();
            this.solntype.setChoiceLists(chlstdefs);
            for (BPFPickList pickList : bpfPickLists) {
                this.iteratePickList(pickList);
            }
        }
    }

    private void iteratePickList(BPFPickList pickList) throws TransitionException {
        String pickListType = pickList.getType();
        ConfigurationStorage.PickLists.PickList tempPickList = pickList.getData();
        if (pickListType.equals("STRING")) {
            CmisChoiceString outerStringChoiceList = new CmisChoiceString();
            outerStringChoiceList.setDisplayName(String.valueOf(this.solntype.getPrefix()) + "_" + tempPickList.getNAME());
            ConfigurationStorage.PickLists.PickList.Items items = tempPickList.getItems();
            List<ConfigurationStorage.PickLists.PickList.Items.Item> itemList = items.getItem();
            for (ConfigurationStorage.PickLists.PickList.Items.Item item : itemList) {
                CmisChoiceString stringChoiceItem = new CmisChoiceString();
                stringChoiceItem.setDisplayName(item.getDESCRIPTION());
                stringChoiceItem.getValue().add(item.getDESCRIPTION());
                outerStringChoiceList.getChoice().add(stringChoiceItem);
            }
            if (outerStringChoiceList != null) {
                ChoiceListStringDefinitionType chd = new ChoiceListStringDefinitionType();
                chd.setChoice(outerStringChoiceList);
                chd.setId(Id.createId().toString());
                chd.setType(EnumChoiceListType.STRING);
                this.solntype.getChoiceLists().getChoiceListDefinition().add(chd);
            }
        } else if (pickListType.equals("INTEGER")) {
            CmisChoiceInteger outerIntegerChoiceList = new CmisChoiceInteger();
            outerIntegerChoiceList.setDisplayName(String.valueOf(this.solntype.getPrefix()) + "_" + tempPickList.getNAME());
            ConfigurationStorage.PickLists.PickList.Items items = tempPickList.getItems();
            List<ConfigurationStorage.PickLists.PickList.Items.Item> itemList = items.getItem();
            for (ConfigurationStorage.PickLists.PickList.Items.Item item : itemList) {
                CmisChoiceInteger integerChoiceItem = new CmisChoiceInteger();
                integerChoiceItem.setDisplayName(item.getDESCRIPTION());
                integerChoiceItem.getValue().add(BigInteger.valueOf(item.getCODE()));
                outerIntegerChoiceList.getChoice().add(integerChoiceItem);
            }
            if (outerIntegerChoiceList != null) {
                ChoiceListIntegerDefinitionType chd = new ChoiceListIntegerDefinitionType();
                chd.setChoice(outerIntegerChoiceList);
                chd.setId(Id.createId().toString());
                chd.setType(EnumChoiceListType.INTEGER);
                this.solntype.getChoiceLists().getChoiceListDefinition().add(chd);
            }
        }
    }

    public void processProperties() throws TransitionException {
        try {
            List<ConfigurationStorage.ApplicationFields.Field> appFieldsList = ConfigurationStorageUtil.getApplicationFieldsByCase(this.bpfData, this.solutionName);
            for (ConfigurationStorage.ApplicationFields.Field field : appFieldsList) {
                this.iterateProperty(field);
            }
        }
        catch (TransitionException e) {
            e.printStackTrace();
        }
    }

    public void iterateProperty(ConfigurationStorage.ApplicationFields.Field field) throws TransitionException {
        CEProperty ceProperty = this.ceData.getPropertyByName(field.getDBCOLUMN());
        short pickListId = -1;
        if (field.getPICKLISTID() != null) {
            pickListId = field.getPICKLISTID();
        }
        ConfigurationStorage.PickLists.PickList pickList = null;
        String pickListDisplayName = null;
        if (pickListId != -1) {
            pickList = ConfigurationStorageUtil.getPickListById(this.bpfData, pickListId);
            pickListDisplayName = String.valueOf(this.solntype.getPrefix()) + "_" + pickList.getNAME();
        }
        try {
            if (field.getDATATYPE() == 6) {
                CmisPropertyBooleanDefinitionType p = new CmisPropertyBooleanDefinitionType();
                p.setPropertyType(EnumPropertyType.BOOLEAN);
                this.setCommonPropertyFields((CmisPropertyDefinitionType)p, field, ceProperty);
                this.props.getPropertyDefinition().add(p);
                this.propertiesMap.put(p.getId(), (CmisPropertyDefinitionType)p);
                this.propertiesMapWithBPFID.put(field.getID(), (CmisPropertyDefinitionType)p);
                this.propertiesMapWithBPFName.put(field.getNAME(), (CmisPropertyDefinitionType)p);
            } else if (field.getDATATYPE() == 1) {
                CmisPropertyStringDefinitionType p = new CmisPropertyStringDefinitionType();
                p.setPropertyType(EnumPropertyType.STRING);
                this.setCommonPropertyFields((CmisPropertyDefinitionType)p, field, ceProperty);
                int mxl = field.getMAXCHARS();
                p.setMaxLength(BigInteger.valueOf(mxl));
                if (pickListDisplayName != null) {
                    CmisChoiceString ccb = new CmisChoiceString();
                    ccb.setDisplayName(pickListDisplayName);
                    p.getChoice().add(ccb);
                }
                this.props.getPropertyDefinition().add(p);
                this.propertiesMap.put(p.getId(), (CmisPropertyDefinitionType)p);
                this.propertiesMapWithBPFID.put(field.getID(), (CmisPropertyDefinitionType)p);
                this.propertiesMapWithBPFName.put(field.getNAME(), (CmisPropertyDefinitionType)p);
            } else if (field.getDATATYPE() == 3) {
                CmisPropertyDateTimeDefinitionType p = new CmisPropertyDateTimeDefinitionType();
                p.setPropertyType(EnumPropertyType.DATETIME);
                this.setCommonPropertyFields((CmisPropertyDefinitionType)p, field, ceProperty);
                this.props.getPropertyDefinition().add(p);
                this.propertiesMap.put(p.getId(), (CmisPropertyDefinitionType)p);
                this.propertiesMapWithBPFID.put(field.getID(), (CmisPropertyDefinitionType)p);
                this.propertiesMapWithBPFName.put(field.getNAME(), (CmisPropertyDefinitionType)p);
            } else if (field.getDATATYPE() == 7) {
                CmisPropertyDecimalDefinitionType p = new CmisPropertyDecimalDefinitionType();
                p.setPropertyType(EnumPropertyType.DECIMAL);
                this.setCommonPropertyFields((CmisPropertyDefinitionType)p, field, ceProperty);
                this.props.getPropertyDefinition().add(p);
                this.propertiesMap.put(p.getId(), (CmisPropertyDefinitionType)p);
                this.propertiesMapWithBPFID.put(field.getID(), (CmisPropertyDefinitionType)p);
                this.propertiesMapWithBPFName.put(field.getNAME(), (CmisPropertyDefinitionType)p);
            } else if (field.getDATATYPE() == 2) {
                CmisPropertyIntegerDefinitionType p = new CmisPropertyIntegerDefinitionType();
                p.setPropertyType(EnumPropertyType.INTEGER);
                this.setCommonPropertyFields((CmisPropertyDefinitionType)p, field, ceProperty);
                if (pickListDisplayName != null) {
                    CmisChoiceInteger ccb = new CmisChoiceInteger();
                    ccb.setDisplayName(pickListDisplayName);
                    p.getChoice().add(ccb);
                }
                this.props.getPropertyDefinition().add(p);
                this.propertiesMap.put(p.getId(), (CmisPropertyDefinitionType)p);
                this.propertiesMapWithBPFID.put(field.getID(), (CmisPropertyDefinitionType)p);
                this.propertiesMapWithBPFName.put(field.getNAME(), (CmisPropertyDefinitionType)p);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new TransitionException();
        }
        this.solntype.setProperties(this.props);
    }

    private void setCommonPropertyFields(CmisPropertyDefinitionType p, ConfigurationStorage.ApplicationFields.Field field, CEProperty ceProperty) throws TransitionException {
        p.setCardinality(EnumCardinality.SINGLE);
        p.setUpdatability(EnumUpdatability.READWRITE);
        p.setOpenChoice(Boolean.valueOf(false));
        p.setRequired(false);
        p.setInherited(Boolean.valueOf(false));
        p.setOrderable(true);
        p.setQueryable(true);
        p.setId("");
        p.setDisplayName(field.getLABEL());
        p.setDescription(field.getLABEL());
        p.setLocalName(String.valueOf(this.solntype.getPrefix()) + "_" + field.getNAME());
        if (ceProperty != null) {
            p.setRequired(ceProperty.isValueRequired());
            boolean casehid = ceProperty.isHidden();
            Hidden h = new Hidden(Boolean.valueOf(casehid));
            p.getAny().add(h);
            p.setId(this.convertId(ceProperty.getPrimaryID()));
        } else {
            p.setId(Id.createId().toString());
        }
    }

    private void setCommonPropertyFields(CmisPropertyDefinitionType p, CEProperty ceProperty) {
        p.setCardinality(EnumCardinality.SINGLE);
        p.setUpdatability(EnumUpdatability.READWRITE);
        p.setOpenChoice(Boolean.valueOf(false));
        p.setRequired(false);
        p.setInherited(Boolean.valueOf(false));
        p.setOrderable(true);
        p.setQueryable(true);
        p.setId("");
        p.setDisplayName(ceProperty.getName());
        p.setDescription(ceProperty.getName());
        p.setLocalName(String.valueOf(this.solntype.getPrefix()) + "_" + ceProperty.getName());
        if (ceProperty != null) {
            p.setRequired(ceProperty.isValueRequired());
            boolean casehid = ceProperty.isHidden();
            Hidden h = new Hidden(Boolean.valueOf(casehid));
            p.getAny().add(h);
            p.setId(this.convertId(ceProperty.getPrimaryID()));
        }
    }

    public void processDocumentClass() {
        String documentClassName = ConfigurationStorageUtil.getDocumentClassNameByCase(this.bpfData, this.solutionName);
        ObjectManifest.ClassDefinitions.DocumentClassDefinition dcd = this.ceData.getDocumentClassByName(documentClassName);
        if (dcd != null) {
            CmisTypeDocumentDefinitionType docType = new CmisTypeDocumentDefinitionType();
            docType.setLocalNamespace("");
            docType.setBaseId(EnumBaseObjectTypeIds.CMIS_DOCUMENT);
            docType.setCreatable(true);
            docType.setFileable(true);
            docType.setQueryable(true);
            docType.setFulltextIndexed(false);
            docType.setIncludedInSupertypeQuery(true);
            docType.setControllablePolicy(true);
            docType.setControllableACL(true);
            docType.setVersionable(true);
            docType.setContentStreamAllowed(EnumContentStreamAllowed.ALLOWED);
            docType.setId("");
            ObjectManifest.ClassDefinitions.DocumentClassDefinition.DocumentClassDefinitionProperties dcp = dcd.getDocumentClassDefinitionProperties();
            docType.setLocalName(String.valueOf(this.solntype.getPrefix()) + "_" + dcp.getSymbolicName());
            docType.setDescription(dcp.getName());
            List<Object> propertyList = dcd.getDocumentClassDefinitionProperties().getPropertyDefinitions().getPropertyDefinitionObjectOrPropertyDefinitionStringOrPropertyDefinitionInteger32();
            ArrayList<CmisPropertyDateTimeDefinitionType> propList = new ArrayList<CmisPropertyDateTimeDefinitionType>();
            Iterator<Object> it = propertyList.iterator();
            while (it.hasNext()) {
                CEProperty ceProperty;
                CmisPropertyDateTimeDefinitionType p;
                Object pdd;
                CmisPropertyDateTimeDefinitionType cloneType = null;
                CmisPropertyDefinitionType type = null;
                Object tempObj = it.next();
                boolean isSupportType = true;
                if (tempObj instanceof ObjectManifest.ClassDefinitions.DocumentClassDefinition.DocumentClassDefinitionProperties.PropertyDefinitions.PropertyDefinitionDateTime) {
                    pdd = (ObjectManifest.ClassDefinitions.DocumentClassDefinition.DocumentClassDefinitionProperties.PropertyDefinitions.PropertyDefinitionDateTime)tempObj;
                    if (!this.isBPFSpecificField(((ObjectManifest.ClassDefinitions.DocumentClassDefinition.DocumentClassDefinitionProperties.PropertyDefinitions.PropertyDefinitionDateTime)pdd).getName())) {
                        cloneType = new CmisPropertyDateTimeDefinitionType();
                        type = this.propertiesMap.get(this.convertId(((ObjectManifest.ClassDefinitions.DocumentClassDefinition.DocumentClassDefinitionProperties.PropertyDefinitions.PropertyDefinitionDateTime)pdd).getPrimaryId()));
                        if (type == null) {
                            p = new CmisPropertyDateTimeDefinitionType();
                            p.setPropertyType(EnumPropertyType.DATETIME);
                            ceProperty = new CEProperty(((ObjectManifest.ClassDefinitions.DocumentClassDefinition.DocumentClassDefinitionProperties.PropertyDefinitions.PropertyDefinitionDateTime)pdd).getPrimaryId(), ((ObjectManifest.ClassDefinitions.DocumentClassDefinition.DocumentClassDefinitionProperties.PropertyDefinitions.PropertyDefinitionDateTime)pdd).getName(), false, false, null);
                            this.setCommonPropertyFields((CmisPropertyDefinitionType)p, ceProperty);
                            this.props.getPropertyDefinition().add(p);
                            this.propertiesMap.put(p.getId(), (CmisPropertyDefinitionType)p);
                            type = p;
                        }
                        cloneType.setDisplayName(((ObjectManifest.ClassDefinitions.DocumentClassDefinition.DocumentClassDefinitionProperties.PropertyDefinitions.PropertyDefinitionDateTime)pdd).getName());
                        cloneType.setId(((ObjectManifest.ClassDefinitions.DocumentClassDefinition.DocumentClassDefinitionProperties.PropertyDefinitions.PropertyDefinitionDateTime)pdd).getPrimaryId());
                        cloneType.setDescription(((ObjectManifest.ClassDefinitions.DocumentClassDefinition.DocumentClassDefinitionProperties.PropertyDefinitions.PropertyDefinitionDateTime)pdd).getName());
                        cloneType.setLocalName(String.valueOf(this.solntype.getPrefix()) + "_" + ((ObjectManifest.ClassDefinitions.DocumentClassDefinition.DocumentClassDefinitionProperties.PropertyDefinitions.PropertyDefinitionDateTime)pdd).getName());
                        cloneType.setPropertyType(EnumPropertyType.DATETIME);
                    } else {
                        isSupportType = false;
                    }
                } else if (tempObj instanceof ObjectManifest.ClassDefinitions.DocumentClassDefinition.DocumentClassDefinitionProperties.PropertyDefinitions.PropertyDefinitionFloat64) {
                    pdd = (ObjectManifest.ClassDefinitions.DocumentClassDefinition.DocumentClassDefinitionProperties.PropertyDefinitions.PropertyDefinitionFloat64)tempObj;
                    if (!this.isBPFSpecificField(((ObjectManifest.ClassDefinitions.DocumentClassDefinition.DocumentClassDefinitionProperties.PropertyDefinitions.PropertyDefinitionFloat64)pdd).getName())) {
                        cloneType = new CmisPropertyDecimalDefinitionType();
                        type = this.propertiesMap.get(this.convertId(((ObjectManifest.ClassDefinitions.DocumentClassDefinition.DocumentClassDefinitionProperties.PropertyDefinitions.PropertyDefinitionFloat64)pdd).getPrimaryId()));
                        if (type == null) {
                            p = new CmisPropertyDecimalDefinitionType();
                            p.setPropertyType(EnumPropertyType.DECIMAL);
                            ceProperty = new CEProperty(((ObjectManifest.ClassDefinitions.DocumentClassDefinition.DocumentClassDefinitionProperties.PropertyDefinitions.PropertyDefinitionFloat64)pdd).getPrimaryId(), ((ObjectManifest.ClassDefinitions.DocumentClassDefinition.DocumentClassDefinitionProperties.PropertyDefinitions.PropertyDefinitionFloat64)pdd).getName(), false, false, null);
                            this.setCommonPropertyFields((CmisPropertyDefinitionType)p, ceProperty);
                            this.props.getPropertyDefinition().add(p);
                            this.propertiesMap.put(p.getId(), (CmisPropertyDefinitionType)p);
                            type = p;
                        }
                        cloneType.setDisplayName(((ObjectManifest.ClassDefinitions.DocumentClassDefinition.DocumentClassDefinitionProperties.PropertyDefinitions.PropertyDefinitionFloat64)pdd).getName());
                        cloneType.setId(((ObjectManifest.ClassDefinitions.DocumentClassDefinition.DocumentClassDefinitionProperties.PropertyDefinitions.PropertyDefinitionFloat64)pdd).getPrimaryId());
                        cloneType.setDescription(((ObjectManifest.ClassDefinitions.DocumentClassDefinition.DocumentClassDefinitionProperties.PropertyDefinitions.PropertyDefinitionFloat64)pdd).getName());
                        cloneType.setLocalName(String.valueOf(this.solntype.getPrefix()) + "_" + ((ObjectManifest.ClassDefinitions.DocumentClassDefinition.DocumentClassDefinitionProperties.PropertyDefinitions.PropertyDefinitionFloat64)pdd).getName());
                        cloneType.setPropertyType(EnumPropertyType.DECIMAL);
                    } else {
                        isSupportType = false;
                    }
                } else if (tempObj instanceof ObjectManifest.ClassDefinitions.DocumentClassDefinition.DocumentClassDefinitionProperties.PropertyDefinitions.PropertyDefinitionInteger32) {
                    pdd = (ObjectManifest.ClassDefinitions.DocumentClassDefinition.DocumentClassDefinitionProperties.PropertyDefinitions.PropertyDefinitionInteger32)tempObj;
                    if (!this.isBPFSpecificField(((ObjectManifest.ClassDefinitions.DocumentClassDefinition.DocumentClassDefinitionProperties.PropertyDefinitions.PropertyDefinitionInteger32)pdd).getName())) {
                        cloneType = new CmisPropertyIntegerDefinitionType();
                        type = this.propertiesMap.get(this.convertId(((ObjectManifest.ClassDefinitions.DocumentClassDefinition.DocumentClassDefinitionProperties.PropertyDefinitions.PropertyDefinitionInteger32)pdd).getPrimaryId()));
                        if (type == null) {
                            p = new CmisPropertyIntegerDefinitionType();
                            p.setPropertyType(EnumPropertyType.INTEGER);
                            ceProperty = new CEProperty(((ObjectManifest.ClassDefinitions.DocumentClassDefinition.DocumentClassDefinitionProperties.PropertyDefinitions.PropertyDefinitionInteger32)pdd).getPrimaryId(), ((ObjectManifest.ClassDefinitions.DocumentClassDefinition.DocumentClassDefinitionProperties.PropertyDefinitions.PropertyDefinitionInteger32)pdd).getName(), false, false, null);
                            this.setCommonPropertyFields((CmisPropertyDefinitionType)p, ceProperty);
                            this.props.getPropertyDefinition().add(p);
                            this.propertiesMap.put(p.getId(), (CmisPropertyDefinitionType)p);
                            type = p;
                        }
                        cloneType.setDisplayName(((ObjectManifest.ClassDefinitions.DocumentClassDefinition.DocumentClassDefinitionProperties.PropertyDefinitions.PropertyDefinitionInteger32)pdd).getName());
                        cloneType.setId(((ObjectManifest.ClassDefinitions.DocumentClassDefinition.DocumentClassDefinitionProperties.PropertyDefinitions.PropertyDefinitionInteger32)pdd).getPrimaryId());
                        cloneType.setDescription(((ObjectManifest.ClassDefinitions.DocumentClassDefinition.DocumentClassDefinitionProperties.PropertyDefinitions.PropertyDefinitionInteger32)pdd).getName());
                        cloneType.setLocalName(String.valueOf(this.solntype.getPrefix()) + "_" + ((ObjectManifest.ClassDefinitions.DocumentClassDefinition.DocumentClassDefinitionProperties.PropertyDefinitions.PropertyDefinitionInteger32)pdd).getName());
                        cloneType.setPropertyType(EnumPropertyType.INTEGER);
                    } else {
                        isSupportType = false;
                    }
                } else if (tempObj instanceof ObjectManifest.ClassDefinitions.DocumentClassDefinition.DocumentClassDefinitionProperties.PropertyDefinitions.PropertyDefinitionString) {
                    pdd = (ObjectManifest.ClassDefinitions.DocumentClassDefinition.DocumentClassDefinitionProperties.PropertyDefinitions.PropertyDefinitionString)tempObj;
                    if (!this.isBPFSpecificField(((ObjectManifest.ClassDefinitions.DocumentClassDefinition.DocumentClassDefinitionProperties.PropertyDefinitions.PropertyDefinitionString)pdd).getName())) {
                        cloneType = new CmisPropertyStringDefinitionType();
                        type = this.propertiesMap.get(this.convertId(((ObjectManifest.ClassDefinitions.DocumentClassDefinition.DocumentClassDefinitionProperties.PropertyDefinitions.PropertyDefinitionString)pdd).getPrimaryId()));
                        if (type == null) {
                            p = new CmisPropertyStringDefinitionType();
                            p.setPropertyType(EnumPropertyType.STRING);
                            ceProperty = new CEProperty(((ObjectManifest.ClassDefinitions.DocumentClassDefinition.DocumentClassDefinitionProperties.PropertyDefinitions.PropertyDefinitionString)pdd).getPrimaryId(), ((ObjectManifest.ClassDefinitions.DocumentClassDefinition.DocumentClassDefinitionProperties.PropertyDefinitions.PropertyDefinitionString)pdd).getName(), false, false, null);
                            this.setCommonPropertyFields((CmisPropertyDefinitionType)p, ceProperty);
                            this.props.getPropertyDefinition().add(p);
                            this.propertiesMap.put(p.getId(), (CmisPropertyDefinitionType)p);
                            type = p;
                        }
                        cloneType.setDisplayName(((ObjectManifest.ClassDefinitions.DocumentClassDefinition.DocumentClassDefinitionProperties.PropertyDefinitions.PropertyDefinitionString)pdd).getName());
                        cloneType.setId(((ObjectManifest.ClassDefinitions.DocumentClassDefinition.DocumentClassDefinitionProperties.PropertyDefinitions.PropertyDefinitionString)pdd).getPrimaryId());
                        cloneType.setDescription(((ObjectManifest.ClassDefinitions.DocumentClassDefinition.DocumentClassDefinitionProperties.PropertyDefinitions.PropertyDefinitionString)pdd).getName());
                        cloneType.setLocalName(String.valueOf(this.solntype.getPrefix()) + "_" + ((ObjectManifest.ClassDefinitions.DocumentClassDefinition.DocumentClassDefinitionProperties.PropertyDefinitions.PropertyDefinitionString)pdd).getName());
                        cloneType.setPropertyType(EnumPropertyType.STRING);
                    } else {
                        isSupportType = false;
                    }
                } else {
                    isSupportType = false;
                }
                if (!isSupportType) continue;
                if (type != null) {
                    cloneType.setCardinality(type.getCardinality());
                    cloneType.setDescription(type.getDescription());
                    cloneType.setDisplayName(type.getDisplayName());
                    cloneType.setId(type.getId());
                    cloneType.setLocalName(type.getLocalName());
                    cloneType.setOpenChoice(type.isOpenChoice());
                    cloneType.setOrderable(type.isOrderable());
                    cloneType.setPropertyType(type.getPropertyType());
                    cloneType.setQueryable(type.isQueryable());
                    cloneType.setQueryName(type.getQueryName());
                    cloneType.setRequired(type.isRequired());
                    cloneType.setUpdatability(type.getUpdatability());
                    for (Object o : type.getAny()) {
                        if (!(it instanceof Hidden)) continue;
                        Hidden h = (Hidden)o;
                        cloneType.getAny().add(h);
                        break;
                    }
                } else {
                    cloneType.setCardinality(EnumCardinality.SINGLE);
                    cloneType.setOpenChoice(Boolean.valueOf(false));
                    cloneType.setOrderable(true);
                    cloneType.setQueryable(true);
                    cloneType.setRequired(false);
                    cloneType.setUpdatability(EnumUpdatability.READWRITE);
                    Hidden h = new Hidden(Boolean.valueOf(false));
                    cloneType.getAny().add(h);
                }
                propList.add(cloneType);
            }
            docType.getPropertyDefinition().addAll(propList);
            docType.setDisplayName(dcp.getName());
            docType.setBaseId(EnumBaseObjectTypeIds.CMIS_DOCUMENT);
            docType.setContentStreamAllowed(EnumContentStreamAllowed.ALLOWED);
            docType.setId(Id.createId().toString());
            this.solntype.getTypes().getTypeDefinition().add(docType);
        }
    }

    private void processFilter() {
        List<ConfigurationStorage.InbasketFilters.InbasketFilter> fList = this.bpfData.getInbasketFilters().getInbasketFilter();
        for (ConfigurationStorage.InbasketFilters.InbasketFilter filter : fList) {
            short filterId = filter.getID();
            String sql = filter.getRegularSQL();
            this.parseFilterSQL(sql.trim(), filterId);
        }
    }

    private void parseFilterSQL(String sql, int filterId) {
        String name = "";
        int paramIndex = 1;
        if (sql.indexOf("UPPER") == 0 || sql.indexOf("UPPER") == 0) {
            int beginIndex = sql.indexOf("(") + 1;
            int endIndex = sql.indexOf(")");
            name = sql.substring(beginIndex, endIndex);
        } else {
            int endIndex = sql.indexOf(" ");
            name = sql.substring(0, endIndex);
        }
        if (this.propertiesMapWithBPFName.get(name) != null) {
            CommonInbasketFilter cif;
            ArrayList<CommonInbasketFilter> cifl = new ArrayList<CommonInbasketFilter>();
            if (sql.indexOf(">") != -1 && sql.indexOf(">=") == -1) {
                String param = "Param" + paramIndex++;
                cif = new CommonInbasketFilter(name, ">", param);
                cifl.add(cif);
            }
            if (sql.indexOf(">=") != -1) {
                String param = "Param" + paramIndex++;
                cif = new CommonInbasketFilter(name, ">=", param);
                cifl.add(cif);
            }
            if (sql.indexOf("<") != -1 && sql.indexOf("<=") == -1) {
                String param = "Param" + paramIndex++;
                cif = new CommonInbasketFilter(name, "<", param);
                cifl.add(cif);
            }
            if (sql.indexOf("<=") != -1) {
                String param = "Param" + paramIndex++;
                cif = new CommonInbasketFilter(name, "<=", param);
                cifl.add(cif);
            }
            if (sql.indexOf("=") != -1 && sql.indexOf("<=") == -1 && sql.indexOf(">=") == -1) {
                String param = "Param" + paramIndex++;
                cif = new CommonInbasketFilter(name, "=", param);
                cifl.add(cif);
            }
            if (sql.indexOf("LIKE") != -1) {
                String param = "Param" + paramIndex++;
                cif = new CommonInbasketFilter(name, "%", param);
                cifl.add(cif);
            }
            this.filterMapWithBPFID.put(filterId, cifl);
        }
    }

    public void processRoleType() throws TransitionException {
        List<ConfigurationStorage.Profiles.Profile> profiles = ConfigurationStorageUtil.getProfiles(this.bpfData);
        for (ConfigurationStorage.Profiles.Profile profile : profiles) {
            this.iterateRoleType(profile);
        }
    }

    private void iterateRoleType(ConfigurationStorage.Profiles.Profile profile) {
        RoleType rt = new RoleType();
        rt.setState(TypeState.EnumTypeState.NEW);
        rt.setName(profile.getNAME());
        rt.setDescription(profile.getDESCRIPTION());
        rt.setPersonalInbasketType("Solution Personal Inbasket");
        rt.setCanAssignWork(true);
        rt.setCanMoveWorkToPersonalInBasket(true);
        rt.setViewAssignedWorkInBasket(false);
        String roleQueueName = String.valueOf(this.solntype.getPrefix()) + "_" + rt.getName();
        List<ConfigurationStorage.Inbaskets.Inbasket> inbaskets = ConfigurationStorageUtil.getInbasketsByProfile(this.bpfData, profile.getNAME());
        ConfigurationStorage.Inbaskets.Inbasket primaryInbasket = null;
        boolean isFirst = true;
        ArrayList inbasksets = new ArrayList();
        rt.setRoleInbasketsType(inbasksets);
        if (inbaskets.size() > 0) {
            for (ConfigurationStorage.Inbaskets.Inbasket in : inbaskets) {
                RoleInbasketsType inbasket;
                if (!in.getNAME().equals("My Work") && !in.getNAME().equals("Search")) {
                    if (isFirst) {
                        primaryInbasket = in;
                        isFirst = false;
                        inbasket = new RoleInbasketsType();
                        inbasket.setName(primaryInbasket.getNAME());
                        inbasket.setQueue(roleQueueName);
                        inbasket.setPersonal(true);
                        rt.getRoleInbasketsType().add(inbasket);
                        rt.setPrimaryQueue(roleQueueName);
                        this.iterateInbasket(roleQueueName, primaryInbasket, rt, true);
                        continue;
                    }
                    this.iterateInbasket(roleQueueName, in, rt, false);
                    continue;
                }
                if (!in.getNAME().equals("My Work")) continue;
                inbasket = new RoleInbasketsType();
                inbasket.setName(String.valueOf(rt.getName()) + "'s Work");
                inbasket.setQueue("Inbox");
                inbasket.setPersonal(true);
                rt.getRoleInbasketsType().add(inbasket);
                this.iterateInbasket("Inbox", in, rt, false);
            }
        }
        Integer last2 = 0;
        Set keys = this.roles.getRoleTable().keySet();
        for (Integer last2 : keys) {
        }
        if (rt.getState() == TypeState.EnumTypeState.NEW) {
            this.roles.getRoleTable().put(last2 + 1, rt);
        }
    }

    private void iterateInbasket(String roleQueueName, ConfigurationStorage.Inbaskets.Inbasket inbasket, RoleType rt, boolean isPrimary) {
        InbasketType in = new InbasketType();
        in.setState(TypeState.EnumTypeState.NEW);
        in.setName(inbasket.getNAME());
        in.setDescription(String.valueOf(rt.getName()) + "'s Work");
        if (roleQueueName.equals("Inbox")) {
            in.setName(String.valueOf(rt.getName()) + "'s Work");
            in.setType("Solution Personal Inbasket");
        }
        this.processInbasketColumn(inbasket, in);
        this.processInbasketFilter(inbasket, in);
        if (isPrimary || roleQueueName.equals("Inbox")) {
            in.setQueue(roleQueueName);
            Integer last2 = 0;
            Set keys = this.inbaskets.getInbasketTable().keySet();
            for (Integer last2 : keys) {
            }
            if (in.getState() == TypeState.EnumTypeState.NEW) {
                this.inbaskets.getInbasketTable().put(last2 + 1, in);
            }
        }
    }

    private void processInbasketColumn(ConfigurationStorage.Inbaskets.Inbasket inbasket, InbasketType in) {
        List<ConfigurationStorage.Inbaskets.Inbasket.Columns.Column> columnList = inbasket.getColumns().getColumn();
        ArrayList<Column> columns = new ArrayList<Column>();
        Iterator<ConfigurationStorage.Inbaskets.Inbasket.Columns.Column> it = columnList.iterator();
        while (it.hasNext()) {
            Column column = new Column();
            ConfigurationStorage.Inbaskets.Inbasket.Columns.Column columnBPF = it.next();
            CmisPropertyDefinitionType cpd = this.propertiesMapWithBPFID.get(columnBPF.getField().getFIELDID());
            if (cpd == null) continue;
            column.setName(cpd.getLocalName());
            column.setLabel(cpd.getDisplayName());
            column.setSortable(true);
            column.setSortDefault(true);
            column.setSortAscending(true);
            column.setState(TypeState.EnumTypeState.NEW);
            columns.add(column);
        }
        in.setColumns(columns);
    }

    private void processInbasketFilter(ConfigurationStorage.Inbaskets.Inbasket inbasket, InbasketType in) {
        ArrayList<Filter> filters = in.getFilters();
        if (filters == null) {
            filters = new ArrayList<Filter>();
            in.setFilters(filters);
        }
        List<ConfigurationStorage.Inbaskets.Inbasket.Filters.Filter> filterList = inbasket.getFilters().getFilter();
        boolean i = false;
        for (ConfigurationStorage.Inbaskets.Inbasket.Filters.Filter bpfInbasketFilter : filterList) {
            List<CommonInbasketFilter> cifl = this.filterMapWithBPFID.get(bpfInbasketFilter.getCUSTOMFILTERID());
            if (cifl == null) continue;
            for (CommonInbasketFilter cif : cifl) {
                CmisPropertyDefinitionType property = this.propertiesMapWithBPFName.get(cif.getFieldName());
                Filter condition = new Filter();
                condition.setName(property.getLocalName());
                String type = null;
                if (property.getPropertyType().equals((Object)EnumPropertyType.INTEGER)) {
                    type = "integer";
                } else if (property.getPropertyType().equals((Object)EnumPropertyType.STRING)) {
                    type = "string";
                } else if (property.getPropertyType().equals((Object)EnumPropertyType.BOOLEAN)) {
                    type = "boolean";
                } else if (property.getPropertyType().equals((Object)EnumPropertyType.DECIMAL)) {
                    type = "float";
                } else if (property.getPropertyType().equals((Object)EnumPropertyType.DATETIME)) {
                    type = "datetime";
                }
                condition.setOperator(cif.getOperator());
                condition.setType(type);
                condition.setLabel(cif.getParam());
                condition.setUniqueName(condition.getName());
                condition.setState(TypeState.EnumTypeState.NEW);
                filters.add(condition);
            }
        }
        in.setFilters(filters);
    }

    public void processCaseType() throws TransitionException {
        CaseTypeType ct = new CaseTypeType();
        ViewsType vts = new ViewsType();
        ct.setViews(vts);
        TasksType acts = new TasksType();
        ct.setTasks(acts);
        PropertyDefinitionsType caseProps = new PropertyDefinitionsType();
        ct.setCaseProperties(caseProps);
        ct.setId("");
        String caseTypeName = this.removeSpace(this.configuration.getBpfCaseName());
        ct.setName(caseTypeName);
        ct.setHashTimePattern(EnumHashTimePattern.YYYY_MM_DD_HH);
        ct.setDescription(this.configuration.getBpfCaseName());
        this.processCaseProperties(caseProps);
        this.processViewType(vts);
        CaseStructureType caseStructure = new CaseStructureType();
        ct.setCaseStructure(caseStructure);
        ct.setDisplayName(this.configuration.getBpfCaseName());
        ct.setCaseTitle(this.configuration.getBpfCaseName());
        ct.setCasePageName(String.valueOf(this.solntype.getPrefix()) + "_" + "CmAcmCASE_DEFAULT_PAGE");
        ct.setCaseCreationPageName(String.valueOf(this.solntype.getPrefix()) + "_" + "CmAcmCASE_NEW_DEFAULT_PAGE");
        ct.setCaseSplitPageName(String.valueOf(this.solntype.getPrefix()) + "_" + "CmAcmCASE_SPLIT_DEFAULT_PAGE");
        ct.setId(Id.createId().toString());
        this.solntype.getCaseTypes().getCaseType().add(ct);
    }

    public void processCaseProperties(PropertyDefinitionsType caseProps) throws TransitionException {
        for (CmisPropertyDefinitionType type : this.props.getPropertyDefinition()) {
            EnumPropertyType cpt = type.getPropertyType();
            this.iterateCaseProperty(caseProps, cpt, type);
        }
    }

    public void iterateCaseProperty(PropertyDefinitionsType caseProps, EnumPropertyType cpt, CmisPropertyDefinitionType type) throws TransitionException {
        try {
            if (cpt.toString().equalsIgnoreCase("boolean")) {
                CmisPropertyBooleanDefinitionType p = new CmisPropertyBooleanDefinitionType();
                p.setPropertyType(EnumPropertyType.BOOLEAN);
                this.setCaseProperty((CmisPropertyDefinitionType)p, type);
                caseProps.getPropertyDefinition().add(p);
            } else if (cpt.toString().equalsIgnoreCase("string")) {
                CmisPropertyStringDefinitionType p = new CmisPropertyStringDefinitionType();
                p.setPropertyType(EnumPropertyType.STRING);
                this.setCaseProperty((CmisPropertyDefinitionType)p, type);
                caseProps.getPropertyDefinition().add(p);
            } else if (cpt.toString().equalsIgnoreCase("datetime")) {
                CmisPropertyDateTimeDefinitionType p = new CmisPropertyDateTimeDefinitionType();
                p.setPropertyType(EnumPropertyType.DATETIME);
                this.setCaseProperty((CmisPropertyDefinitionType)p, type);
                caseProps.getPropertyDefinition().add(p);
            } else if (cpt.toString().equalsIgnoreCase("decimal")) {
                CmisPropertyDecimalDefinitionType p = new CmisPropertyDecimalDefinitionType();
                p.setPropertyType(EnumPropertyType.DECIMAL);
                this.setCaseProperty((CmisPropertyDefinitionType)p, type);
                caseProps.getPropertyDefinition().add(p);
            } else if (cpt.toString().equalsIgnoreCase("integer")) {
                CmisPropertyIntegerDefinitionType p = new CmisPropertyIntegerDefinitionType();
                p.setPropertyType(EnumPropertyType.INTEGER);
                this.setCaseProperty((CmisPropertyDefinitionType)p, type);
                caseProps.getPropertyDefinition().add(p);
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
    }

    public void setCaseProperty(CmisPropertyDefinitionType p, CmisPropertyDefinitionType type) {
        p.setCardinality(type.getCardinality());
        p.setRequired(type.isRequired());
        p.setOpenChoice(Boolean.valueOf(false));
        p.setInherited(Boolean.valueOf(false));
        p.setOrderable(true);
        p.setQueryable(true);
        p.setDescription(type.getDescription());
        p.setUpdatability(type.getUpdatability());
        if (type.getLocalName() != null) {
            p.setLocalName(type.getLocalName());
        }
        if (type.getDisplayName() != null) {
            p.setDisplayName(type.getDisplayName());
        }
        if (type.getId() != null) {
            p.setId(type.getId());
        }
        for (Object o : type.getAny()) {
            if (!(o instanceof Hidden)) continue;
            Hidden h = (Hidden)o;
            p.getAny().add(h);
            break;
        }
    }

    private void processViewType(ViewsType vts) throws TransitionException {
        this.iterateView("CaseSummaryView", vts);
        this.iterateView("CaseSearchView", vts);
        this.iterateView("CaseDataView", vts);
    }

    private void iterateView(String viewId, ViewsType vts) throws TransitionException {
        ViewType vt = new ViewType();
        vt.setId(viewId);
        this.processViewProperty(viewId, vt);
        vts.getView().add(vt);
    }

    private void processViewProperty(String viewId, ViewType vt) {
        block4: {
            block5: {
                block3: {
                    if (!viewId.equals("CaseSummaryView")) break block3;
                    for (CmisPropertyDefinitionType type : this.props.getPropertyDefinition()) {
                        String s = type.getLocalName();
                        vt.getPropertyId().add(s);
                    }
                    break block4;
                }
                if (!viewId.equals("CaseSearchView")) break block5;
                for (CmisPropertyDefinitionType type : this.props.getPropertyDefinition()) {
                    String s = type.getLocalName();
                    vt.getPropertyId().add(s);
                }
                break block4;
            }
            if (!viewId.equals("CaseDataView")) break block4;
            for (CmisPropertyDefinitionType type : this.props.getPropertyDefinition()) {
                String s = type.getLocalName();
                vt.getPropertyId().add(s);
            }
        }
    }

    public void processRolePageNameElement() throws TransitionException {
        RolePageNamesType rps = new RolePageNamesType();
        for (RoleType role : this.roles.getRoleTable().values()) {
            RolePageNameType rp = new RolePageNameType();
            rp.setRoleName(role.getName());
            rps.getRolePageName().add(rp);
        }
    }

    private String convertId(String Id2) {
        String result = null;
        result = "{" + Id2 + "}";
        return result;
    }

    private String removeSpace(String name) {
        String result = null;
        String[] stringArray = name.split(" ");
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < stringArray.length) {
            sb.append(stringArray[i]);
            ++i;
        }
        result = sb.toString();
        return result;
    }

    private boolean isBPFSpecificField(String name) {
        boolean result = false;
        result = name.toUpperCase().indexOf("BP8") == 0 || name.toUpperCase().indexOf("BPF") == 0 || name.equals("BoundUser") || name.equals("LockUser") || name.equals("Step Name");
        return result;
    }

    @Override
    public void output() {
        try {
            String outputPath = this.configuration.getOutputPath();
            String sdfOutputPath = String.valueOf(outputPath) + "sdf.xml";
            FileOutputStream bpfFos = new FileOutputStream(sdfOutputPath);
            this.XMLOutputStream = new ByteArrayOutputStream();
            String pkgName = "com.ibm.xmlns.prod.ecm.acm.sdf:org.oasis_open.docs.ns.cmis.core._200908:com.ibm.xmlns.prod.ecm.cmis.caseextensions";
            JAXBContext jc = JAXBContext.newInstance((String)pkgName);
            ObjectFactory factory = new ObjectFactory();
            Marshaller m = jc.createMarshaller();
            m.setProperty("jaxb.encoding", (Object)"UTF-8");
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            m.setProperty("com.sun.xml.bind.namespacePrefixMapper", (Object)new ACMNamespacePrefixMapperImpl());
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            m.marshal((Object)factory.createSolution(this.getSolutionType()), (OutputStream)bpfFos);
            m.marshal((Object)factory.createSolution(this.getSolutionType()), (OutputStream)this.XMLOutputStream);
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        try {
            TransitionManager tm = TransitionManager.getInstance();
            tm.loadBPFMetadata();
            tm.setSolutionName("Case Management");
            tm.setSolutionPrifix("BPF");
            tm.convert();
            System.out.println("Convertion completed!");
        }
        catch (Exception e) {
            System.out.println("Error in converting, please check your configuration.");
            e.printStackTrace();
        }
    }
}

