/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.acm.transition.converter;

import com.filenet.api.constants.RefreshMode;
import com.filenet.api.core.Connection;
import com.filenet.api.core.Document;
import com.filenet.api.core.Domain;
import com.filenet.api.core.EngineObject;
import com.filenet.api.core.Factory;
import com.filenet.api.core.Folder;
import com.filenet.api.core.IndependentlyPersistableObject;
import com.filenet.api.core.ObjectStore;
import com.filenet.api.core.UpdatingBatch;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.property.PropertyFilter;
import com.filenet.api.util.Id;
import com.filenet.api.util.UserContext;
import com.ibm.acm.sold.comm.CaseTypeData;
import com.ibm.acm.sold.comm.SdfData;
import com.ibm.acm.sold.connector.CEDocumentHandler;
import com.ibm.acm.sold.connector.CEFolderHandler;
import com.ibm.acm.sold.connector.Utility;
import com.ibm.acm.sold.converter.DateTime;
import com.ibm.acm.sold.exception.AcmConnectionFailure;
import com.ibm.acm.sold.exception.AcmException;
import com.ibm.acm.sold.exception.AcmFileNotFoundException;
import com.ibm.acm.sold.messages.Message;
import com.ibm.acm.transition.common.Config;
import com.ibm.acm.transition.converter.CEDataConnector;
import com.ibm.acm.transition.converter.PEConfig;
import com.ibm.acm.transition.entity.CEData;
import com.ibm.acm.transition.entity.CEProperty;
import com.ibm.acm.transition.entity.SolutionData;
import com.ibm.acm.transition.jaxb.CEJAXBSingleton;
import com.ibm.acm.transition.jaxb.ce.ObjectManifest;
import com.ibm.xmlns.prod.ecm.acm.sdf.CaseTypeType;
import com.ibm.xmlns.prod.ecm.acm.sdf.ContentType;
import com.ibm.xmlns.prod.ecm.acm.sdf.PropertyDefinitionsType;
import com.ibm.xmlns.prod.ecm.acm.sdf.SolutionType;
import com.ibm.xmlns.prod.ecm.acm.sdf.TaskType;
import com.ibm.xmlns.prod.ecm.acm.sdf.TypeDefinitionsType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.xml.bind.JAXBException;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyDefinitionType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisTypeDefinitionType;

public class CEDataConnectorImpl
implements CEDataConnector {
    private Config configuration;
    private CEData ceData = new CEData();
    UserContext origUC = null;
    ObjectStore objectstore = null;
    Folder folder = null;
    SdfData Sdfdata = null;
    SolutionData solData = null;
    String userName = null;
    Folder m_solutionsFolder = null;
    private String projectArea = null;
    private PropertyFilter pf = null;

    public CEDataConnectorImpl() {
        ArrayList<CEProperty> propertyList = new ArrayList<CEProperty>();
        this.ceData.setCeProperties(propertyList);
    }

    @Override
    public CEData getCEData() {
        return this.ceData;
    }

    @Override
    public void setConfiguration(Config config) {
        this.configuration = config;
    }

    @Override
    public void setSolutionData(SolutionData data) {
        this.solData = data;
    }

    @Override
    public void loadCEData() {
        CEJAXBSingleton cjs = CEJAXBSingleton.getSingleton();
        try {
            ObjectManifest jaxbObjConfig = cjs.readCEData(ObjectManifest.class, new FileInputStream(this.configuration.getCeXMLPath()));
            ObjectManifest.PropertyTemplates properties = jaxbObjConfig.getPropertyTemplates();
            List<Object> cePropertyList = properties.getPropertyTemplateBooleanOrPropertyTemplateDateTimeOrPropertyTemplateInteger32();
            for (Object tempObj : cePropertyList) {
                CEProperty ceProperty;
                Object property;
                if (tempObj instanceof ObjectManifest.PropertyTemplates.PropertyTemplateBoolean) {
                    property = (ObjectManifest.PropertyTemplates.PropertyTemplateBoolean)tempObj;
                    ceProperty = new CEProperty();
                    ceProperty.setPrimaryID(((ObjectManifest.PropertyTemplates.PropertyTemplateBoolean)property).getPropertyTemplateBooleanProperties().getPrimaryId());
                    ceProperty.setName(((ObjectManifest.PropertyTemplates.PropertyTemplateBoolean)property).getPropertyTemplateBooleanProperties().getSymbolicName());
                    ceProperty.setHidden(Boolean.getBoolean(((ObjectManifest.PropertyTemplates.PropertyTemplateBoolean)property).getPropertyTemplateBooleanProperties().getIsHidden()));
                    ceProperty.setValueRequired(Boolean.getBoolean(((ObjectManifest.PropertyTemplates.PropertyTemplateBoolean)property).getPropertyTemplateBooleanProperties().getIsValueRequired()));
                    this.ceData.getCeProperties().add(ceProperty);
                    continue;
                }
                if (tempObj instanceof ObjectManifest.PropertyTemplates.PropertyTemplateDateTime) {
                    property = (ObjectManifest.PropertyTemplates.PropertyTemplateDateTime)tempObj;
                    ceProperty = new CEProperty();
                    ceProperty.setPrimaryID(((ObjectManifest.PropertyTemplates.PropertyTemplateDateTime)property).getPropertyTemplateDateTimeProperties().getPrimaryId());
                    ceProperty.setName(((ObjectManifest.PropertyTemplates.PropertyTemplateDateTime)property).getPropertyTemplateDateTimeProperties().getSymbolicName());
                    ceProperty.setHidden(Boolean.getBoolean(((ObjectManifest.PropertyTemplates.PropertyTemplateDateTime)property).getPropertyTemplateDateTimeProperties().getIsHidden()));
                    ceProperty.setValueRequired(Boolean.getBoolean(((ObjectManifest.PropertyTemplates.PropertyTemplateDateTime)property).getPropertyTemplateDateTimeProperties().getIsValueRequired()));
                    this.ceData.getCeProperties().add(ceProperty);
                    continue;
                }
                if (tempObj.getClass().isInstance(ObjectManifest.PropertyTemplates.PropertyTemplateFloat64.class)) {
                    property = (ObjectManifest.PropertyTemplates.PropertyTemplateFloat64)tempObj;
                    ceProperty = new CEProperty();
                    ceProperty.setPrimaryID(((ObjectManifest.PropertyTemplates.PropertyTemplateFloat64)property).getPropertyTemplateFloat64Properties().getPrimaryId());
                    ceProperty.setName(((ObjectManifest.PropertyTemplates.PropertyTemplateFloat64)property).getPropertyTemplateFloat64Properties().getSymbolicName());
                    ceProperty.setHidden(Boolean.getBoolean((String)((ObjectManifest.PropertyTemplates.PropertyTemplateFloat64)property).getPropertyTemplateFloat64Properties().getIsHidden()));
                    ceProperty.setValueRequired(Boolean.getBoolean((String)((ObjectManifest.PropertyTemplates.PropertyTemplateFloat64)property).getPropertyTemplateFloat64Properties().getIsValueRequired()));
                    this.ceData.getCeProperties().add(ceProperty);
                    continue;
                }
                if (tempObj instanceof ObjectManifest.PropertyTemplates.PropertyTemplateInteger32) {
                    property = (ObjectManifest.PropertyTemplates.PropertyTemplateInteger32)tempObj;
                    ceProperty = new CEProperty();
                    ceProperty.setPrimaryID(((ObjectManifest.PropertyTemplates.PropertyTemplateInteger32)property).getPropertyTemplateInteger32Properties().getPrimaryId());
                    ceProperty.setName(((ObjectManifest.PropertyTemplates.PropertyTemplateInteger32)property).getPropertyTemplateInteger32Properties().getSymbolicName());
                    ceProperty.setHidden(Boolean.getBoolean(((ObjectManifest.PropertyTemplates.PropertyTemplateInteger32)property).getPropertyTemplateInteger32Properties().getIsHidden()));
                    ceProperty.setValueRequired(Boolean.getBoolean(((ObjectManifest.PropertyTemplates.PropertyTemplateInteger32)property).getPropertyTemplateInteger32Properties().getIsValueRequired()));
                    this.ceData.getCeProperties().add(ceProperty);
                    continue;
                }
                if (tempObj instanceof ObjectManifest.PropertyTemplates.PropertyTemplateString) {
                    property = (ObjectManifest.PropertyTemplates.PropertyTemplateString)tempObj;
                    ceProperty = new CEProperty();
                    ceProperty.setPrimaryID(((ObjectManifest.PropertyTemplates.PropertyTemplateString)property).getPropertyTemplateStringProperties().getPrimaryId());
                    ceProperty.setName(((ObjectManifest.PropertyTemplates.PropertyTemplateString)property).getPropertyTemplateStringProperties().getSymbolicName());
                    ceProperty.setHidden(Boolean.getBoolean(((ObjectManifest.PropertyTemplates.PropertyTemplateString)property).getPropertyTemplateStringProperties().getIsHidden()));
                    ceProperty.setValueRequired(Boolean.getBoolean(((ObjectManifest.PropertyTemplates.PropertyTemplateString)property).getPropertyTemplateStringProperties().getIsValueRequired()));
                    this.ceData.getCeProperties().add(ceProperty);
                    continue;
                }
                if (!(tempObj instanceof ObjectManifest.PropertyTemplates.PropertyTemplateObject)) continue;
                property = (ObjectManifest.PropertyTemplates.PropertyTemplateObject)tempObj;
                ceProperty = new CEProperty();
                ceProperty.setPrimaryID(((ObjectManifest.PropertyTemplates.PropertyTemplateObject)property).getPropertyTemplateObjectProperties().getPrimaryId());
                ceProperty.setName(((ObjectManifest.PropertyTemplates.PropertyTemplateObject)property).getPropertyTemplateObjectProperties().getSymbolicName());
                ceProperty.setHidden(Boolean.getBoolean(((ObjectManifest.PropertyTemplates.PropertyTemplateObject)property).getPropertyTemplateObjectProperties().getIsHidden()));
                ceProperty.setValueRequired(Boolean.getBoolean(((ObjectManifest.PropertyTemplates.PropertyTemplateObject)property).getPropertyTemplateObjectProperties().getIsValueRequired()));
                this.ceData.getCeProperties().add(ceProperty);
            }
            List<ObjectManifest.ClassDefinitions.DocumentClassDefinition> docClassDefinitionList = jaxbObjConfig.getClassDefinitions().getDocumentClassDefinition();
            this.ceData.setCeDocProperties(docClassDefinitionList);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
    }

    @Override
    public synchronized void openSession() {
        this.origUC = UserContext.get();
        UserContext tempUC = new UserContext();
        tempUC.setLocale(this.origUC.getLocale());
        UserContext.set((UserContext)tempUC);
        Connection conn = null;
        try {
            conn = Factory.Connection.getConnection((String)this.configuration.getCeUri());
            Subject subject = UserContext.createSubject((Connection)conn, (String)this.configuration.getUserName(), (String)this.configuration.getPassword(), null);
            UserContext.get().pushSubject(subject);
            Domain domain = Factory.Domain.fetchInstance((Connection)conn, null, null);
        }
        catch (EngineRuntimeException e) {
            e.printStackTrace();
            Message message = new Message("B0005E.CONNECTION_FAILURE", new Object[]{e.getLocalizedMessage()});
        }
        catch (Exception e) {
            e.printStackTrace();
            Message message = new Message("B0005E.CONNECTION_FAILURE", new Object[]{e.getLocalizedMessage()});
        }
        if (conn == null) {
            Message e = new Message("B0005E.CONNECTION_FAILURE");
        }
        try {
            this.objectstore = this.getObjectSore();
            CEFolderHandler cefldrhandler = new CEFolderHandler(this.objectstore);
            this.m_solutionsFolder = cefldrhandler.getSolutionsFolder();
        }
        catch (AcmException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String save(PEConfig peconfig, InputStream configContent) {
        Folder solFolder;
        CEDocumentHandler docHandler = new CEDocumentHandler(this.objectstore);
        SolutionType solutionType = this.solData.getConverterData().getSolutionType();
        String solutionName = solutionType.getName();
        String solutionDesc = solutionType.getDescription();
        String solutionIconURI = null;
        if (solutionType.getIcon() != null) {
            solutionIconURI = solutionType.getIcon().getUri();
        }
        Id sdfVsid = null;
        Id configVsid = null;
        ArrayList<Object> docs = new ArrayList<IndependentlyPersistableObject>(6);
        ArrayList<IndependentlyPersistableObject> docsList = new ArrayList<IndependentlyPersistableObject>(6);
        List caseTypes = null;
        if (solutionType.getCaseTypes() != null) {
            caseTypes = solutionType.getCaseTypes().getCaseType();
        }
        if (this.m_solutionsFolder.equals(null)) {
            Message message = new Message("B4039E.GET_SOLUTIONS_FOLDER_FAILED");
        }
        try {
            InputStream sdfContent;
            solFolder = null;
            if (solFolder == null) {
                solFolder = Factory.Folder.createInstance((ObjectStore)this.objectstore, (String)"CmAcmSolutionFolder");
                solFolder.set_Parent(this.m_solutionsFolder);
                solFolder.set_FolderName(solutionName);
                if (solutionDesc != null) {
                    solFolder.getProperties().putValue("Description", solutionDesc);
                }
                if (solutionIconURI != null) {
                    solFolder.getProperties().putValue("CmAcmIconURI", solutionIconURI);
                }
                docs.add(docHandler.createDocument(CEDocumentHandler.EnumDocumentType.SDF));
                docs.add(docHandler.createDocument(CEDocumentHandler.EnumDocumentType.PECONFIG));
                docs.add(docHandler.createDocument(CEDocumentHandler.EnumDocumentType.GLOBAL_XPDL));
                docs.add(solFolder);
                for (CaseTypeType caseType : caseTypes) {
                    CaseTypeData caseTypeData = this.solData.getCasetypedata(caseType.getName());
                    if (caseTypeData == null) continue;
                    docs.add((IndependentlyPersistableObject)docHandler.createDocument(CEDocumentHandler.EnumDocumentType.XPDL, caseType.getDisplayName()));
                }
                this.updateDocumentsInBatch(docs, RefreshMode.REFRESH, this.pf);
                docHandler.fileToFolder(solFolder, (Document)docs.get(0), this.pf);
                docHandler.fileToFolder(solFolder, (Document)docs.get(1), this.pf);
                docHandler.fileToFolder(solFolder, (Document)docs.get(2), this.pf);
                ContentType ct = new ContentType();
                Id global_xpdl_vsid = ((Document)docs.get(2)).get_VersionSeries().get_Id();
                ct.setContentId(global_xpdl_vsid.toString());
                solutionType.setGlobalProcessCollection(ct);
                CaseTypeData ctd = new CaseTypeData();
                ctd.setSymName(global_xpdl_vsid.toString());
                this.solData.setCasetypedata(global_xpdl_vsid.toString(), ctd);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                try {
                    ctd.toXPDLStream((OutputStream)out, solutionType.getName());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Message msg = new Message("B4016E.SAVE_FAILED", new Object[]{e.getLocalizedMessage()});
                    throw new AcmException(msg);
                }
                ByteArrayInputStream content = new ByteArrayInputStream(out.toByteArray());
                docsList.add((IndependentlyPersistableObject)docHandler.saveDocument(global_xpdl_vsid, (InputStream)content, CEDocumentHandler.EnumDocumentType.GLOBAL_XPDL));
                int i = 4;
                for (CaseTypeType caseType : caseTypes) {
                    CaseTypeData caseTypeData = this.solData.getCasetypedata(caseType.getName());
                    if (caseTypeData == null) continue;
                    docHandler.fileToFolder(solFolder, (Document)docs.get(i), caseType.getName(), this.pf);
                    ct = new ContentType();
                    ct.setContentId(((Document)docs.get(i)).get_VersionSeries().get_Id().toString());
                    caseType.setProcessDefinition(ct);
                    ++i;
                }
            }
            if (solutionType.getGlobalProcessCollection() == null) {
                if (this.Sdfdata != null && this.Sdfdata.getSolutionType() != null && this.Sdfdata.getSolutionType().getGlobalProcessCollection() != null) {
                    solutionType.setGlobalProcessCollection(this.Sdfdata.getSolutionType().getGlobalProcessCollection());
                } else {
                    docsList.add((IndependentlyPersistableObject)this.createGlobalXpdl(solFolder, docHandler, solutionType));
                }
            }
            if (solutionDesc != null) {
                solFolder.getProperties().putValue("Description", solutionDesc);
            } else {
                solFolder.getProperties().putValue("Description", "");
            }
            if (solutionIconURI != null) {
                solFolder.getProperties().putValue("CmAcmIconURI", solutionIconURI);
            }
            this.projectArea = "dev_env_connection_definition";
            String projectAreaPath = "/IBM Case Manager/Connection Definitions/" + this.projectArea;
            Document projectAreaDoc = Factory.Document.fetchInstance((ObjectStore)this.objectstore, (String)projectAreaPath, null);
            solFolder.getProperties().putValue("CmAcmProjectArea", (EngineObject)projectAreaDoc.get_VersionSeries());
            String integrationType = solutionType.getIntegrationType().name();
            int result = integrationType.equalsIgnoreCase("CM_8") ? 1 : 0;
            solFolder.getProperties().putValue("CmAcmIntegrationType", result);
            solFolder.save(RefreshMode.NO_REFRESH, this.pf);
            TypeDefinitionsType docTypes = solutionType.getTypes();
            Map<String, String> docGuids = this.solData.getDocTypeGuids();
            if (docTypes != null && docGuids != null) {
                Iterator<String> i1 = docGuids.keySet().iterator();
                while (i1.hasNext()) {
                    String key = i1.next();
                    boolean found = false;
                    for (CmisTypeDefinitionType d : docTypes.getTypeDefinition()) {
                        if (!key.equals(d.getLocalName())) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    i1.remove();
                }
            }
            PropertyDefinitionsType props = solutionType.getProperties();
            Map<String, String> propGuids = this.solData.getPropertyGuids();
            if (props != null && propGuids != null) {
                Iterator<String> i1 = propGuids.keySet().iterator();
                while (i1.hasNext()) {
                    String key = i1.next();
                    boolean found = false;
                    for (CmisPropertyDefinitionType p : props.getPropertyDefinition()) {
                        if (!key.equals(p.getLocalName())) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    i1.remove();
                }
            }
            Document sdfDoc = this.getDocument(solFolder, "Solution Definition", "solution");
            sdfVsid = sdfDoc.get_VersionSeries().get_Id();
            Document configDoc = this.getDocument(solFolder, "PE Configuration", "solution");
            configVsid = configDoc.get_VersionSeries().get_Id();
            ContentType ct = new ContentType();
            ct.setContentId(configVsid.toString());
            solutionType.setProcessConfiguration(ct);
            ArrayList<String> detetedXpdlList = new ArrayList<String>(5);
            if (this.Sdfdata != null && this.Sdfdata.getSolutionType() != null && this.Sdfdata.getSolutionType().getCaseTypes() != null) {
                List oldCaseTypesList = this.Sdfdata.getSolutionType().getCaseTypes().getCaseType();
                for (CaseTypeType oldCaseType : oldCaseTypesList) {
                    boolean bFound = false;
                    for (CaseTypeType caseType : caseTypes) {
                        if (!Collator.getInstance().equals(oldCaseType.getName(), caseType.getName())) continue;
                        caseType.setProcessDefinition(oldCaseType.getProcessDefinition());
                        bFound = true;
                        break;
                    }
                    if (bFound) continue;
                    if (oldCaseType.getProcessDefinition() != null) {
                        detetedXpdlList.add(oldCaseType.getProcessDefinition().getContentId());
                    }
                    this.solData.removeCaseTypeTaskGuids(oldCaseType.getName());
                }
            }
            for (CaseTypeType caseType : caseTypes) {
                Document savedDoc;
                CaseTypeData caseTypeData = this.solData.getCasetypedata(caseType.getName());
                if (caseTypeData == null) continue;
                if (caseTypeData.getActivitiesMap().size() != 0) {
                    Map actList = caseTypeData.getActivitiesMap();
                    Iterator i1 = actList.keySet().iterator();
                    while (i1.hasNext()) {
                        String key = (String)i1.next();
                        boolean found = false;
                        List tasklist = caseType.getTasks().getTask();
                        for (TaskType t : tasklist) {
                            if (!Collator.getInstance().equals(key, t.getName())) continue;
                            found = true;
                        }
                        if (found) continue;
                        i1.remove();
                        this.solData.removeTaskGuid(key);
                    }
                }
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                try {
                    caseTypeData.toXPDLStream((OutputStream)out, solutionType.getName());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Message msg = new Message("B4016E.SAVE_FAILED", new Object[]{e.getLocalizedMessage()});
                    throw new AcmException(msg);
                }
                ByteArrayInputStream content = new ByteArrayInputStream(out.toByteArray());
                Id id = null;
                if (caseType.getProcessDefinition() != null) {
                    id = new Id(caseType.getProcessDefinition().getContentId());
                }
                if (id == null) {
                    Document doc = docHandler.createDocument(CEDocumentHandler.EnumDocumentType.XPDL, caseType.getDisplayName());
                    doc.save(RefreshMode.REFRESH, this.pf);
                    docHandler.fileToFolder(solFolder, doc, caseType.getName(), this.pf);
                    id = doc.get_VersionSeries().get_Id();
                    ContentType cType = new ContentType();
                    cType.setContentId(id.toString());
                    caseType.setProcessDefinition(cType);
                }
                if ((savedDoc = docHandler.saveDocument(id, (InputStream)content, CEDocumentHandler.EnumDocumentType.XPDL)) == null) continue;
                docsList.add((IndependentlyPersistableObject)savedDoc);
            }
            if (configContent != null) {
                docsList.add((IndependentlyPersistableObject)docHandler.saveDocument(configVsid, configContent, CEDocumentHandler.EnumDocumentType.PECONFIG));
            }
            if ((sdfContent = this.solData.getConverterData().getConverterdXMLStream()) != null) {
                docsList.add((IndependentlyPersistableObject)docHandler.saveDocument(sdfVsid, sdfContent, CEDocumentHandler.EnumDocumentType.SDF));
            }
            this.updateDocumentsInBatch(docsList, RefreshMode.NO_REFRESH, this.pf);
            for (String xpdlVsid : detetedXpdlList) {
                docHandler.deleteDocument(new Id(xpdlVsid), this.pf);
            }
            sdfContent.close();
            Utility.deleteTempFile((String)solutionName);
        }
        catch (AcmException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            Message msg = new Message("B4016E.SAVE_FAILED", new Object[]{e.getLocalizedMessage()});
            e.printStackTrace();
        }
        Message msg = new Message("B4005I.SOLUTION_CREATED");
        String response = "";
        response = sdfVsid != null ? response.concat("{\"msg\":\"" + msg.getFormattedText() + "\",\"sdfVSID\":\"" + sdfVsid.toString() + "\"}") : response.concat("{\"msg\":\"" + msg.getFormattedText() + "\"}");
        try {
            docHandler = new CEDocumentHandler(this.objectstore);
            CEFolderHandler cefldrhandler = new CEFolderHandler(this.objectstore);
            solFolder = cefldrhandler.getFolder(solutionName, "solution");
            Document configDoc = this.getDocument(solFolder, "PE Configuration", "solution");
            Document sdfDoc = this.getDocument(solFolder, "Solution Definition", "solution");
            sdfVsid = sdfDoc.get_VersionSeries().get_Id();
            configVsid = configDoc.get_VersionSeries().get_Id();
            docs = new ArrayList(6);
            docs.add((IndependentlyPersistableObject)docHandler.closeDocument(sdfVsid));
            docs.add(docHandler.closeDocument(configVsid));
            if (docHandler.checkDocExists(solFolder, "Solution Workflow Collection")) {
                Document globalXpdlDoc = this.getDocument(solFolder, "Solution Workflow Collection", "solution");
                Id globalXpdlVsid = globalXpdlDoc.get_VersionSeries().get_Id();
                docs.add(docHandler.closeDocument(globalXpdlVsid));
            }
            if (this.solData != null && this.solData.getSdfData() != null && this.solData.getSdfData().getSolutionType() != null && this.solData.getSdfData().getSolutionType().getCaseTypes() != null) {
                caseTypes = this.solData.getSdfData().getSolutionType().getCaseTypes().getCaseType();
                for (CaseTypeType caseType : caseTypes) {
                    CaseTypeData caseTypeData = this.solData.getCasetypedata(caseType.getName());
                    if (caseType.getProcessDefinition() == null) continue;
                    Id id = new Id(caseType.getProcessDefinition().getContentId());
                    docs.add(docHandler.closeDocument(id));
                }
            }
            this.updateDocumentsInBatch(docs, RefreshMode.REFRESH, this.pf);
            Document configDoc_new = this.getDocument(solFolder, "PE Configuration", "solution");
            Document sdfDoc_new = this.getDocument(solFolder, "Solution Definition", "solution");
            String pecfgId = ((Document)configDoc_new.get_CurrentVersion()).get_Id().toString();
            String sdfId = ((Document)sdfDoc_new.get_CurrentVersion()).get_Id().toString();
            String sdf_lastModified = DateTime.listDate((Date)sdfDoc_new.get_DateLastModified());
            String lockedBy = null;
            if (configDoc_new.get_IsReserved().booleanValue()) {
                Document resvObj = (Document)configDoc_new.get_Reservation();
                lockedBy = resvObj.get_Creator();
            }
            response = lockedBy != null ? "{\"sdfId\":\"" + sdfId + "\",\"pecfgId\":\"" + pecfgId + "\",\"lastModifiedOn\":\"" + sdf_lastModified + "\",\"lockedBy\":\"" + lockedBy + "\"}" : "{\"sdfId\":\"" + sdfId + "\",\"pecfgId\":\"" + pecfgId + "\",\"lastModifiedOn\":\"" + sdf_lastModified + "\"}";
            return response;
        }
        catch (EngineRuntimeException e) {
            e.printStackTrace();
        }
        catch (AcmException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return response;
    }

    @Override
    public void closeSession() {
        if (this.origUC != null) {
            UserContext.set((UserContext)this.origUC);
        }
    }

    public ObjectStore getObjectSore() throws AcmException {
        ObjectStore dos = null;
        try {
            Connection p8connection = Factory.Connection.getConnection((String)this.configuration.getCeUri());
            Domain domain = Factory.Domain.getInstance((Connection)p8connection, null);
            domain.fetchProperty("ObjectStores", null);
            dos = Factory.ObjectStore.fetchInstance((Domain)domain, (String)this.configuration.getObjStore(), null);
        }
        catch (Exception e) {
            e.printStackTrace();
            Message msg = new Message("B0006E.DOMAIN_FAILURE");
            throw new AcmConnectionFailure(msg, (Throwable)e);
        }
        return dos;
    }

    public void updateDocumentsInBatch(List<IndependentlyPersistableObject> docs, RefreshMode refMode, PropertyFilter pf) {
        UpdatingBatch ub = UpdatingBatch.createUpdatingBatchInstance((Domain)this.objectstore.get_Domain(), (RefreshMode)refMode);
        for (IndependentlyPersistableObject document : docs) {
            ub.add(document, pf);
        }
        ub.updateBatch();
    }

    public Document createGlobalXpdl(Folder solFolder, CEDocumentHandler docHandler, SolutionType solutionType) throws AcmException {
        Document doc = docHandler.createDocument(CEDocumentHandler.EnumDocumentType.GLOBAL_XPDL);
        doc.save(RefreshMode.REFRESH, this.pf);
        docHandler.fileToFolder(solFolder, doc, this.pf);
        ContentType ct = new ContentType();
        Id global_xpdl_vsid = doc.get_VersionSeries().get_Id();
        ct.setContentId(global_xpdl_vsid.toString());
        solutionType.setGlobalProcessCollection(ct);
        CaseTypeData ctd = new CaseTypeData();
        ctd.setSymName(global_xpdl_vsid.toString());
        this.solData.setCasetypedata(global_xpdl_vsid.toString(), ctd);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            ctd.toXPDLStream((OutputStream)out, solutionType.getName());
        }
        catch (Exception e) {
            e.printStackTrace();
            Message msg = new Message("B4016E.SAVE_FAILED", new Object[]{e.getLocalizedMessage()});
            throw new AcmException(msg);
        }
        ByteArrayInputStream content = new ByteArrayInputStream(out.toByteArray());
        return docHandler.saveDocument(global_xpdl_vsid, (InputStream)content, CEDocumentHandler.EnumDocumentType.GLOBAL_XPDL);
    }

    public Document getDocument(Folder folder, String fileName, String type) throws AcmFileNotFoundException {
        String folderName = folder.get_Name();
        String fileString = null;
        Document doc = null;
        int Type2 = type.compareToIgnoreCase("solution");
        fileString = Type2 == 0 ? "/" + this.configuration.getRootFolder() + "/" + this.configuration.getSolutionFolder() + "/" + folderName + "/" + fileName : "/" + this.configuration.getRootFolder() + "/" + this.configuration.getTemplateFolder() + "/" + folderName + "/" + fileName;
        try {
            doc = Factory.Document.fetchInstance((ObjectStore)this.objectstore, (String)fileString, null);
            return doc;
        }
        catch (EngineRuntimeException e) {
            Message msg = new Message("B4042E.FILE_NOT_FOUND", new Object[]{fileName});
            throw new AcmFileNotFoundException(msg);
        }
    }
}

