/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.acm.transition.common;

import com.ibm.acm.sold.connector.IConnector;
import com.ibm.acm.transition.common.Constants;
import com.ibm.acm.transition.converter.FileInput;
import com.ibm.acm.transition.exception.TransitionException;
import com.ibm.acm.transition.messages.Message;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class Utility
implements IConnector {
    private static final Logger log = Logger.getLogger((String)Utility.class.getName());

    public static String addSdf(String sxml) {
        log.trace((Object)">>addSdf");
        Pattern p = Pattern.compile("<");
        Matcher m = p.matcher(sxml);
        sxml = m.replaceAll("<sdf:");
        Pattern p1 = Pattern.compile("<sdf:/");
        Matcher m1 = p1.matcher(sxml);
        sxml = m1.replaceAll("</sdf:");
        log.debug((Object)("xml structure with sdf:" + sxml));
        log.trace((Object)"<<addSdf");
        return sxml;
    }

    public static String addHeadFoot(String sxml) {
        log.trace((Object)"<<addHeadFoot");
        sxml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><sdf:solution xsi:schemaLocation=\"http://w3.ibm.com/xmlns/stdwip/ecm/sdf SDF-Schema.xsd\" xmlns:cmis=\"http://docs.oasis-open.org/ns/cmis/core/200908/\" xmlns:sdf=\"http://w3.ibm.com/xmlns/stdwip/ecm/sdf\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">" + sxml + "</sdf:solution>";
        log.debug((Object)("Complete XML structure:" + sxml));
        log.trace((Object)"<<addHeadFoot");
        return sxml;
    }

    public static String removeHeadFoot(String sxml) {
        log.trace((Object)">>removeHeadFoot");
        StringBuilder sbxml = new StringBuilder(sxml);
        int ilenHeader = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><sdf:solution xsi:schemaLocation=\"http://w3.ibm.com/xmlns/stdwip/ecm/sdf SDF-Schema.xsd\" xmlns:cmis=\"http://docs.oasis-open.org/ns/cmis/core/200908/\" xmlns:sdf=\"http://w3.ibm.com/xmlns/stdwip/ecm/sdf\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">".length();
        sbxml.delete(0, ilenHeader);
        int ilenFooter = "</sdf:solution>".length();
        int ilenXML = sbxml.length();
        sbxml.delete(ilenXML - ilenFooter, ilenXML);
        log.trace((Object)"<<removeHeadFoot");
        return sbxml.toString();
    }

    public static String removeSdf(String sxml) {
        log.trace((Object)">>removeSdf");
        Pattern p = Pattern.compile("sdf:");
        Matcher m = p.matcher(sxml);
        sxml = m.replaceAll("");
        log.debug((Object)("Json Structure:" + sxml));
        log.trace((Object)"<<removeSdf");
        return sxml;
    }

    public static String getSolutionName(String sxmlStr) {
        log.trace((Object)">>getSolutionName");
        log.debug((Object)"Getting Solution Name");
        int inameindex = sxmlStr.indexOf(Constants.solution[0]);
        int ilength = Constants.solution[0].length() + inameindex + 1;
        int isolnameend = sxmlStr.indexOf("<", ilength);
        String sname = sxmlStr.substring(ilength, isolnameend);
        log.debug((Object)("Solution Name:" + sname));
        log.trace((Object)"<<getSolutionName");
        return sname;
    }

    public static String getSolutionDescription(String sxmlStr) {
        log.trace((Object)">>getSolutionDescription");
        int inameindex = sxmlStr.indexOf(Constants.solution[1]);
        int ilength = Constants.solution[1].length() + inameindex + 1;
        int isolDescend = sxmlStr.indexOf("<", ilength);
        String sDesc = sxmlStr.substring(ilength, isolDescend);
        log.debug((Object)("Solution Description:" + sDesc));
        log.trace((Object)"<<getSolutionName");
        return sDesc;
    }

    public static InputStream getResourceAsStream(String fname) throws TransitionException {
        FileInputStream fis = null;
        File file = new File(fname);
        if (file.exists()) {
            try {
                log.debug((Object)" file found");
                fis = new FileInputStream(fname);
            }
            catch (FileNotFoundException e) {
                Message message = new Message("B4042E.FILE_NOT_FOUND");
            }
        } else {
            log.warn((Object)" file not found");
        }
        return fis;
    }

    public static String getResourceAsString(String fname) throws TransitionException {
        String str = new String();
        FileInput file = new FileInput(fname);
        str = file.read();
        Utility.deleteTempFile(fname);
        return str;
    }

    public static InputStream stringToStream(String str) throws TransitionException {
        if (str == null) {
            Message msg = new Message("B4001E.INVALID_ARGUMENTS_TO_METHOD");
            log.error((Object)"B4001E.INVALID_ARGUMENTS_TO_METHOD");
        }
        byte[] bytes = null;
        try {
            bytes = str.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            Message message = new Message("B4031E.CONVERSION_EXCEPTION");
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        return bais;
    }

    public static String readAsUTF8(String src) throws TransitionException {
        if (src == null) {
            return null;
        }
        String utf8Str = null;
        try {
            byte[] buf = src.getBytes("UTF8");
            utf8Str = new String(buf, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            Message message = new Message("B4031E.CONVERSION_EXCEPTION");
        }
        return utf8Str;
    }

    public static void deleteTempFile(String fileName) {
        if (fileName == null || fileName.equals("")) {
            return;
        }
        log.info((Object)("File to be deleted : " + fileName));
        File file = new File(fileName);
        if (file.exists()) {
            log.info((Object)"File exists");
            file.delete();
        }
    }

    public static String readStream(InputStream input, int length) throws TransitionException {
        Message message;
        int totalBytesread = 0;
        byte[] buf = new byte[length];
        StringBuffer result = new StringBuffer(length);
        int bytesRead = 0;
        try {
            bytesRead = input.read(buf, 0, length);
        }
        catch (IOException e1) {
            log.error((Object)" error ::", (Throwable)e1);
            message = new Message("B4026E.CONTENT_RETRIEVAL_FAILED" + e1.getLocalizedMessage());
        }
        log.info((Object)"Data read from the payload : ");
        log.info((Object)"-------------------------------------");
        log.info((Object)("Content Length : " + length));
        while (bytesRead > 0) {
            try {
                result.append(new String(buf, 0, bytesRead, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                message = new Message("B4031E.CONVERSION_EXCEPTION");
            }
            totalBytesread += bytesRead;
            log.info((Object)("Count of Partially read data :" + bytesRead));
            try {
                bytesRead = input.read(buf, 0, length);
            }
            catch (IOException e) {
                log.error((Object)" error ::", (Throwable)e);
                message = new Message("B4026E.CONTENT_RETRIEVAL_FAILED" + e.getLocalizedMessage());
            }
        }
        log.info((Object)("Total bytes read :" + totalBytesread));
        log.info((Object)"-------------------------------------");
        return result.toString();
    }
}

