/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.acm.transition.common;

import com.ibm.acm.transition.common.Config;
import com.ibm.acm.transition.jaxb.ConfigJAXBSingleton;
import com.ibm.acm.transition.jaxb.config.Configuration;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.List;
import javax.xml.bind.JAXBException;

public class ConfigurationManager {
    private static ConfigurationManager cm;
    private Config config = new Config();

    private ConfigurationManager() {
    }

    public Config getConfig() {
        return this.config;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public static ConfigurationManager getInstance() {
        if (cm == null) {
            cm = new ConfigurationManager();
            cm.loadConfig();
        }
        return cm;
    }

    private void loadConfig() {
        ConfigJAXBSingleton cjs = ConfigJAXBSingleton.getSingleton();
        try {
            Configuration jaxbObjConfig = cjs.readConfiguration(Configuration.class, new FileInputStream("../config/configuration.xml"));
            List<Configuration.Param> params = jaxbObjConfig.getParam();
            for (Configuration.Param tempParam : params) {
                String paramName = tempParam.getName();
                String paramValue = tempParam.getValue();
                if (paramName.equals("SchemaVersion")) {
                    this.config.setSchemaVersion(paramValue);
                    continue;
                }
                if (paramName.equals("VendorName")) {
                    this.config.setVendorName(paramValue);
                    continue;
                }
                if (paramName.equals("ProductName")) {
                    this.config.setProductName(paramValue);
                    continue;
                }
                if (paramName.equals("ProductVersion")) {
                    this.config.setProductVersion(paramValue);
                    continue;
                }
                if (paramName.equals("ConverterClassName")) {
                    this.config.setConverterClassName(paramValue);
                    continue;
                }
                if (paramName.equals("CEConnctorClassName")) {
                    this.config.setCeDataConnectorClassName(paramValue);
                    continue;
                }
                if (paramName.equals("IconUri")) {
                    this.config.setIconUri(paramValue);
                    continue;
                }
                if (paramName.equals("BPFXMLPath")) {
                    this.config.setBpfXMLPath(paramValue);
                    continue;
                }
                if (paramName.equals("CEXMLPath")) {
                    this.config.setCeXMLPath(paramValue);
                    continue;
                }
                if (paramName.equals("OutputPath")) {
                    this.config.setOutputPath(paramValue);
                    continue;
                }
                if (paramName.equals("CEURL")) {
                    this.config.setCeUri(paramValue);
                    continue;
                }
                if (paramName.equals("ObjectStore")) {
                    this.config.setObjStore(paramValue);
                    continue;
                }
                if (paramName.equals("TemplateFolder")) {
                    this.config.setTemplateFolder(paramValue);
                    continue;
                }
                if (paramName.equals("SolutionFolder")) {
                    this.config.setSolutionFolder(paramValue);
                    continue;
                }
                if (paramName.equals("RootFolder")) {
                    this.config.setRootFolder(paramValue);
                    continue;
                }
                if (paramName.equals("JaasAuth")) {
                    this.config.setJaasAuthentication(Boolean.parseBoolean(paramValue));
                    continue;
                }
                if (paramName.equals("UserName")) {
                    this.config.setUserName(paramValue);
                    continue;
                }
                if (!paramName.equals("Password")) continue;
                this.config.setPassword(paramValue);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
    }
}

