/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.acm.transition;

import com.ibm.acm.sold.exception.AcmConnectionFailure;
import com.ibm.acm.sold.exception.AcmException;
import com.ibm.acm.transition.common.Config;
import com.ibm.acm.transition.common.ConfigurationManager;
import com.ibm.acm.transition.converter.CEDataConnector;
import com.ibm.acm.transition.converter.Converter;
import com.ibm.acm.transition.converter.PEConfig;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.List;

public class TransitionManager {
    private static volatile TransitionManager transitionManager = null;
    private Config configuration = null;
    private String solutionName;
    private String solutionDescription;
    private String solutionPrifix;
    private String bpfCaseName;
    private String integrationType;
    private String iconType;
    private String icon;
    private String schemaVersion;
    private String vendorName;
    private String productName;
    private String productVersion;
    private Converter converter;
    private CEDataConnector ceDataConnector;
    private PEConfig peConfig;

    public static TransitionManager getInstance() {
        if (transitionManager == null) {
            transitionManager = new TransitionManager();
        }
        return transitionManager;
    }

    private TransitionManager() {
        this.init();
    }

    public String getSolutionName() {
        return this.solutionName;
    }

    public void setSolutionName(String solutionName) {
        this.solutionName = solutionName;
        this.converter.setSolutionName(solutionName);
    }

    public String getSolutionDescription() {
        return this.solutionDescription;
    }

    public void setSolutionDescription(String solutionDescription) {
        this.solutionDescription = solutionDescription;
    }

    public String getSolutionPrifix() {
        return this.solutionPrifix;
    }

    public void setSolutionPrifix(String solutionPrifix) {
        this.solutionPrifix = solutionPrifix;
        this.converter.setPrefix(solutionPrifix);
    }

    public String getIntegrationType() {
        return this.integrationType;
    }

    public void setIntegrationType(String integrationType) {
        this.integrationType = integrationType;
    }

    public String getIconType() {
        return this.iconType;
    }

    public void setIconType(String iconType) {
        this.iconType = iconType;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public String getSchemaVersion() {
        return this.schemaVersion;
    }

    public void setSchemaVersion(String schemaVersion) {
        this.schemaVersion = schemaVersion;
    }

    public String getVendorName() {
        return this.vendorName;
    }

    public void setVendorName(String vendorName) {
        this.vendorName = vendorName;
    }

    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public void setProductVersion(String productVersion) {
        this.productVersion = productVersion;
    }

    public Converter getConverter() {
        return this.converter;
    }

    public void setConverter(Converter converter) {
        this.converter = converter;
    }

    private void init() {
        ConfigurationManager cm = ConfigurationManager.getInstance();
        this.configuration = cm.getConfig();
        this.configuration.setBpfCaseName("Case Management");
        try {
            Class<?> ceDataConnectorcls = Class.forName(this.configuration.getCeDataConnectorClassName());
            this.ceDataConnector = (CEDataConnector)ceDataConnectorcls.newInstance();
            this.ceDataConnector.setConfiguration(this.configuration);
            this.ceDataConnector.loadCEData();
            Class<?> cls = Class.forName(this.configuration.getConverterClassName());
            this.converter = (Converter)cls.newInstance();
            if (this.converter != null) {
                this.converter.setConfiguration(this.configuration);
                this.converter.setCEData(this.ceDataConnector.getCEData());
                this.converter.setBpfXMLPath(this.configuration.getBpfXMLPath());
                this.peConfig = new PEConfig(this.converter.getSolutionData(), this.converter);
                this.peConfig.setConfiguration(this.configuration);
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public void loadBPFMetadata() {
        this.converter.loadBPFMetadata();
    }

    public List<String> getSolutionNameList() {
        List<String> result = null;
        result = this.converter.getSolutionList();
        return result;
    }

    public void convert() {
        this.performConvert(this.configuration);
    }

    private void performConvert(Config conf) {
        this.converter.convert();
        this.converter.output();
        try {
            this.peConfig.generateConfig(this.converter.getSolutionData());
        }
        catch (AcmException e) {
            e.printStackTrace();
        }
    }

    public void save() {
        this.ceDataConnector.openSession();
        try {
            InputStream configContent = this.peConfig.generateConfig(this.converter.getSolutionData());
            this.ceDataConnector.setSolutionData(this.peConfig.getSolutionData());
            this.ceDataConnector.save(this.peConfig, configContent);
        }
        catch (AcmConnectionFailure e) {
            e.printStackTrace();
        }
        catch (AcmException e) {
            e.printStackTrace();
        }
        this.ceDataConnector.closeSession();
    }

    public static void main(String[] args) {
        try {
            String s;
            TransitionManager tm = TransitionManager.getInstance();
            tm.loadBPFMetadata();
            List<String> solutionList = tm.getSolutionNameList();
            int solutionIndex = 1;
            HashMap<Integer, String> solutionMap = new HashMap<Integer, String>();
            System.out.println("Please select the number before solution name to convert:");
            for (String tempSolutionName : solutionList) {
                solutionMap.put(solutionIndex, tempSolutionName);
                System.out.println(String.valueOf(solutionIndex++) + ": " + tempSolutionName);
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            int i = 0;
            boolean isFirst = true;
            String solutionName = (String)solutionMap.get(i);
            while (solutionName == null) {
                if (!isFirst) {
                    System.out.println("Please select correct solution name number!");
                }
                s = in.readLine();
                i = Integer.parseInt(s);
                solutionName = (String)solutionMap.get(i);
                isFirst = false;
            }
            tm.setSolutionName(solutionName);
            System.out.println("Please input prefix for this solution:");
            s = in.readLine();
            tm.setSolutionPrifix(s);
            tm.convert();
            tm.save();
            System.out.println("Convertion completed!");
        }
        catch (Exception e) {
            System.out.println("Error in converting, please check your configuration.");
            e.printStackTrace();
        }
    }
}

