/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.wsi.serialization.reference;

import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.api.util.Id;
import com.filenet.apiimpl.core.GlobalIdentity;
import com.filenet.apiimpl.core.ObjectByName;
import com.filenet.apiimpl.core.ObjectByPath;
import com.filenet.apiimpl.core.ObjectReferenceBase;
import com.filenet.apiimpl.core.RepositoryIdentity;
import com.filenet.apiimpl.property.UnevaluatedPropertyValue;
import com.filenet.apiimpl.wsi.serialization.Context;
import com.filenet.apiimpl.wsi.serialization.DeserializerContext;
import com.filenet.apiimpl.wsi.serialization.Serialization;
import com.filenet.apiimpl.wsi.serialization.Util;
import com.filenet.apiimpl.wsi.serialization.reference.ReferenceValues;

public class ObjectReferenceSerialization
extends Serialization {
    public static final ObjectReferenceSerialization INSTANCE = new ObjectReferenceSerialization();

    public Object deserialize(Object object, DeserializerContext context) throws Exception {
        ObjectReferenceBase reference;
        String classId = Util.emptyAsNull(context.getAttribute("classId"));
        String objectId = Util.emptyAsNull(context.getAttribute("objectId"));
        String objectStore = Util.emptyAsNull(context.getAttribute("objectStore"));
        String path = Util.emptyAsNull(context.getAttribute("path"));
        String propertyId = Util.emptyAsNull(context.getAttribute("propertyId"));
        Integer itemIndex = Util.minusOneAsNull(Util.parseInteger(context.getAttribute("itemIndex")));
        String batchRef = context.getAttribute("batchRef");
        context.nextEndToken();
        GlobalIdentity store = null;
        if (objectStore != null) {
            store = new GlobalIdentity("ObjectStore", objectStore);
        }
        if (path != null) {
            reference = new ObjectByPath(classId, store, path);
        } else if (batchRef != null) {
            reference = context.getReference(batchRef);
            if (reference == null) {
                throw new EngineRuntimeException(ExceptionCode.E_INVALID_REQUEST);
            }
        } else {
            reference = objectStore == null ? new GlobalIdentity(classId, objectId) : (objectId != null ? (Id.isId(objectId) ? new RepositoryIdentity(classId, store, new Id(objectId)) : (ObjectReferenceSerialization.isPath(objectId) ? new ObjectByPath(classId, store, objectId) : new ObjectByName(classId, store, objectId))) : (ObjectReferenceSerialization.isObjectStore(classId) ? store : new RepositoryIdentity(classId, store, null)));
        }
        if (propertyId != null) {
            reference = new UnevaluatedPropertyValue(reference, propertyId, itemIndex);
        }
        return reference;
    }

    public String getTypeName(ObjectReferenceBase reference, Context context) {
        throw new UnsupportedOperationException();
    }

    public String getClassId(ObjectReferenceBase reference, Context context) {
        return reference.getClassIdentity();
    }

    public String getObjectId(ObjectReferenceBase reference, Context context) {
        return reference.getObjectIdentity();
    }

    public String getObjectStore(ObjectReferenceBase reference, Context context) {
        return reference.getObjectStoreIdentity();
    }

    public String getPath(ObjectReferenceBase reference, Context context) {
        return null;
    }

    public String getPropertyId(ObjectReferenceBase reference, Context context) {
        return null;
    }

    public Integer getItemIndex(ObjectReferenceBase reference, Context context) {
        return null;
    }

    public ReferenceValues getValues(ObjectReferenceBase reference, Context context) {
        ReferenceValues values = new ReferenceValues();
        values.classId = this.getClassId(reference, context);
        values.objectId = this.getObjectId(reference, context);
        values.objectStore = this.getObjectStore(reference, context);
        values.path = this.getPath(reference, context);
        values.propertyId = this.getPropertyId(reference, context);
        values.itemIndex = this.getItemIndex(reference, context);
        return values;
    }

    public ObjectReferenceBase getParent(ObjectReferenceBase reference) {
        return null;
    }

    public static ObjectReferenceSerialization getHandler(ObjectReferenceBase reference, Context context) {
        return (ObjectReferenceSerialization)context.getHandler(reference.getClass());
    }

    public static boolean isObjectStore(String classIdentity) {
        return ObjectReferenceBase.isObjectStoreClassIdentity(classIdentity);
    }

    public static boolean isPath(String objectIdentity) {
        return ObjectReferenceBase.isPathIdentity(objectIdentity);
    }
}

