/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.wsi.serialization.property;

import com.filenet.apiimpl.property.PropertyStringImpl;
import com.filenet.apiimpl.util.XMLHelper;
import com.filenet.apiimpl.wsi.serialization.DeserializerContext;
import com.filenet.apiimpl.wsi.serialization.SerializerContext;
import com.filenet.apiimpl.wsi.serialization.property.PropertyDeserializerCall;
import com.filenet.apiimpl.wsi.serialization.property.PropertySerialization;
import com.filenet.apiimpl.wsi.serialization.property.PropertySerializerCall;

public class StringSerialization
extends PropertySerialization {
    public static final StringSerialization INSTANCE = new StringSerialization();

    public void serialize(Object object, SerializerContext context) throws Exception {
        PropertySerializerCall call = this.enter("SingletonString", object, context);
        String value = call.property.getStringValue();
        if (!XMLHelper.isValidText(value)) {
            value = XMLHelper.encodeText(value);
            if (context.isClientProcessing() || context.getVersion() > 350) {
                context.writeAttribute("encoding", "H9");
            }
        }
        context.writeOptionalElement("Value", context.getOptionalXsdType("string"), value);
        context.leaveElement();
    }

    public Object deserialize(Object object, DeserializerContext context) throws Exception {
        String encoding = context.getAttribute("encoding");
        PropertyDeserializerCall call = this.enter(object, context);
        String value = this.getValueText(context);
        if (encoding != null && encoding.equals("H9")) {
            value = XMLHelper.decodeText(value);
        }
        PropertyStringImpl property = new PropertyStringImpl(call.propertyId, value, call.propertyAccess);
        return this.leave(property, call, context);
    }
}

