/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.wsi.serialization.property;

import com.filenet.apiimpl.collection.StringListImpl;
import com.filenet.apiimpl.property.PropertyStringListImpl;
import com.filenet.apiimpl.util.XMLHelper;
import com.filenet.apiimpl.wsi.serialization.DeserializerContext;
import com.filenet.apiimpl.wsi.serialization.SerializerContext;
import com.filenet.apiimpl.wsi.serialization.property.PropertyDeserializerCall;
import com.filenet.apiimpl.wsi.serialization.property.PropertySerialization;
import com.filenet.apiimpl.wsi.serialization.property.PropertySerializerCall;
import java.util.List;

public class StringListSerialization
extends PropertySerialization {
    public static final StringListSerialization INSTANCE = new StringListSerialization();

    public void serialize(Object object, SerializerContext context) throws Exception {
        List list;
        PropertySerializerCall call = this.enter("ListOfString", object, context);
        Object value = call.property.getObjectValue();
        List list2 = list = value instanceof List ? (List)value : null;
        if (list != null && list.size() > 0) {
            String[] values = list.toArray(new String[list.size()]);
            if (!XMLHelper.isValidText(values)) {
                XMLHelper.encodeText(values);
                if (context.isClientProcessing() || context.getVersion() > 350) {
                    context.writeAttribute("encoding", "H9");
                }
            }
            context.writeElementArray("Value", context.getOptionalXsdType("string"), values);
        }
        context.leaveElement();
    }

    public Object deserialize(Object object, DeserializerContext context) throws Exception {
        String encoding = context.getAttribute("encoding");
        PropertyDeserializerCall call = this.enter(object, context);
        List values = context.readElementList("Value");
        if (encoding != null && encoding.equals("H9")) {
            int size = values.size();
            for (int i = 0; i < size; ++i) {
                values.set(i, XMLHelper.decodeText((String)values.get(i)));
            }
        }
        PropertyStringListImpl property = new PropertyStringListImpl(call.propertyId, new StringListImpl(values), call.propertyAccess);
        return this.leave(property, call, context);
    }
}

