/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.wsi.serialization.property;

import com.filenet.api.constants.PropertyState;
import com.filenet.api.core.ObjectReference;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.apiimpl.core.ObjectReferenceBase;
import com.filenet.apiimpl.core.SubSetImpl;
import com.filenet.apiimpl.property.PropertyEngineObjectSetImpl;
import com.filenet.apiimpl.property.UnevaluatedPropertyValue;
import com.filenet.apiimpl.wsi.serialization.DeserializerContext;
import com.filenet.apiimpl.wsi.serialization.SerializerContext;
import com.filenet.apiimpl.wsi.serialization.Util;
import com.filenet.apiimpl.wsi.serialization.core.CollectionTerminatorSerialization;
import com.filenet.apiimpl.wsi.serialization.core.EngineObjectSerialization;
import com.filenet.apiimpl.wsi.serialization.property.PropertyDeserializerCall;
import com.filenet.apiimpl.wsi.serialization.property.PropertySerialization;
import com.filenet.apiimpl.wsi.serialization.property.PropertySerializerCall;
import com.filenet.apiimpl.wsi.serialization.property.UnevaluatedCollectionSerialization;
import com.filenet.apiimpl.wsi.serialization.reference.ObjectReferenceSerialization;
import java.util.List;

public class ObjectSetSerialization
extends PropertySerialization {
    public static final ObjectSetSerialization INSTANCE = new ObjectSetSerialization();

    public void serialize(Object object, SerializerContext context) throws Exception {
        PropertySerializerCall call = (PropertySerializerCall)object;
        if (call.property.getState().equals(PropertyState.UNEVALUATED)) {
            UnevaluatedCollectionSerialization.INSTANCE.serialize("EnumOfObject", "Enum", call, context);
            return;
        }
        this.enter("EnumOfObject", object, context);
        SubSetImpl set = (SubSetImpl)call.property.getInstanceValue();
        String continuation = Util.nullAsEmpty(Util.continuation(set));
        context.serializeObjectArray("Value", EngineObjectSerialization.INSTANCE, Util.objects(set));
        if (set.getTraversalError() == null) {
            context.serializeObject("CollectionTerminator", CollectionTerminatorSerialization.INSTANCE, (Object)continuation);
        } else {
            context.serializeObject("CollectionTerminator", CollectionTerminatorSerialization.INSTANCE, (Object)set.getTraversalError());
        }
        if (context.getVersion() >= 400 && call.parent == null) {
            ObjectReference parent = Util.parent(set);
            context.serializeObject("ParentReference", Util.objectClass(parent), (Object)parent);
        }
        context.leaveElement();
    }

    public Object deserialize(Object object, DeserializerContext context) throws Exception {
        PropertyDeserializerCall call = this.enter(object, context);
        if (context.isEndToken() && context.getVersion() < 400) {
            UnevaluatedPropertyValue unevaluated = new UnevaluatedPropertyValue(Util.reference(call.parent), call.propertyId);
            PropertyEngineObjectSetImpl property = new PropertyEngineObjectSetImpl(unevaluated, context.getConnection(), call.propertyAccess);
            return this.leave(property, call, context);
        }
        List list = context.deserializeObjectList("Value", EngineObjectSerialization.INSTANCE, call);
        Object collectionTerm = context.deserializeObject("CollectionTerminator", CollectionTerminatorSerialization.INSTANCE, null);
        String continuation = null;
        EngineRuntimeException traversalError = null;
        if (collectionTerm instanceof String) {
            continuation = (String)collectionTerm;
        } else if (collectionTerm instanceof EngineRuntimeException) {
            traversalError = (EngineRuntimeException)collectionTerm;
        }
        ObjectReferenceBase parent = (ObjectReferenceBase)context.deserializeObject("ParentReference", ObjectReferenceSerialization.INSTANCE, null);
        SubSetImpl set = Util.createIndependentObjectSet(context.getConnection(), list, continuation, parent == null ? Util.reference(call.parent) : parent, call.propertyId, call.filter, call.maxElements);
        set.setTraversalError(traversalError);
        PropertyEngineObjectSetImpl property = new PropertyEngineObjectSetImpl(call.propertyId, set, call.propertyAccess);
        return this.leave(property, call, context);
    }
}

