/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.wsi.serialization.property;

import com.filenet.api.constants.PropertyState;
import com.filenet.api.core.EngineObject;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.apiimpl.constants.ListMode;
import com.filenet.apiimpl.core.ContentTransferImpl;
import com.filenet.apiimpl.core.DependentIdentity;
import com.filenet.apiimpl.core.EngineObjectImpl;
import com.filenet.apiimpl.core.ListImpl;
import com.filenet.apiimpl.core.ListUpdate;
import com.filenet.apiimpl.core.ObjectFactory;
import com.filenet.apiimpl.core.ObjectReferenceBase;
import com.filenet.apiimpl.core.SubListImpl;
import com.filenet.apiimpl.property.PropertyEngineObjectListImpl;
import com.filenet.apiimpl.property.PropertyImpl;
import com.filenet.apiimpl.property.PropertyUpdateList;
import com.filenet.apiimpl.wsi.serialization.DeserializerContext;
import com.filenet.apiimpl.wsi.serialization.Serialization;
import com.filenet.apiimpl.wsi.serialization.SerializerContext;
import com.filenet.apiimpl.wsi.serialization.Util;
import com.filenet.apiimpl.wsi.serialization.core.EngineObjectSerialization;
import com.filenet.apiimpl.wsi.serialization.property.PropertiesSerialization;
import com.filenet.apiimpl.wsi.serialization.property.PropertyDeserializerCall;
import com.filenet.apiimpl.wsi.serialization.property.PropertySerialization;
import com.filenet.apiimpl.wsi.serialization.property.PropertySerializerCall;
import com.filenet.apiimpl.wsi.serialization.property.UnevaluatedCollectionSerialization;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ObjectListSerialization
extends PropertySerialization {
    private static HashMap MAP_LIST_MODE = new HashMap();
    private static HashMap MAP_DEPENDENT_ACTION = new HashMap();
    private static Integer defaultDependentAction = new Integer(3);
    public static final ObjectListSerialization INSTANCE;
    public static final Serialization DEPENDENT_UPDATE;

    public void serialize(Object object, SerializerContext context) throws Exception {
        PropertySerializerCall call = (PropertySerializerCall)object;
        PropertyImpl property = call.property;
        if (property.getState().equals(PropertyState.UNEVALUATED)) {
            UnevaluatedCollectionSerialization.INSTANCE.serialize("ListOfObject", "List", call, context);
            return;
        }
        this.enter("ListOfObject", object, context);
        if (property instanceof PropertyUpdateList) {
            List pul = ((PropertyUpdateList)property).getUpdateListValue();
            ListMode lm = ((ListImpl.ListUpdates)pul).getListMode();
            if (lm == ListMode.REPLACE) {
                context.writeAttribute("listMode", "Replace");
            }
            context.serializeObjectArray("Value", DEPENDENT_UPDATE, Util.objects(pul));
        } else {
            context.serializeObjectArray("Value", EngineObjectSerialization.INSTANCE, Util.objects((List)property.getInstanceValue()));
        }
        context.leaveElement();
    }

    public Object deserialize(Object object, DeserializerContext context) throws Exception {
        PropertyImpl property;
        ListMode lm = (ListMode)context.deserializeEnumAttribute("listMode", false, MAP_LIST_MODE, ListMode.UPDATE);
        PropertyDeserializerCall call = this.enter(object, context);
        if (context.isServerProcessing()) {
            ArrayList<Object> list = new ArrayList<Object>();
            while (context.isStartToken()) {
                Object value = context.deserializeObject(DEPENDENT_UPDATE, (Object)call);
                list.add(value);
            }
            property = new PropertyUpdateList(call.propertyId, new ListImpl.ListUpdates(list, lm));
        } else {
            ArrayList<Object> list = new ArrayList<Object>();
            while (context.isStartToken()) {
                call.propertyIndex = new Integer(list.size());
                Object value = context.deserializeObject(EngineObjectSerialization.INSTANCE, (Object)call);
                list.add(value);
            }
            call.propertyIndex = null;
            property = new PropertyEngineObjectListImpl(call.propertyId, new SubListImpl(EngineObject.class, list), call.propertyAccess);
        }
        return this.leave(property, call, context);
    }

    private static int toListUpdateAction(DeserializerContext context) throws Exception {
        Object da = context.deserializeEnumAttribute("dependentAction", false, MAP_DEPENDENT_ACTION, defaultDependentAction);
        return (Integer)da;
    }

    static {
        MAP_LIST_MODE.put("Update", ListMode.UPDATE);
        MAP_LIST_MODE.put("Replace", ListMode.REPLACE);
        MAP_DEPENDENT_ACTION.put("Update", new Integer(3));
        MAP_DEPENDENT_ACTION.put("Move", new Integer(1));
        MAP_DEPENDENT_ACTION.put("Insert", new Integer(0));
        MAP_DEPENDENT_ACTION.put("Delete", new Integer(2));
        INSTANCE = new ObjectListSerialization();
        DEPENDENT_UPDATE = new Serialization(){

            public void serialize(Object object, SerializerContext context) throws Exception {
                ListUpdate lu = (ListUpdate)object;
                boolean doProps = true;
                EngineObjectImpl eo = lu.getObject();
                DependentIdentity di = (DependentIdentity)eo.getObjectReference();
                context.writeAttribute("classId", di.getClassIdentity());
                context.writeAttribute("originalIndex", Util.toIntString(lu.getOrigIndex()));
                context.writeAttribute("newIndex", Util.toIntString(lu.getNewIndex()));
                switch (lu.getAction()) {
                    case 2: {
                        doProps = false;
                        context.writeAttribute("dependentAction", "Delete");
                        break;
                    }
                    case 3: {
                        context.writeAttribute("dependentAction", "Update");
                        break;
                    }
                    case 1: {
                        context.writeAttribute("dependentAction", "Move");
                        break;
                    }
                    case 0: {
                        context.writeAttribute("dependentAction", "Insert");
                        break;
                    }
                    default: {
                        throw new EngineRuntimeException(ExceptionCode.TRANSPORT_WSI_INVALID_DEPENDENT_OBJ_ACTION, new Integer(lu.getAction()));
                    }
                }
                if (doProps) {
                    PropertiesSerialization.INSTANCE.serialize(eo, context);
                }
                context.leaveElement();
            }

            public Object deserialize(Object object, DeserializerContext context) throws Exception {
                DependentIdentity di;
                PropertyDeserializerCall call = (PropertyDeserializerCall)object;
                String classId = Util.emptyAsNull(context.getAttribute("classId"));
                int action = ObjectListSerialization.toListUpdateAction(context);
                Integer origIndex = Util.parseInteger(context.getAttribute("originalIndex"));
                Integer newIndex = Util.parseInteger(context.getAttribute("newIndex"));
                int origIndexVal = -1;
                if (origIndex != null) {
                    origIndexVal = origIndex;
                }
                int newIndexVal = -1;
                if (newIndex != null) {
                    newIndexVal = newIndex;
                }
                ObjectReferenceBase parent = Util.reference(call.parent);
                if (origIndexVal == -1) {
                    di = new DependentIdentity(classId, parent, call.propertyId, null);
                    di.setIsNew(true);
                } else {
                    di = new DependentIdentity(classId, parent, call.propertyId, origIndex);
                }
                EngineObjectImpl eo = ObjectFactory.getInstance(di, null, null);
                if (Util.isStartToken(context.nextElementToken())) {
                    PropertiesSerialization.INSTANCE.deserialize(new PropertyDeserializerCall(call, eo), context);
                }
                if (context.isServerProcessing() && eo instanceof ContentTransferImpl && eo.getProperties().isPropertyPresent("Content")) {
                    context.addContentTransfer(eo);
                }
                context.checkEndToken();
                ListUpdate lu = new ListUpdate(action, eo, origIndexVal, newIndexVal);
                return lu;
            }
        };
    }
}

