/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.wsi.serialization.property;

import com.filenet.api.property.FilterElement;
import com.filenet.apiimpl.wsi.serialization.DeserializerContext;
import com.filenet.apiimpl.wsi.serialization.Serialization;
import com.filenet.apiimpl.wsi.serialization.SerializerContext;
import com.filenet.apiimpl.wsi.serialization.Util;

public class FilterElementSerialization
extends Serialization {
    public static final FilterElementSerialization INSTANCE = new FilterElementSerialization();

    public void serialize(Object object, SerializerContext context) throws Exception {
        FilterElement element = (FilterElement)object;
        context.writeOptionalSchemaType("FilterElementType");
        context.writeAttribute("maxRecursion", Util.toIntString(element.getMaxRecursion()));
        context.writeAttribute("maxSize", Util.toUnsignedLongString(element.getMaxSize()));
        context.writeAttribute("maxElements", Util.toIntString(element.getPageSize()));
        if (context.getVersion() >= 400) {
            context.writeAttribute("levelDependents", Util.toBooleanString(element.getLevelDependents()));
        }
        context.writeContent(element.getValue());
        context.leaveElement();
    }

    public Object deserialize(Object object, DeserializerContext context) throws Exception {
        Integer maxRecursion = Util.minusOneAsNull(Util.parseInteger(context.getAttribute("maxRecursion")));
        Long maxSize = Util.parseLong(context.getAttribute("maxSize"));
        Integer pageSize = Util.minusOneAsNull(Util.parseInteger(context.getAttribute("maxElements")));
        Boolean levelDependents = Util.parseBoolean(context.getAttribute("levelDependents"));
        String value = null;
        if (Util.isContentToken(context.nextToken())) {
            value = Util.emptyAsNull(context.readContent());
            context.nextEndToken();
        } else {
            context.checkEndToken();
        }
        return new FilterElement(maxRecursion, maxSize, levelDependents, value, pageSize);
    }
}

