/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.wsi.serialization.property;

import com.filenet.api.exception.ExceptionCode;
import com.filenet.apiimpl.core.ConnectionImpl;
import com.filenet.apiimpl.core.ObjectReferenceBase;
import com.filenet.apiimpl.property.ClientInputStream;
import com.filenet.apiimpl.property.PropertyContentImpl;
import com.filenet.apiimpl.wsi.serialization.DeserializerContext;
import com.filenet.apiimpl.wsi.serialization.SerializerContext;
import com.filenet.apiimpl.wsi.serialization.Util;
import com.filenet.apiimpl.wsi.serialization.property.PropertyDeserializerCall;
import com.filenet.apiimpl.wsi.serialization.property.PropertySerialization;
import com.filenet.apiimpl.wsi.serialization.property.PropertySerializerCall;
import java.io.InputStream;

public class ContentSerialization
extends PropertySerialization {
    public static final ContentSerialization INSTANCE = new ContentSerialization();

    public void serialize(Object object, SerializerContext context) throws Exception {
        PropertySerializerCall call = this.enter("ContentData", object, context);
        PropertyContentImpl property = (PropertyContentImpl)call.property;
        InputStream stream = property.getInputStreamValue();
        if (stream != null) {
            context.enterElement("Value");
            this.serializeStream(context, stream);
            context.leaveElement();
        }
        context.leaveElement();
    }

    public void serializeStream(SerializerContext context, InputStream stream) throws Exception {
        if (context.isForTrace()) {
            if (stream == null) {
                context.writeContent("From null stream");
            } else {
                context.writeContent("From " + stream.toString());
            }
            return;
        }
        switch (context.getAttachmentMode()) {
            case 1: {
                context.writeWsdlSchemaType("DIMEContent");
                context.writeAttribute("size", Util.toUnsignedLongString(Util.size(stream)));
                context.enterElement("Attachment");
                context.writeOptionalWsdlSchemaType("DIMEAttachmentReference");
                context.writeAttribute("http://schemas.xmlsoap.org/ws/2002/04/reference/", "location", context.registerAttachment(stream));
                context.leaveElement();
                break;
            }
            case 3: {
                context.writeSchemaType("InlineContent");
                context.writeAttribute("size", Util.toUnsignedLongString(Util.size(stream)));
                context.enterElement("Binary");
                context.enterNamespacedElement("http://www.w3.org/2004/08/xop/include", "Include");
                context.writeAttribute("href", context.registerAttachment(stream));
                context.leaveElement();
                context.leaveElement();
                break;
            }
            default: {
                byte[] bytes = ClientInputStream.gatherStreamToBytes(stream);
                context.writeSchemaType("InlineContent");
                context.writeAttribute("size", Util.toUnsignedLongString(bytes == null ? 0 : bytes.length));
                context.writeElement("Binary", context.getOptionalXsdType("base64Binary"), Util.toBase64BinaryString(bytes));
            }
        }
    }

    public Object deserialize(Object object, DeserializerContext context) throws Exception {
        PropertyDeserializerCall call = this.enter(object, context);
        ClientInputStream stream = null;
        if (context.isStartToken("Value")) {
            stream = this.deserializeStream(context, null, null, null, null, null);
        }
        PropertyContentImpl property = new PropertyContentImpl(call.propertyId, stream, call.propertyAccess);
        return this.leave(property, call, context);
    }

    public ClientInputStream deserializeStream(DeserializerContext context, ConnectionImpl connection, ObjectReferenceBase source, Integer elementSequenceNumber, String continueFrom, Long totalSize) throws Exception {
        String type = context.getXsiType();
        context.nextStartToken();
        String contentId = null;
        ClientInputStream stream = null;
        if (type.equals("DIMEContent")) {
            contentId = context.getAttribute("http://schemas.xmlsoap.org/ws/2002/04/reference/", "location");
            context.nextEndToken();
        } else if (type.equals("InlineContent")) {
            context.nextToken();
            if (context.isStartToken("Include")) {
                contentId = context.getAttribute("href");
                context.nextEndToken();
                context.nextEndToken();
            } else {
                stream = new ClientInputStream(connection, source, elementSequenceNumber, continueFrom, Util.parseBase64Binary(context.readContent()), totalSize);
                context.nextEndToken();
            }
        } else {
            context.throwException(ExceptionCode.TRANSPORT_WSI_INVALID_CONTENT_TYPE, type);
        }
        if (stream == null) {
            stream = new ClientInputStream(connection, source, elementSequenceNumber, continueFrom, context.referenceAttachment(contentId), totalSize);
        }
        context.nextEndToken();
        return stream;
    }
}

