/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.wsi.serialization.property;

import com.filenet.apiimpl.property.PropertyBinaryImpl;
import com.filenet.apiimpl.wsi.serialization.DeserializerContext;
import com.filenet.apiimpl.wsi.serialization.SerializerContext;
import com.filenet.apiimpl.wsi.serialization.Util;
import com.filenet.apiimpl.wsi.serialization.property.PropertyDeserializerCall;
import com.filenet.apiimpl.wsi.serialization.property.PropertySerialization;
import com.filenet.apiimpl.wsi.serialization.property.PropertySerializerCall;
import java.io.InputStream;

public class BinarySerialization
extends PropertySerialization {
    public static final BinarySerialization INSTANCE = new BinarySerialization();

    public void serialize(Object object, SerializerContext context) throws Exception {
        PropertySerializerCall call = this.enter("SingletonBinary", object, context);
        Object val = call.property.getObjectValue();
        if (val != null) {
            if (val instanceof InputStream) {
                context.writeElement("Value", null, "XOP stream");
            } else {
                context.writeOptionalElement("Value", context.getOptionalXsdType("base64Binary"), Util.toBase64BinaryString((byte[])val));
            }
        }
        context.leaveElement();
    }

    public Object deserialize(Object object, DeserializerContext context) throws Exception {
        PropertyBinaryImpl property;
        PropertyDeserializerCall call = this.enter(object, context);
        Object val = BinarySerialization.deserializeBinaryValue(context, this.util);
        if (val instanceof InputStream) {
            property = new PropertyBinaryImpl(call.propertyId, null, call.propertyAccess);
            property.setObjectValue(val);
            context.addXopBinaryProperty(property);
        } else {
            property = new PropertyBinaryImpl(call.propertyId, (byte[])val, call.propertyAccess);
        }
        return this.leave(property, call, context);
    }

    public static Object deserializeBinaryValue(DeserializerContext context, Util util) throws Exception {
        Object val = null;
        if (context.isStartToken("Value")) {
            context.nextToken();
            if (context.isStartToken("Include")) {
                String contentId = context.getAttribute("href");
                context.nextEndToken();
                val = context.referenceAttachment(contentId);
            } else {
                val = context.isEndToken() ? new byte[]{} : Util.parseBase64Binary(context.readContent());
            }
            context.nextEndToken();
        }
        return val;
    }
}

