/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.wsi.serialization.operation;

import com.filenet.api.meta.ClassDescription;
import com.filenet.api.util.Id;
import com.filenet.apiimpl.core.ClassDescriptionImpl;
import com.filenet.apiimpl.core.EngineObjectUtil;
import com.filenet.apiimpl.core.SetImpl;
import com.filenet.apiimpl.core.SubSetImpl;
import com.filenet.apiimpl.meta.SearchScopeIdentity;
import com.filenet.apiimpl.transport.MetadataSearchRequest;
import com.filenet.apiimpl.transport.MetadataSearchResponse;
import com.filenet.apiimpl.wsi.serialization.DeserializerContext;
import com.filenet.apiimpl.wsi.serialization.Serialization;
import com.filenet.apiimpl.wsi.serialization.SerializerContext;
import com.filenet.apiimpl.wsi.serialization.Util;
import com.filenet.apiimpl.wsi.serialization.core.CollectionTerminatorSerialization;
import com.filenet.apiimpl.wsi.serialization.core.EngineObjectSerialization;
import com.filenet.apiimpl.wsi.serialization.property.PropertiesSerialization;
import com.filenet.apiimpl.wsi.serialization.property.PropertyDeserializerCall;
import java.util.ArrayList;

public class GetSearchMetadataResponseSerialization
extends Serialization {
    public static final GetSearchMetadataResponseSerialization INSTANCE = new GetSearchMetadataResponseSerialization();
    public static final Serialization SEARCHABLE_CLASS_DESCRIPTION = new Serialization(){

        public Object deserialize(Object object, DeserializerContext context) throws Exception {
            PropertyDeserializerCall call = (PropertyDeserializerCall)object;
            SearchScopeIdentity ssi = (SearchScopeIdentity)call.request;
            String classId = Util.emptyAsNull(context.getAttribute("classId"));
            Id objectId = Util.parseId(context.getAttribute("objectId"));
            ClassDescriptionImpl value = EngineObjectUtil.getClassDescriptionBySearchScope(context.getConnection(), objectId, ssi.getObjectStores(), ssi.getMergeMode());
            if (Util.isStartToken(context.nextElementToken())) {
                PropertiesSerialization.INSTANCE.deserialize(new PropertyDeserializerCall(call, value), context);
            }
            value.setDirty(false);
            return value;
        }
    };

    public void serialize(Object object, SerializerContext context) throws Exception {
        MetadataSearchResponse response = (MetadataSearchResponse)object;
        String epoch = response.getMetadataEpochId();
        if (epoch != null) {
            context.writeAttribute("metadataEpochId", epoch);
        }
        if (context.getVersion() > 350) {
            context.writeAttribute("collectionType", "Enum");
        }
        SetImpl set = (SetImpl)((Object)response.getClassDescriptionSet());
        context.serializeObjectArray("Object", EngineObjectSerialization.INSTANCE, Util.objects(set));
        context.serializeObject("CollectionTerminator", CollectionTerminatorSerialization.INSTANCE, (Object)"");
        context.leaveElement();
    }

    public Object deserialize(Object object, DeserializerContext context) throws Exception {
        MetadataSearchRequest request = (MetadataSearchRequest)context.getRequest();
        PropertyDeserializerCall call = new PropertyDeserializerCall(request.getSearchScope(), request.getPropertyFilter());
        String epoch = context.getAttribute("metadataEpochId");
        context.nextElementToken();
        ArrayList list = (ArrayList)context.deserializeObjectList("Object", SEARCHABLE_CLASS_DESCRIPTION, call);
        context.deserializeObject("CollectionTerminator", CollectionTerminatorSerialization.INSTANCE, null);
        context.checkEndToken();
        SubSetImpl set = new SubSetImpl(ClassDescription.class, list);
        MetadataSearchResponse response = new MetadataSearchResponse();
        response.setMetadataEpochId(epoch);
        response.setClassDescriptionSet(set);
        return response;
    }
}

